/*-----------------------------------------------------------------------------
+------------------------------------------------------------------------------
|  Copyright 2004-2007 Texas Instruments Incorporated. All rights reserved.
|
|  IMPORTANT: Your use of this Software is limited to those specific rights
|  granted under the terms of a software license agreement between the user who
|  downloaded the software, his/her employer (which must be your employer) and
|  Texas Instruments Incorporated (the "License"). You may not use this Software
|  unless you agree to abide by the terms of the License. The License limits
|  your use, and you acknowledge, that the Software may not be modified, copied
|  or distributed unless embedded on a Texas Instruments microcontroller or used
|  solely and exclusively in conjunction with a Texas Instruments radio
|  frequency transceiver, which is integrated into your product. Other than for
|  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
|  works of, modify, distribute, perform, display or sell this Software and/or
|  its documentation for any purpose.
|
|  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
|  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
|  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
|  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
|  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
|  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
|  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES INCLUDING
|  BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
|  CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
|  SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
|  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
|
|  Should you have any questions regarding your right to use this Software,
|  contact Texas Instruments Incorporated at www.TI.com.
|
+------------------------------------------------------------------------------
| Purpose:    
+------------------------------------------------------------------------------
| Decription: 
+----------------------------------------------------------------------------*/

/*==== DECLARATION CONTROL ==================================================*/

#ifndef SPI_TEST_H
#define SPI_TEST_H


/*==== INCLUDES ==============================================================*/
#include "hal_timer_32k.h"
#include "hal_spi.h"
#include "hal_lcd.h"
#include "hal_led.h"
#include "hal_button.h"
#include "hal_joystick.h"
#include "hal_assert.h"
#include "hal_board.h"
#include "hal_int.h"
#include "hal_uart.h"
#include "hal_rf.h"
#include "hal_digio.h"
#include "util.h"
#include "util_lcd.h"
#include "util_uart.h"
#include "basic_rf.h"
#include "hal_dma.h"
#include "clock.h"
#include "string.h"


/***********************************************************************************
* CONSTANTS
*/
// Application states
#define IDLE                      0
#define TRANSMIT_PACKET           1


/*==== DEFINES ===============================================================*/
#define NUMBER_OF_MODES 2       // Operational mode constants
#define SPI_MODE_SLAVE  0x10
#define SPI_MODE_MASTER 0x20

#define NUMBER_OF_TESTS 8       // Operational mode constants
#define M_S_ACTIVE  0x01
#define M_S_TXBYTE_RXBYTE 0x02
#define M_S_DMA 0x03
#define M_S_INTERRUPT 0x04
#define S_M_ACTIVE  0x05
#define S_M_TXBYTE_RXBYTE 0x06
#define S_M_DMA 0x07
#define S_M_INTERRUPT 0x08

#define NUMBER_OF_TRIG 2
#define NUMBER_OF_PRI 3

#define DUMMY_BYTE 0x00

#define DMAIF0         0x01 // DMA channel 0 interrupt flag in the DMAIRQ register
#define DMAIF1         0x02 // DMA channel 0 interrupt flag in the DMAIRQ register

#define CPOL  0x80
#define CPHA  0x40
#define ORDER 0x20

#define UTX1IF 0x40
#define URX1IF 0x80
             
#define DMAARM0         0x01 // The value to arm the DMA channel 0 in the DMAARM register
#define DMAARM1         0x02 // The value to arm the DMA channel 0 in the DMAARM register
#define ABORT           0x80

#define N               9
#define N_PACKETS       10000

/*==== MACROS ================================================================*/
#define SET_WORD(regH, regL, word) \
   do{                             \
      (regH) = HIBYTE( word );     \
      (regL) = LOBYTE( word );     \
   }while(0)

#ifndef WIN32
#define UPPER_WORD(a) ((uint16) (((DWORD)(a)) >> 16))
#define HIWORD(a)     UPPER_WORD(a)

#define LOWER_WORD(a) ((uint16) ((DWORD)(a)))
#define LOWORD(a)     LOWER_WORD(a)

#define UPPER_BYTE(a) ((uint8) (((uint16)(a)) >> 8))
#define HIBYTE(a)     UPPER_BYTE(a)

#define LOWER_BYTE(a) ((uint8) ( (uint16)(a))      )
#define LOBYTE(a)     LOWER_BYTE(a)
#endif

/*==== TYPES =================================================================*/
/*==== GLOBALS ===============================================================*/


/*==== GLOBAL VARS ==_========================================================*/
volatile uint8 dataReceived;
volatile uint8 dataTransmitted;
volatile uint8 dma0Done;
volatile uint8 dma1Done;
uint8 *pRxBuffer;
uint8 *pTxBuffer;

volatile uint8 appState;
volatile uint8 appStarted;


/*==== FUNCTIONS =============================================================*/

void waitForJoystickIdle(void);
void appStartStop(void);
void appSpiRunTst(uint8 testSet, uint8 *pTxData, uint8 *pRxData);


// PER test packet format
typedef struct {
    uint32 seqNumber;
    uint8 padding[103];
} perTestPacket_t;

/*
typedef struct {
  uint32 n
*/  

// PER test receiver statistics
typedef struct {
    uint32 expectedSeqNum;
    uint32 rcvdPkts;
    uint32 lostPkts;
    int16 rssiSum;
} perRxStats_t;

basicRfCfg_t basicRfConfig;
perTestPacket_t txPacket;
perTestPacket_t rxPacket;
uint32 burstSize;

/***********************************************************************************
* CONSTANTS AND DEFINES
*/

// BasicRF definitions
#define PAN_ID                0x2010
#define TX_ADDR               0x2530
#define RX_ADDR               0xBEEF
#define MAX_PAYLOAD_LENGTH       103
#define PACKET_SIZE           sizeof(perTestPacket_t)

#define RSSI_AVG_WINDOW_SIZE   32  // Window size for RSSI moving average


#endif  /* SPI_TEST_H */

/*==== END OF FILE ==========================================================*/
