/******************************************************************************


-----------------                                     -----------------
|         MISO  |->P18, 9 ------------------> P18, 9  | MISO          |
|         SSN   |->P18, 13------------------> P18, 13 | SSN           |
|  Rf05EB       |                                     |      Rf05EB   |
|         SCLK  |->P18, 15 -----------------> P18, 15 | SCLK          |
|         MOSI  |->P18, 11 -----------------> P18, 11 | MOSI          |
|               |                                     |               |
|          GND  |->P18, 20 -----------------> P18, 20 | GND           |
-----------------                                     -----------------

======================================
||                                  ||
|| Start up slave before master!!   ||
||                                  ||
======================================

******************************************************************************/

/*==== INCLUDES ==============================================================*/
#include "cc2530_spiTst.h"
#include "cc2530_spiTst_menu.h"


/***********************************************************************************
* LOCAL VARIABLES
*/
static volatile uint8 appState;
static volatile uint8 appStarted;

/***********************************************************************************
* LOCAL FUNCTIONS
*/


/*==== DECLARATION CONTROL ===================================================*/
void printStats(void);


/*==== GLOBAL VARS============================================================*/

static uint8 appMode;       // Spi operating appMode, either master or slave
static uint8 appTestNo;      // Which test to run


/***********************************************************************************
* @fn          appStartStop
*
* @brief       Joystick up interrupt service routine. Start or stop 32KHz timer,
*              and thereby start or stop PER test packet transmission.
*
* @param       none
*
* @return      none
*/
void appStartStop(void)
{
    // toggle value
    appStarted ^= 1;

    if(appStarted) {
        halTimer32kIntEnable();
    }
    else {
        halTimer32kIntDisable();
    }
}



/***********************************************************************************
* @fn          appSlave
*
* @brief       Application code for the slave mode. Puts MCU in endless loop
*
* @param       
*
* @return      none
*/
static void appSlave()
{
    // Set selected test
    appTestNo = appSelectTest(); 
    appSpiSetTest(appMode, appTestNo);
}


/***********************************************************************************
* @fn          appMaster
*
* @brief       Application code for the Master mode. Puts MCU in endless
*              loop
*
* @param       basicRfConfig - file scope variable. Basic RF configuration data
*              txPacket - file scope variable of type perTestPacket_t
*              appState - file scope variable. Holds application state
*              appStarted - file scope variable. Controls start and stop of
*                           transmission
*
* @return      none
*/
static void appMaster()
{
  
    // Set selected test
    appTestNo = appSelectTest(); 
    appSpiSetTest(appMode, appTestNo);
     
}
/*******************************************************************************
* @fn  main
*
* @brief
*      Main function. 
*
* Parameters:
*
* @param  void
*
* @return void
*
*******************************************************************************/
void main(void)
{ 
    
  // Choose the crystal oscillator as the system clock and set 
  // timer tick speed = system clock speed = fRef (fxosc)

    halBoardInit();

  halJoystickInit();
  halJoystickIntConnect(HAL_JOYSTICK_EVT_PUSHED, printStats);
  halIntOn();

  halLedClear(1);
 
  // Print Logo and splash screen on LCD
  utilPrintLogo("SPI Tester");
 
 // Wait for user to press S1 to enter menu
  while (halButtonPushed()!= HAL_BUTTON_1);
  halMcuWaitMs(350);
  halLcdClear();
    
  appMode = appSelectMode();
  
    // Master application
    if(appMode == SPI_MODE_MASTER) {
        // No return from here
        appMaster();
    }
    // Slave application
    else if(appMode == SPI_MODE_SLAVE) {
        // No return from here
        appSlave();
    }
    // Role is undefined. This code should not be reached
    HAL_ASSERT(FALSE);
}

/******************************************************************************
* @fn  URX1_IRQ
*
* @brief
*      
*
* Parameters:
*
* @param  void
*
* @return void
*
******************************************************************************/
#pragma vector=URX0_VECTOR
__interrupt void urx0_IRQ(void)
{
  static uint8 bufferIndex = 0;
 
  TCON &= ~0x08; // TCON.URX0IF = 0;

  pRxBuffer[bufferIndex++] = U0DBUF;
  if (bufferIndex == N)
  {
    bufferIndex = 0;
    dataReceived = TRUE;
  } 
  else {
    if (appMode == SPI_MODE_MASTER) {
      halMcuWaitUs(5); // Delay to allow slave to keep up
    }
    
    U0DBUF = pTxBuffer[bufferIndex];
  }
}

/******************************************************************************
* @fn  UTX0_IRQ
*
* @brief
*      
*
* Parameters:
*
* @param  void
*
* @return void
*
******************************************************************************/
#pragma vector=UTX0_VECTOR
__interrupt void utx0_IRQ(void)
{
  static uint8 bufferIndex = 0;
  
  IRCON2 &= ~0x02; // IRCON2.UTX0IF = 0

  if (++bufferIndex == N)
  {
    bufferIndex = 0;
    dataTransmitted = TRUE;
  }
  U0DBUF = pTxBuffer[bufferIndex];
}

/******************************************************************************
* @fn  DMA_IRQ
*
* @brief
*      
*
* Parameters:
*
* @param  void
*
* @return void
*
******************************************************************************/
#pragma vector=DMA_VECTOR
__interrupt void dma_IRQ(void)
{
  DMAIF = 0;              // Clear the CPU DMA interrupt flag
  if (DMAIRQ & 0x01) {
    DMAIRQ &= ~DMAIF0;     // DMA channel 0 module interrupt flag
    dma0Done = TRUE;
  }
  if (DMAIRQ & 0x02) {
    DMAIRQ &= ~DMAIF1;     // DMA channel 0 module interrupt flag
    dma1Done = TRUE;
  }
}

/*==== PRIVATE FUNCTIONS =====================================================*/
void printStats(void)
{  
  // Wait until joystick has been released for 10 ms
  // NOTE: This stalls MCU for a long time
  waitForJoystickIdle();
}


/******************************************************************************
* @fn  waitForJoystickIdle
*
* @brief
*      Wait until joystick has been idle for 10 ms
*
* Parameters:
*
* @param 
*
* @return
*           
*
*
******************************************************************************/
void waitForJoystickIdle(void)
{
  do {
    // Wait until joystick not active
    while (MCU_IO_GET(HAL_BOARD_IO_JOY_MOVE_PORT, HAL_BOARD_IO_JOY_MOVE_PIN));
    halMcuWaitMs(10);
    // Wait 10 ms and see that joystick is still not active
  } while (MCU_IO_GET(HAL_BOARD_IO_JOY_MOVE_PORT, HAL_BOARD_IO_JOY_MOVE_PIN));
}

/*==== END OF FILE ===========================================================*/


