
/***********************************************************************************
    Filename:     per_test_menu.h

    Description:  PER test menu header file

***********************************************************************************/

#ifndef PER_TEST_MENU_H
#define PER_TEST_MENU_H

/***********************************************************************************
* INCLUDES
*/
#include "hal_types.h"
#include "hal_defs.h"
#include "hal_board.h"

/***********************************************************************************
* CONSTANTS AND DEFINES
*/
// Application modes
#define MODE_TX                   0
#define MODE_RX                   1
#define MODE_SPI_MASTER           2
#define MODE_SPI_SLAVE            3
#define MODES                     4

// Burst Sizes
#define BURST_SIZE_1            10
#define BURST_SIZE_2            100
#define BURST_SIZE_3            1000
#define BURST_SIZE_4            10000
#define BURSTSIZES              4

#define TRIG_VAL_1              DMA_TRIG_URX0
#define TRIG_VAL_2              DMA_TRIG_UTX0

// Channel 11, first channel in band
#define CHANNEL_11              11
#define CHANNELS                16

/***********************************************************************************
* GLOBAL FUNCTIONS
*/
uint8 appSelectMode(void);
uint8 appSelectTest(void);
uint8 appSelectChannel(void);
uint8 appSelectOutputPower(void);
uint8 appSelectGain(void);          // Modules with CC2590/91 only
uint8 appSelectRate(void);
uint32 appSelectBurstSize(void);
uint8 appSelectDmaTrig(uint8 Tx);
void appSpiSetTest(uint8 testMode, uint8 testSet);

#endif


/***********************************************************************************
  Copyright 2007 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS?WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
***********************************************************************************/
