/**************************************************************************************************
 *                                           INCLUDES
 **************************************************************************************************/

#include  "hal_mcu.h"
#include  "clock.h"
#include  "hal_defs.h"
#include  "hal_types.h"
#include  "hal_spi.h"

/**************************************************************************************************
 *                                            CONSTANTS
 **************************************************************************************************/

/**************************************************************************************************
 *                                              MACROS
 **************************************************************************************************/

/**************************************************************************************************
 *                                            TYPEDEFS
 **************************************************************************************************/

/**************************************************************************************************
 *                                         GLOBAL VARIABLES
 **************************************************************************************************/

/**************************************************************************************************
 *                                          FUNCTIONS - API
 **************************************************************************************************/

/**************************************************************************************************
 * @fn      halMasterSpiInit
 *
 * @brief   Initialize master SPI Service
 *
 * @param   None
 *
 * @return  None
 **************************************************************************************************/
void halMasterSpiInit(void)
{
        
        register uint8 baud_exponent;
        register uint8 baud_mantissa;
        // Configure the I/O pins accosiated with USART0 (SPI mode)
        // Setup I/O (USART0 at alternative 1 location)
        // MISO:  P0_2
        // MOSI:  P0_3
        // SCK:   P0_5
        // SSN:   P0_4
        PERCFG &= ~0x01;
      
        // P0SEL |= 0x2C;  // P0_5, P0_3, and P0_2 are peripherals
        // Use SPI on USART 0 alternative 1
        MCU_IO_PERIPHERAL(0, 2);
        MCU_IO_PERIPHERAL(0, 3);
        MCU_IO_PERIPHERAL(0, 5);
                
#if 0   // 4Mbps
        baud_exponent = 17 + CC2530_GET_CLKSPD();	// for maximum rate
        baud_mantissa = 0;	// for maximum rate
#else   // 3.5Mbps
        baud_exponent = 16 + CC2530_GET_CLKSPD();
        baud_mantissa = 192;
#endif
        // In master mode, SSN is an output controlled by the application
        SSN = HIGH;
        P0SEL &= ~0x10; // P0_4 is GPIO (SSN) 
        P0DIR |= 0x10; // Set SSN as output
//        P2SEL |= 0x40; // USART1 takes priority on P1
//        P2SEL &= ~0x20; // USART1 takes priority on P1
                
        // Configure peripheral
        U0UCR  = 0x80;      // Flush and goto IDLE state. 8-N-1.
        U0CSR  = 0x00;      // SPI mode, master.
        U0GCR  = SPI_TRANSFER_MSB_FIRST | SPI_CLOCK_PHA_0 | SPI_CLOCK_POL_LO | baud_exponent;
        U0BAUD = baud_mantissa;
        
        // Clear flags
        U0CSR &= ~0x02; // U0TX_BYTE = 0
        U0CSR &= ~0x04; // U0RX_BYTE = 0
   
}// halMasterSpiInit


/**************************************************************************************************
 * @fn      halSlaveSpiInit
 *
 * @brief   Initialize slave SPI Service
 *
 * @param   None
 *
 * @return  None
 **************************************************************************************************/
void halSlaveSpiInit(void)
{         
        register uint8 baud_exponent;
        register uint8 baud_mantissa;
        // Configure the I/O pins accosiated with USART0 (SPI mode)
        // Setup I/O (USART0 at alternative 1 location)
        // MISO:  P0_2
        // MOSI:  P0_3
        // SCK:   P0_5
        // SSN:   P0_4
        PERCFG &= ~0x01;
      
        // P0SEL |= 0x2C;  // P0_5, P0_3, and P0_2 are peripherals
        // Use SPI on USART 0 alternative 1
        MCU_IO_PERIPHERAL(0, 2);
        MCU_IO_PERIPHERAL(0, 3);
        MCU_IO_PERIPHERAL(0, 5);
        MCU_IO_PERIPHERAL(0, 4);
                
#if 0   // 4Mbps
        baud_exponent = 17 + CC2530_GET_CLKSPD();	// for maximum rate
        baud_mantissa = 0;	// for maximum rate
#else   // 3.5Mbps
        baud_exponent = 16 + CC2530_GET_CLKSPD();
        baud_mantissa = 192;
#endif
                
        // Configure peripheral
        U0UCR  = 0x80;      // Flush and goto IDLE state. 8-N-1.
        U0CSR  = 0x20;      // SPI mode, slave.
        U0GCR  = SPI_TRANSFER_MSB_FIRST | SPI_CLOCK_PHA_0 | SPI_CLOCK_POL_LO | baud_exponent;
        U0BAUD = baud_mantissa;
        
        // Clear flags
        U0CSR &= ~0x02; // U0TX_BYTE = 0
        U0CSR &= ~0x04; // U0RX_BYTE = 0
} //halSlaveSpiInit




/**************************************************************************************************
  Description:    This file contains the interface to the HAL SPI.


  Copyright 2010 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS?WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
**************************************************************************************************/
