/**************************************************************************************************
    Filename:       tvsa_cc2430.c
    Revised:        $Date: 2010-01-28 17:08:24 -0800 (Thu, 28 Jan 2010) $
    Revision:       $Revision: 21616 $

    Description:

    This file implements the CC2430 board-specific Temperature/Voltage calculations.

    Copyright 2009 Texas Instruments Incorporated. All rights reserved.

    IMPORTANT: Your use of this Software is limited to those specific rights
    granted under the terms of a software license agreement between the user
    who downloaded the software, his/her employer (which must be your employer)
    and Texas Instruments Incorporated (the "License").  You may not use this
    Software unless you agree to abide by the terms of the License. The License
    limits your use, and you acknowledge, that the Software may not be modified,
    copied or distributed unless embedded on a Texas Instruments microcontroller
    or used solely and exclusively in conjunction with a Texas Instruments radio
    frequency transceiver, which is integrated into your product.  Other than for
    the foregoing purpose, you may not use, reproduce, copy, prepare derivative
    works of, modify, distribute, perform, display or sell this Software and/or
    its documentation for any purpose.

    YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
    PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
    INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
    NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
    TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
    NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
    LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
    INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
    OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
    OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
    (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

    Should you have any questions regarding your right to use this Software,
    contact Texas Instruments Incorporated at www.TI.com.
**************************************************************************************************/

/* ------------------------------------------------------------------------------------------------
 *                                          Includes
 * ------------------------------------------------------------------------------------------------
 */

#include "tvsa.h"
#include "ZComDef.h"

/* ------------------------------------------------------------------------------------------------
 *                                           Constants
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Typedefs
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Macros
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Global Variables
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Local Variables
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Local Functions
 * ------------------------------------------------------------------------------------------------
 */

static void HalInitTV(void);
static void HalCalcTV(uint8 *tvDat);

/**************************************************************************************************
 * @fn          HalCalcTV
 *
 * @brief       This function is called by tvsaAppInit() to calibrate to the assumed room temp
 *              of 22 degC.
 *
 * input parameters
 *
 * None.
 *
 * output parameters
 *
 * None.
 *
 * @return      None.
 **************************************************************************************************
 */
static void HalInitTV(void)
{
}

/**************************************************************************************************
 * @fn          HalCalcTV
 *
 * @brief       This function is called by tvsaAppEvt() to calculate the data for a TVSA report.
 *
 * input parameters
 *
 * None.
 *
 * output parameters
 *
 * None.
 *
 * @return      None.
 **************************************************************************************************
 */
static void HalCalcTV(uint8 *tvDat)
{
  uint16 tmp;

  // Start the SOC temperature sensor measurement.
  ADCCON2 = 0x3E;
  ADCCON1 = 0x73;
  while (!(ADCCON1 & 0x80));
  tmp = ADCL >> 4;
  tmp |= ADCH << 4;

  // Calculate the temperature measured in degC.
  // ADC * 1250 / 2047
  tmp *= 25;
  tmp /= 41;
  // ADC - (DataSheet + Measured Extra Offset)
  tmp -= (743 + 0);
  // ADC / TEMP COEFF of 2.45.
  tmp *= 100;
  tmp /= 245;

  tvDat[TVSA_TEM_IDX] = (uint8)tmp;

  // Start the SOC battery voltage measurement.
  ADCCON2 = 0x3F;
  ADCCON1 = 0x73;
  while (!(ADCCON1 & 0x80));
  tmp = ADCL >> 4;
  tmp |= ADCH << 4;

  // Calculate the Vdd measured in 10ths of V.
  // ADC * 3.75 / 2047 * 10
  tmp *= 5;
  tmp /= 273;

  tvDat[TVSA_BUS_IDX] = (uint8)tmp;
}

/**************************************************************************************************
*/
