/**************************************************************************************************
    Filename:       tvsa_msp430.c
    Revised:        $Date: 2010-01-28 17:08:24 -0800 (Thu, 28 Jan 2010) $
    Revision:       $Revision: 21616 $

    Description:

    This file implements the MSP430 board-specific Temperature/Voltage calculations.

    Copyright 2009 Texas Instruments Incorporated. All rights reserved.

    IMPORTANT: Your use of this Software is limited to those specific rights
    granted under the terms of a software license agreement between the user
    who downloaded the software, his/her employer (which must be your employer)
    and Texas Instruments Incorporated (the "License").  You may not use this
    Software unless you agree to abide by the terms of the License. The License
    limits your use, and you acknowledge, that the Software may not be modified,
    copied or distributed unless embedded on a Texas Instruments microcontroller
    or used solely and exclusively in conjunction with a Texas Instruments radio
    frequency transceiver, which is integrated into your product.  Other than for
    the foregoing purpose, you may not use, reproduce, copy, prepare derivative
    works of, modify, distribute, perform, display or sell this Software and/or
    its documentation for any purpose.

    YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
    PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
    INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
    NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
    TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
    NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
    LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
    INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
    OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
    OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
    (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

    Should you have any questions regarding your right to use this Software,
    contact Texas Instruments Incorporated at www.TI.com.
**************************************************************************************************/

/* ------------------------------------------------------------------------------------------------
 *                                          Includes
 * ------------------------------------------------------------------------------------------------
 */

#include "hal_board_cfg.h"
#include "tvsa.h"
#include "ZComDef.h"

/* ------------------------------------------------------------------------------------------------
 *                                           Constants
 * ------------------------------------------------------------------------------------------------
 */

#if !defined ADC12SHT0_8
#define ADC12SHT0_8
#endif
#if !defined ADC12INCH_10
#define ADC12INCH_10 INCH_10
#endif
#if !defined ADC12INCH_11
#define ADC12INCH_11 INCH_11
#endif
#if !defined ADC12REFON
#define ADC12REFON REFON
#endif
#if !defined ADC12SREF_1
#define ADC12SREF_1 SREF_1
#endif
#if !defined ADC12ENC
#define ADC12ENC ENC
#endif
#if !defined ADC12SHP
#define ADC12SHP SHP
#endif
#if !defined ADC12SHT0_2
#define ADC12SHT0_2 SHT0_2
#endif

/* ------------------------------------------------------------------------------------------------
 *                                           Typedefs
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Macros
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Global Variables
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Local Variables
 * ------------------------------------------------------------------------------------------------
 */

/* ------------------------------------------------------------------------------------------------
 *                                           Local Functions
 * ------------------------------------------------------------------------------------------------
 */

static void HalInitTV(void);
static void HalCalcTV(uint8 *tvDat);

/**************************************************************************************************
 * @fn          HalCalcTV
 *
 * @brief       This function is called by tvsaAppInit() to calibrate to the assumed room temp
 *              of 22 degC.
 *
 * input parameters
 *
 * None.
 *
 * output parameters
 *
 * None.
 *
 * @return      None.
 **************************************************************************************************
 */
static void HalInitTV(void)
{
}

/**************************************************************************************************
 * @fn          HalCalcTV
 *
 * @brief       This function is called by tvsaAppEvt() to calculate the data for a TVSA report.
 *
 * input parameters
 *
 * None.
 *
 * output parameters
 *
 * None.
 *
 * @return      None.
 **************************************************************************************************
 */
static void HalCalcTV(uint8 *tvDat)
{
  uint16 adcVal = ADC12MEM0;                // Dummy read to clear IFG.
  uint8 wdt = WDTCTL & 0xFF;
  WDTCTL = WDTPW + WDTHOLD;                 // Stop WDT
  ADC12CTL0 = ADC12SHT0_8 + ADC12REFON + ADC12ON;
                                            // Internal ref = 1.5V
  ADC12CTL1 = ADC12SHP;                     // enable sample timer
  ADC12MCTL0 = ADC12SREF_1 + ADC12INCH_10;  // ADC i/p ch A10 = temp sense i/p

  __delay_cycles(37);                       // 35us delay to allow Ref to settle
                                            // based on default DCO frequency.
                                            // See Datasheet for typical settle
                                            // time.
  ADC12CTL0 |= ADC12ENC;
  ADC12CTL0 |= ADC12SC;                     // Sampling and conversion start
  while (ADC12IFG == 0);
  adcVal = ADC12MEM0;

  // Temperature in Celsius
  // ((A10/4096*1500mV) - 894mV)*(1/3.66mV) = (A10/4096*410) - 244
  // = (A10 - 2438) * (410 / 4096)
  //ggg - why not work? tvDat[TVSA_TEM_IDX] = (uint8)(((adcVal - 2438) * 410) / 4096);
  tvDat[TVSA_TEM_IDX] = (uint8)(((adcVal - 2438) * 410) / 2048);
  
  // Setup code taken from TI example code: msp430x22x4_adc11_temp.c.
  ADC12CTL1 = ADC12INCH_11 + ADC12DIV_3;    // Internal bus voltage, ADC12CLK/4
  ADC12CTL0 = ADC12SREF_1 + ADC12SHT0_2 + ADC12REFON + ADC12ON;

  __delay_cycles(37);                       // 35us delay to allow Ref to settle

  ADC12CTL0 |= ADC12ENC + ADC12SC;          // Sampling and conversion start.
  while (ADC12IFG == 0);
  adcVal = ADC12MEM0;

  // Measurement of AVcc/2 is in range 0 to 1023 indicating voltage from 0 to 1.5V.
  tvDat[TVSA_BUS_IDX] = (uint8)((adcVal * 30 + 512) / 1024);  // Convert to units of 0.1V

  ADC12CTL0 = 0;                            // Disable the ADC
  ADC12CTL0 = 0;                            // Turn off reference (must be done AFTER clearing ENC).
  WDTCTL = WDTPW + wdt;
}

/**************************************************************************************************
*/
