//*****************************************************************************
//
// Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/ 
// 
// 
//  Redistribution and use in source and binary forms, with or without 
//  modification, are permitted provided that the following conditions 
//  are met:
//
//    Redistributions of source code must retain the above copyright 
//    notice, this list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the 
//    documentation and/or other materials provided with the   
//    distribution.
//
//    Neither the name of Texas Instruments Incorporated nor the names of
//    its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

//*****************************************************************************
//
// Application Name     - SPI Demo
// Application Overview - The demo application focuses on showing the required 
//                        initialization sequence to enable the CC3200 SPI 
//                        module in full duplex 4-wire master and slave mode(s).
// Application Details  -
// http://processors.wiki.ti.com/index.php/CC32xx_SPI_Demo
// or
// docs\examples\CC32xx_SPI_Demo.pdf
//
//*****************************************************************************


//*****************************************************************************
//
//! \addtogroup SPI_Demo
//! @{
//
//*****************************************************************************

// Standard includes
#include <string.h>

// Driverlib includes
#include "hw_types.h"
#include "hw_memmap.h"
#include "hw_common_reg.h"
#include "hw_ints.h"
#include "hw_mcspi.h"
#include "hw_udma.h"
#include "spi.h"
#include "rom.h"
#include "rom_map.h"
#include "utils.h"
#include "prcm.h"
#include "uart.h"
#include "udma.h"
#include "interrupt.h"

// Common interface includes
#include "uart_if.h"
#include "udma_if.h"
#include "pinmux.h"


#define APPLICATION_VERSION     "1.1.0"
//*****************************************************************************
//
// Application Master/Slave mode selector macro
//
// MASTER_MODE = 1 : Application in master mode
// MASTER_MODE = 0 : Application in slave mode
//
//*****************************************************************************
#define MASTER_MODE      1

#define SPI_IF_BIT_RATE  1000000
#define TR_BUFF_SIZE     100

#define MASTER_MSG       "This is CC3200 SPI Master Application\n\r"
#define SLAVE_MSG        "This is CC3200 SPI Slave Application\n\r"

//*****************************************************************************
//                 GLOBAL VARIABLES -- Start
//*****************************************************************************
static unsigned char g_ucTxBuff[TR_BUFF_SIZE];
static unsigned char g_ucRxBuff[TR_BUFF_SIZE];
//static unsigned char g_ucDummyBuff[10];
static unsigned char ucTxBuffNdx;
static unsigned char ucRxBuffNdx;

unsigned char g_ucDMAEnabled = 0;

volatile char g_cDummy;

#if defined(ccs)
extern void (* const g_pfnVectors[])(void);
#endif
#if defined(ewarm)
extern uVectorEntry __vector_table;
#endif
//*****************************************************************************
//                 GLOBAL VARIABLES -- End
//*****************************************************************************



//*****************************************************************************
//
//! SPI Slave Interrupt handler
//!
//! This function is invoked when SPI slave has its receive register full or
//! transmit register empty.
//!
//! \return None.
//
//*****************************************************************************
static void SpiIntHandler()
{
    unsigned long ulRecvData;
    unsigned long ulStatus;

    //ulStatus = MAP_SPIIntStatus(GSPI_BASE,true);
    
    //MAP_SPIIntClear(GSPI_BASE,SPI_INT_DMARX|SPI_INT_DMATX);
    SPIIntClear(GSPI_BASE,SPI_INT_EOW);
    SPICSDisable(GSPI_BASE);
    g_cDummy = 0x01;
    //MAP_SPIIntClear(GSPI_BASE,SPI_INT_RX_FULL|SPI_INT_TX_EMPTY);

    if(ulStatus & SPI_INT_TX_EMPTY)
    {
        //MAP_SPIDataPut(GSPI_BASE,g_ucTxBuff[ucTxBuffNdx%TR_BUFF_SIZE]);
        ucTxBuffNdx++;
    }

    if(ulStatus & SPI_INT_RX_FULL)
    {
        //MAP_SPIDataGetNonBlocking(GSPI_BASE,&ulRecvData);
        //g_ucTxBuff[ucRxBuffNdx%TR_BUFF_SIZE] = ulRecvData;
        //Report("%c",ulRecvData);
        ucRxBuffNdx++;
    }
    
    if(ulStatus & SPI_INT_DMARX)
    {
      ucTxBuffNdx++;
      //MAP_SPIDataGet(GSPI_BASE,&ulDummy);
    }
    
    if(ulStatus & SPI_INT_DMATX)
    {
      ucTxBuffNdx++;
    }
    
}
void Master_Send(unsigned char *ucBuff,int len)
{
  unsigned long ulDummy=0;
 
  SPIWordCountSet(GSPI_BASE,len);
  
  SetupTransfer(UDMA_CH31_GSPI_TX,UDMA_MODE_BASIC,len,
                UDMA_SIZE_8,UDMA_ARB_1,
                (void *)ucBuff,UDMA_SRC_INC_8,(void *)(GSPI_BASE + MCSPI_O_TX0),
                UDMA_DST_INC_NONE);

  SetupTransfer(UDMA_CH30_GSPI_RX,UDMA_MODE_BASIC,len,
                UDMA_SIZE_8,UDMA_ARB_1,
                (void *)(GSPI_BASE + MCSPI_O_RX0),UDMA_SRC_INC_NONE,
                &ulDummy,UDMA_SRC_INC_NONE);
  
  MAP_SPIIntClear(GSPI_BASE,SPI_INT_EOW);
  
  //SPICSEnable(GSPI_BASE);
  MAP_SPIEnable(GSPI_BASE);
  
  while( !(MAP_SPIIntStatus(GSPI_BASE,false) & SPI_INT_EOW) );
  
  //SPICSDisable(GSPI_BASE);
  MAP_SPIDisable(GSPI_BASE);
}

void Master_Receive(unsigned char *ucBuff,int len)
{
  unsigned long ulDummy=0;
  
  SPIWordCountSet(GSPI_BASE,len);
  
  SetupTransfer(UDMA_CH30_GSPI_RX,UDMA_MODE_BASIC,len,
                UDMA_SIZE_8,UDMA_ARB_1,
                (void *)(GSPI_BASE + MCSPI_O_RX0),UDMA_SRC_INC_NONE,
                (void *)ucBuff,UDMA_DST_INC_8);
  
  SetupTransfer(UDMA_CH31_GSPI_TX,UDMA_MODE_BASIC,len,
                UDMA_SIZE_8,UDMA_ARB_1,
                &ulDummy,UDMA_SRC_INC_NONE,(void *)(GSPI_BASE + MCSPI_O_TX0),
                UDMA_DST_INC_NONE);

  MAP_SPIIntClear(GSPI_BASE,SPI_INT_EOW);
  
  MAP_SPIEnable(GSPI_BASE);
  //SPICSEnable(GSPI_BASE);
  
  while( !(MAP_SPIIntStatus(GSPI_BASE,false) & SPI_INT_EOW) );

  //SPICSDisable(GSPI_BASE);
  MAP_SPIDisable(GSPI_BASE);
}


//*****************************************************************************
//
//! SPI Slave mode main loop
//!
//! This function configures SPI modelue as slave and enables the channel for
//! communication
//!
//! \return None.
//
//*****************************************************************************
void Spi_Init()
{
    unsigned long ulBase;

    //NWP master interface
    ulBase = GSPI_BASE;

    //Enable MCSPIA2
    PRCMPeripheralClkEnable(PRCM_GSPI,PRCM_RUN_MODE_CLK);

    //Disable Chip Select
    SPICSDisable(ulBase);

    //Disable SPI Channel
    SPIDisable(ulBase);

    // Reset SPI
    SPIReset(ulBase);

    //
  // Configure SPI interface
  //
  SPIConfigSetExpClk(ulBase,PRCMPeripheralClockGet(PRCM_GSPI),
                     SPI_IF_BIT_RATE,SPI_MODE_MASTER,SPI_SUB_MODE_0,
                     (SPI_SW_CTRL_CS |
                     SPI_4PIN_MODE |
                     SPI_TURBO_OFF |
                     SPI_CS_ACTIVEHIGH |
                     SPI_WL_8));

  //
  // Initialize UDMA
  //
  UDMAInit();
  
if(PRCMPeripheralStatusGet(PRCM_UDMA))
{
  g_ucDMAEnabled = (HWREG(UDMA_BASE + UDMA_O_CTLBASE) != 0x0) ? 1 : 0;
}
else
{
	g_ucDMAEnabled = 0;
}

if(g_ucDMAEnabled)
{
    // Set DMA channel
    MAP_uDMAChannelAssign(UDMA_CH30_GSPI_RX);
    MAP_uDMAChannelAttributeDisable(UDMA_CH30_GSPI_RX,UDMA_ATTR_ALTSELECT);
    MAP_uDMAChannelAssign(UDMA_CH31_GSPI_TX);
    MAP_uDMAChannelAttributeDisable(UDMA_CH31_GSPI_TX,UDMA_ATTR_ALTSELECT);

    SPIFIFOLevelSet(ulBase,1,1);
    SPIFIFOEnable(ulBase,SPI_RX_FIFO|SPI_TX_FIFO);
    SPIDmaEnable(ulBase,SPI_RX_DMA|SPI_TX_DMA);

    IntRegister(INT_GSPI,SpiIntHandler);
    
    SPICSEnable(GSPI_BASE);
    //IntPrioritySet(INT_GSPI, INT_PRIORITY_LVL_1);
    //IntEnable(INT_GSPI);
    
    //SPIIntEnable(ulBase,SPI_INT_DMARX|SPI_INT_DMATX);
    //SPIIntEnable(ulBase,SPI_INT_EOW);
}
    g_cDummy = 0;

    //MAP_SPIEnable(ulBase);
}

//*****************************************************************************
//
//! Board Initialization & Configuration
//!
//! \param  None
//!
//! \return None
//
//*****************************************************************************
static void
BoardInit(void)
{
/* In case of TI-RTOS vector table is initialize by OS itself */
#ifndef USE_TIRTOS
  //
  // Set vector table base
  //
#if defined(ccs)
    MAP_IntVTableBaseSet((unsigned long)&g_pfnVectors[0]);
#endif
#if defined(ewarm)
    MAP_IntVTableBaseSet((unsigned long)&__vector_table);
#endif
#endif
    //
    // Enable Processor
    //
    MAP_IntMasterEnable();
    MAP_IntEnable(FAULT_SYSTICK);

    PRCMCC3200MCUInit();
}

//*****************************************************************************
//
//! Main function for spi demo application
//!
//! \param none
//!
//! \return None.
//
//*****************************************************************************
void main()
{
  unsigned long i=0;
  unsigned long j=0;
  unsigned long k=0;
    //
    // Initialize Board configurations
    //
    BoardInit();

    //
    // Muxing UART and SPI lines.
    //
    PinMuxConfig();

    //
    // Enable the SPI module clock
    //
    MAP_PRCMPeripheralClkEnable(PRCM_GSPI,PRCM_RUN_MODE_CLK);

    //
    // Initialising the Terminal.
    //
    InitTerm();

    //
    // Clearing the Terminal.
    //
    ClearTerm();

    //
    // Display the Banner
    //
    Message("\n\n\n\r");
    Message("\t\t   ********************************************\n\r");
    Message("\t\t        CC3200 SPI Demo Application  \n\r");
    Message("\t\t   ********************************************\n\r");
    Message("\n\n\n\r");

    //
    // Reset the peripheral
    //
    MAP_PRCMPeripheralReset(PRCM_GSPI);
    
    Spi_Init();
    

    while(1)
    {
       //Master_Send(g_ucTxBuff,10);
       //while(g_cDummy != 0x01);
         //g_cDummy = 0x00;
       Master_Receive(g_ucRxBuff,10);
       //Master_Receive();
       for(i=0;i<50000;i++)
       {}
         //for(j=0;j<40000;j++);
    }
    
    while(1);
    

}

