#include "stdafx.h"
#include "common.h"

#define GUI_VERSION_MAJOR 3
#define GUI_VERSION_MINOR 0
#define GUI_VERSION_BUILD 0

#ifndef DLP_API_H
#define DLP_API_H

typedef struct _hidmessageStruct
{
    struct _hidhead
    {
        struct _packetcontrolStruct
        {
            unsigned char dest		:3; /* 0 - ProjCtrl; 1 - RFC; 7 - Debugmsg */
            unsigned char reserved	:2;
            unsigned char nack		:1; /* Command Handler Error */
            unsigned char reply	:1; /* Host wants a reply from device */
            unsigned char rw		:1; /* Write = 0; Read = 1 */
        }flags;
        unsigned char seq;
        unsigned short length;
    }head;
    union
    {
        unsigned short cmd;
        unsigned char data[HID_MESSAGE_MAX_SIZE];
    }text;
}hidMessageStruct;

typedef struct _readCmdData
{
    unsigned char CMD2;
    unsigned char CMD3;
    unsigned short len;
}CmdFormat;

typedef struct _rectangle
{
    unsigned short firstPixel;
    unsigned short firstLine;
    unsigned short pixelsPerLine;
    unsigned short linesPerFrame;
}rectangle;


typedef struct _vidSigStatus
{
    unsigned char Status;
    unsigned int HRes;
    unsigned int VRes;
    unsigned char RSVD;
    unsigned char HSyncPol;
    unsigned char VSyncPol;
    unsigned long int PixClock;
    unsigned int HFreq;
    unsigned int VFreq;
    unsigned int TotPixPerLine;
    unsigned int TotLinPerFrame;
    unsigned int ActvPixPerLine;
    unsigned int ActvLinePerFrame;
    unsigned int FirstActvPix;
    unsigned int FirstActvLine;
}VideoSigStatus;

typedef enum
{
    VID_SIG_STAT,
    SOURCE_SEL,
    PIXEL_FORMAT,
    CLK_SEL,
    CHANNEL_SWAP,
    FPD_MODE,
    CURTAIN_COLOR,
    POWER_CONTROL,
    FLIP_LONG,
    FLIP_SHORT,
    TPG_SEL,
    PWM_INVERT,
    LED_ENABLE,
    GET_VERSION,
    GET_FIRMWAE_TAG_INFO,
    SW_RESET,
    DMD_PARK,
    BUFFER_FREEZE,
    STATUS_HW,
    STATUS_SYS,
    STATUS_MAIN,
    CSC_DATA,
    GAMMA_CTL,
    BC_CTL,
    PWM_ENABLE,
    PWM_SETUP,
    PWM_CAPTURE_CONFIG,
    GPIO_CONFIG,
    LED_CURRENT,
    DISP_CONFIG,
    TEMP_CONFIG,
    TEMP_READ,
    MEM_CONTROL,
    I2C_CONTROL,
    LUT_VALID,
    DISP_MODE,
    TRIG_OUT1_CTL,
    TRIG_OUT2_CTL,
    RED_STROBE_DLY,
    GRN_STROBE_DLY,
    BLU_STROBE_DLY,
    PAT_DISP_MODE,
    PAT_TRIG_MODE,
    PAT_START_STOP,
    BUFFER_SWAP,
    BUFFER_WR_DISABLE,
    CURRENT_RD_BUFFER,
    PAT_EXPO_PRD,
    INVERT_DATA,
    PAT_CONFIG,
    MBOX_ADDRESS,
    MBOX_CONTROL,
    MBOX_DATA,
    TRIG_IN1_DELAY,
    TRIG_IN2_CONTROL,
    IMAGE_LOAD,
    IMAGE_LOAD_TIMING,
    I2C0_CTRL,
    MBOX_EXP_DATA,
    MBOX_EXP_ADDRESS,
    EXP_PAT_CONFIG,
    NUM_IMAGE_IN_FLASH,
    I2C0_STAT,
    GPCLK_CONFIG,
    PULSE_GPIO_23,
    ENABLE_DLP_DEBUG,
    TPG_COLOR,
    PWM_CAPTURE_READ,
    PROG_MODE,
    BL_STATUS,
    BL_SPL_MODE,
    BL_GET_MANID,
    BL_GET_DEVID,
    BL_GET_CHKSUM,
    BL_SET_SECTADDR,
    BL_SECT_ERASE,
    BL_SET_DNLDSIZE,
    BL_DNLD_DATA,
    BL_FLASH_TYPE,
    BL_CALC_CHKSUM,
    BL_PROG_MODE
}DLP_CMD;


int  DLP_GetVideoSignalStatus(VideoSigStatus *vidSigStat);
int  DLP_SetInputSource(unsigned int source, unsigned int portWidth);
int  DLP_GetInputSource(unsigned int *pSource, unsigned int *portWidth);
int  DLP_SetPixelFormat(unsigned int format);
int  DLP_GetPixelFormat(unsigned int *pFormat);
int  DLP_SetPortClock(unsigned int clock);
int  DLP_GetPortClock(unsigned int *pClock);
int  DLP_SetDataChannelSwap(unsigned int port, unsigned int swap);
int  DLP_GetDataChannelSwap(unsigned int *pPort, unsigned int *pSwap);
int  DLP_SetFPD_Mode_Field(unsigned int PixelMappingMode, bool SwapPolarity, unsigned int FieldSignalSelect);
int  DLP_GetFPD_Mode_Field(unsigned int *pPixelMappingMode, bool *pSwapPolarity, unsigned int *pFieldSignalSelect);
int  DLP_SetPowerMode(bool);
int  DLP_GetPowerMode(bool *Standby);
int  DLP_SetLongAxisImageFlip(bool);
bool DLP_GetLongAxisImageFlip();
int  DLP_SetShortAxisImageFlip(bool);
bool DLP_GetShortAxisImageFlip();
int  DLP_SetTPGSelect(unsigned int pattern);
int  DLP_GetTPGSelect(unsigned int *pPattern);
int  DLP_SetLEDPWMInvert(bool invert);
int  DLP_GetLEDPWMInvert(bool *inverted);
int  DLP_SetLedEnables(bool SeqCtrl, bool Red, bool Green, bool Blue);
int  DLP_GetLedEnables(bool *pSeqCtrl, bool *pRed, bool *pGreen, bool *pBlue);
int  DLP_GetVersion(unsigned int *pApp_ver, unsigned int *pAPI_ver, unsigned int *pSWConfig_ver, unsigned int *pSeqConfig_ver);
int  DLP_GetFirmwareVersion(unsigned int *pFW_ver);
int  DLP_SoftwareReset(void);
int  DLP_GetStatus(unsigned char *pHWStatus, unsigned char *pSysStatus, unsigned char *pMainStatus);
int  DLP_SetPWMEnable(unsigned int channel, bool Enable);
int  DLP_GetPWMEnable(unsigned int channel, bool *pEnable);
int  DLP_SetPWMConfig(unsigned int channel, unsigned int pulsePeriod, unsigned int dutyCycle);
int  DLP_GetPWMConfig(unsigned int channel, unsigned int *pPulsePeriod, unsigned int *pDutyCycle);
int  DLP_SetPWMCaptureConfig(unsigned int channel, bool enable, unsigned int sampleRate);
int  DLP_GetPWMCaptureConfig(unsigned int channel, bool *pEnabled, unsigned int *pSampleRate);
int  DLP_SetGPIOConfig(unsigned int pinNum, bool enAltFunc, bool altFunc1, bool dirOutput, bool outTypeOpenDrain, bool pinState);
int  DLP_GetGPIOConfig(unsigned int pinNum, bool *pEnAltFunc, bool *pAltFunc1, bool *pDirOutput, bool *pOutTypeOpenDrain, bool *pState);
int  DLP_GetLedCurrents(unsigned char *pRed, unsigned char *pGreen, unsigned char *pBlue);
int  DLP_SetLedCurrents(unsigned char RedCurrent, unsigned char GreenCurrent, unsigned char BlueCurrent);
int  DLP_SetDisplay(rectangle croppedArea, rectangle displayArea);
int  DLP_GetDisplay(rectangle *pCroppedArea, rectangle *pDisplayArea);
int  DLP_MemRead(unsigned int addr, unsigned int *readWord);
int  DLP_MemWrite(unsigned int addr, unsigned int data);
int  DLP_ValidatePatLutData(unsigned int *pStatus);
int  DLP_StartPatLutValidate();
int  DLP_CheckPatLutValidate(bool *ready, unsigned int *pStatus);
int  DLP_SetPatternDisplayMode(bool external);
int  DLP_GetPatternDisplayMode(bool *external);
int  DLP_SetTrigOutConfig(unsigned int trigOutNum, bool invert, unsigned int rising, unsigned int falling);
int  DLP_GetTrigOutConfig(unsigned int trigOutNum, bool *pInvert,unsigned int *pRising, unsigned int *pFalling);
int  DLP_SetRedLEDStrobeDelay(unsigned char rising, unsigned char falling);
int  DLP_SetGreenLEDStrobeDelay(unsigned char rising, unsigned char falling);
int  DLP_SetBlueLEDStrobeDelay(unsigned char rising, unsigned char falling);
int  DLP_GetRedLEDStrobeDelay(unsigned char *, unsigned char *);
int  DLP_GetGreenLEDStrobeDelay(unsigned char *, unsigned char *);
int  DLP_GetBlueLEDStrobeDelay(unsigned char *, unsigned char *);
int  DLP_EnterProgrammingMode(void);
int  DLP_ExitProgrammingMode(void);
int  DLP_GetProgrammingMode(bool *ProgMode);
int  DLP_GetFlashManID(unsigned short *manID);
int  DLP_GetFlashDevID(unsigned long long *devID);
int  DLP_GetBLStatus(unsigned char *BL_Status);
int  DLP_SetFlashAddr(unsigned int Addr);
int  DLP_FlashSectorErase(void);
int  DLP_SetUploadSize(unsigned int dataLen);
int  DLP_UploadData(unsigned char *pByteArray, unsigned int dataLen);
void DLP_WaitForFlashReady(void);
int  DLP_SetFlashType(unsigned char Type);
int  DLP_CalculateFlashChecksum(void);
int  DLP_GetFlashChecksum(unsigned int*checksum);
int  DLP_SetMode(bool SLmode);
int  DLP_GetMode(bool *pMode);
int  DLP_LoadImageIndex(unsigned int index);
int  DLP_GetImageIndex(unsigned int *pIndex);
int  DLP_GetNumImagesInFlash(unsigned int *pNumImgInFlash);
int  DLP_SetTPGColor(unsigned short redFG, unsigned short greenFG, unsigned short blueFG, unsigned short redBG, unsigned short greenBG, unsigned short blueBG);
int  DLP_GetTPGColor(unsigned short *pRedFG, unsigned short *pGreenFG, unsigned short *pBlueFG, unsigned short *pRedBG, unsigned short *pGreenBG, unsigned short *pBlueBG);
int  DLP_ClearPatLut(void);
int  DLP_ClearExpLut(void);
int  DLP_AddToPatLut(int TrigType, int PatNum,int BitDepth,int LEDSelect,bool InvertPat, bool InsertBlack,bool BufSwap, bool trigOutPrev);
int  DLP_AddToExpLut(int TrigType, int PatNum,int BitDepth,int LEDSelect,bool InvertPat, bool InsertBlack,bool BufSwap, bool trigOutPrev, unsigned int exp_time_us, unsigned int ptn_frame_period_us);
int  DLP_GetPatLutItem(int index, int *pTrigType, int *pPatNum,int *pBitDepth,int *pLEDSelect,bool *pInvertPat, bool *pInsertBlack,bool *pBufSwap, bool *pTrigOutPrev);
int  DLP_GetVarExpPatLutItem(int index, int *pTrigType, int *pPatNum,int *pBitDepth,int *pLEDSelect,bool *pInvertPat, bool *pInsertBlack,bool *pBufSwap, bool *pTrigOutPrev, int *pPatExp, int *pPatPeriod);
int  DLP_SendPatLut(void);
int  DLP_SendVarExpPatLut(void);
int  DLP_SendImageLut(unsigned char *lutEntries, unsigned int numEntries);
int  DLP_SendVarExpImageLut(unsigned char *lutEntries, unsigned int numEntries);
int  DLP_GetPatLut(int numEntries);
int  DLP_GetVarExpPatLut(int numEntries);
int  DLP_GetImageLut(unsigned char *pLut, int numEntries);
int  DLP_GetvarExpImageLut(unsigned char *pLut, int numEntries);
int  DLP_SetPatternTriggerMode(int);
int  DLP_GetPatternTriggerMode(int *);
int  DLP_PatternDisplay(unsigned int Action);
int  DLP_GetPatternDisplay(unsigned int *pAction);
int  DLP_SetVarExpPatternConfig(unsigned int numLutEntries, unsigned int numPatsForTrigOut2, unsigned int numImages, bool repeat);
int  DLP_GetVarExpPatternConfig(unsigned int *pNumLutEntries, unsigned int *pNumPatsForTrigOut2, unsigned int *pNumImages,  bool *pRepeat);
int  DLP_SetPatternConfig(unsigned int numLutEntries, bool repeat, unsigned int numPatsForTrigOut2, unsigned int numImages);
int  DLP_GetPatternConfig(unsigned int *pNumLutEntries, bool *pRepeat, unsigned int *pNumPatsForTrigOut2, unsigned int *pNumImages);
int  DLP_SetExposure_FramePeriod(unsigned int exposurePeriod, unsigned int framePeriod);
int  DLP_GetExposure_FramePeriod(unsigned int *pExposure, unsigned int *pFramePeriod);
int  DLP_SetTrigIn1Delay(unsigned int Delay);
int  DLP_GetTrigIn1Delay(unsigned int *pDelay);
int  DLP_SetTrigIn2Pol(bool isFallingEdge);
int  DLP_GetTrigIn2Pol(bool *pIsFallingEdge);
int  DLP_SetInvertData(bool invert);
int  DLP_PWMCaptureRead(unsigned int channel, unsigned int *pLowPeriod, unsigned int *pHighPeriod);
int  DLP_SetGeneralPurposeClockOutFreq(unsigned int clkId, bool enable, unsigned int clkDivider);
int  DLP_GetGeneralPurposeClockOutFreq(unsigned int clkId, bool *pEnabled, unsigned int *pClkDivider);
int  DLP_MeasureImageLoadTiming(unsigned int startIndex, unsigned int numFlash);
int  DLP_ReadImageLoadTiming(unsigned int *pTimingData);
int  DLP_SetFreeze(bool Freeze);
int  DLP_GetFirmwareTagInfo(unsigned char *pFwTagInfo);
int  DLP_I2C0WriteData(bool is7Bit,unsigned int sclClk, unsigned int devAddr, unsigned int numWriteBytes, unsigned char *pWdata);
int  DLP_I2C0ReadData(bool is7Bit, unsigned int sclClk, unsigned int devAddr, unsigned int numWriteBytes, unsigned int numReadBytes, unsigned char *pWData, unsigned char *pRdata);
int  DLP_I2C0TranStat(unsigned char *pStat);
#endif // API_H
