
// Picture_ControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Picture_Control.h"
#include "Picture_ControlDlg.h"
#include "afxdialogex.h"
#include "API.h"
#include "usb.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

extern unsigned char g_SeqNum;
extern unsigned long int g_PatLut[MAX_PAT_LUT_ENTRIES];
extern unsigned int g_PatLutIndex;

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CPicture_ControlDlg dialog




CPicture_ControlDlg::CPicture_ControlDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CPicture_ControlDlg::IDD, pParent)
	, m_Frequency(0)
	, m_SinglePicture(0)
	, m_Picture_M(0)
	, m_Picture_N(0)
{

		m_Frequency = 10;

		m_SinglePicture = 12;

	     m_Picture_M = 10;
	     m_Picture_N = 20;

		 USB_Close();
         USB_Exit();
		 m_USB_Connected = false;
/******************************************************/
			    DLP_SetLongAxisImageFlip(false);
    DLP_SetShortAxisImageFlip(true);

    DLP_SetMode(0x1);
	    // Send trigger 1 input delay
    DLP_SetTrigIn1Delay(1);

    // Send trigger 1 output delays
    DLP_SetTrigOutConfig(1, false, 187, 187);

    // Send trigger 2 output delay
    DLP_SetTrigOutConfig(2, false, 187, 187);

	DLP_SetRedLEDStrobeDelay(187, 187);
    DLP_SetGreenLEDStrobeDelay(187, 187);
    DLP_SetBlueLEDStrobeDelay(187, 187);

    DLP_SetMode(0x0);

    // Should the LEDs be controlled by the sequence?
    DLP_SetLedEnables(true, false, false, false);
    DLP_SetLEDPWMInvert(false);
    DLP_SetLedCurrents(120, 120, 120);

    DLP_SetMode(true);

    /////on_SourceSetBut_clicked();
	DLP_SetInputSource(2, 0);
        DLP_LoadImageIndex(0);

    /// on_PortClockSetBut_clicked();
	    DLP_SetPortClock(0);

    //on_PixelFormatSetBut_clicked();
    DLP_SetPixelFormat(0);
		
	//on_SetSwapBut_clicked();
//    DLP_SetDataChannelSwap(0, ui->SwapSelectList->currentIndex());

    //on_FPDModeSetBut_clicked();
	    DLP_SetFPD_Mode_Field(3, 1, 1);


		/**********************************************************/

		//////////////////////*************************************////////////////

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPicture_ControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK1, m_USB_Connected);
	DDX_Text(pDX, IDC_EDIT1, m_Frequency);
	DDV_MinMaxInt(pDX, m_Frequency, 1, 120);
	DDX_Text(pDX, IDC_EDIT2, m_SinglePicture);
	DDV_MinMaxInt(pDX, m_SinglePicture, 1, 31);
	DDX_Text(pDX, IDC_EDIT3, m_Picture_M);
	DDV_MinMaxInt(pDX, m_Picture_M, 1, 31);
	DDX_Text(pDX, IDC_EDIT4, m_Picture_N);
	DDV_MinMaxInt(pDX, m_Picture_N, 1, 31);
}

BEGIN_MESSAGE_MAP(CPicture_ControlDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &CPicture_ControlDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON5, &CPicture_ControlDlg::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_CHECK1, &CPicture_ControlDlg::OnBnClickedCheck1)
	ON_BN_CLICKED(IDC_BUTTON6, &CPicture_ControlDlg::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON7, &CPicture_ControlDlg::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON8, &CPicture_ControlDlg::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON2, &CPicture_ControlDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CPicture_ControlDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CPicture_ControlDlg::OnBnClickedButton4)
END_MESSAGE_MAP()


// CPicture_ControlDlg message handlers

BOOL CPicture_ControlDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPicture_ControlDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPicture_ControlDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPicture_ControlDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CPicture_ControlDlg::OnBnClickedButton1()
{// project fringes
	    unsigned int patMode;
				int numLutEntries=0;
			unsigned int status;
			unsigned char splashLut[64];
			int numSplashLutEntries = 0;
			unsigned int numPatterns;
			unsigned long int exposure_time;

				UpdateData(true);
			    int i = 0;

			((CButton*)GetDlgItem(IDC_EDIT1))->SetCheck(true);
						
			DLP_SetMode(true);
    		DLP_ClearPatLut();

			numSplashLutEntries = 11;
			numLutEntries = 31;

			g_PatLut[0] = 0x67800;
			g_PatLut[1] = 0x24804;
			g_PatLut[2] = 0x27808;
			g_PatLut[3] = 0x67808;
			g_PatLut[4] = 0x27804;
			g_PatLut[5] = 0x27808;
			g_PatLut[6] = 0x67800;
			g_PatLut[7] = 0x27804;
			g_PatLut[8] = 0x27808;
			g_PatLut[9] = 0x67800;
			g_PatLut[10] = 0x27804;
			g_PatLut[11] = 0x27808;
			g_PatLut[12] = 0x67800;
			g_PatLut[13] = 0x27804;
			g_PatLut[14] = 0x27808;
			g_PatLut[15] = 0x67800;
			g_PatLut[16] = 0x27804;
            g_PatLut[17] = 0x27808;
            g_PatLut[18] = 0x67800;
			g_PatLut[19] = 0x27804;
			g_PatLut[20] = 0x27808;
			g_PatLut[21] =  0x67800;
			g_PatLut[22] = 0x27804;
			g_PatLut[23] = 0x27808;
            g_PatLut[24] = 0x67800;
			g_PatLut[25] = 0x27804;
			g_PatLut[26] = 0x27808;
			g_PatLut[27] = 0x67800;
			g_PatLut[28] = 0x27804;
			g_PatLut[29] = 0x27808;
			g_PatLut[30] = 0x67800;

			splashLut[0] = 0x0;
			splashLut[1] = 0x1;
			splashLut[2] = 0x2;			
			splashLut[3] = 0x3;			
			splashLut[4] = 0x4;			
			splashLut[5] = 0x5;
			splashLut[6] = 0x6;
			splashLut[7] = 0x7;
			splashLut[8] = 0x8;			
			splashLut[9] = 0x9;			
			splashLut[10] = 0xA;			

			DLP_SetPatternDisplayMode(false);

		numPatterns = 31;

		DLP_SetPatternConfig(numLutEntries, true , numPatterns, numSplashLutEntries);
		DLP_SetLongAxisImageFlip(false);
		DLP_SetShortAxisImageFlip(true);

		exposure_time = 1000000/m_Frequency;
		 DLP_SetExposure_FramePeriod(exposure_time, exposure_time);

		  DLP_SetPatternTriggerMode(1);
		  g_PatLutIndex = 31;
		  DLP_SendPatLut();

		   DLP_SendImageLut(&splashLut[0], numSplashLutEntries);
		   
		   DLP_ValidatePatLutData(&status);
		   
		   DLP_SetLedEnables(true, false, false, false);
           DLP_SetLEDPWMInvert(false);
		   DLP_SetLedCurrents(120, 120, 120);
//		   		   DLP_SetLedEnables(false, false, false, true); //Blue
//		   DLP_SetLedEnables(false, false, true, false); // Green
//		   DLP_SetLedEnables(false, true, false, false); //RED
//		   DLP_SetLedEnables(false, true, true, true); //white
		   		   DLP_SetLedEnables(true, true, true, true); //automatic
			DLP_PatternDisplay(2); //Start pattern display
							Sleep(1000);

			while(1)
			{
				DLP_PatternDisplay(2);
				if(i++ > 5)
					break;
			}

	// TODO: Add your control notification handler code here
}


void CPicture_ControlDlg::OnBnClickedButton5()
{//connect USB
	    char versionStr[255];
    //unsigned int API_ver, App_ver, SWConfig_ver, SeqConfig_ver;
    unsigned int FW_ver;
    bool SLmode=0;

		if(USB_IsConnected())
		USB_Close();

   USB_Init();
	USB_Open();

    if(USB_IsConnected() == true)
	{
	   // Display GUI Version #
		m_USB_Connected = true;
		((CButton*)GetDlgItem(IDC_CHECK1))->SetCheck(true);
		sprintf(versionStr, "DLP VisionFly Control Software - %d.%d.%d", GUI_VERSION_MAJOR, GUI_VERSION_MINOR, GUI_VERSION_BUILD);
	}
	else
	{
		((CButton*)GetDlgItem(IDC_CHECK1))->SetCheck(false);
	}
	// TODO: Add your control notification handler code here
}

void CPicture_ControlDlg::OnBnClickedCheck1()
{

	// TODO: Add your control notification handler code here
}
void CPicture_ControlDlg::OnBnClickedButton6()
{//start button

//		    applyIniParam(firstIniToken, iniParams, numIniParams);
			if(USB_IsConnected())
		USB_Close();
	USB_Open();

    DLP_SetLongAxisImageFlip(false);
    DLP_SetShortAxisImageFlip(true);

    DLP_SetMode(false);
	    // Send trigger 1 input delay
    DLP_SetTrigIn1Delay(1);
    // Send trigger 1 output delays
    DLP_SetTrigOutConfig(1, false, 187, 187);
    // Send trigger 2 output delay
    DLP_SetTrigOutConfig(2, false, 187, 187);

	DLP_SetRedLEDStrobeDelay(187, 187);
    DLP_SetGreenLEDStrobeDelay(187, 187);
    DLP_SetBlueLEDStrobeDelay(187, 187);

    

    // Should the LEDs be controlled by the sequence?
    DLP_SetLedEnables(true, false, false, false);
    DLP_SetLEDPWMInvert(false);
    DLP_SetLedCurrents(120, 120, 120);

    DLP_SetMode(0x0);
    /////on_SourceSetBut_clicked();
	DLP_SetInputSource(2, 0);
        DLP_LoadImageIndex(0);

    /// on_PortClockSetBut_clicked();
	    DLP_SetPortClock(0);

    //on_PixelFormatSetBut_clicked();
    DLP_SetPixelFormat(0);
		
	//on_SetSwapBut_clicked();
//    DLP_SetDataChannelSwap(0, ui->SwapSelectList->currentIndex());

    //on_FPDModeSetBut_clicked();
	    DLP_SetFPD_Mode_Field(3, 1, 1);

	// TODO: Add your control notification handler code here
}


void CPicture_ControlDlg::OnBnClickedButton7()
{
	DLP_PatternDisplay(1);
	// TODO: Add your control notification handler code here
}


void CPicture_ControlDlg::OnBnClickedButton8()
{
	DLP_PatternDisplay(0);
	// TODO: Add your control notification handler code here
}


void CPicture_ControlDlg::OnBnClickedButton2()
{// project white//  Project Picture M to Picture N
	    unsigned int patMode;
				int numLutEntries=0;
			unsigned int status;
			unsigned char splashLut[64];
			int numSplashLutEntries = 0;
			unsigned int numPatterns;
			unsigned long int exposure_time;
			int picture_number;
			int i = 0;
			int ii = 0;

				UpdateData(true);
			    
			((CButton*)GetDlgItem(IDC_EDIT1))->SetCheck(true);
			DLP_SetMode(true);
    		DLP_ClearPatLut();
			m_Picture_M = m_Picture_M -1;
			m_Picture_N = m_Picture_N -1;

			for(picture_number = m_Picture_M; picture_number <= m_Picture_N; picture_number++) 
			{
				if(picture_number%3 == 0)
				{
					g_PatLut[ii] = 0x67800;

				}
				if(picture_number%3 == 1)
				{
				
					g_PatLut[ii] = 0x27804;

				}
				if(picture_number%3 == 2)
				{
					g_PatLut[ii] = 0x27808;
				}

				splashLut[ii] = picture_number/3;
				ii++;
			}
			DLP_SetPatternDisplayMode(false);

//		    numPatterns = 31;
			numPatterns = m_Picture_N - m_Picture_M + 1;
			numPatterns = 1;
			numSplashLutEntries = ii;
//			numLutEntries = 31;
			numLutEntries = ii;

		DLP_SetPatternConfig(numLutEntries, true , numPatterns, numSplashLutEntries);
		DLP_SetLongAxisImageFlip(false);
		DLP_SetShortAxisImageFlip(true);

		exposure_time = 1000000/m_Frequency;
		 DLP_SetExposure_FramePeriod(exposure_time, exposure_time);

		  DLP_SetPatternTriggerMode(1);
//		  g_PatLutIndex = 31;
		  g_PatLutIndex = m_Picture_N - m_Picture_M + 1;
		  DLP_SendPatLut();

		   DLP_SendImageLut(&splashLut[0], numSplashLutEntries);
		   
		   DLP_ValidatePatLutData(&status);

		   DLP_SetLedEnables(true, false, false, false);
           DLP_SetLEDPWMInvert(false);
		   DLP_SetLedCurrents(120, 120, 120);
//		   		   DLP_SetLedEnables(false, false, false, true); //Blue
//		   DLP_SetLedEnables(false, false, true, false); // Green
//		   DLP_SetLedEnables(false, true, false, false); //RED
//		   DLP_SetLedEnables(false, true, true, true); //white
		   		   DLP_SetLedEnables(true, true, true, true); //automatic
			DLP_PatternDisplay(2); //Start pattern display
							Sleep(1000);

			while(1)
			{
				DLP_PatternDisplay(2);
				if(i++ > 5)
					break;
			}
	// TODO: Add your control notification handler code here
}


void CPicture_ControlDlg::OnBnClickedButton3()
{//project black//  m_SinglePicture project 1 picture:12

	    unsigned int patMode;
				int numLutEntries=0;
			unsigned int status;
			unsigned char splashLut[64];
			int numSplashLutEntries = 0;
			unsigned int numPatterns;
			unsigned long int exposure_time;

				UpdateData(true);
			    int i = 0;

			((CButton*)GetDlgItem(IDC_EDIT1))->SetCheck(true);

    		DLP_ClearPatLut();
			m_SinglePicture = m_SinglePicture -1;
			numSplashLutEntries = 1;
//			numLutEntries = 31;
			numLutEntries = 1;

			if(m_SinglePicture%3 == 0)
			{
				g_PatLut[0] = 0x67800;

			}
			if(m_SinglePicture%3 == 1)
			{
				
				g_PatLut[0] = 0x27804;

			}
			if(m_SinglePicture%3 == 2)
			{
			
				g_PatLut[0] = 0x27808;

			}

			splashLut[0] = m_SinglePicture/3;

			splashLut[1] = 0x1;
			splashLut[2] = 0x2;			
			splashLut[3] = 0x3;			
			splashLut[4] = 0x4;			
			splashLut[5] = 0x5;
			splashLut[6] = 0x6;
			splashLut[7] = 0x7;
			splashLut[8] = 0x8;			
			splashLut[9] = 0x9;			
			splashLut[10] = 0xA;			

			DLP_SetPatternDisplayMode(false);

//		numPatterns = 31;
			numPatterns = 1;

		DLP_SetPatternConfig(numLutEntries, true , numPatterns, numSplashLutEntries);
		DLP_SetLongAxisImageFlip(false);
		DLP_SetShortAxisImageFlip(true);

		exposure_time = 1000000/m_Frequency;
		 DLP_SetExposure_FramePeriod(exposure_time, exposure_time);

		  DLP_SetPatternTriggerMode(1);
//		  g_PatLutIndex = 31;
		  g_PatLutIndex = 1;
		  DLP_SendPatLut();

		   DLP_SendImageLut(&splashLut[0], numSplashLutEntries);
		   
		   DLP_ValidatePatLutData(&status);

		   DLP_SetLedEnables(true, false, false, false);
           DLP_SetLEDPWMInvert(false);
		   DLP_SetLedCurrents(120, 120, 120);
//		   		   DLP_SetLedEnables(false, false, false, true); //Blue
//		   DLP_SetLedEnables(false, false, true, false); // Green
//		   DLP_SetLedEnables(false, true, false, false); //RED
//		   DLP_SetLedEnables(false, true, true, true); //white
		   		   DLP_SetLedEnables(true, true, true, true); //automatic
			DLP_PatternDisplay(2); //Start pattern display
							Sleep(1000);

			while(1)
			{
				DLP_PatternDisplay(2);
				if(i++ > 5)
					break;
			}

	// TODO: Add your control notification handler code here
}


void CPicture_ControlDlg::OnBnClickedButton4()
{//project cross
				int numLutEntries=0;
			unsigned int status;
			unsigned char splashLut[64];
			int numSplashLutEntries = 0;
			unsigned int numPatterns;

			DLP_ClearPatLut();

			numSplashLutEntries = 0x1;
			numLutEntries = 0x1;

			g_PatLut[0] = 0x67804;
			g_PatLut[1] = 0x27800;
			g_PatLut[2] = 0x27804;
			g_PatLut[3] = 0x67808;
			g_PatLut[4] = 0x27100;
			g_PatLut[5] = 0x27104;
			g_PatLut[6] = 0x27108;
			g_PatLut[7] = 0x2710c;
			g_PatLut[8] = 0x27110;
			g_PatLut[9] = 0x27114;
			g_PatLut[10] = 0x27118;
			g_PatLut[11] = 0x2711c;
			g_PatLut[12] = 0x27120;

			splashLut[0] = 0x4;
			splashLut[1] = 0x1;
			splashLut[2] = 0x0;
			splashLut[3] = 0x1;
			splashLut[4] = 0x1;
			splashLut[5] = 0x1;
			splashLut[6] = 0x1;
			splashLut[7] = 0x1;
			splashLut[8] = 0x1;
			splashLut[9] = 0x1;
			splashLut[10] = 0x1;
			splashLut[11] = 0x1;
			splashLut[12] = 0x1;


			DLP_SetPatternDisplayMode(false);

		numPatterns = 0x1;

		DLP_SetPatternConfig(numLutEntries, true , numPatterns, numSplashLutEntries);

		 DLP_SetExposure_FramePeriod(8333, 8333);

		  DLP_SetPatternTriggerMode(1);
		  g_PatLutIndex = 1;
		  DLP_SendPatLut();

		   DLP_SendImageLut(&splashLut[0], numSplashLutEntries);
		   
		   DLP_ValidatePatLutData(&status);
		   DLP_SetLedEnables(false, true, true, true);
			DLP_PatternDisplay(2); //Start pattern display



	// TODO: Add your control notification handler code here
}
