/*
* Copyright (c) 2017 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free,
* non-exclusive license under copyrights and patents it now or hereafter
* owns or controls to make, have made, use, import, offer to sell and sell ("Utilize")
* this software subject to the terms herein.  With respect to the foregoing patent
* license, such license is granted  solely to the extent that any such patent is necessary
* to Utilize the software alone.  The patent license shall not apply to any combinations which
* include this software, other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license (including the
* above copyright notice and the disclaimer and (if applicable) source code license limitations below)
* in the documentation and/or other materials provided with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided that the following
* conditions are met:
*
*             * No reverse engineering, decompilation, or disassembly of this software is permitted with respect to any
*               software provided in binary form.
*             * any redistribution and use are licensed by TI for use only with TI Devices.
*             * Nothing shall obligate TI to provide you with source code for the software licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the source code are permitted
* provided that the following conditions are met:
*
*   * any redistribution and use of the source code, including any resulting derivative works, are licensed by
*     TI for use only with TI Devices.
*   * any redistribution and use of any object code compiled from the source code and any resulting derivative
*     works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers may be used to endorse or
* promote products derived from this software without specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __DEMO_COMMON_H__
#define __DEMO_COMMON_H__


#define DEMO_NUM_RESULTS               3
#define DEMO_MAGIC_CAL_PASS            0x0abacaca

#define DEMO_MEAS_ERR_CONFIG          -1
#define DEMO_MEAS_ERR_START           -2
#define DEMO_MEAS_ERR_FFT             -3
#define DEMO_MEAS_ERR_CAL             -4
//Mandatory Define for reporting Time Measurements
#define REPORT_IR14_TIME_MEASUREMENTS

//Define for setting PMIC into PFM Mode (Higher Efficiency)
#define PMIC_MODE_PFM

//Define for PMIC Type. NOTE: This program assumes you have made the appropriate
//PMIC modification as detailed in the Getting Started Guide
#define PMIC_TYPE_J //if PMIC on board has not been modded then comment this out.

#ifndef PMIC_TYPE_J

#undef PMIC_MODE_PFM //PFM mode is only supported on PMIC-J (LP87524J)

#endif




/**
 * @brief
 *  Chirp output data
 *
 * @details
 *  The structure is contains the processed chirp data that will be transmitted
 *  from the IWR1443 to the MSP432.
 */
typedef struct LSDemo_ChirpData_t
{
    /*! * @brief   The top N distances captured by the radar chirp. */
    float                       distance[DEMO_NUM_RESULTS];

    /*! @brief   The raw power (squared) of the frequency bin. */
    uint32_t                    power_sqr[DEMO_NUM_RESULTS];
    /*! @brief   IWR1443 measurement error code. */
    int32_t                     err;
    int32_t                     pad;
} LSDemo_ChirpData;

/**
 * @brief
 *  Calibration output data
 *
 * @details
 *  The structure is contains the calibration results that will be transmitted
 *  from the IWR1443 to the MSP432.
 */
typedef struct LSDemo_CalData_t
{
    /*! * @brief   pass/fail results of the IWR1443 calibration. */
    int32_t                     pass;
    /*! * @brief   Number of calibration data chunks flashed. */
    int32_t                     numChunks;
    /*! * @brief   Mask of calibration tasks (bitmask). */
    int32_t                     taskMask;
    /*! * @brief   pad word. */
    int32_t                     pad[5];

} LSDemo_CalData;


#endif // __DEMO_COMMON_H__
