/*
* Copyright (c) 2017 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free,
* non-exclusive license under copyrights and patents it now or hereafter
* owns or controls to make, have made, use, import, offer to sell and sell ("Utilize")
* this software subject to the terms herein.  With respect to the foregoing patent
* license, such license is granted  solely to the extent that any such patent is necessary
* to Utilize the software alone.  The patent license shall not apply to any combinations which
* include this software, other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license (including the
* above copyright notice and the disclaimer and (if applicable) source code license limitations below)
* in the documentation and/or other materials provided with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided that the following
* conditions are met:
*
*             * No reverse engineering, decompilation, or disassembly of this software is permitted with respect to any
*               software provided in binary form.
*             * any redistribution and use are licensed by TI for use only with TI Devices.
*             * Nothing shall obligate TI to provide you with source code for the software licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the source code are permitted
* provided that the following conditions are met:
*
*   * any redistribution and use of the source code, including any resulting derivative works, are licensed by
*     TI for use only with TI Devices.
*   * any redistribution and use of any object code compiled from the source code and any resulting derivative
*     works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers may be used to endorse or
* promote products derived from this software without specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __AR_GPIO_H__
#define __AR_GPIO_H__

//AR14xx GIO registers are described in the TRM, section 5.2.4.3.5.
#define GPIO_BASE_AR14XX               0xFFF7BC00

#define GPIO_GIOGCR0_REG              (GPIO_BASE_AR14XX + 0)
#define GPIO_GIOENACLR_REG            (GPIO_BASE_AR14XX + 0x14)
#define GPIO_GIODIR_REG               (GPIO_BASE_AR14XX + 0x34)
#define GPIO_GIODIN_REG               (GPIO_BASE_AR14XX + 0x38)
#define GPIO_GIODSET_REG              (GPIO_BASE_AR14XX + 0x40)
#define GPIO_GIODCLR_REG              (GPIO_BASE_AR14XX + 0x44)
#define GPIO_GIOPDR_REG               (GPIO_BASE_AR14XX + 0x48)
#define GPIO_GIOPULDIS_REG            (GPIO_BASE_AR14XX + 0x4c)
#define GPIO_GIOPSL_REG               (GPIO_BASE_AR14XX + 0x50)

#define GPIO_GIOB_OFFSET               0x20

#define GPIO_A                         0
#define GPIO_B                         1
#define GPIO_ON                        1
#define GPIO_OFF                       0
#define GPIO_INPUT                     0
#define GPIO_OUTPUT                    1


void    gpio_init(void);
void    gpio_reinit(void);
void    gpio_shutdown(void);
void    gpio_set_direction(uint16_t port, uint16_t pin, uint16_t dir);
uint8_t gpio_read(uint16_t port, uint16_t pin);
void    gpio_write(uint16_t port, uint16_t pin, uint8_t value);
void    gpio_led_on(void);
void    gpio_led_off(void);

#endif // __AR_GPIO_H__
