#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "ti/platform/platform.h"
#include "ti/platform/resource_mgr.h"

#define CORE_NUM_6670     4
platform_info    sPlatformInfo;

unsigned char *Osal_platformMalloc (uint32_t num_bytes, uint32_t alignment)
{
	return malloc(num_bytes);
}

void Osal_platformFree (uint8_t *dataPtr, uint32_t num_bytes)
{
    /* Free up the memory */
    if (dataPtr)
    {
        free(dataPtr);
    }
}

void Osal_platformSpiCsEnter(void)
{
    return;
}

void Osal_platformSpiCsExit (void)
{
    return;
}
void MulticoreBoot()
{

    int *pBootMagicAddCore0;
    int *IpcGr0;
	platform_init_flags  sFlags;
    platform_init_config sConfig;
    int i;
    int pform_status;
    int coreId = 0;

    coreId = platform_get_coreid ();

	if(coreId == 0)
	{

	    /*
	     * You can choose what to initialize on the platform by setting the following
	     * flags. We will initialize everything.
	     */
	    memset( (void *) &sFlags,  0, sizeof(platform_init_flags));
	    memset( (void *) &sConfig, 0, sizeof(platform_init_config));


	    sFlags.pll  = 1;    /* PLLs for clocking      */
	    sFlags.ddr  = 0;    /* External memory         */
	    sFlags.tcsl = 1;    /* Time stamp counter     */
		sFlags.phy  = 1;    /* Ethernet             */
	    sFlags.ecc  = 0;    /* Memory ECC             */

	    sConfig.pllm = 0;    /* Use libraries default clock divisor */
	    pform_status =  platform_init(&sFlags, &sConfig);

	    /* Platform Information - we will read it form the Platform Library */
	    platform_get_info(&sPlatformInfo);

	    if (pform_status == Platform_EOK)
	    {

	       /*write Boot Magic add of other cores and send IPC interrupt*/
	       pBootMagicAddCore0 = (int*)0x108FFFFC;
  	       (*pBootMagicAddCore0)+= 0x10000000;// translate to global address
	       for(i = 1;i < CORE_NUM_6670; i++)//write the other cores' boot magic address
	       {
	          *(pBootMagicAddCore0+ (0x01000000*i)/4 ) = (*pBootMagicAddCore0) + 0x01000000 * i;
	       }

	       IpcGr0  = (int*)0x02620240;
	       /*warning:when running on no-boot mode,core0~core7 must all be connected to the target*/
	       for(i = 1;i < CORE_NUM_6670;i++)//core0 sent ipc interrupt to
	       {
	          *(IpcGr0+i) = (*(IpcGr0+i)) | 0x00000001;
	       }
	    }


	}

	else
	{

	    memset( (void *) &sFlags,  0, sizeof(platform_init_flags));
	    memset( (void *) &sConfig, 0, sizeof(platform_init_config));


	    sFlags.pll  = 0;    /* PLLs for clocking      */
	    sFlags.ddr  = 0;    /* External memory         */
	    sFlags.tcsl = 1;    /* Time stamp counter     */
	    sFlags.phy  = 1;    /* Ethernet             */
	    sFlags.ecc  = 0;    /* Memory ECC             */

	    sConfig.pllm = 0;    /* Use libraries default clock divisor */
	    pform_status = platform_init(&sFlags, &sConfig);

	}







}
