/*
 * AM572x_GPIO.h
 *
 *  Created on: 202055
 *      Author: 
 */

#ifndef INCLUDE_AM572X_GPIO_H_
#define INCLUDE_AM572X_GPIO_H_

#include "stdint.h"
/****************************************************************************/
/*                                                                          */
/*              GPIO                                                        */
/*                                                                          */
/****************************************************************************/

union GPIOSYS_CONFIG
{
    uint32_t  all;
    struct  GPIOREGS_CONFIG
    {
        uint32_t AutoIdle  :1;    // 0
        uint32_t SoftReset :1;    // 1
        uint32_t EnaWakeUp :1;    // 2
        uint32_t IdleMode  :2;    // 3--4
        uint32_t rsvd      :27;   // 5--31
    }bit;
};
union GPIO_EOI
{
    uint32_t  all;
    struct  GPIOREGS_EOI
    {
        uint32_t LINE_NUMBER  :1;    // 0
        uint32_t rsvd         :31;   // 1--31
    }bit;
};
union GPIO_SYS_STATUS
{
    uint32_t  all;
    struct  GPIOREGS_SYSSTATUS
    {
        uint32_t RESETDONE    :1;    // 0
        uint32_t rsvd         :31;   // 1--31
    }bit;
};
union GPIO_DEBOUNCTIME
{
    uint32_t  all;
    struct  GPIOREGS_DEBOUNCTIME
    {
        uint32_t DebouncTime :8;    // 0--7
        uint32_t rsvd        :24;   // 8--31
    }bit;
};
struct GPIO_BITS
{
    uint32_t GPIO0   :1;    // 0
    uint32_t GPIO1   :1;    // 1
    uint32_t GPIO2   :1;    // 2
    uint32_t GPIO3   :1;    // 3
    uint32_t GPIO4   :1;    // 4
    uint32_t GPIO5   :1;    // 5
    uint32_t GPIO6   :1;    // 6
    uint32_t GPIO7   :1;    // 7
    uint32_t GPIO8   :1;    // 8
    uint32_t GPIO9   :1;    // 9
    uint32_t GPIO10  :1;    // 10
    uint32_t GPIO11  :1;    // 11
    uint32_t GPIO12  :1;    // 12
    uint32_t GPIO13  :1;    // 13
    uint32_t GPIO14  :1;    // 14
    uint32_t GPIO15  :1;    // 15
    uint32_t GPIO16  :1;    // 16
    uint32_t GPIO17  :1;    // 17
    uint32_t GPIO18  :1;    // 18
    uint32_t GPIO19  :1;    // 19
    uint32_t GPIO20  :1;    // 20
    uint32_t GPIO21  :1;    // 21
    uint32_t GPIO22  :1;    // 22
    uint32_t GPIO23  :1;    // 23
    uint32_t GPIO24  :1;    // 24
    uint32_t GPIO25  :1;    // 25
    uint32_t GPIO26  :1;    // 26
    uint32_t GPIO27  :1;    // 27
    uint32_t GPIO28  :1;    // 28
    uint32_t GPIO29  :1;    // 29
    uint32_t GPIO30  :1;    // 30
    uint32_t GPIO31  :1;    // 31
};


union GPIORegs_CTRL
{
    uint32_t  all;
    struct  GPIOREGS_CTRL
    {
        uint32_t DisableModule :1;    // 0
        uint32_t GatingRatio   :2;    // 1--2
        uint32_t rsvd          :29;   // 3--31
    }bit;
};
union GPIO_Regs
{
    uint32_t  all;
    struct  GPIO_BITS  bit;
};


// GPIO Ĵ
struct hw_GPIORegs
{
    uint32_t                      Revision;//IP˰汾
    uint32_t                      rsvd1[3];
    union GPIOSYS_CONFIG          Config;//ϵͳ
    uint32_t                      rsvd2[3];
    union GPIO_EOI                Eoi;
    union GPIO_Regs               IRQSTATUS_RAW0;
    union GPIO_Regs               IRQSTATUS_RAW1;
    union GPIO_Regs               IRQSTATUS0;
    union GPIO_Regs               IRQSTATUS1;
    union GPIO_Regs               IRQSTATUS_SET0;
    union GPIO_Regs               IRQSTATUS_SET1;
    union GPIO_Regs               IRQSTATUS_CLR0;
    union GPIO_Regs               IRQSTATUS_CLR1;
    union GPIO_Regs               IRQWAKEN0;
    union GPIO_Regs               IRQWAKEN1;
    uint32_t                      rsvd3[50];
    union GPIO_SYS_STATUS         SYS_STATUS;
    uint32_t                      rsvd4[6];
    union GPIORegs_CTRL           Ctrl; //ƼĴ
    union GPIO_Regs               OE;         //ʹ,Ĵ
    union GPIO_Regs               IN_DATA;     //ݼĴ
    union GPIO_Regs               OUT_DATA;    //ݼĴ
    union GPIO_Regs               LowLevelDetection0;//͵ƽʹ
    union GPIO_Regs               LowLevelDetection1;//͵ƽʹ
    union GPIO_Regs               RisDetection;//ؼʹ
    union GPIO_Regs               FalDetection;//½ؼʹ
    union GPIO_Regs               DebouncEnable;//ȥʹ
    union GPIO_DEBOUNCTIME        DebouncTime;//ȥʱ
    uint32_t                      rsvd5[14];
    union GPIO_Regs               CLR_DATAOUT;    //λĴ
    union GPIO_Regs               SET_DATAOUT;    //λĴ
};
// GPIO 洢ռӳ
extern volatile struct hw_GPIORegs     *GpioARegs;
extern volatile struct hw_GPIORegs     *GpioBRegs;
extern volatile struct hw_GPIORegs     GpioCRegs;
extern volatile struct hw_GPIORegs     *GpioDRegs;
extern volatile struct hw_GPIORegs     *GpioERegs;
extern volatile struct hw_GPIORegs     *GpioFRegs;
extern volatile struct hw_GPIORegs     *GpioGRegs;
extern volatile struct hw_GPIORegs     *GpioHRegs;


#endif /* INCLUDE_AM572X_GPIO_H_ */
