/*
 * AM572x_PADCTRL.h
 *
 *  Created on: 202055
 *      Author: 
 */

#ifndef INCLUDE_AM572X_PADCTRL_H_
#define INCLUDE_AM572X_PADCTRL_H_

#include "stdint.h"

union CTRL_CORE_PAD
{
    uint32_t  all;
    struct  CORE_PAD
    {
        uint32_t MUXMODE        :4;  //0--3
        uint32_t DELAYMODE      :4;  //4--7
        uint32_t MODESELECT     :1;  //8
        uint32_t rsvd1          :7;  //9--15
        uint32_t PULLUDENABLE   :1;  //16
        uint32_t PULLTYPESELECT :1;  //17
        uint32_t INPUTENABLE    :1;  //18
        uint32_t SLEWCONTROL    :1;  //19
        uint32_t rsvd2          :4;  //20--23
        uint32_t WAKEUPENABLE   :1;  //24
        uint32_t WAKEUPEVENT    :1;  //25
        uint32_t rsvd3          :6;  //26--31
    }bit;
};

struct PAD_CTRL_CORE
{
    union CTRL_CORE_PAD PIN_AD9;
    uint32_t            rsvd[18];
    union CTRL_CORE_PAD PIN_AF4;
};
extern volatile struct PAD_CTRL_CORE *PADConfig;
#endif /* INCLUDE_AM572X_PADCTRL_H_ */
