
#include "EVM_init.h"

uint8_t *Osal_platformMalloc (uint32_t num_bytes, uint32_t alignment)
{
    return malloc(num_bytes);
}
void Osal_platformFree (uint8_t *dataPtr, uint32_t num_bytes)
{
    if (dataPtr)
    {
        free(dataPtr);
    }
}

void Osal_platformSpiCsEnter(void)
{
    while ((CSL_semAcquireDirect (PLATFORM_SPI_HW_SEM)) == 0);
    return;
}
void Osal_platformSpiCsExit (void)
{
    CSL_semReleaseSemaphore (PLATFORM_SPI_HW_SEM);
    return;
}

uint32_t convert_CoreLocal2GlobalAddr (uint32_t addr)
{
    uint32_t coreNum;
    coreNum = CSL_chipReadReg(CSL_CHIP_DNUM);
    return ((1 << 28) | (coreNum << 24) | (addr & 0x00ffffff));
}
void EVM_init()
{
    platform_init_flags sFlags;
    platform_init_config sConfig;
    int32_t pform_status;

    platform_uart_init();
    platform_uart_set_baudrate(115200);
    (void) platform_write_configure(PLATFORM_WRITE_ALL);
    memset( (void *) &sFlags, 0, sizeof(platform_init_flags));
    memset( (void *) &sConfig, 0, sizeof(platform_init_config));

    sFlags.pll = 0; /* PLLs for clocking */
    sFlags.ddr = 0; /* External memory */
    //sFlags.tcsl = 1; /* Time stamp counter */
    sFlags.phy = 0; /* Ethernet */
    sFlags.ecc = 0; /* Memory ECC */
    sConfig.pllm = 0; /* Use libraries default clock divisor */
    pform_status = platform_init(&sFlags, &sConfig);

    if (pform_status != Platform_EOK)
    {
        platform_write("Platform failed to initialize. Error code %d \n", pform_status);
        platform_write("We will die in an infinite loop... \n");
        while (1)
        {
            (void) platform_led(1, PLATFORM_LED_ON, PLATFORM_USER_LED_CLASS);
            (void) platform_delay(50000);
            (void) platform_led(1, PLATFORM_LED_OFF, PLATFORM_USER_LED_CLASS);
            (void) platform_delay(50000);
        }
    }
    return;
}

Void my_print_status_for_Notify_sendEvent(Int status)
{
    switch(status)
    {
    case Notify_E_EVTNOTREGISTERED :
        platform_write("event has no registered callback \n");
        break;
    case Notify_E_NOTINITIALIZED :
        platform_write("remote driver has not yet been initialized \n");
        break;
    case Notify_E_EVTDISABLED :
        platform_write("remote event is disabled \n");
        break;
    case Notify_E_TIMEOUT :
        platform_write("timeout occurred (when waitClear is TRUE) \n");
        break;
    case Notify_S_SUCCESS :
        platform_write(" event successfully sent \n");
        break;
    default :
        platform_write(" What? \n");
        break;
    }
}


