#ifndef EVM_INIT_H_
#define EVM_INIT_H_





#endif /* EVM_INIT_H_ */

#include <xdc/std.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//runtime
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>
#include <xdc/runtime/IHeap.h>
#include <xdc/runtime/Memory.h>
//sysbios
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/knl/swi.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Semaphore.h>
//platform
#include "ti\platform\platform.h"
#include "ti\platform\resource_mgr.h"
/* ----- IPC module Headers */
#include <ti/ipc/GateMP.h>
#include <ti/ipc/Ipc.h>
#include <ti/ipc/MessageQ.h>
//#include <ti/ipc/HeapBufMP.h> //not rtsc
#include <ti/sdo/ipc/heaps/HeapBufMP.h>
#include <ti/sdo/ipc/SharedRegion.h>
#include <ti/ipc/MultiProc.h>
#include <ti/ipc/Notify.h>
//cfg.global
#include <xdc/cfg/global.h>
//

uint8_t *Osal_platformMalloc (uint32_t num_bytes, uint32_t alignment);
void Osal_platformFree (uint8_t *dataPtr, uint32_t num_bytes);
void Osal_platformSpiCsEnter(void);
void Osal_platformSpiCsExit (void);
uint32_t convert_CoreLocal2GlobalAddr (uint32_t addr);
Void my_print_status_for_Notify_sendEvent(Int status);
void EVM_init();

