#include "EVM_init.h"
#include <ti/sdo/edma3/rm/edma3_common.h>
#include <ti/sdo/edma3/drv/sample/bios6_edma3_drv_sample.h>

#define MAX_ACOUNT                  (64u)

#pragma DATA_ALIGN(Data_in_DDR3, 4);
#pragma DATA_SECTION ( Data_in_DDR3 , ".mysection_in_ddr3");
Uint32 Data_in_DDR3[MAX_ACOUNT];

#pragma DATA_ALIGN(Data_in_MSM, 4);
#pragma DATA_SECTION ( Data_in_MSM , ".mysection_in_msm");
Uint32 Data_in_MSM[MAX_ACOUNT];

Uint32 *s_addr,*d_addr;

//#define OPT_SYNCDIM_SHIFT                   (0x00000002u)
#define OPT_TCC_MASK                        (0x0003F000u)
#define OPT_TCC_SHIFT                       (0x0000000Cu)
#define OPT_ITCINTEN_SHIFT                  (0x00000015u)
#define OPT_TCINTEN_SHIFT                   (0x00000014u)

volatile short irqRaised = 0;
void *AppSemHandle = NULL;
void callback1 (uint32_t tcc, EDMA3_RM_TccStatus status, void *appData);

Void taskFxn(UArg a0, UArg a1)
{
    //EDMA3_DRV_SyncType syncType=EDMA3_DRV_SYNC_A;
    uint32_t numenabled = 0,aCnt,bCnt,cCnt;
    uint32_t Istestpassed = 0u;
    unsigned int i;
    for(i=0;i<MAX_ACOUNT;i++)
    {
        Data_in_MSM[i]=MAX_ACOUNT-i;
        Data_in_DDR3[i]=i;
    }
    /*for (i = 0; i < 4; i++)
    {
        platform_write("Before DMA Data in MSM  %d  is %d\n",i,Data_in_MSM[i]);
        platform_write("Before DMA Data in DDR3 %d  is %d\n",i,Data_in_DDR3[i]);
    }*/
    platform_write("task start!\n");
    //Uint32 srcAddr,  dstAddr;
    unsigned int edmaInstance = 0;

    EDMA3_DRV_Result edmaResult = EDMA3_DRV_SOK;
    EDMA3_DRV_Handle hEdma;
    //EDMA3_OS_Sem_Handle *hSem;
    Semaphore_Params semParams;
    Semaphore_Params_init(&semParams);

    edmaResult = edma3OsSemCreate(0, &semParams, &AppSemHandle);

    EDMA3_DRV_PaRAMRegs paramSet = {0,0,0,0,0,0,0,0,0,0,0,0};

    hEdma = edma3init(edmaInstance, &edmaResult);

    if (hEdma)
    {
        platform_write("edma3init() Passed\n");
    }
    else
    {
        platform_write("edma3init() Failed, error code: %d\n", (int)edmaResult);
    }

    uint32_t chId=0;
    uint32_t tcc = 0;

    chId = EDMA3_DRV_DMA_CHANNEL_ANY;
    tcc = EDMA3_DRV_TCC_ANY;

    if (edmaResult == EDMA3_DRV_SOK)
    {
        edmaResult = EDMA3_DRV_requestChannel (hEdma, &chId, &tcc,(EDMA3_RM_EventQueue)0, &callback1,NULL);
    }


    s_addr = Data_in_DDR3 ;
    d_addr = Data_in_MSM  ;
#ifdef EDMA3_ENABLE_DCACHE
    //Note: These functions are required if the buffer is in DDR.
    //For other cases, where buffer is NOT in DDR, user
    //may or may not require the below functions.
    // Flush the Source Buffer
    if (edmaResult == EDMA3_DRV_SOK)
    {
        edmaResult = Edma3_CacheFlush((uint32_t)s_addr, MAX_ACOUNT);
    }

    //Invalidate the Destination Buffer
    if (edmaResult == EDMA3_DRV_SOK)
    {
        edmaResult = Edma3_CacheInvalidate((uint32_t)d_addr, MAX_ACOUNT);
    }
#endif  //EDMA3_ENABLE_DCACHE

    if (edmaResult == EDMA3_DRV_SOK)
    {
        paramSet.srcAddr    = (uint32_t)(s_addr);
        paramSet.destAddr   = (uint32_t)(d_addr);

        aCnt = MAX_ACOUNT;
        bCnt = 1;
        cCnt = 1;
        paramSet.aCnt       = aCnt;
        paramSet.bCnt       = bCnt;
        paramSet.cCnt       = cCnt;

        paramSet.srcBIdx    = MAX_ACOUNT;
        paramSet.destBIdx   = MAX_ACOUNT;
        paramSet.srcCIdx    = MAX_ACOUNT;
        paramSet.destCIdx   = MAX_ACOUNT;

        paramSet.bCntReload = bCnt;

        paramSet.linkAddr   = 0xFFFFu;

        paramSet.opt &= 0xFFFFFFFCu;//Source & Destination are in INCR modes

        paramSet.opt |= ((tcc << OPT_TCC_SHIFT) & OPT_TCC_MASK);//Program the TCC

        paramSet.opt |= (1 << OPT_ITCINTEN_SHIFT);//Enable Intermediate & Final transfer completion interrupt
        paramSet.opt |= (1 << OPT_TCINTEN_SHIFT); //Enable Intermediate & Final transfer completion interrupt

        paramSet.opt &= 0xFFFFFFFBu;//syncType == EDMA3_DRV_SYNC_A

        edmaResult = EDMA3_DRV_setPaRAM(hEdma, chId, &paramSet);
    }




    platform_write("1 is ok\n");
    if (edmaResult == EDMA3_DRV_SOK)
    {
        numenabled = bCnt * cCnt;

        for (i = 0; i < numenabled; i++)
        {
            irqRaised = 0 ;
            platform_write("2 is ok\n");
            edmaResult = EDMA3_DRV_enableTransfer (hEdma, chId,EDMA3_DRV_TRIG_MODE_MANUAL);
            if (edmaResult != EDMA3_DRV_SOK)
            {
                platform_write("edma3_test: EDMA3_DRV_enableTransfer " \
                    "Failed, error code: %d\r\n", (int)edmaResult);
                break;
            }
            platform_write("3 is ok\n");
            edma3OsSemTake(AppSemHandle, EDMA3_OSSEM_NO_TIMEOUT);
            while (irqRaised == 0u)//Wait for the Completion ISR
            {
                platform_write("waiting for interrupt...\n");//Wait for the Completion ISR
            }

            if (irqRaised < 0)
            {
                /* Some error occured, break from the FOR loop. */
                platform_write("\r\nedma3_test: Event Miss Occured!!!\r\n");

                /* Clear the error bits first */
                edmaResult = EDMA3_DRV_clearErrorBits (hEdma, chId);
                break;
            }

            platform_write("4 is ok\n");
        }

    }
    for (i = 0; i < 4; i++)
    {
        platform_write("Data in MSM  %d  is %d\n",i,Data_in_MSM[i]);
        platform_write("Data in DDR3 %d  is %d\n",i,Data_in_DDR3[i]);
    }

        if (EDMA3_DRV_SOK == edmaResult)
        {
            for (i = 0; i < (MAX_ACOUNT*1*1); i++)
            {
                if (s_addr[i] != d_addr[i])
                {
                    Istestpassed = 0u;
                    platform_write("edma3_test: Data write-read matching" \
                        "FAILED at i = %d\r\n", i);
                    break;
                }
            }
            if (i == (MAX_ACOUNT*1*1))
            {
                Istestpassed = 1u;
            }

            platform_write("5 is ok\n");
            /* Free the previously allocated channel. */
            edmaResult = EDMA3_DRV_freeChannel (hEdma, chId);
            if (edmaResult != EDMA3_DRV_SOK)
            {
                platform_write("edma3_test: EDMA3_DRV_freeChannel() FAILED, " \
                    "error code: %d\r\n", (int)edmaResult);
            }
        }
        if(Istestpassed == 1u)
        {
            platform_write("edma3_test PASSED\r\n");
        }
        else
        {
            platform_write("edma3_test FAILED\r\n");
            edmaResult = ((EDMA3_DRV_SOK == edmaResult) ?
                        EDMA3_DATA_MISMATCH_ERROR : edmaResult);
        }

    platform_write("6 is ok\n");

}

Int main()
{
    platform_write("BIOS_start\n");
    BIOS_start();
    return(0);
}

void callback1 (uint32_t tcc, EDMA3_RM_TccStatus status, void *appData)//Callback function 1
{
    (void)tcc;
    (void)appData;

    switch (status)
    {
    case EDMA3_RM_XFER_COMPLETE:
        irqRaised = 1;//Transfer completed successfully
        break;
    case EDMA3_RM_E_CC_DMA_EVT_MISS:
        irqRaised = -1;//Transfer resulted in DMA event miss error
        break;
    case EDMA3_RM_E_CC_QDMA_EVT_MISS:
        irqRaised = -2;//Transfer resulted in QDMA event miss error
        break;
    default:
        break;
    }
    edma3OsSemGive(AppSemHandle);
}
