/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_srio.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for SRIO
 */
#ifndef _CSLR_SRIO_H_
#define _CSLR_SRIO_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure for the Buffer Descriptors
\**************************************************************************/
typedef struct buffDesc {
    Uint32 nextDescPtr;
    Uint32 buffPtr;
    Uint32 opt1;
    Uint32 opt2;
} CSL_SrioBuffDesc;

/**************************************************************************\
* Register Overlay Structure for BLK_ENABLE 
\**************************************************************************/
typedef struct  {
    volatile Uint32 BLK_EN;
    volatile Uint32 BLK_EN_STAT;
} CSL_SrioBlk_enableRegs;

/**************************************************************************\
* Register Overlay Structure for HW_PKT_FWD 
\**************************************************************************/
typedef struct  {
    volatile Uint32 PF_16BIT_CNTL;
    volatile Uint32 PF_8BIT_CNTL;
} CSL_SrioHw_pkt_fwdRegs;

/**************************************************************************\
* Register Overlay Structure for DOORBELL_INTR 
\**************************************************************************/
typedef struct  {
    volatile Uint32 DOORBELL_ICSR;
    volatile Uint8 RSVD0[4];
    volatile Uint32 DOORBELL_ICCR;
    volatile Uint8 RSVD1[4];
} CSL_SrioDoorbell_intrRegs;

/**************************************************************************\
* Register Overlay Structure for DOORBELL_INTR_ROUTE 
\**************************************************************************/
typedef struct  {
    volatile Uint32 DOORBELL_ICRR;
    volatile Uint32 DOORBELL_ICRR2;
    volatile Uint8 RSVD0[8];
} CSL_SrioDoorbell_intr_routeRegs;

/**************************************************************************\
* Register Overlay Structure for LSU 
\**************************************************************************/
typedef struct  {
    volatile Uint32 LSU_REG0;
    volatile Uint32 LSU_REG1;
    volatile Uint32 LSU_REG2;
    volatile Uint32 LSU_REG3;
    volatile Uint32 LSU_REG4;
    volatile Uint32 LSU_REG5;
    volatile Uint32 LSU_REG6;
    volatile Uint32 LSU_FLOW_MASKS;
} CSL_SrioLsuRegs;

/**************************************************************************\
* Register Overlay Structure for MAP 
\**************************************************************************/
typedef struct  {
    volatile Uint32 RXU_MAP_L;
    volatile Uint32 RXU_MAP_H;
} CSL_SrioMapRegs;

/**************************************************************************\
* Register Overlay Structure for PORT 
\**************************************************************************/
typedef struct  {
    volatile Uint32 SP_LM_REQ;
    volatile Uint32 SP_LM_RESP;
    volatile Uint32 SP_ACKID_STAT;
    volatile Uint8 RSVD0[12];
    volatile Uint32 SP_ERR_STAT;
    volatile Uint32 SP_CTL;
} CSL_SrioPortRegs;

/**************************************************************************\
* Register Overlay Structure for PORT_ERROR 
\**************************************************************************/
typedef struct  {
    volatile Uint32 SP_ERR_DET;
    volatile Uint32 SP_RATE_EN;
    volatile Uint32 SP_ERR_ATTR_CAPT_DBG0;
    volatile Uint32 SP_ERR_CAPT_DBG[4];
    volatile Uint8 RSVD0[12];
    volatile Uint32 SP_ERR_RATE;
    volatile Uint32 SP_ERR_THRESH;
    volatile Uint8 RSVD1[16];
} CSL_SrioPort_errorRegs;

/**************************************************************************\
* Register Overlay Structure for PORT_OPTION 
\**************************************************************************/
typedef struct  {
    volatile Uint32 SP_RST_OPT;
    volatile Uint32 SP_CTL_INDEP;
    volatile Uint32 SP_SILENCE_TIMER;
    volatile Uint32 SP_MULT_EVNT_CS;
    volatile Uint8 RSVD0[4];
    volatile Uint32 SP_CS_TX;
    volatile Uint8 RSVD1[232];
} CSL_SrioPort_optionRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint32 PCR;
    volatile Uint8 RSVD0[24];
    volatile Uint32 PER_SET_CNTL;
    volatile Uint8 RSVD1[12];
    volatile Uint32 GBL_EN;
    volatile Uint32 GBL_EN_STAT;
    CSL_SrioBlk_enableRegs BLK_ENABLE[9];
    volatile Uint32 DEVICEID_REG1;
    volatile Uint32 DEVICEID_REG2;
    volatile Uint8 RSVD3[8];
    CSL_SrioHw_pkt_fwdRegs HW_PKT_FWD[4];
    volatile Uint8 RSVD4[80];
    volatile Uint32 SERDES_CFGRX_CNTL[4];
    volatile Uint32 SERDES_CFGTX_CNTL[4];
    volatile Uint32 SERDES_CFG_CNTL[4];
    volatile Uint8 RSVD5[208];
    CSL_SrioDoorbell_intrRegs DOORBELL_INTR[4];
    volatile Uint32 RX_CPPI_ICSR;
    volatile Uint8 RSVD6[4];
    volatile Uint32 RX_CPPI_ICCR;
    volatile Uint8 RSVD7[4];
    volatile Uint32 TX_CPPI_ICSR;
    volatile Uint8 RSVD8[4];
    volatile Uint32 TX_CPPI_ICCR;
    volatile Uint8 RSVD9[4];
    volatile Uint32 LSU_ICSR;
    volatile Uint8 RSVD10[4];
    volatile Uint32 LSU_ICCR;
    volatile Uint8 RSVD11[4];
    volatile Uint32 ERR_RST_EVNT_ICSR;
    volatile Uint8 RSVD12[4];
    volatile Uint32 ERR_RST_EVNT_ICCR;
    volatile Uint8 RSVD13[4];
    CSL_SrioDoorbell_intr_routeRegs DOORBELL_INTR_ROUTE[4];
    volatile Uint32 RX_CPPI_ICRR;
    volatile Uint32 RX_CPPI_ICRR2;
    volatile Uint8 RSVD14[8];
    volatile Uint32 TX_CPPI_ICRR;
    volatile Uint32 TX_CPPI_ICRR2;
    volatile Uint8 RSVD15[8];
    volatile Uint32 LSU_ICRR[4];
    volatile Uint32 ERR_RST_EVNT_ICRR;
    volatile Uint32 ERR_RST_EVNT_ICRR2;
    volatile Uint32 ERR_RST_EVNT_ICRR3;
    volatile Uint8 RSVD16[4];
    volatile Uint32 INTDST_DECODE[8];
    volatile Uint32 INTDST_RATE_CNTL[8];
    volatile Uint8 RSVD17[192];
    CSL_SrioLsuRegs LSU[4];
    volatile Uint8 RSVD18[128];
    volatile Uint32 QUEUE_TXDMA_HDP[16];
    volatile Uint8 RSVD19[64];
    volatile Uint32 QUEUE_TXDMA_CP[16];
    volatile Uint8 RSVD20[64];
    volatile Uint32 QUEUE_RXDMA_HDP[16];
    volatile Uint8 RSVD21[64];
    volatile Uint32 QUEUE_RXDMA_CP[16];
    volatile Uint8 RSVD22[64];
    volatile Uint32 TX_QUEUE_TEAR_DOWN;
    volatile Uint32 TX_CPPI_FLOW_MASKS[8];
    volatile Uint8 RSVD23[28];
    volatile Uint32 RX_QUEUE_TEAR_DOWN;
    volatile Uint32 RX_CPPI_CNTL;
    volatile Uint8 RSVD24[152];
    volatile Uint32 TX_QUEUE_CNTL0;
    volatile Uint32 TX_QUEUE_CNTL1;
    volatile Uint32 TX_QUEUE_CNTL2;
    volatile Uint32 TX_QUEUE_CNTL3;
    volatile Uint8 RSVD25[16];
    CSL_SrioMapRegs MAP[32];
    volatile Uint32 FLOW_CNTL[16];
    volatile Uint8 RSVD27[1728];
    volatile Uint32 DEV_ID;
    volatile Uint32 DEV_INFO;
    volatile Uint32 ASBLY_ID;
    volatile Uint32 ASBLY_INFO;
    volatile Uint32 PE_FEAT;
    volatile Uint8 RSVD28[4];
    volatile Uint32 SRC_OP;
    volatile Uint32 DEST_OP;
    volatile Uint8 RSVD29[44];
    volatile Uint32 PE_LL_CTL;
    volatile Uint8 RSVD30[8];
    volatile Uint32 LCL_CFG_HBAR;
    volatile Uint32 LCL_CFG_BAR;
    volatile Uint32 BASE_ID;
    volatile Uint8 RSVD31[4];
    volatile Uint32 HOST_BASE_ID_LOCK;
    volatile Uint32 COMP_TAG;
    volatile Uint8 RSVD32[144];
    volatile Uint32 SP_MB_HEAD;
    volatile Uint8 RSVD33[28];
    volatile Uint32 SP_LT_CTL;
    volatile Uint32 SP_RT_CTL;
    volatile Uint8 RSVD34[20];
    volatile Uint32 SP_GEN_CTL;
    CSL_SrioPortRegs PORT[4];
    volatile Uint8 RSVD35[3648];
    volatile Uint32 ERR_RPT_BH;
    volatile Uint8 RSVD36[4];
    volatile Uint32 ERR_DET;
    volatile Uint32 ERR_EN;
    volatile Uint32 H_ADDR_CAPT;
    volatile Uint32 ADDR_CAPT;
    volatile Uint32 ID_CAPT;
    volatile Uint32 CTRL_CAPT;
    volatile Uint8 RSVD37[8];
    volatile Uint32 PW_TGT_ID;
    volatile Uint8 RSVD38[20];
    CSL_SrioPort_errorRegs PORT_ERROR[4];
    volatile Uint8 RSVD39[65216];
    volatile Uint32 SP_IP_DISCOVERY_TIMER;
    volatile Uint32 SP_IP_MODE;
    volatile Uint32 IP_PRESCAL;
    volatile Uint8 RSVD40[4];
    volatile Uint32 SP_IP_PW_IN_CAPT[4];
    volatile Uint8 RSVD41[8160];
    CSL_SrioPort_optionRegs PORT_OPTION[4];
    volatile Uint8 RSVD42[965864];
    CSL_SrioBuffDesc txBuffDesc[32];
    CSL_SrioBuffDesc rxBuffDesc[32];
} CSL_SrioRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_SrioRegs             *CSL_SrioRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PID */

#define CSL_SRIO_PID_TYPE_MASK           (0x00FF0000u)
#define CSL_SRIO_PID_TYPE_SHIFT          (0x00000010u)
#define CSL_SRIO_PID_TYPE_RESETVAL       (0x00000001u)

#define CSL_SRIO_PID_CLASS_MASK          (0x0000FF00u)
#define CSL_SRIO_PID_CLASS_SHIFT         (0x00000008u)
#define CSL_SRIO_PID_CLASS_RESETVAL      (0x0000000Au)

#define CSL_SRIO_PID_REV_MASK            (0x000000FFu)
#define CSL_SRIO_PID_REV_SHIFT           (0x00000000u)
#define CSL_SRIO_PID_REV_RESETVAL        (0x00000001u)

#define CSL_SRIO_PID_RESETVAL            (0x00010A01u)

/* PCR */

#define CSL_SRIO_PCR_PEREN_MASK          (0x00000004u)
#define CSL_SRIO_PCR_PEREN_SHIFT         (0x00000002u)
#define CSL_SRIO_PCR_PEREN_RESETVAL      (0x00000000u)

/*----PEREN Tokens----*/
#define CSL_SRIO_PCR_PEREN_DISABLE       (0x00000000u)
#define CSL_SRIO_PCR_PEREN_ENABLE        (0x00000001u)

#define CSL_SRIO_PCR_SOFT_MASK           (0x00000002u)
#define CSL_SRIO_PCR_SOFT_SHIFT          (0x00000001u)
#define CSL_SRIO_PCR_SOFT_RESETVAL       (0x00000000u)

#define CSL_SRIO_PCR_FREE_MASK           (0x00000001u)
#define CSL_SRIO_PCR_FREE_SHIFT          (0x00000000u)
#define CSL_SRIO_PCR_FREE_RESETVAL       (0x00000001u)

#define CSL_SRIO_PCR_RESETVAL            (0x00000001u)

/* PER_SET_CNTL */

#define CSL_SRIO_PER_SET_CNTL_SW_MEM_SLEEP_OVERRIDE_MASK (0x04000000u)
#define CSL_SRIO_PER_SET_CNTL_SW_MEM_SLEEP_OVERRIDE_SHIFT (0x0000001Au)
#define CSL_SRIO_PER_SET_CNTL_SW_MEM_SLEEP_OVERRIDE_RESETVAL (0x00000001u)

/*----SW_MEM_SLEEP_OVERRIDE Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_SW_MEM_SLEEP_OVERRIDE_DISABLE (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_SW_MEM_SLEEP_OVERRIDE_ENABLE (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_LOOPBACK_MASK (0x02000000u)
#define CSL_SRIO_PER_SET_CNTL_LOOPBACK_SHIFT (0x00000019u)
#define CSL_SRIO_PER_SET_CNTL_LOOPBACK_RESETVAL (0x00000000u)

/*----LOOPBACK Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_LOOPBACK_NORMAL (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_LOOPBACK_LOOPBACK (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_BOOT_COMPLETE_MASK (0x01000000u)
#define CSL_SRIO_PER_SET_CNTL_BOOT_COMPLETE_SHIFT (0x00000018u)
#define CSL_SRIO_PER_SET_CNTL_BOOT_COMPLETE_RESETVAL (0x00000000u)

/*----BOOT_COMPLETE Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_BOOT_COMPLETE_WRITE_ENABLE (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_BOOT_COMPLETE_WRITE_DISABLE (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_TX_PRI2_WM_MASK (0x001C0000u)
#define CSL_SRIO_PER_SET_CNTL_TX_PRI2_WM_SHIFT (0x00000012u)
#define CSL_SRIO_PER_SET_CNTL_TX_PRI2_WM_RESETVAL (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_TX_PRI1_WM_MASK (0x00038000u)
#define CSL_SRIO_PER_SET_CNTL_TX_PRI1_WM_SHIFT (0x0000000Fu)
#define CSL_SRIO_PER_SET_CNTL_TX_PRI1_WM_RESETVAL (0x00000002u)

#define CSL_SRIO_PER_SET_CNTL_TX_PRI0_WM_MASK (0x00007000u)
#define CSL_SRIO_PER_SET_CNTL_TX_PRI0_WM_SHIFT (0x0000000Cu)
#define CSL_SRIO_PER_SET_CNTL_TX_PRI0_WM_RESETVAL (0x00000003u)

#define CSL_SRIO_PER_SET_CNTL_CBA_TRANS_PRI_MASK (0x00000E00u)
#define CSL_SRIO_PER_SET_CNTL_CBA_TRANS_PRI_SHIFT (0x00000009u)
#define CSL_SRIO_PER_SET_CNTL_CBA_TRANS_PRI_RESETVAL (0x00000000u)

#define CSL_SRIO_PER_SET_CNTL_1X_MODE_MASK (0x00000100u)
#define CSL_SRIO_PER_SET_CNTL_1X_MODE_SHIFT (0x00000008u)
#define CSL_SRIO_PER_SET_CNTL_1X_MODE_RESETVAL (0x00000000u)

/*----1X_MODE Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_1X_MODE_DISABLE (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_1X_MODE_ENABLE (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_MASK (0x000000F0u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_SHIFT (0x00000004u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_RESETVAL (0x00000000u)

/*----PRESCALER_SELECT Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_1 (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_2 (0x00000001u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_3 (0x00000002u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_4 (0x00000003u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_5 (0x00000004u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_6 (0x00000005u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_7 (0x00000006u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_8 (0x00000007u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_9 (0x00000008u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_10 (0x00000009u)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_11 (0x0000000Au)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_12 (0x0000000Bu)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_13 (0x0000000Cu)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_14 (0x0000000Du)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_15 (0x0000000Eu)
#define CSL_SRIO_PER_SET_CNTL_PRESCALER_SELECT_16 (0x0000000Fu)

#define CSL_SRIO_PER_SET_CNTL_ENPLL4_MASK (0x00000008u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL4_SHIFT (0x00000003u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL4_RESETVAL (0x00000000u)

/*----ENPLL4 Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_ENPLL4_DISABLE (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL4_ENABLE (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_ENPLL3_MASK (0x00000004u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL3_SHIFT (0x00000002u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL3_RESETVAL (0x00000000u)

/*----ENPLL3 Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_ENPLL3_DISABLE (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL3_ENABLE (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_ENPLL2_MASK (0x00000002u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL2_SHIFT (0x00000001u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL2_RESETVAL (0x00000000u)

/*----ENPLL2 Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_ENPLL2_DISABLE (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL2_ENABLE (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_ENPLL1_MASK (0x00000001u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL1_SHIFT (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL1_RESETVAL (0x00000000u)

/*----ENPLL1 Tokens----*/
#define CSL_SRIO_PER_SET_CNTL_ENPLL1_DISABLE (0x00000000u)
#define CSL_SRIO_PER_SET_CNTL_ENPLL1_ENABLE (0x00000001u)

#define CSL_SRIO_PER_SET_CNTL_RESETVAL   (0x04053000u)

/* GBL_EN */

#define CSL_SRIO_GBL_EN_EN_MASK          (0x00000001u)
#define CSL_SRIO_GBL_EN_EN_SHIFT         (0x00000000u)
#define CSL_SRIO_GBL_EN_EN_RESETVAL      (0x00000000u)

/*----EN Tokens----*/
#define CSL_SRIO_GBL_EN_EN_DISABLE       (0x00000000u)
#define CSL_SRIO_GBL_EN_EN_ENABLE        (0x00000001u)

#define CSL_SRIO_GBL_EN_RESETVAL         (0x00000000u)

/* GBL_EN_STAT */

#define CSL_SRIO_GBL_EN_STAT_GBL_EN_STAT_MASK (0x00000001u)
#define CSL_SRIO_GBL_EN_STAT_GBL_EN_STAT_SHIFT (0x00000000u)
#define CSL_SRIO_GBL_EN_STAT_GBL_EN_STAT_RESETVAL (0x00000000u)

#define CSL_SRIO_GBL_EN_STAT_RESETVAL    (0x00000000u)

/* BLK_EN */

#define CSL_SRIO_BLK_EN_EN_MASK          (0x00000001u)
#define CSL_SRIO_BLK_EN_EN_SHIFT         (0x00000000u)
#define CSL_SRIO_BLK_EN_EN_RESETVAL      (0x00000000u)

/*----EN Tokens----*/
#define CSL_SRIO_BLK_EN_EN_DISABLE       (0x00000000u)
#define CSL_SRIO_BLK_EN_EN_ENABLE        (0x00000001u)

#define CSL_SRIO_BLK_EN_RESETVAL         (0x00000000u)

/* BLK_EN_STAT */

#define CSL_SRIO_BLK_EN_STAT_EN_STAT_MASK (0x00000001u)
#define CSL_SRIO_BLK_EN_STAT_EN_STAT_SHIFT (0x00000000u)
#define CSL_SRIO_BLK_EN_STAT_EN_STAT_RESETVAL (0x00000000u)

#define CSL_SRIO_BLK_EN_STAT_RESETVAL    (0x00000000u)

/* DEVICEID_REG1 */

#define CSL_SRIO_DEVICEID_REG1_8BNODEID_MASK (0x00FF0000u)
#define CSL_SRIO_DEVICEID_REG1_8BNODEID_SHIFT (0x00000010u)
#define CSL_SRIO_DEVICEID_REG1_8BNODEID_RESETVAL (0x000000FFu)

#define CSL_SRIO_DEVICEID_REG1_16BNODEID_MASK (0x0000FFFFu)
#define CSL_SRIO_DEVICEID_REG1_16BNODEID_SHIFT (0x00000000u)
#define CSL_SRIO_DEVICEID_REG1_16BNODEID_RESETVAL (0x0000FFFFu)

#define CSL_SRIO_DEVICEID_REG1_RESETVAL  (0x00FFFFFFu)

/* DEVICEID_REG2 */

#define CSL_SRIO_DEVICEID_REG2_8BNODEID_MASK (0x00FF0000u)
#define CSL_SRIO_DEVICEID_REG2_8BNODEID_SHIFT (0x00000010u)
#define CSL_SRIO_DEVICEID_REG2_8BNODEID_RESETVAL (0x000000FFu)

#define CSL_SRIO_DEVICEID_REG2_16BNODEID_MASK (0x0000FFFFu)
#define CSL_SRIO_DEVICEID_REG2_16BNODEID_SHIFT (0x00000000u)
#define CSL_SRIO_DEVICEID_REG2_16BNODEID_RESETVAL (0x0000FFFFu)

#define CSL_SRIO_DEVICEID_REG2_RESETVAL  (0x00FFFFFFu)

/* PF_16BIT_CNTL */

#define CSL_SRIO_PF_16BIT_CNTL_16BIT_DEVID_UP_BOUND_MASK (0xFFFF0000u)
#define CSL_SRIO_PF_16BIT_CNTL_16BIT_DEVID_UP_BOUND_SHIFT (0x00000010u)
#define CSL_SRIO_PF_16BIT_CNTL_16BIT_DEVID_UP_BOUND_RESETVAL (0x0000FFFFu)

#define CSL_SRIO_PF_16BIT_CNTL_16BIT_DEVID_LOW_BOUND_MASK (0x0000FFFFu)
#define CSL_SRIO_PF_16BIT_CNTL_16BIT_DEVID_LOW_BOUND_SHIFT (0x00000000u)
#define CSL_SRIO_PF_16BIT_CNTL_16BIT_DEVID_LOW_BOUND_RESETVAL (0x0000FFFFu)

#define CSL_SRIO_PF_16BIT_CNTL_RESETVAL  (0xFFFFFFFFu)

/* PF_8BIT_CNTL */

#define CSL_SRIO_PF_8BIT_CNTL_OUT_BOUND_PORT_MASK (0x00030000u)
#define CSL_SRIO_PF_8BIT_CNTL_OUT_BOUND_PORT_SHIFT (0x00000010u)
#define CSL_SRIO_PF_8BIT_CNTL_OUT_BOUND_PORT_RESETVAL (0x00000003u)

#define CSL_SRIO_PF_8BIT_CNTL_8BIT_DEVID_UP_BOUND_MASK (0x0000FF00u)
#define CSL_SRIO_PF_8BIT_CNTL_8BIT_DEVID_UP_BOUND_SHIFT (0x00000008u)
#define CSL_SRIO_PF_8BIT_CNTL_8BIT_DEVID_UP_BOUND_RESETVAL (0x000000FFu)

#define CSL_SRIO_PF_8BIT_CNTL_8BIT_DEVID_LOW_BOUND_MASK (0x000000FFu)
#define CSL_SRIO_PF_8BIT_CNTL_8BIT_DEVID_LOW_BOUND_SHIFT (0x00000000u)
#define CSL_SRIO_PF_8BIT_CNTL_8BIT_DEVID_LOW_BOUND_RESETVAL (0x000000FFu)

#define CSL_SRIO_PF_8BIT_CNTL_RESETVAL   (0x0003FFFFu)

/* SERDES_CFGRX_CNTL */

#define CSL_SRIO_SERDES_CFGRX_CNTL_EQ_MASK (0x00780000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_EQ_SHIFT (0x00000013u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_EQ_RESETVAL (0x00000000u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_CDR_MASK (0x00070000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_CDR_SHIFT (0x00000010u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_CDR_RESETVAL (0x00000000u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_LOS_MASK (0x0000C000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_LOS_SHIFT (0x0000000Eu)
#define CSL_SRIO_SERDES_CFGRX_CNTL_LOS_RESETVAL (0x00000000u)

/*----LOS Tokens----*/
#define CSL_SRIO_SERDES_CFGRX_CNTL_LOS_DISABLED (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_LOS_HIGH_THRESHOLD (0x00000001u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_LOS_LOW_THRESHOLD (0x00000002u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_ALIGN_MASK (0x00003000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_ALIGN_SHIFT (0x0000000Cu)
#define CSL_SRIO_SERDES_CFGRX_CNTL_ALIGN_RESETVAL (0x00000000u)

/*----ALIGN Tokens----*/
#define CSL_SRIO_SERDES_CFGRX_CNTL_ALIGN_DISABLE (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_ALIGN_COMMA (0x00000001u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_ALIGN_JOG (0x00000002u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_TERM_MASK (0x00000700u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_TERM_SHIFT (0x00000008u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_TERM_RESETVAL (0x00000000u)

/*----TERM Tokens----*/
#define CSL_SRIO_SERDES_CFGRX_CNTL_TERM_VDDT (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_TERM_0_8_VDDT (0x00000001u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_TERM_FLOATING (0x00000003u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_INVPAIR_MASK (0x00000080u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_INVPAIR_SHIFT (0x00000007u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_INVPAIR_RESETVAL (0x00000000u)

/*----INVPAIR Tokens----*/
#define CSL_SRIO_SERDES_CFGRX_CNTL_INVPAIR_NORMAL (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_INVPAIR_INVERTED (0x00000001u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_RATE_MASK (0x00000060u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_RATE_SHIFT (0x00000005u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_RATE_RESETVAL (0x00000000u)

/*----RATE Tokens----*/
#define CSL_SRIO_SERDES_CFGRX_CNTL_RATE_FULL (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_RATE_HALF (0x00000001u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_RATE_QUARTER (0x00000002u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_BUSWIDTH_MASK (0x0000001Cu)
#define CSL_SRIO_SERDES_CFGRX_CNTL_BUSWIDTH_SHIFT (0x00000002u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_BUSWIDTH_RESETVAL (0x00000000u)

/*----BUSWIDTH Tokens----*/
#define CSL_SRIO_SERDES_CFGRX_CNTL_BUSWIDTH_10BIT (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_BUSWIDTH_8BIT (0x00000001u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_ENRX_MASK (0x00000001u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_ENRX_SHIFT (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_ENRX_RESETVAL (0x00000000u)

/*----ENRX Tokens----*/
#define CSL_SRIO_SERDES_CFGRX_CNTL_ENRX_DISABLE (0x00000000u)
#define CSL_SRIO_SERDES_CFGRX_CNTL_ENRX_ENABLE (0x00000001u)

#define CSL_SRIO_SERDES_CFGRX_CNTL_RESETVAL (0x00000000u)

/* SERDES_CFGTX_CNTL */

#define CSL_SRIO_SERDES_CFGTX_CNTL_ENFTP_MASK (0x00010000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENFTP_SHIFT (0x00000010u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENFTP_RESETVAL (0x00000000u)

/*----ENFTP Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENFTP_ARBITRARY (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENFTP_FIXED (0x00000001u)

#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_MASK (0x0000F000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_SHIFT (0x0000000Cu)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_RESETVAL (0x00000000u)

/*----DE Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_4_76 (0x00000001u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_9_52 (0x00000002u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_14_28 (0x00000003u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_19_04 (0x00000004u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_23_80 (0x00000005u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_28_56 (0x00000006u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_33_32 (0x00000007u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_38_08 (0x00000008u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_42_85 (0x00000009u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_47_61 (0x0000000Au)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_52_38 (0x0000000Bu)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_57_14 (0x0000000Cu)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_61_90 (0x0000000Du)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_66_66 (0x0000000Eu)
#define CSL_SRIO_SERDES_CFGTX_CNTL_DE_71_42 (0x0000000Fu)

#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_MASK (0x00000E00u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_SHIFT (0x00000009u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_RESETVAL (0x00000000u)

/*----SWING Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_125 (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_250 (0x00000001u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_500 (0x00000002u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_625 (0x00000003u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_750 (0x00000004u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_1000 (0x00000005u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_1125 (0x00000006u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_SWING_1250 (0x00000007u)

#define CSL_SRIO_SERDES_CFGTX_CNTL_CM_MASK (0x00000100u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_CM_SHIFT (0x00000008u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_CM_RESETVAL (0x00000000u)

/*----CM Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_CM_NORMAL (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_CM_RAISED (0x00000001u)

#define CSL_SRIO_SERDES_CFGTX_CNTL_INVPAIR_MASK (0x00000080u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_INVPAIR_SHIFT (0x00000007u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_INVPAIR_RESETVAL (0x00000000u)

/*----INVPAIR Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_INVPAIR_NORMAL (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_INVPAIR_INVERTED (0x00000001u)

#define CSL_SRIO_SERDES_CFGTX_CNTL_RATE_MASK (0x00000060u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_RATE_SHIFT (0x00000005u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_RATE_RESETVAL (0x00000000u)

/*----RATE Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_RATE_FULL (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_RATE_HALF (0x00000001u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_RATE_QUARTER (0x00000002u)

#define CSL_SRIO_SERDES_CFGTX_CNTL_BUSWIDTH_MASK (0x0000001Cu)
#define CSL_SRIO_SERDES_CFGTX_CNTL_BUSWIDTH_SHIFT (0x00000002u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_BUSWIDTH_RESETVAL (0x00000000u)

/*----BUSWIDTH Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_BUSWIDTH_10BIT (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_BUSWIDTH_8BIT (0x00000001u)

#define CSL_SRIO_SERDES_CFGTX_CNTL_ENTX_MASK (0x00000001u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENTX_SHIFT (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENTX_RESETVAL (0x00000000u)

/*----ENTX Tokens----*/
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENTX_DISABLE (0x00000000u)
#define CSL_SRIO_SERDES_CFGTX_CNTL_ENTX_ENABLE (0x00000001u)

#define CSL_SRIO_SERDES_CFGTX_CNTL_RESETVAL (0x00000000u)

/* SERDES_CFG_CNTL */

#define CSL_SRIO_SERDES_CFG_CNTL_LB_MASK (0x00000300u)
#define CSL_SRIO_SERDES_CFG_CNTL_LB_SHIFT (0x00000008u)
#define CSL_SRIO_SERDES_CFG_CNTL_LB_RESETVAL (0x00000000u)

/*----LB Tokens----*/
#define CSL_SRIO_SERDES_CFG_CNTL_LB_FREQ_DEP (0x00000000u)
#define CSL_SRIO_SERDES_CFG_CNTL_LB_LOW  (0x00000002u)
#define CSL_SRIO_SERDES_CFG_CNTL_LB_HIGH (0x00000003u)

#define CSL_SRIO_SERDES_CFG_CNTL_MPY_MASK (0x0000003Eu)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_SHIFT (0x00000001u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_RESETVAL (0x00000000u)

/*----MPY Tokens----*/
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_4   (0x00000000u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_5   (0x00000001u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_6   (0x00000002u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_8   (0x00000004u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_10  (0x00000005u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_12  (0x00000006u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_12_5 (0x00000007u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_15  (0x00000008u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_20  (0x00000009u)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_25  (0x0000000Au)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_50  (0x0000000Du)
#define CSL_SRIO_SERDES_CFG_CNTL_MPY_60  (0x0000000Eu)

#define CSL_SRIO_SERDES_CFG_CNTL_ENPLL_MASK (0x00000001u)
#define CSL_SRIO_SERDES_CFG_CNTL_ENPLL_SHIFT (0x00000000u)
#define CSL_SRIO_SERDES_CFG_CNTL_ENPLL_RESETVAL (0x00000000u)

/*----ENPLL Tokens----*/
#define CSL_SRIO_SERDES_CFG_CNTL_ENPLL_DISABLE (0x00000000u)
#define CSL_SRIO_SERDES_CFG_CNTL_ENPLL_ENABLE (0x00000001u)

#define CSL_SRIO_SERDES_CFG_CNTL_RESETVAL (0x00000000u)

/* DOORBELL_ICSR */

#define CSL_SRIO_DOORBELL_ICSR_ICS15_MASK (0x00008000u)
#define CSL_SRIO_DOORBELL_ICSR_ICS15_SHIFT (0x0000000Fu)
#define CSL_SRIO_DOORBELL_ICSR_ICS15_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS14_MASK (0x00004000u)
#define CSL_SRIO_DOORBELL_ICSR_ICS14_SHIFT (0x0000000Eu)
#define CSL_SRIO_DOORBELL_ICSR_ICS14_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS13_MASK (0x00002000u)
#define CSL_SRIO_DOORBELL_ICSR_ICS13_SHIFT (0x0000000Du)
#define CSL_SRIO_DOORBELL_ICSR_ICS13_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS12_MASK (0x00001000u)
#define CSL_SRIO_DOORBELL_ICSR_ICS12_SHIFT (0x0000000Cu)
#define CSL_SRIO_DOORBELL_ICSR_ICS12_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS11_MASK (0x00000800u)
#define CSL_SRIO_DOORBELL_ICSR_ICS11_SHIFT (0x0000000Bu)
#define CSL_SRIO_DOORBELL_ICSR_ICS11_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS10_MASK (0x00000400u)
#define CSL_SRIO_DOORBELL_ICSR_ICS10_SHIFT (0x0000000Au)
#define CSL_SRIO_DOORBELL_ICSR_ICS10_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS9_MASK (0x00000200u)
#define CSL_SRIO_DOORBELL_ICSR_ICS9_SHIFT (0x00000009u)
#define CSL_SRIO_DOORBELL_ICSR_ICS9_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS8_MASK (0x00000100u)
#define CSL_SRIO_DOORBELL_ICSR_ICS8_SHIFT (0x00000008u)
#define CSL_SRIO_DOORBELL_ICSR_ICS8_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS7_MASK (0x00000080u)
#define CSL_SRIO_DOORBELL_ICSR_ICS7_SHIFT (0x00000007u)
#define CSL_SRIO_DOORBELL_ICSR_ICS7_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS6_MASK (0x00000040u)
#define CSL_SRIO_DOORBELL_ICSR_ICS6_SHIFT (0x00000006u)
#define CSL_SRIO_DOORBELL_ICSR_ICS6_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS5_MASK (0x00000020u)
#define CSL_SRIO_DOORBELL_ICSR_ICS5_SHIFT (0x00000005u)
#define CSL_SRIO_DOORBELL_ICSR_ICS5_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS4_MASK (0x00000010u)
#define CSL_SRIO_DOORBELL_ICSR_ICS4_SHIFT (0x00000004u)
#define CSL_SRIO_DOORBELL_ICSR_ICS4_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS3_MASK (0x00000008u)
#define CSL_SRIO_DOORBELL_ICSR_ICS3_SHIFT (0x00000003u)
#define CSL_SRIO_DOORBELL_ICSR_ICS3_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS2_MASK (0x00000004u)
#define CSL_SRIO_DOORBELL_ICSR_ICS2_SHIFT (0x00000002u)
#define CSL_SRIO_DOORBELL_ICSR_ICS2_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS1_MASK (0x00000002u)
#define CSL_SRIO_DOORBELL_ICSR_ICS1_SHIFT (0x00000001u)
#define CSL_SRIO_DOORBELL_ICSR_ICS1_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_ICS0_MASK (0x00000001u)
#define CSL_SRIO_DOORBELL_ICSR_ICS0_SHIFT (0x00000000u)
#define CSL_SRIO_DOORBELL_ICSR_ICS0_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICSR_RESETVAL  (0x00000000u)

/* DOORBELL_ICCR */

#define CSL_SRIO_DOORBELL_ICCR_ICC15_MASK (0x00008000u)
#define CSL_SRIO_DOORBELL_ICCR_ICC15_SHIFT (0x0000000Fu)
#define CSL_SRIO_DOORBELL_ICCR_ICC15_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC14_MASK (0x00004000u)
#define CSL_SRIO_DOORBELL_ICCR_ICC14_SHIFT (0x0000000Eu)
#define CSL_SRIO_DOORBELL_ICCR_ICC14_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC13_MASK (0x00002000u)
#define CSL_SRIO_DOORBELL_ICCR_ICC13_SHIFT (0x0000000Du)
#define CSL_SRIO_DOORBELL_ICCR_ICC13_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC12_MASK (0x00001000u)
#define CSL_SRIO_DOORBELL_ICCR_ICC12_SHIFT (0x0000000Cu)
#define CSL_SRIO_DOORBELL_ICCR_ICC12_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC11_MASK (0x00000800u)
#define CSL_SRIO_DOORBELL_ICCR_ICC11_SHIFT (0x0000000Bu)
#define CSL_SRIO_DOORBELL_ICCR_ICC11_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC10_MASK (0x00000400u)
#define CSL_SRIO_DOORBELL_ICCR_ICC10_SHIFT (0x0000000Au)
#define CSL_SRIO_DOORBELL_ICCR_ICC10_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC9_MASK (0x00000200u)
#define CSL_SRIO_DOORBELL_ICCR_ICC9_SHIFT (0x00000009u)
#define CSL_SRIO_DOORBELL_ICCR_ICC9_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC8_MASK (0x00000100u)
#define CSL_SRIO_DOORBELL_ICCR_ICC8_SHIFT (0x00000008u)
#define CSL_SRIO_DOORBELL_ICCR_ICC8_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC7_MASK (0x00000080u)
#define CSL_SRIO_DOORBELL_ICCR_ICC7_SHIFT (0x00000007u)
#define CSL_SRIO_DOORBELL_ICCR_ICC7_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC6_MASK (0x00000040u)
#define CSL_SRIO_DOORBELL_ICCR_ICC6_SHIFT (0x00000006u)
#define CSL_SRIO_DOORBELL_ICCR_ICC6_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC5_MASK (0x00000020u)
#define CSL_SRIO_DOORBELL_ICCR_ICC5_SHIFT (0x00000005u)
#define CSL_SRIO_DOORBELL_ICCR_ICC5_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC4_MASK (0x00000010u)
#define CSL_SRIO_DOORBELL_ICCR_ICC4_SHIFT (0x00000004u)
#define CSL_SRIO_DOORBELL_ICCR_ICC4_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC3_MASK (0x00000008u)
#define CSL_SRIO_DOORBELL_ICCR_ICC3_SHIFT (0x00000003u)
#define CSL_SRIO_DOORBELL_ICCR_ICC3_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC2_MASK (0x00000004u)
#define CSL_SRIO_DOORBELL_ICCR_ICC2_SHIFT (0x00000002u)
#define CSL_SRIO_DOORBELL_ICCR_ICC2_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC1_MASK (0x00000002u)
#define CSL_SRIO_DOORBELL_ICCR_ICC1_SHIFT (0x00000001u)
#define CSL_SRIO_DOORBELL_ICCR_ICC1_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_ICC0_MASK (0x00000001u)
#define CSL_SRIO_DOORBELL_ICCR_ICC0_SHIFT (0x00000000u)
#define CSL_SRIO_DOORBELL_ICCR_ICC0_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICCR_RESETVAL  (0x00000000u)

/* RX_CPPI_ICSR */

#define CSL_SRIO_RX_CPPI_ICSR_ICS15_MASK (0x00008000u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS15_SHIFT (0x0000000Fu)
#define CSL_SRIO_RX_CPPI_ICSR_ICS15_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS14_MASK (0x00004000u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS14_SHIFT (0x0000000Eu)
#define CSL_SRIO_RX_CPPI_ICSR_ICS14_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS13_MASK (0x00002000u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS13_SHIFT (0x0000000Du)
#define CSL_SRIO_RX_CPPI_ICSR_ICS13_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS12_MASK (0x00001000u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS12_SHIFT (0x0000000Cu)
#define CSL_SRIO_RX_CPPI_ICSR_ICS12_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS11_MASK (0x00000800u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS11_SHIFT (0x0000000Bu)
#define CSL_SRIO_RX_CPPI_ICSR_ICS11_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS10_MASK (0x00000400u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS10_SHIFT (0x0000000Au)
#define CSL_SRIO_RX_CPPI_ICSR_ICS10_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS9_MASK  (0x00000200u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS9_SHIFT (0x00000009u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS9_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS8_MASK  (0x00000100u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS8_SHIFT (0x00000008u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS8_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS7_MASK  (0x00000080u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS7_SHIFT (0x00000007u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS7_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS6_MASK  (0x00000040u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS6_SHIFT (0x00000006u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS6_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS5_MASK  (0x00000020u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS5_SHIFT (0x00000005u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS5_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS4_MASK  (0x00000010u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS4_SHIFT (0x00000004u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS4_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS3_MASK  (0x00000008u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS3_SHIFT (0x00000003u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS3_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS2_MASK  (0x00000004u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS2_SHIFT (0x00000002u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS2_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS1_MASK  (0x00000002u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS1_SHIFT (0x00000001u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS1_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_ICS0_MASK  (0x00000001u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS0_SHIFT (0x00000000u)
#define CSL_SRIO_RX_CPPI_ICSR_ICS0_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICSR_RESETVAL   (0x00000000u)

/* RX_CPPI_ICCR */

#define CSL_SRIO_RX_CPPI_ICCR_ICC15_MASK (0x00008000u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC15_SHIFT (0x0000000Fu)
#define CSL_SRIO_RX_CPPI_ICCR_ICC15_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC14_MASK (0x00004000u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC14_SHIFT (0x0000000Eu)
#define CSL_SRIO_RX_CPPI_ICCR_ICC14_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC13_MASK (0x00002000u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC13_SHIFT (0x0000000Du)
#define CSL_SRIO_RX_CPPI_ICCR_ICC13_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC12_MASK (0x00001000u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC12_SHIFT (0x0000000Cu)
#define CSL_SRIO_RX_CPPI_ICCR_ICC12_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC11_MASK (0x00000800u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC11_SHIFT (0x0000000Bu)
#define CSL_SRIO_RX_CPPI_ICCR_ICC11_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC10_MASK (0x00000400u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC10_SHIFT (0x0000000Au)
#define CSL_SRIO_RX_CPPI_ICCR_ICC10_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC9_MASK  (0x00000200u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC9_SHIFT (0x00000009u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC9_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC8_MASK  (0x00000100u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC8_SHIFT (0x00000008u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC8_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC7_MASK  (0x00000080u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC7_SHIFT (0x00000007u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC7_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC6_MASK  (0x00000040u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC6_SHIFT (0x00000006u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC6_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC5_MASK  (0x00000020u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC5_SHIFT (0x00000005u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC5_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC4_MASK  (0x00000010u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC4_SHIFT (0x00000004u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC4_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC3_MASK  (0x00000008u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC3_SHIFT (0x00000003u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC3_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC2_MASK  (0x00000004u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC2_SHIFT (0x00000002u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC2_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC1_MASK  (0x00000002u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC1_SHIFT (0x00000001u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC1_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_ICC0_MASK  (0x00000001u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC0_SHIFT (0x00000000u)
#define CSL_SRIO_RX_CPPI_ICCR_ICC0_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICCR_RESETVAL   (0x00000000u)

/* TX_CPPI_ICSR */

#define CSL_SRIO_TX_CPPI_ICSR_ICS15_MASK (0x00008000u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS15_SHIFT (0x0000000Fu)
#define CSL_SRIO_TX_CPPI_ICSR_ICS15_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS14_MASK (0x00004000u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS14_SHIFT (0x0000000Eu)
#define CSL_SRIO_TX_CPPI_ICSR_ICS14_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS13_MASK (0x00002000u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS13_SHIFT (0x0000000Du)
#define CSL_SRIO_TX_CPPI_ICSR_ICS13_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS12_MASK (0x00001000u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS12_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_CPPI_ICSR_ICS12_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS11_MASK (0x00000800u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS11_SHIFT (0x0000000Bu)
#define CSL_SRIO_TX_CPPI_ICSR_ICS11_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS10_MASK (0x00000400u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS10_SHIFT (0x0000000Au)
#define CSL_SRIO_TX_CPPI_ICSR_ICS10_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS9_MASK  (0x00000200u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS9_SHIFT (0x00000009u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS9_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS8_MASK  (0x00000100u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS8_SHIFT (0x00000008u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS8_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS7_MASK  (0x00000080u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS7_SHIFT (0x00000007u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS7_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS6_MASK  (0x00000040u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS6_SHIFT (0x00000006u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS6_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS5_MASK  (0x00000020u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS5_SHIFT (0x00000005u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS5_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS4_MASK  (0x00000010u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS4_SHIFT (0x00000004u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS4_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS3_MASK  (0x00000008u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS3_SHIFT (0x00000003u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS3_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS2_MASK  (0x00000004u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS2_SHIFT (0x00000002u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS2_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS1_MASK  (0x00000002u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS1_SHIFT (0x00000001u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS1_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_ICS0_MASK  (0x00000001u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS0_SHIFT (0x00000000u)
#define CSL_SRIO_TX_CPPI_ICSR_ICS0_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICSR_RESETVAL   (0x00000000u)

/* TX_CPPI_ICCR */

#define CSL_SRIO_TX_CPPI_ICCR_ICC15_MASK (0x00008000u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC15_SHIFT (0x0000000Fu)
#define CSL_SRIO_TX_CPPI_ICCR_ICC15_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC14_MASK (0x00004000u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC14_SHIFT (0x0000000Eu)
#define CSL_SRIO_TX_CPPI_ICCR_ICC14_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC13_MASK (0x00002000u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC13_SHIFT (0x0000000Du)
#define CSL_SRIO_TX_CPPI_ICCR_ICC13_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC12_MASK (0x00001000u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC12_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_CPPI_ICCR_ICC12_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC11_MASK (0x00000800u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC11_SHIFT (0x0000000Bu)
#define CSL_SRIO_TX_CPPI_ICCR_ICC11_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC10_MASK (0x00000400u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC10_SHIFT (0x0000000Au)
#define CSL_SRIO_TX_CPPI_ICCR_ICC10_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC9_MASK  (0x00000200u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC9_SHIFT (0x00000009u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC9_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC8_MASK  (0x00000100u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC8_SHIFT (0x00000008u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC8_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC7_MASK  (0x00000080u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC7_SHIFT (0x00000007u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC7_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC6_MASK  (0x00000040u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC6_SHIFT (0x00000006u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC6_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC5_MASK  (0x00000020u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC5_SHIFT (0x00000005u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC5_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC4_MASK  (0x00000010u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC4_SHIFT (0x00000004u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC4_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC3_MASK  (0x00000008u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC3_SHIFT (0x00000003u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC3_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC2_MASK  (0x00000004u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC2_SHIFT (0x00000002u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC2_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC1_MASK  (0x00000002u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC1_SHIFT (0x00000001u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC1_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_ICC0_MASK  (0x00000001u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC0_SHIFT (0x00000000u)
#define CSL_SRIO_TX_CPPI_ICCR_ICC0_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICCR_RESETVAL   (0x00000000u)

/* LSU_ICSR */

#define CSL_SRIO_LSU_ICSR_ICS31_MASK     (0x80000000u)
#define CSL_SRIO_LSU_ICSR_ICS31_SHIFT    (0x0000001Fu)
#define CSL_SRIO_LSU_ICSR_ICS31_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS30_MASK     (0x40000000u)
#define CSL_SRIO_LSU_ICSR_ICS30_SHIFT    (0x0000001Eu)
#define CSL_SRIO_LSU_ICSR_ICS30_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS29_MASK     (0x20000000u)
#define CSL_SRIO_LSU_ICSR_ICS29_SHIFT    (0x0000001Du)
#define CSL_SRIO_LSU_ICSR_ICS29_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS28_MASK     (0x10000000u)
#define CSL_SRIO_LSU_ICSR_ICS28_SHIFT    (0x0000001Cu)
#define CSL_SRIO_LSU_ICSR_ICS28_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS27_MASK     (0x08000000u)
#define CSL_SRIO_LSU_ICSR_ICS27_SHIFT    (0x0000001Bu)
#define CSL_SRIO_LSU_ICSR_ICS27_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS26_MASK     (0x04000000u)
#define CSL_SRIO_LSU_ICSR_ICS26_SHIFT    (0x0000001Au)
#define CSL_SRIO_LSU_ICSR_ICS26_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS25_MASK     (0x02000000u)
#define CSL_SRIO_LSU_ICSR_ICS25_SHIFT    (0x00000019u)
#define CSL_SRIO_LSU_ICSR_ICS25_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS24_MASK     (0x01000000u)
#define CSL_SRIO_LSU_ICSR_ICS24_SHIFT    (0x00000018u)
#define CSL_SRIO_LSU_ICSR_ICS24_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS23_MASK     (0x00800000u)
#define CSL_SRIO_LSU_ICSR_ICS23_SHIFT    (0x00000017u)
#define CSL_SRIO_LSU_ICSR_ICS23_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS22_MASK     (0x00400000u)
#define CSL_SRIO_LSU_ICSR_ICS22_SHIFT    (0x00000016u)
#define CSL_SRIO_LSU_ICSR_ICS22_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS21_MASK     (0x00200000u)
#define CSL_SRIO_LSU_ICSR_ICS21_SHIFT    (0x00000015u)
#define CSL_SRIO_LSU_ICSR_ICS21_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS20_MASK     (0x00100000u)
#define CSL_SRIO_LSU_ICSR_ICS20_SHIFT    (0x00000014u)
#define CSL_SRIO_LSU_ICSR_ICS20_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS19_MASK     (0x00080000u)
#define CSL_SRIO_LSU_ICSR_ICS19_SHIFT    (0x00000013u)
#define CSL_SRIO_LSU_ICSR_ICS19_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS18_MASK     (0x00040000u)
#define CSL_SRIO_LSU_ICSR_ICS18_SHIFT    (0x00000012u)
#define CSL_SRIO_LSU_ICSR_ICS18_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS17_MASK     (0x00020000u)
#define CSL_SRIO_LSU_ICSR_ICS17_SHIFT    (0x00000011u)
#define CSL_SRIO_LSU_ICSR_ICS17_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS16_MASK     (0x00010000u)
#define CSL_SRIO_LSU_ICSR_ICS16_SHIFT    (0x00000010u)
#define CSL_SRIO_LSU_ICSR_ICS16_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS15_MASK     (0x00008000u)
#define CSL_SRIO_LSU_ICSR_ICS15_SHIFT    (0x0000000Fu)
#define CSL_SRIO_LSU_ICSR_ICS15_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS14_MASK     (0x00004000u)
#define CSL_SRIO_LSU_ICSR_ICS14_SHIFT    (0x0000000Eu)
#define CSL_SRIO_LSU_ICSR_ICS14_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS13_MASK     (0x00002000u)
#define CSL_SRIO_LSU_ICSR_ICS13_SHIFT    (0x0000000Du)
#define CSL_SRIO_LSU_ICSR_ICS13_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS12_MASK     (0x00001000u)
#define CSL_SRIO_LSU_ICSR_ICS12_SHIFT    (0x0000000Cu)
#define CSL_SRIO_LSU_ICSR_ICS12_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS11_MASK     (0x00000800u)
#define CSL_SRIO_LSU_ICSR_ICS11_SHIFT    (0x0000000Bu)
#define CSL_SRIO_LSU_ICSR_ICS11_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS10_MASK     (0x00000400u)
#define CSL_SRIO_LSU_ICSR_ICS10_SHIFT    (0x0000000Au)
#define CSL_SRIO_LSU_ICSR_ICS10_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS9_MASK      (0x00000200u)
#define CSL_SRIO_LSU_ICSR_ICS9_SHIFT     (0x00000009u)
#define CSL_SRIO_LSU_ICSR_ICS9_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS8_MASK      (0x00000100u)
#define CSL_SRIO_LSU_ICSR_ICS8_SHIFT     (0x00000008u)
#define CSL_SRIO_LSU_ICSR_ICS8_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS7_MASK      (0x00000080u)
#define CSL_SRIO_LSU_ICSR_ICS7_SHIFT     (0x00000007u)
#define CSL_SRIO_LSU_ICSR_ICS7_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS6_MASK      (0x00000040u)
#define CSL_SRIO_LSU_ICSR_ICS6_SHIFT     (0x00000006u)
#define CSL_SRIO_LSU_ICSR_ICS6_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS5_MASK      (0x00000020u)
#define CSL_SRIO_LSU_ICSR_ICS5_SHIFT     (0x00000005u)
#define CSL_SRIO_LSU_ICSR_ICS5_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS4_MASK      (0x00000010u)
#define CSL_SRIO_LSU_ICSR_ICS4_SHIFT     (0x00000004u)
#define CSL_SRIO_LSU_ICSR_ICS4_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS3_MASK      (0x00000008u)
#define CSL_SRIO_LSU_ICSR_ICS3_SHIFT     (0x00000003u)
#define CSL_SRIO_LSU_ICSR_ICS3_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS2_MASK      (0x00000004u)
#define CSL_SRIO_LSU_ICSR_ICS2_SHIFT     (0x00000002u)
#define CSL_SRIO_LSU_ICSR_ICS2_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS1_MASK      (0x00000002u)
#define CSL_SRIO_LSU_ICSR_ICS1_SHIFT     (0x00000001u)
#define CSL_SRIO_LSU_ICSR_ICS1_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_ICS0_MASK      (0x00000001u)
#define CSL_SRIO_LSU_ICSR_ICS0_SHIFT     (0x00000000u)
#define CSL_SRIO_LSU_ICSR_ICS0_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICSR_RESETVAL       (0x00000000u)

/* LSU_ICCR */

#define CSL_SRIO_LSU_ICCR_ICC31_MASK     (0x80000000u)
#define CSL_SRIO_LSU_ICCR_ICC31_SHIFT    (0x0000001Fu)
#define CSL_SRIO_LSU_ICCR_ICC31_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC30_MASK     (0x40000000u)
#define CSL_SRIO_LSU_ICCR_ICC30_SHIFT    (0x0000001Eu)
#define CSL_SRIO_LSU_ICCR_ICC30_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC29_MASK     (0x20000000u)
#define CSL_SRIO_LSU_ICCR_ICC29_SHIFT    (0x0000001Du)
#define CSL_SRIO_LSU_ICCR_ICC29_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC28_MASK     (0x10000000u)
#define CSL_SRIO_LSU_ICCR_ICC28_SHIFT    (0x0000001Cu)
#define CSL_SRIO_LSU_ICCR_ICC28_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC27_MASK     (0x08000000u)
#define CSL_SRIO_LSU_ICCR_ICC27_SHIFT    (0x0000001Bu)
#define CSL_SRIO_LSU_ICCR_ICC27_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC26_MASK     (0x04000000u)
#define CSL_SRIO_LSU_ICCR_ICC26_SHIFT    (0x0000001Au)
#define CSL_SRIO_LSU_ICCR_ICC26_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC25_MASK     (0x02000000u)
#define CSL_SRIO_LSU_ICCR_ICC25_SHIFT    (0x00000019u)
#define CSL_SRIO_LSU_ICCR_ICC25_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC24_MASK     (0x01000000u)
#define CSL_SRIO_LSU_ICCR_ICC24_SHIFT    (0x00000018u)
#define CSL_SRIO_LSU_ICCR_ICC24_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC23_MASK     (0x00800000u)
#define CSL_SRIO_LSU_ICCR_ICC23_SHIFT    (0x00000017u)
#define CSL_SRIO_LSU_ICCR_ICC23_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC22_MASK     (0x00400000u)
#define CSL_SRIO_LSU_ICCR_ICC22_SHIFT    (0x00000016u)
#define CSL_SRIO_LSU_ICCR_ICC22_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC21_MASK     (0x00200000u)
#define CSL_SRIO_LSU_ICCR_ICC21_SHIFT    (0x00000015u)
#define CSL_SRIO_LSU_ICCR_ICC21_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC20_MASK     (0x00100000u)
#define CSL_SRIO_LSU_ICCR_ICC20_SHIFT    (0x00000014u)
#define CSL_SRIO_LSU_ICCR_ICC20_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC19_MASK     (0x00080000u)
#define CSL_SRIO_LSU_ICCR_ICC19_SHIFT    (0x00000013u)
#define CSL_SRIO_LSU_ICCR_ICC19_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC18_MASK     (0x00040000u)
#define CSL_SRIO_LSU_ICCR_ICC18_SHIFT    (0x00000012u)
#define CSL_SRIO_LSU_ICCR_ICC18_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC17_MASK     (0x00020000u)
#define CSL_SRIO_LSU_ICCR_ICC17_SHIFT    (0x00000011u)
#define CSL_SRIO_LSU_ICCR_ICC17_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC16_MASK     (0x00010000u)
#define CSL_SRIO_LSU_ICCR_ICC16_SHIFT    (0x00000010u)
#define CSL_SRIO_LSU_ICCR_ICC16_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC15_MASK     (0x00008000u)
#define CSL_SRIO_LSU_ICCR_ICC15_SHIFT    (0x0000000Fu)
#define CSL_SRIO_LSU_ICCR_ICC15_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC14_MASK     (0x00004000u)
#define CSL_SRIO_LSU_ICCR_ICC14_SHIFT    (0x0000000Eu)
#define CSL_SRIO_LSU_ICCR_ICC14_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC13_MASK     (0x00002000u)
#define CSL_SRIO_LSU_ICCR_ICC13_SHIFT    (0x0000000Du)
#define CSL_SRIO_LSU_ICCR_ICC13_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC12_MASK     (0x00001000u)
#define CSL_SRIO_LSU_ICCR_ICC12_SHIFT    (0x0000000Cu)
#define CSL_SRIO_LSU_ICCR_ICC12_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC11_MASK     (0x00000800u)
#define CSL_SRIO_LSU_ICCR_ICC11_SHIFT    (0x0000000Bu)
#define CSL_SRIO_LSU_ICCR_ICC11_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC10_MASK     (0x00000400u)
#define CSL_SRIO_LSU_ICCR_ICC10_SHIFT    (0x0000000Au)
#define CSL_SRIO_LSU_ICCR_ICC10_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC9_MASK      (0x00000200u)
#define CSL_SRIO_LSU_ICCR_ICC9_SHIFT     (0x00000009u)
#define CSL_SRIO_LSU_ICCR_ICC9_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC8_MASK      (0x00000100u)
#define CSL_SRIO_LSU_ICCR_ICC8_SHIFT     (0x00000008u)
#define CSL_SRIO_LSU_ICCR_ICC8_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC7_MASK      (0x00000080u)
#define CSL_SRIO_LSU_ICCR_ICC7_SHIFT     (0x00000007u)
#define CSL_SRIO_LSU_ICCR_ICC7_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC6_MASK      (0x00000040u)
#define CSL_SRIO_LSU_ICCR_ICC6_SHIFT     (0x00000006u)
#define CSL_SRIO_LSU_ICCR_ICC6_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC5_MASK      (0x00000020u)
#define CSL_SRIO_LSU_ICCR_ICC5_SHIFT     (0x00000005u)
#define CSL_SRIO_LSU_ICCR_ICC5_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC4_MASK      (0x00000010u)
#define CSL_SRIO_LSU_ICCR_ICC4_SHIFT     (0x00000004u)
#define CSL_SRIO_LSU_ICCR_ICC4_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC3_MASK      (0x00000008u)
#define CSL_SRIO_LSU_ICCR_ICC3_SHIFT     (0x00000003u)
#define CSL_SRIO_LSU_ICCR_ICC3_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC2_MASK      (0x00000004u)
#define CSL_SRIO_LSU_ICCR_ICC2_SHIFT     (0x00000002u)
#define CSL_SRIO_LSU_ICCR_ICC2_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC1_MASK      (0x00000002u)
#define CSL_SRIO_LSU_ICCR_ICC1_SHIFT     (0x00000001u)
#define CSL_SRIO_LSU_ICCR_ICC1_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_ICC0_MASK      (0x00000001u)
#define CSL_SRIO_LSU_ICCR_ICC0_SHIFT     (0x00000000u)
#define CSL_SRIO_LSU_ICCR_ICC0_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICCR_RESETVAL       (0x00000000u)

/* ERR_RST_EVNT_ICSR */

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS16_MASK (0x00010000u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS16_SHIFT (0x00000010u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS16_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS11_MASK (0x00000800u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS11_SHIFT (0x0000000Bu)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS11_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS10_MASK (0x00000400u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS10_SHIFT (0x0000000Au)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS10_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS9_MASK (0x00000200u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS9_SHIFT (0x00000009u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS9_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS8_MASK (0x00000100u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS8_SHIFT (0x00000008u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS8_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS2_MASK (0x00000004u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS2_SHIFT (0x00000002u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS2_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS1_MASK (0x00000002u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS1_SHIFT (0x00000001u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS1_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS0_MASK (0x00000001u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS0_SHIFT (0x00000000u)
#define CSL_SRIO_ERR_RST_EVNT_ICSR_ICS0_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICSR_RESETVAL (0x00000000u)

/* ERR_RST_EVNT_ICCR */

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC16_MASK (0x00010000u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC16_SHIFT (0x00000010u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC16_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC11_MASK (0x00000800u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC11_SHIFT (0x0000000Bu)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC11_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC10_MASK (0x00000400u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC10_SHIFT (0x0000000Au)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC10_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC9_MASK (0x00000200u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC9_SHIFT (0x00000009u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC9_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC8_MASK (0x00000100u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC8_SHIFT (0x00000008u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC8_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC2_MASK (0x00000004u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC2_SHIFT (0x00000002u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC2_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC1_MASK (0x00000002u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC1_SHIFT (0x00000001u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC1_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC0_MASK (0x00000001u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC0_SHIFT (0x00000000u)
#define CSL_SRIO_ERR_RST_EVNT_ICCR_ICC0_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICCR_RESETVAL (0x00000000u)

/* DOORBELL_ICRR */

#define CSL_SRIO_DOORBELL_ICRR_ICR7_MASK (0xF0000000u)
#define CSL_SRIO_DOORBELL_ICRR_ICR7_SHIFT (0x0000001Cu)
#define CSL_SRIO_DOORBELL_ICRR_ICR7_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_ICR6_MASK (0x0F000000u)
#define CSL_SRIO_DOORBELL_ICRR_ICR6_SHIFT (0x00000018u)
#define CSL_SRIO_DOORBELL_ICRR_ICR6_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_ICR5_MASK (0x00F00000u)
#define CSL_SRIO_DOORBELL_ICRR_ICR5_SHIFT (0x00000014u)
#define CSL_SRIO_DOORBELL_ICRR_ICR5_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_ICR4_MASK (0x000F0000u)
#define CSL_SRIO_DOORBELL_ICRR_ICR4_SHIFT (0x00000010u)
#define CSL_SRIO_DOORBELL_ICRR_ICR4_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_ICR3_MASK (0x0000F000u)
#define CSL_SRIO_DOORBELL_ICRR_ICR3_SHIFT (0x0000000Cu)
#define CSL_SRIO_DOORBELL_ICRR_ICR3_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_ICR2_MASK (0x00000F00u)
#define CSL_SRIO_DOORBELL_ICRR_ICR2_SHIFT (0x00000008u)
#define CSL_SRIO_DOORBELL_ICRR_ICR2_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_ICR1_MASK (0x000000F0u)
#define CSL_SRIO_DOORBELL_ICRR_ICR1_SHIFT (0x00000004u)
#define CSL_SRIO_DOORBELL_ICRR_ICR1_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_ICR0_MASK (0x0000000Fu)
#define CSL_SRIO_DOORBELL_ICRR_ICR0_SHIFT (0x00000000u)
#define CSL_SRIO_DOORBELL_ICRR_ICR0_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR_RESETVAL  (0x00000000u)

/* DOORBELL_ICRR2 */

#define CSL_SRIO_DOORBELL_ICRR2_ICR7_MASK (0xF0000000u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR7_SHIFT (0x0000001Cu)
#define CSL_SRIO_DOORBELL_ICRR2_ICR7_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_ICR6_MASK (0x0F000000u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR6_SHIFT (0x00000018u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR6_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_ICR5_MASK (0x00F00000u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR5_SHIFT (0x00000014u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR5_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_ICR4_MASK (0x000F0000u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR4_SHIFT (0x00000010u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR4_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_ICR3_MASK (0x0000F000u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR3_SHIFT (0x0000000Cu)
#define CSL_SRIO_DOORBELL_ICRR2_ICR3_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_ICR2_MASK (0x00000F00u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR2_SHIFT (0x00000008u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR2_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_ICR1_MASK (0x000000F0u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR1_SHIFT (0x00000004u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR1_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_ICR0_MASK (0x0000000Fu)
#define CSL_SRIO_DOORBELL_ICRR2_ICR0_SHIFT (0x00000000u)
#define CSL_SRIO_DOORBELL_ICRR2_ICR0_RESETVAL (0x00000000u)

#define CSL_SRIO_DOORBELL_ICRR2_RESETVAL (0x00000000u)

/* RX_CPPI_ICRR */

#define CSL_SRIO_RX_CPPI_ICRR_ICR7_MASK  (0xF0000000u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR7_SHIFT (0x0000001Cu)
#define CSL_SRIO_RX_CPPI_ICRR_ICR7_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_ICR6_MASK  (0x0F000000u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR6_SHIFT (0x00000018u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR6_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_ICR5_MASK  (0x00F00000u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR5_SHIFT (0x00000014u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR5_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_ICR4_MASK  (0x000F0000u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR4_SHIFT (0x00000010u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR4_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_ICR3_MASK  (0x0000F000u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR3_SHIFT (0x0000000Cu)
#define CSL_SRIO_RX_CPPI_ICRR_ICR3_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_ICR2_MASK  (0x00000F00u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR2_SHIFT (0x00000008u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR2_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_ICR1_MASK  (0x000000F0u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR1_SHIFT (0x00000004u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR1_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_ICR0_MASK  (0x0000000Fu)
#define CSL_SRIO_RX_CPPI_ICRR_ICR0_SHIFT (0x00000000u)
#define CSL_SRIO_RX_CPPI_ICRR_ICR0_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR_RESETVAL   (0x00000000u)

/* RX_CPPI_ICRR2 */

#define CSL_SRIO_RX_CPPI_ICRR2_ICR7_MASK (0xF0000000u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR7_SHIFT (0x0000001Cu)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR7_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_ICR6_MASK (0x0F000000u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR6_SHIFT (0x00000018u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR6_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_ICR5_MASK (0x00F00000u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR5_SHIFT (0x00000014u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR5_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_ICR4_MASK (0x000F0000u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR4_SHIFT (0x00000010u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR4_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_ICR3_MASK (0x0000F000u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR3_SHIFT (0x0000000Cu)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR3_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_ICR2_MASK (0x00000F00u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR2_SHIFT (0x00000008u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR2_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_ICR1_MASK (0x000000F0u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR1_SHIFT (0x00000004u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR1_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_ICR0_MASK (0x0000000Fu)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR0_SHIFT (0x00000000u)
#define CSL_SRIO_RX_CPPI_ICRR2_ICR0_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_ICRR2_RESETVAL  (0x00000000u)

/* TX_CPPI_ICRR */

#define CSL_SRIO_TX_CPPI_ICRR_ICR7_MASK  (0xF0000000u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR7_SHIFT (0x0000001Cu)
#define CSL_SRIO_TX_CPPI_ICRR_ICR7_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_ICR6_MASK  (0x0F000000u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR6_SHIFT (0x00000018u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR6_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_ICR5_MASK  (0x00F00000u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR5_SHIFT (0x00000014u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR5_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_ICR4_MASK  (0x000F0000u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR4_SHIFT (0x00000010u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR4_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_ICR3_MASK  (0x0000F000u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR3_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_CPPI_ICRR_ICR3_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_ICR2_MASK  (0x00000F00u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR2_SHIFT (0x00000008u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR2_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_ICR1_MASK  (0x000000F0u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR1_SHIFT (0x00000004u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR1_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_ICR0_MASK  (0x0000000Fu)
#define CSL_SRIO_TX_CPPI_ICRR_ICR0_SHIFT (0x00000000u)
#define CSL_SRIO_TX_CPPI_ICRR_ICR0_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR_RESETVAL   (0x00000000u)

/* TX_CPPI_ICRR2 */

#define CSL_SRIO_TX_CPPI_ICRR2_ICR7_MASK (0xF0000000u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR7_SHIFT (0x0000001Cu)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR7_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_ICR6_MASK (0x0F000000u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR6_SHIFT (0x00000018u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR6_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_ICR5_MASK (0x00F00000u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR5_SHIFT (0x00000014u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR5_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_ICR4_MASK (0x000F0000u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR4_SHIFT (0x00000010u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR4_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_ICR3_MASK (0x0000F000u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR3_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR3_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_ICR2_MASK (0x00000F00u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR2_SHIFT (0x00000008u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR2_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_ICR1_MASK (0x000000F0u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR1_SHIFT (0x00000004u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR1_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_ICR0_MASK (0x0000000Fu)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR0_SHIFT (0x00000000u)
#define CSL_SRIO_TX_CPPI_ICRR2_ICR0_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_CPPI_ICRR2_RESETVAL  (0x00000000u)

/* LSU_ICRR */

#define CSL_SRIO_LSU_ICRR_ICR7_MASK      (0xF0000000u)
#define CSL_SRIO_LSU_ICRR_ICR7_SHIFT     (0x0000001Cu)
#define CSL_SRIO_LSU_ICRR_ICR7_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_ICR6_MASK      (0x0F000000u)
#define CSL_SRIO_LSU_ICRR_ICR6_SHIFT     (0x00000018u)
#define CSL_SRIO_LSU_ICRR_ICR6_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_ICR5_MASK      (0x00F00000u)
#define CSL_SRIO_LSU_ICRR_ICR5_SHIFT     (0x00000014u)
#define CSL_SRIO_LSU_ICRR_ICR5_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_ICR4_MASK      (0x000F0000u)
#define CSL_SRIO_LSU_ICRR_ICR4_SHIFT     (0x00000010u)
#define CSL_SRIO_LSU_ICRR_ICR4_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_ICR3_MASK      (0x0000F000u)
#define CSL_SRIO_LSU_ICRR_ICR3_SHIFT     (0x0000000Cu)
#define CSL_SRIO_LSU_ICRR_ICR3_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_ICR2_MASK      (0x00000F00u)
#define CSL_SRIO_LSU_ICRR_ICR2_SHIFT     (0x00000008u)
#define CSL_SRIO_LSU_ICRR_ICR2_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_ICR1_MASK      (0x000000F0u)
#define CSL_SRIO_LSU_ICRR_ICR1_SHIFT     (0x00000004u)
#define CSL_SRIO_LSU_ICRR_ICR1_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_ICR0_MASK      (0x0000000Fu)
#define CSL_SRIO_LSU_ICRR_ICR0_SHIFT     (0x00000000u)
#define CSL_SRIO_LSU_ICRR_ICR0_RESETVAL  (0x00000000u)

#define CSL_SRIO_LSU_ICRR_RESETVAL       (0x00000000u)

/* ERR_RST_EVNT_ICRR */

#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR2_MASK (0x00000F00u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR2_SHIFT (0x00000008u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR2_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR1_MASK (0x000000F0u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR1_SHIFT (0x00000004u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR1_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR0_MASK (0x0000000Fu)
#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR0_SHIFT (0x00000000u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR_ICR0_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR_RESETVAL (0x00000000u)

/* ERR_RST_EVNT_ICRR2 */

#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR11_MASK (0x0000F000u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR11_SHIFT (0x0000000Cu)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR11_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR10_MASK (0x00000F00u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR10_SHIFT (0x00000008u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR10_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR9_MASK (0x000000F0u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR9_SHIFT (0x00000004u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR9_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR8_MASK (0x0000000Fu)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR8_SHIFT (0x00000000u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR2_ICR8_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR2_RESETVAL (0x00000000u)

/* ERR_RST_EVNT_ICRR3 */

#define CSL_SRIO_ERR_RST_EVNT_ICRR3_ICR16_MASK (0x0000000Fu)
#define CSL_SRIO_ERR_RST_EVNT_ICRR3_ICR16_SHIFT (0x00000000u)
#define CSL_SRIO_ERR_RST_EVNT_ICRR3_ICR16_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RST_EVNT_ICRR3_RESETVAL (0x00000000u)

/* INTDST_DECODE */

#define CSL_SRIO_INTDST_DECODE_ISDR31_MASK (0x80000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR31_SHIFT (0x0000001Fu)
#define CSL_SRIO_INTDST_DECODE_ISDR31_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR30_MASK (0x40000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR30_SHIFT (0x0000001Eu)
#define CSL_SRIO_INTDST_DECODE_ISDR30_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR29_MASK (0x20000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR29_SHIFT (0x0000001Du)
#define CSL_SRIO_INTDST_DECODE_ISDR29_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR28_MASK (0x10000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR28_SHIFT (0x0000001Cu)
#define CSL_SRIO_INTDST_DECODE_ISDR28_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR27_MASK (0x08000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR27_SHIFT (0x0000001Bu)
#define CSL_SRIO_INTDST_DECODE_ISDR27_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR26_MASK (0x04000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR26_SHIFT (0x0000001Au)
#define CSL_SRIO_INTDST_DECODE_ISDR26_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR25_MASK (0x02000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR25_SHIFT (0x00000019u)
#define CSL_SRIO_INTDST_DECODE_ISDR25_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR24_MASK (0x01000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR24_SHIFT (0x00000018u)
#define CSL_SRIO_INTDST_DECODE_ISDR24_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR23_MASK (0x00800000u)
#define CSL_SRIO_INTDST_DECODE_ISDR23_SHIFT (0x00000017u)
#define CSL_SRIO_INTDST_DECODE_ISDR23_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR22_MASK (0x00400000u)
#define CSL_SRIO_INTDST_DECODE_ISDR22_SHIFT (0x00000016u)
#define CSL_SRIO_INTDST_DECODE_ISDR22_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR21_MASK (0x00200000u)
#define CSL_SRIO_INTDST_DECODE_ISDR21_SHIFT (0x00000015u)
#define CSL_SRIO_INTDST_DECODE_ISDR21_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR20_MASK (0x00100000u)
#define CSL_SRIO_INTDST_DECODE_ISDR20_SHIFT (0x00000014u)
#define CSL_SRIO_INTDST_DECODE_ISDR20_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR19_MASK (0x00080000u)
#define CSL_SRIO_INTDST_DECODE_ISDR19_SHIFT (0x00000013u)
#define CSL_SRIO_INTDST_DECODE_ISDR19_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR18_MASK (0x00040000u)
#define CSL_SRIO_INTDST_DECODE_ISDR18_SHIFT (0x00000012u)
#define CSL_SRIO_INTDST_DECODE_ISDR18_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR17_MASK (0x00020000u)
#define CSL_SRIO_INTDST_DECODE_ISDR17_SHIFT (0x00000011u)
#define CSL_SRIO_INTDST_DECODE_ISDR17_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR16_MASK (0x00010000u)
#define CSL_SRIO_INTDST_DECODE_ISDR16_SHIFT (0x00000010u)
#define CSL_SRIO_INTDST_DECODE_ISDR16_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR15_MASK (0x00008000u)
#define CSL_SRIO_INTDST_DECODE_ISDR15_SHIFT (0x0000000Fu)
#define CSL_SRIO_INTDST_DECODE_ISDR15_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR14_MASK (0x00004000u)
#define CSL_SRIO_INTDST_DECODE_ISDR14_SHIFT (0x0000000Eu)
#define CSL_SRIO_INTDST_DECODE_ISDR14_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR13_MASK (0x00002000u)
#define CSL_SRIO_INTDST_DECODE_ISDR13_SHIFT (0x0000000Du)
#define CSL_SRIO_INTDST_DECODE_ISDR13_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR12_MASK (0x00001000u)
#define CSL_SRIO_INTDST_DECODE_ISDR12_SHIFT (0x0000000Cu)
#define CSL_SRIO_INTDST_DECODE_ISDR12_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR11_MASK (0x00000800u)
#define CSL_SRIO_INTDST_DECODE_ISDR11_SHIFT (0x0000000Bu)
#define CSL_SRIO_INTDST_DECODE_ISDR11_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR10_MASK (0x00000400u)
#define CSL_SRIO_INTDST_DECODE_ISDR10_SHIFT (0x0000000Au)
#define CSL_SRIO_INTDST_DECODE_ISDR10_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR9_MASK (0x00000200u)
#define CSL_SRIO_INTDST_DECODE_ISDR9_SHIFT (0x00000009u)
#define CSL_SRIO_INTDST_DECODE_ISDR9_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR8_MASK (0x00000100u)
#define CSL_SRIO_INTDST_DECODE_ISDR8_SHIFT (0x00000008u)
#define CSL_SRIO_INTDST_DECODE_ISDR8_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR7_MASK (0x00000080u)
#define CSL_SRIO_INTDST_DECODE_ISDR7_SHIFT (0x00000007u)
#define CSL_SRIO_INTDST_DECODE_ISDR7_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR6_MASK (0x00000040u)
#define CSL_SRIO_INTDST_DECODE_ISDR6_SHIFT (0x00000006u)
#define CSL_SRIO_INTDST_DECODE_ISDR6_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR5_MASK (0x00000020u)
#define CSL_SRIO_INTDST_DECODE_ISDR5_SHIFT (0x00000005u)
#define CSL_SRIO_INTDST_DECODE_ISDR5_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR4_MASK (0x00000010u)
#define CSL_SRIO_INTDST_DECODE_ISDR4_SHIFT (0x00000004u)
#define CSL_SRIO_INTDST_DECODE_ISDR4_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR3_MASK (0x00000008u)
#define CSL_SRIO_INTDST_DECODE_ISDR3_SHIFT (0x00000003u)
#define CSL_SRIO_INTDST_DECODE_ISDR3_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR2_MASK (0x00000004u)
#define CSL_SRIO_INTDST_DECODE_ISDR2_SHIFT (0x00000002u)
#define CSL_SRIO_INTDST_DECODE_ISDR2_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR1_MASK (0x00000002u)
#define CSL_SRIO_INTDST_DECODE_ISDR1_SHIFT (0x00000001u)
#define CSL_SRIO_INTDST_DECODE_ISDR1_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_ISDR0_MASK (0x00000001u)
#define CSL_SRIO_INTDST_DECODE_ISDR0_SHIFT (0x00000000u)
#define CSL_SRIO_INTDST_DECODE_ISDR0_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_DECODE_RESETVAL  (0x00000000u)

/* INTDST_RATE_CNTL */

#define CSL_SRIO_INTDST_RATE_CNTL_COUNT_DOWN_VALUE_MASK (0xFFFFFFFFu)
#define CSL_SRIO_INTDST_RATE_CNTL_COUNT_DOWN_VALUE_SHIFT (0x00000000u)
#define CSL_SRIO_INTDST_RATE_CNTL_COUNT_DOWN_VALUE_RESETVAL (0x00000000u)

#define CSL_SRIO_INTDST_RATE_CNTL_RESETVAL (0x00000000u)

/* LSU_REG0 */

#define CSL_SRIO_LSU_REG0_ADDRESS_MSB_MASK (0xFFFFFFFFu)
#define CSL_SRIO_LSU_REG0_ADDRESS_MSB_SHIFT (0x00000000u)
#define CSL_SRIO_LSU_REG0_ADDRESS_MSB_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG0_RESETVAL       (0x00000000u)

/* LSU_REG1 */

#define CSL_SRIO_LSU_REG1_ADDRESS_LSB_CONFIG_OFFSET_MASK (0xFFFFFFFFu)
#define CSL_SRIO_LSU_REG1_ADDRESS_LSB_CONFIG_OFFSET_SHIFT (0x00000000u)
#define CSL_SRIO_LSU_REG1_ADDRESS_LSB_CONFIG_OFFSET_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG1_RESETVAL       (0x00000000u)

/* LSU_REG2 */

#define CSL_SRIO_LSU_REG2_DSP_ADDRESS_MASK (0xFFFFFFFFu)
#define CSL_SRIO_LSU_REG2_DSP_ADDRESS_SHIFT (0x00000000u)
#define CSL_SRIO_LSU_REG2_DSP_ADDRESS_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG2_RESETVAL       (0x00000000u)

/* LSU_REG3 */

#define CSL_SRIO_LSU_REG3_BYTE_COUNT_MASK (0x00000FFFu)
#define CSL_SRIO_LSU_REG3_BYTE_COUNT_SHIFT (0x00000000u)
#define CSL_SRIO_LSU_REG3_BYTE_COUNT_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG3_RESETVAL       (0x00000000u)

/* LSU_REG4 */

#define CSL_SRIO_LSU_REG4_OUTPORTID_MASK (0xC0000000u)
#define CSL_SRIO_LSU_REG4_OUTPORTID_SHIFT (0x0000001Eu)
#define CSL_SRIO_LSU_REG4_OUTPORTID_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG4_PRIORITY_MASK  (0x30000000u)
#define CSL_SRIO_LSU_REG4_PRIORITY_SHIFT (0x0000001Cu)
#define CSL_SRIO_LSU_REG4_PRIORITY_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG4_XAMBS_MASK     (0x0C000000u)
#define CSL_SRIO_LSU_REG4_XAMBS_SHIFT    (0x0000001Au)
#define CSL_SRIO_LSU_REG4_XAMBS_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG4_ID_SIZE_MASK   (0x03000000u)
#define CSL_SRIO_LSU_REG4_ID_SIZE_SHIFT  (0x00000018u)
#define CSL_SRIO_LSU_REG4_ID_SIZE_RESETVAL (0x00000000u)

/*----ID_SIZE Tokens----*/
#define CSL_SRIO_LSU_REG4_ID_SIZE_8BIT   (0x00000000u)
#define CSL_SRIO_LSU_REG4_ID_SIZE_16BIT  (0x00000001u)

#define CSL_SRIO_LSU_REG4_DESTID_MASK    (0x00FFFF00u)
#define CSL_SRIO_LSU_REG4_DESTID_SHIFT   (0x00000008u)
#define CSL_SRIO_LSU_REG4_DESTID_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG4_INTERRUPT_REQ_MASK (0x00000001u)
#define CSL_SRIO_LSU_REG4_INTERRUPT_REQ_SHIFT (0x00000000u)
#define CSL_SRIO_LSU_REG4_INTERRUPT_REQ_RESETVAL (0x00000000u)

/*----INTERRUPT_REQ Tokens----*/
#define CSL_SRIO_LSU_REG4_INTERRUPT_REQ_DISABLE (0x00000000u)
#define CSL_SRIO_LSU_REG4_INTERRUPT_REQ_ENABLE (0x00000001u)

#define CSL_SRIO_LSU_REG4_RESETVAL       (0x00000000u)

/* LSU_REG5 */

#define CSL_SRIO_LSU_REG5_DRBLL_INFO_MASK (0xFFFF0000u)
#define CSL_SRIO_LSU_REG5_DRBLL_INFO_SHIFT (0x00000010u)
#define CSL_SRIO_LSU_REG5_DRBLL_INFO_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG5_HOP_COUNT_MASK (0x0000FF00u)
#define CSL_SRIO_LSU_REG5_HOP_COUNT_SHIFT (0x00000008u)
#define CSL_SRIO_LSU_REG5_HOP_COUNT_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG5_PACKET_TYPE_MASK (0x000000FFu)
#define CSL_SRIO_LSU_REG5_PACKET_TYPE_SHIFT (0x00000000u)
#define CSL_SRIO_LSU_REG5_PACKET_TYPE_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG5_RESETVAL       (0x00000000u)

/* LSU_REG6 */

#define CSL_SRIO_LSU_REG6_COMPLETION_CODE_MASK (0x0000001Eu)
#define CSL_SRIO_LSU_REG6_COMPLETION_CODE_SHIFT (0x00000001u)
#define CSL_SRIO_LSU_REG6_COMPLETION_CODE_RESETVAL (0x00000000u)

#define CSL_SRIO_LSU_REG6_BSY_MASK       (0x00000001u)
#define CSL_SRIO_LSU_REG6_BSY_SHIFT      (0x00000000u)
#define CSL_SRIO_LSU_REG6_BSY_RESETVAL   (0x00000000u)

#define CSL_SRIO_LSU_REG6_RESETVAL       (0x00000000u)

/* LSU_FLOW_MASKS */

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK15_MASK (0x00008000u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK15_SHIFT (0x0000000Fu)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK15_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK14_MASK (0x00004000u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK14_SHIFT (0x0000000Eu)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK14_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK13_MASK (0x00002000u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK13_SHIFT (0x0000000Du)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK13_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK12_MASK (0x00001000u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK12_SHIFT (0x0000000Cu)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK12_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK11_MASK (0x00000800u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK11_SHIFT (0x0000000Bu)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK11_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK10_MASK (0x00000400u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK10_SHIFT (0x0000000Au)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK10_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK9_MASK (0x00000200u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK9_SHIFT (0x00000009u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK9_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK8_MASK (0x00000100u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK8_SHIFT (0x00000008u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK8_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK7_MASK (0x00000080u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK7_SHIFT (0x00000007u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK7_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK6_MASK (0x00000040u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK6_SHIFT (0x00000006u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK6_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK5_MASK (0x00000020u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK5_SHIFT (0x00000005u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK5_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK4_MASK (0x00000010u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK4_SHIFT (0x00000004u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK4_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK3_MASK (0x00000008u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK3_SHIFT (0x00000003u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK3_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK2_MASK (0x00000004u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK2_SHIFT (0x00000002u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK2_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK1_MASK (0x00000002u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK1_SHIFT (0x00000001u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK1_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK0_MASK (0x00000001u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK0_SHIFT (0x00000000u)
#define CSL_SRIO_LSU_FLOW_MASKS_FLOW_MASK0_RESETVAL (0x00000001u)

#define CSL_SRIO_LSU_FLOW_MASKS_RESETVAL (0x0000FFFFu)

/* QUEUE_TXDMA_HDP */

#define CSL_SRIO_QUEUE_TXDMA_HDP_TX_HDP_MASK (0xFFFFFFFFu)
#define CSL_SRIO_QUEUE_TXDMA_HDP_TX_HDP_SHIFT (0x00000000u)
#define CSL_SRIO_QUEUE_TXDMA_HDP_TX_HDP_RESETVAL (0x00000000u)

#define CSL_SRIO_QUEUE_TXDMA_HDP_RESETVAL (0x00000000u)

/* QUEUE_TXDMA_CP */

#define CSL_SRIO_QUEUE_TXDMA_CP_TX_CP_MASK (0xFFFFFFFFu)
#define CSL_SRIO_QUEUE_TXDMA_CP_TX_CP_SHIFT (0x00000000u)
#define CSL_SRIO_QUEUE_TXDMA_CP_TX_CP_RESETVAL (0x00000000u)

#define CSL_SRIO_QUEUE_TXDMA_CP_RESETVAL (0x00000000u)

/* QUEUE_RXDMA_HDP */

#define CSL_SRIO_QUEUE_RXDMA_HDP_RX_HDP_MASK (0xFFFFFFFFu)
#define CSL_SRIO_QUEUE_RXDMA_HDP_RX_HDP_SHIFT (0x00000000u)
#define CSL_SRIO_QUEUE_RXDMA_HDP_RX_HDP_RESETVAL (0x00000000u)

#define CSL_SRIO_QUEUE_RXDMA_HDP_RESETVAL (0x00000000u)

/* QUEUE_RXDMA_CP */

#define CSL_SRIO_QUEUE_RXDMA_CP_RX_CP_MASK (0xFFFFFFFFu)
#define CSL_SRIO_QUEUE_RXDMA_CP_RX_CP_SHIFT (0x00000000u)
#define CSL_SRIO_QUEUE_RXDMA_CP_RX_CP_RESETVAL (0x00000000u)

#define CSL_SRIO_QUEUE_RXDMA_CP_RESETVAL (0x00000000u)

/* TX_QUEUE_TEAR_DOWN */

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE15_TEAR_DWN_MASK (0x00008000u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE15_TEAR_DWN_SHIFT (0x0000000Fu)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE15_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE14_TEAR_DWN_MASK (0x00004000u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE14_TEAR_DWN_SHIFT (0x0000000Eu)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE14_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE13_TEAR_DWN_MASK (0x00002000u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE13_TEAR_DWN_SHIFT (0x0000000Du)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE13_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE12_TEAR_DWN_MASK (0x00001000u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE12_TEAR_DWN_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE12_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE11_TEAR_DWN_MASK (0x00000800u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE11_TEAR_DWN_SHIFT (0x0000000Bu)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE11_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE10_TEAR_DWN_MASK (0x00000400u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE10_TEAR_DWN_SHIFT (0x0000000Au)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE10_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE9_TEAR_DWN_MASK (0x00000200u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE9_TEAR_DWN_SHIFT (0x00000009u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE9_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE8_TEAR_DWN_MASK (0x00000100u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE8_TEAR_DWN_SHIFT (0x00000008u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE8_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE7_TEAR_DWN_MASK (0x00000080u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE7_TEAR_DWN_SHIFT (0x00000007u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE7_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE6_TEAR_DWN_MASK (0x00000040u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE6_TEAR_DWN_SHIFT (0x00000006u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE6_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE5_TEAR_DWN_MASK (0x00000020u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE5_TEAR_DWN_SHIFT (0x00000005u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE5_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE4_TEAR_DWN_MASK (0x00000010u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE4_TEAR_DWN_SHIFT (0x00000004u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE4_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE3_TEAR_DWN_MASK (0x00000008u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE3_TEAR_DWN_SHIFT (0x00000003u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE3_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE2_TEAR_DWN_MASK (0x00000004u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE2_TEAR_DWN_SHIFT (0x00000002u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE2_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE1_TEAR_DWN_MASK (0x00000002u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE1_TEAR_DWN_SHIFT (0x00000001u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE1_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE0_TEAR_DWN_MASK (0x00000001u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE0_TEAR_DWN_SHIFT (0x00000000u)
#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_QUEUE0_TEAR_DWN_RESETVAL (0x00000000u)

/*----QUEUE Tokens----*/
#define CSL_SRIO_QUEUE_TEAR_DOWN (0x00000001u)

#define CSL_SRIO_TX_QUEUE_TEAR_DOWN_RESETVAL (0x00000000u)

/* TX_CPPI_FLOW_MASKS */

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK15_MASK (0x80000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK15_SHIFT (0x0000001Fu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK15_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK14_MASK (0x40000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK14_SHIFT (0x0000001Eu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK14_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK13_MASK (0x20000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK13_SHIFT (0x0000001Du)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK13_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK12_MASK (0x10000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK12_SHIFT (0x0000001Cu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK12_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK11_MASK (0x08000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK11_SHIFT (0x0000001Bu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK11_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK10_MASK (0x04000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK10_SHIFT (0x0000001Au)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK10_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK9_MASK (0x02000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK9_SHIFT (0x00000019u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK9_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK8_MASK (0x01000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK8_SHIFT (0x00000018u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK8_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK7_MASK (0x00800000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK7_SHIFT (0x00000017u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK7_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK6_MASK (0x00400000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK6_SHIFT (0x00000016u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK6_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK5_MASK (0x00200000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK5_SHIFT (0x00000015u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK5_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK4_MASK (0x00100000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK4_SHIFT (0x00000014u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK4_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK3_MASK (0x00080000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK3_SHIFT (0x00000013u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK3_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK2_MASK (0x00040000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK2_SHIFT (0x00000012u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK2_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK1_MASK (0x00020000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK1_SHIFT (0x00000011u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK1_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK0_MASK (0x00010000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK0_SHIFT (0x000000010u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK0_RESETVAL (0x00000001u)

/*----QUEUE1_FLOW_MASK Tokens----*/
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK_DISABLE (0x00000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE1_FLOW_MASK_ENABLE (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK15_MASK (0x00008000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK15_SHIFT (0x0000000Fu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK15_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK14_MASK (0x00004000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK14_SHIFT (0x0000000Eu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK14_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK13_MASK (0x00002000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK13_SHIFT (0x0000000Du)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK13_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK12_MASK (0x00001000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK12_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK12_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK11_MASK (0x00000800u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK11_SHIFT (0x0000000Bu)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK11_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK10_MASK (0x00000400u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK10_SHIFT (0x0000000Au)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK10_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK9_MASK (0x00000200u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK9_SHIFT (0x00000009u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK9_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK8_MASK (0x00000100u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK8_SHIFT (0x00000008u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK8_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK7_MASK (0x00000080u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK7_SHIFT (0x00000007u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK7_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK6_MASK (0x00000040u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK6_SHIFT (0x00000006u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK6_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK5_MASK (0x00000020u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK5_SHIFT (0x00000005u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK5_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK4_MASK (0x00000010u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK4_SHIFT (0x00000004u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK4_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK3_MASK (0x00000008u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK3_SHIFT (0x00000003u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK3_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK2_MASK (0x00000004u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK2_SHIFT (0x00000002u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK2_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK1_MASK (0x00000002u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK1_SHIFT (0x00000001u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK1_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK0_MASK (0x00000001u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK0_SHIFT (0x00000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK0_RESETVAL (0x00000001u)

/*----QUEUE0_FLOW_MASK Tokens----*/
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK_DISABLE (0x00000000u)
#define CSL_SRIO_TX_CPPI_FLOW_MASKS_QUEUE0_FLOW_MASK_ENABLE (0x00000001u)

#define CSL_SRIO_TX_CPPI_FLOW_MASKS_RESETVAL (0xFFFFFFFFu)

/* RX_QUEUE_TEAR_DOWN */

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE15_TEAR_DWN_MASK (0x00008000u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE15_TEAR_DWN_SHIFT (0x0000000Fu)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE15_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE14_TEAR_DWN_MASK (0x00004000u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE14_TEAR_DWN_SHIFT (0x0000000Eu)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE14_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE13_TEAR_DWN_MASK (0x00002000u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE13_TEAR_DWN_SHIFT (0x0000000Du)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE13_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE12_TEAR_DWN_MASK (0x00001000u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE12_TEAR_DWN_SHIFT (0x0000000Cu)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE12_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE11_TEAR_DWN_MASK (0x00000800u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE11_TEAR_DWN_SHIFT (0x0000000Bu)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE11_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE10_TEAR_DWN_MASK (0x00000400u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE10_TEAR_DWN_SHIFT (0x0000000Au)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE10_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE9_TEAR_DWN_MASK (0x00000200u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE9_TEAR_DWN_SHIFT (0x00000009u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE9_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE8_TEAR_DWN_MASK (0x00000100u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE8_TEAR_DWN_SHIFT (0x00000008u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE8_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE7_TEAR_DWN_MASK (0x00000080u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE7_TEAR_DWN_SHIFT (0x00000007u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE7_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE6_TEAR_DWN_MASK (0x00000040u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE6_TEAR_DWN_SHIFT (0x00000006u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE6_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE5_TEAR_DWN_MASK (0x00000020u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE5_TEAR_DWN_SHIFT (0x00000005u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE5_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE4_TEAR_DWN_MASK (0x00000010u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE4_TEAR_DWN_SHIFT (0x00000004u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE4_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE3_TEAR_DWN_MASK (0x00000008u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE3_TEAR_DWN_SHIFT (0x00000003u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE3_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE2_TEAR_DWN_MASK (0x00000004u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE2_TEAR_DWN_SHIFT (0x00000002u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE2_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE1_TEAR_DWN_MASK (0x00000002u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE1_TEAR_DWN_SHIFT (0x00000001u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE1_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE0_TEAR_DWN_MASK (0x00000001u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE0_TEAR_DWN_SHIFT (0x00000000u)
#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_QUEUE0_TEAR_DWN_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_QUEUE_TEAR_DOWN_RESETVAL (0x00000000u)

/* RX_CPPI_CNTL */

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE15_IN_ORDER_MASK (0x00008000u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE15_IN_ORDER_SHIFT (0x0000000Fu)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE15_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE14_IN_ORDER_MASK (0x00004000u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE14_IN_ORDER_SHIFT (0x0000000Eu)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE14_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE13_IN_ORDER_MASK (0x00002000u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE13_IN_ORDER_SHIFT (0x0000000Du)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE13_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE12_IN_ORDER_MASK (0x00001000u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE12_IN_ORDER_SHIFT (0x0000000Cu)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE12_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE11_IN_ORDER_MASK (0x00000800u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE11_IN_ORDER_SHIFT (0x0000000Bu)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE11_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE10_IN_ORDER_MASK (0x00000400u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE10_IN_ORDER_SHIFT (0x0000000Au)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE10_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE9_IN_ORDER_MASK (0x00000200u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE9_IN_ORDER_SHIFT (0x00000009u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE9_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE8_IN_ORDER_MASK (0x00000100u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE8_IN_ORDER_SHIFT (0x00000008u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE8_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE7_IN_ORDER_MASK (0x00000080u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE7_IN_ORDER_SHIFT (0x00000007u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE7_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE6_IN_ORDER_MASK (0x00000040u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE6_IN_ORDER_SHIFT (0x00000006u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE6_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE5_IN_ORDER_MASK (0x00000020u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE5_IN_ORDER_SHIFT (0x00000005u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE5_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE4_IN_ORDER_MASK (0x00000010u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE4_IN_ORDER_SHIFT (0x00000004u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE4_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE3_IN_ORDER_MASK (0x00000008u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE3_IN_ORDER_SHIFT (0x00000003u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE3_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE2_IN_ORDER_MASK (0x00000004u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE2_IN_ORDER_SHIFT (0x00000002u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE2_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE1_IN_ORDER_MASK (0x00000002u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE1_IN_ORDER_SHIFT (0x00000001u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE1_IN_ORDER_RESETVAL (0x00000000u)

#define CSL_SRIO_RX_CPPI_CNTL_QUEUE0_IN_ORDER_MASK (0x00000001u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE0_IN_ORDER_SHIFT (0x00000000u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE0_IN_ORDER_RESETVAL (0x00000000u)

/*----QUEUE Tokens----*/
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE_IN_ORDER_DISABLE (0x00000000u)
#define CSL_SRIO_RX_CPPI_CNTL_QUEUE_IN_ORDER_ENABLE (0x00000001u)

#define CSL_SRIO_RX_CPPI_CNTL_RESETVAL   (0x00000000u)

/* TX_QUEUE_CNTL0 */

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP3_NUM_MSGS_MASK (0xF0000000u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP3_NUM_MSGS_SHIFT (0x0000001Cu)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP3_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP3_QUEUE_PTR_MASK (0x0F000000u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP3_QUEUE_PTR_SHIFT (0x00000018u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP3_QUEUE_PTR_RESETVAL (0x00000003u)

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP2_NUM_MSGS_MASK (0x00F00000u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP2_NUM_MSGS_SHIFT (0x00000014u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP2_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP2_QUEUE_PTR_MASK (0x000F0000u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP2_QUEUE_PTR_SHIFT (0x00000010u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP2_QUEUE_PTR_RESETVAL (0x00000002u)

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP1_NUM_MSGS_MASK (0x0000F000u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP1_NUM_MSGS_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP1_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP1_QUEUE_PTR_MASK (0x00000F00u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP1_QUEUE_PTR_SHIFT (0x00000008u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP1_QUEUE_PTR_RESETVAL (0x00000001u)

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP0_NUM_MSGS_MASK (0x000000F0u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP0_NUM_MSGS_SHIFT (0x00000004u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP0_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP0_QUEUE_PTR_MASK (0x0000000Fu)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP0_QUEUE_PTR_SHIFT (0x00000000u)
#define CSL_SRIO_TX_QUEUE_CNTL0_TX_QUEUE_MAP0_QUEUE_PTR_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL0_RESETVAL (0x03020100u)

/* TX_QUEUE_CNTL1 */

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP7_NUM_MSGS_MASK (0xF0000000u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP7_NUM_MSGS_SHIFT (0x0000001Cu)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP7_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP7_QUEUE_PTR_MASK (0x0F000000u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP7_QUEUE_PTR_SHIFT (0x00000018u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP7_QUEUE_PTR_RESETVAL (0x00000007u)

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP6_NUM_MSGS_MASK (0x00F00000u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP6_NUM_MSGS_SHIFT (0x00000014u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP6_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP6_QUEUE_PTR_MASK (0x000F0000u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP6_QUEUE_PTR_SHIFT (0x00000010u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP6_QUEUE_PTR_RESETVAL (0x00000006u)

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP5_NUM_MSGS_MASK (0x0000F000u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP5_NUM_MSGS_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP5_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP5_QUEUE_PTR_MASK (0x00000F00u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP5_QUEUE_PTR_SHIFT (0x00000008u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP5_QUEUE_PTR_RESETVAL (0x00000005u)

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP4_NUM_MSGS_MASK (0x000000F0u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP4_NUM_MSGS_SHIFT (0x00000004u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP4_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP4_QUEUE_PTR_MASK (0x0000000Fu)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP4_QUEUE_PTR_SHIFT (0x00000000u)
#define CSL_SRIO_TX_QUEUE_CNTL1_TX_QUEUE_MAP4_QUEUE_PTR_RESETVAL (0x00000004u)

#define CSL_SRIO_TX_QUEUE_CNTL1_RESETVAL (0x07060504u)

/* TX_QUEUE_CNTL2 */

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP11_NUM_MSGS_MASK (0xF0000000u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP11_NUM_MSGS_SHIFT (0x0000001Cu)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP11_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP11_QUEUE_PTR_MASK (0x0F000000u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP11_QUEUE_PTR_SHIFT (0x00000018u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP11_QUEUE_PTR_RESETVAL (0x0000000Bu)

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP10_NUM_MSGS_MASK (0x00F00000u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP10_NUM_MSGS_SHIFT (0x00000014u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP10_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP10_QUEUE_PTR_MASK (0x000F0000u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP10_QUEUE_PTR_SHIFT (0x00000010u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP10_QUEUE_PTR_RESETVAL (0x0000000Au)

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP9_NUM_MSGS_MASK (0x0000F000u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP9_NUM_MSGS_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP9_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP9_QUEUE_PTR_MASK (0x00000F00u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP9_QUEUE_PTR_SHIFT (0x00000008u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP9_QUEUE_PTR_RESETVAL (0x00000009u)

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP8_NUM_MSGS_MASK (0x000000F0u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP8_NUM_MSGS_SHIFT (0x00000004u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP8_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP8_QUEUE_PTR_MASK (0x0000000Fu)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP8_QUEUE_PTR_SHIFT (0x00000000u)
#define CSL_SRIO_TX_QUEUE_CNTL2_TX_QUEUE_MAP8_QUEUE_PTR_RESETVAL (0x00000008u)

#define CSL_SRIO_TX_QUEUE_CNTL2_RESETVAL (0x0B0A0908u)

/* TX_QUEUE_CNTL3 */

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP15_NUM_MSGS_MASK (0xF0000000u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP15_NUM_MSGS_SHIFT (0x0000001Cu)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP15_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP15_QUEUE_PTR_MASK (0x0F000000u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP15_QUEUE_PTR_SHIFT (0x00000018u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP15_QUEUE_PTR_RESETVAL (0x0000000Fu)

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP14_NUM_MSGS_MASK (0x00F00000u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP14_NUM_MSGS_SHIFT (0x00000014u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP14_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP14_QUEUE_PTR_MASK (0x000F0000u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP14_QUEUE_PTR_SHIFT (0x00000010u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP14_QUEUE_PTR_RESETVAL (0x0000000Eu)

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP13_NUM_MSGS_MASK (0x0000F000u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP13_NUM_MSGS_SHIFT (0x0000000Cu)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP13_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP13_QUEUE_PTR_MASK (0x00000F00u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP13_QUEUE_PTR_SHIFT (0x00000008u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP13_QUEUE_PTR_RESETVAL (0x0000000Du)

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP12_NUM_MSGS_MASK (0x000000F0u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP12_NUM_MSGS_SHIFT (0x00000004u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP12_NUM_MSGS_RESETVAL (0x00000000u)

#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP12_QUEUE_PTR_MASK (0x0000000Fu)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP12_QUEUE_PTR_SHIFT (0x00000000u)
#define CSL_SRIO_TX_QUEUE_CNTL3_TX_QUEUE_MAP12_QUEUE_PTR_RESETVAL (0x0000000Cu)

#define CSL_SRIO_TX_QUEUE_CNTL3_RESETVAL (0x0F0E0D0Cu)


/* RXU_MAP_L */

#define CSL_SRIO_RXU_MAP_L_LETTER_MASK_MASK (0xC0000000u)
#define CSL_SRIO_RXU_MAP_L_LETTER_MASK_SHIFT (0x0000001Eu)
#define CSL_SRIO_RXU_MAP_L_LETTER_MASK_RESETVAL (0x00000003u)

#define CSL_SRIO_RXU_MAP_L_MAILBOX_MASK_MASK (0x3F000000u)
#define CSL_SRIO_RXU_MAP_L_MAILBOX_MASK_SHIFT (0x00000018u)
#define CSL_SRIO_RXU_MAP_L_MAILBOX_MASK_RESETVAL (0x0000003Fu)

#define CSL_SRIO_RXU_MAP_L_LETTER_MASK   (0x00C00000u)
#define CSL_SRIO_RXU_MAP_L_LETTER_SHIFT  (0x00000016u)
#define CSL_SRIO_RXU_MAP_L_LETTER_RESETVAL (0x00000000u)

#define CSL_SRIO_RXU_MAP_L_MAILBOX_MASK  (0x003F0000u)
#define CSL_SRIO_RXU_MAP_L_MAILBOX_SHIFT (0x00000010u)
#define CSL_SRIO_RXU_MAP_L_MAILBOX_RESETVAL (0x00000000u)

#define CSL_SRIO_RXU_MAP_L_SOURCEID_MASK (0x0000FFFFu)
#define CSL_SRIO_RXU_MAP_L_SOURCEID_SHIFT (0x00000000u)
#define CSL_SRIO_RXU_MAP_L_SOURCEID_RESETVAL (0x00000000u)

#define CSL_SRIO_RXU_MAP_L_RESETVAL      (0xFF000000u)

/* RXU_MAP_H */

#define CSL_SRIO_RXU_MAP_H_TT_MASK       (0x00000300u)
#define CSL_SRIO_RXU_MAP_H_TT_SHIFT      (0x00000008u)
#define CSL_SRIO_RXU_MAP_H_TT_RESETVAL   (0x00000001u)

/*----TT Tokens----*/
#define CSL_SRIO_RXU_MAP_H_TT_MATCH_8BIT_SRCID (0x00000000u)
#define CSL_SRIO_RXU_MAP_H_TT_MATCH_16BIT_SRCID (0x00000001u)

#define CSL_SRIO_RXU_MAP_H_QUEUE_ID_MASK (0x0000003Cu)
#define CSL_SRIO_RXU_MAP_H_QUEUE_ID_SHIFT (0x00000002u)
#define CSL_SRIO_RXU_MAP_H_QUEUE_ID_RESETVAL (0x00000000u)

#define CSL_SRIO_RXU_MAP_H_PROMISCUOUS_MASK (0x00000002u)
#define CSL_SRIO_RXU_MAP_H_PROMISCUOUS_SHIFT (0x00000001u)
#define CSL_SRIO_RXU_MAP_H_PROMISCUOUS_RESETVAL (0x00000000u)

/*----PROMISCUOUS Tokens----*/
#define CSL_SRIO_RXU_MAP_H_PROMISCUOUS_DISABLE (0x00000000u)
#define CSL_SRIO_RXU_MAP_H_PROMISCUOUS_ENABLE (0x00000001u)

#define CSL_SRIO_RXU_MAP_H_SEGMENT_MAPPING_MASK (0x00000001u)
#define CSL_SRIO_RXU_MAP_H_SEGMENT_MAPPING_SHIFT (0x00000000u)
#define CSL_SRIO_RXU_MAP_H_SEGMENT_MAPPING_RESETVAL (0x00000000u)

/*----SEGMENT_MAPPING Tokens----*/
#define CSL_SRIO_RXU_MAP_H_SEGMENT_MAPPING_SINGLE_SEGMENT (0x00000000u)
#define CSL_SRIO_RXU_MAP_H_SEGMENT_MAPPING_MULTI_SEGMENT (0x00000001u)

#define CSL_SRIO_RXU_MAP_H_RESETVAL      (0x00000100u)

/* FLOW_CNTL */

#define CSL_SRIO_FLOW_CNTL_TT_MASK       (0x00030000u)
#define CSL_SRIO_FLOW_CNTL_TT_SHIFT      (0x00000010u)
#define CSL_SRIO_FLOW_CNTL_TT_RESETVAL   (0x00000001u)

/*----TT Tokens----*/
#define CSL_SRIO_FLOW_CNTL_TT_8BIT_ID    (0x00000000u)
#define CSL_SRIO_FLOW_CNTL_TT_16BIT_ID   (0x00000001u)

#define CSL_SRIO_FLOW_CNTL_FLOW_CNTL_ID_MASK (0x0000FFFFu)
#define CSL_SRIO_FLOW_CNTL_FLOW_CNTL_ID_SHIFT (0x00000000u)
#define CSL_SRIO_FLOW_CNTL_FLOW_CNTL_ID_RESETVAL (0x00000000u)

#define CSL_SRIO_FLOW_CNTL_RESETVAL      (0x00010000u)

/* DEV_ID */

#define CSL_SRIO_DEV_ID_DEVICEIDENTITY_MASK (0xFFFF0000u)
#define CSL_SRIO_DEV_ID_DEVICEIDENTITY_SHIFT (0x00000010u)
#define CSL_SRIO_DEV_ID_DEVICEIDENTITY_RESETVAL (0x00000000u)

#define CSL_SRIO_DEV_ID_DEVICE_VENDORIDENTITY_MASK (0x0000FFFFu)
#define CSL_SRIO_DEV_ID_DEVICE_VENDORIDENTITY_SHIFT (0x00000000u)
#define CSL_SRIO_DEV_ID_DEVICE_VENDORIDENTITY_RESETVAL (0x00000030u)

#define CSL_SRIO_DEV_ID_RESETVAL         (0x00000030u)

/* DEV_INFO */

#define CSL_SRIO_DEV_INFO_DEVICEREV_MASK (0xFFFFFFFFu)
#define CSL_SRIO_DEV_INFO_DEVICEREV_SHIFT (0x00000000u)
#define CSL_SRIO_DEV_INFO_DEVICEREV_RESETVAL (0x00000000u)

#define CSL_SRIO_DEV_INFO_RESETVAL       (0x00000000u)

/* ASBLY_ID */

#define CSL_SRIO_ASBLY_ID_ASSY_IDENTITY_MASK (0xFFFF0000u)
#define CSL_SRIO_ASBLY_ID_ASSY_IDENTITY_SHIFT (0x00000010u)
#define CSL_SRIO_ASBLY_ID_ASSY_IDENTITY_RESETVAL (0x00000000u)

#define CSL_SRIO_ASBLY_ID_ASSY_VENDORIDENTITY_MASK (0x0000FFFFu)
#define CSL_SRIO_ASBLY_ID_ASSY_VENDORIDENTITY_SHIFT (0x00000000u)
#define CSL_SRIO_ASBLY_ID_ASSY_VENDORIDENTITY_RESETVAL (0x00000030u)

#define CSL_SRIO_ASBLY_ID_RESETVAL       (0x00000030u)

/* ASBLY_INFO */

#define CSL_SRIO_ASBLY_INFO_ASSYREV_MASK (0xFFFF0000u)
#define CSL_SRIO_ASBLY_INFO_ASSYREV_SHIFT (0x00000010u)
#define CSL_SRIO_ASBLY_INFO_ASSYREV_RESETVAL (0x00000000u)

#define CSL_SRIO_ASBLY_INFO_EXTENDEDFEATURESPTR_MASK (0x0000FFFFu)
#define CSL_SRIO_ASBLY_INFO_EXTENDEDFEATURESPTR_SHIFT (0x00000000u)
#define CSL_SRIO_ASBLY_INFO_EXTENDEDFEATURESPTR_RESETVAL (0x00000100u)

#define CSL_SRIO_ASBLY_INFO_RESETVAL     (0x00000100u)

/* PE_FEAT */

#define CSL_SRIO_PE_FEAT_BRIDGE_MASK     (0x80000000u)
#define CSL_SRIO_PE_FEAT_BRIDGE_SHIFT    (0x0000001Fu)
#define CSL_SRIO_PE_FEAT_BRIDGE_RESETVAL (0x00000000u)

#define CSL_SRIO_PE_FEAT_MEMORY_MASK     (0x40000000u)
#define CSL_SRIO_PE_FEAT_MEMORY_SHIFT    (0x0000001Eu)
#define CSL_SRIO_PE_FEAT_MEMORY_RESETVAL (0x00000000u)

#define CSL_SRIO_PE_FEAT_PROCESSOR_MASK  (0x20000000u)
#define CSL_SRIO_PE_FEAT_PROCESSOR_SHIFT (0x0000001Du)
#define CSL_SRIO_PE_FEAT_PROCESSOR_RESETVAL (0x00000001u)

#define CSL_SRIO_PE_FEAT_SWITCH_MASK     (0x10000000u)
#define CSL_SRIO_PE_FEAT_SWITCH_SHIFT    (0x0000001Cu)
#define CSL_SRIO_PE_FEAT_SWITCH_RESETVAL (0x00000000u)

#define CSL_SRIO_PE_FEAT_FLOW_CONTROL_SUPPORT_MASK (0x00000080u)
#define CSL_SRIO_PE_FEAT_FLOW_CONTROL_SUPPORT_SHIFT (0x00000007u)
#define CSL_SRIO_PE_FEAT_FLOW_CONTROL_SUPPORT_RESETVAL (0x00000000u)

#define CSL_SRIO_PE_FEAT_RETRANSMIT_SUPPRESS_MASK (0x00000040u)
#define CSL_SRIO_PE_FEAT_RETRANSMIT_SUPPRESS_SHIFT (0x00000006u)
#define CSL_SRIO_PE_FEAT_RETRANSMIT_SUPPRESS_RESETVAL (0x00000000u)

#define CSL_SRIO_PE_FEAT_CRF_SUPPORT_MASK (0x00000020u)
#define CSL_SRIO_PE_FEAT_CRF_SUPPORT_SHIFT (0x00000005u)
#define CSL_SRIO_PE_FEAT_CRF_SUPPORT_RESETVAL (0x00000000u)

#define CSL_SRIO_PE_FEAT_LARGE_SUPPORT_MASK (0x00000010u)
#define CSL_SRIO_PE_FEAT_LARGE_SUPPORT_SHIFT (0x00000004u)
#define CSL_SRIO_PE_FEAT_LARGE_SUPPORT_RESETVAL (0x00000000u)

#define CSL_SRIO_PE_FEAT_EXTENDED_FEATURES_MASK (0x00000008u)
#define CSL_SRIO_PE_FEAT_EXTENDED_FEATURES_SHIFT (0x00000003u)
#define CSL_SRIO_PE_FEAT_EXTENDED_FEATURES_RESETVAL (0x00000001u)

#define CSL_SRIO_PE_FEAT_EXTENDED_ADDRESSING_SUPPORT_MASK (0x00000007u)
#define CSL_SRIO_PE_FEAT_EXTENDED_ADDRESSING_SUPPORT_SHIFT (0x00000000u)
#define CSL_SRIO_PE_FEAT_EXTENDED_ADDRESSING_SUPPORT_RESETVAL (0x00000001u)

#define CSL_SRIO_PE_FEAT_RESETVAL        (0x20000009u)

/* SRC_OP */

#define CSL_SRIO_SRC_OP_IMPLMNT_DEFINED_2_MASK (0x00030000u)
#define CSL_SRIO_SRC_OP_IMPLMNT_DEFINED_2_SHIFT (0x00000010u)
#define CSL_SRIO_SRC_OP_IMPLMNT_DEFINED_2_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_READ_MASK        (0x00008000u)
#define CSL_SRIO_SRC_OP_READ_SHIFT       (0x0000000Fu)
#define CSL_SRIO_SRC_OP_READ_RESETVAL    (0x00000000u)

#define CSL_SRIO_SRC_OP_WRITE_MASK       (0x00004000u)
#define CSL_SRIO_SRC_OP_WRITE_SHIFT      (0x0000000Eu)
#define CSL_SRIO_SRC_OP_WRITE_RESETVAL   (0x00000000u)

#define CSL_SRIO_SRC_OP_STREAM_WRITE_MASK (0x00002000u)
#define CSL_SRIO_SRC_OP_STREAM_WRITE_SHIFT (0x0000000Du)
#define CSL_SRIO_SRC_OP_STREAM_WRITE_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_WRITE_WITH_RESP_MASK (0x00001000u)
#define CSL_SRIO_SRC_OP_WRITE_WITH_RESP_SHIFT (0x0000000Cu)
#define CSL_SRIO_SRC_OP_WRITE_WITH_RESP_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_DATA_MESS_MASK   (0x00000800u)
#define CSL_SRIO_SRC_OP_DATA_MESS_SHIFT  (0x0000000Bu)
#define CSL_SRIO_SRC_OP_DATA_MESS_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_DOORBELL_MASK    (0x00000400u)
#define CSL_SRIO_SRC_OP_DOORBELL_SHIFT   (0x0000000Au)
#define CSL_SRIO_SRC_OP_DOORBELL_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_ATOMIC_TEST_AND_SWAP_MASK (0x00000100u)
#define CSL_SRIO_SRC_OP_ATOMIC_TEST_AND_SWAP_SHIFT (0x00000008u)
#define CSL_SRIO_SRC_OP_ATOMIC_TEST_AND_SWAP_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_ATOMIC_INCRMNT_MASK (0x00000080u)
#define CSL_SRIO_SRC_OP_ATOMIC_INCRMNT_SHIFT (0x00000007u)
#define CSL_SRIO_SRC_OP_ATOMIC_INCRMNT_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_ATOMIC_DCRMNT_MASK (0x00000040u)
#define CSL_SRIO_SRC_OP_ATOMIC_DCRMNT_SHIFT (0x00000006u)
#define CSL_SRIO_SRC_OP_ATOMIC_DCRMNT_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_ATOMIC_SET_MASK  (0x00000020u)
#define CSL_SRIO_SRC_OP_ATOMIC_SET_SHIFT (0x00000005u)
#define CSL_SRIO_SRC_OP_ATOMIC_SET_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_ATOMIC_CLEAR_MASK (0x00000010u)
#define CSL_SRIO_SRC_OP_ATOMIC_CLEAR_SHIFT (0x00000004u)
#define CSL_SRIO_SRC_OP_ATOMIC_CLEAR_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_PORT_WRITE_MASK  (0x00000004u)
#define CSL_SRIO_SRC_OP_PORT_WRITE_SHIFT (0x00000002u)
#define CSL_SRIO_SRC_OP_PORT_WRITE_RESETVAL (0x00000001u)

#define CSL_SRIO_SRC_OP_IMPLMNT_DEFINED_1_MASK (0x00000003u)
#define CSL_SRIO_SRC_OP_IMPLMNT_DEFINED_1_SHIFT (0x00000000u)
#define CSL_SRIO_SRC_OP_IMPLMNT_DEFINED_1_RESETVAL (0x00000000u)

#define CSL_SRIO_SRC_OP_RESETVAL         (0x00000004u)

/* DEST_OP */

#define CSL_SRIO_DEST_OP_IMPLMNT_DEFINED_2_MASK (0x00030000u)
#define CSL_SRIO_DEST_OP_IMPLMNT_DEFINED_2_SHIFT (0x00000010u)
#define CSL_SRIO_DEST_OP_IMPLMNT_DEFINED_2_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_READ_MASK       (0x00008000u)
#define CSL_SRIO_DEST_OP_READ_SHIFT      (0x0000000Fu)
#define CSL_SRIO_DEST_OP_READ_RESETVAL   (0x00000000u)

#define CSL_SRIO_DEST_OP_WRITE_MASK      (0x00004000u)
#define CSL_SRIO_DEST_OP_WRITE_SHIFT     (0x0000000Eu)
#define CSL_SRIO_DEST_OP_WRITE_RESETVAL  (0x00000000u)

#define CSL_SRIO_DEST_OP_STREAM_WRITE_MASK (0x00002000u)
#define CSL_SRIO_DEST_OP_STREAM_WRITE_SHIFT (0x0000000Du)
#define CSL_SRIO_DEST_OP_STREAM_WRITE_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_WRITE_WITH_RESP_MASK (0x00001000u)
#define CSL_SRIO_DEST_OP_WRITE_WITH_RESP_SHIFT (0x0000000Cu)
#define CSL_SRIO_DEST_OP_WRITE_WITH_RESP_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_DATA_MESS_MASK  (0x00000800u)
#define CSL_SRIO_DEST_OP_DATA_MESS_SHIFT (0x0000000Bu)
#define CSL_SRIO_DEST_OP_DATA_MESS_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_DOORBELL_MASK   (0x00000400u)
#define CSL_SRIO_DEST_OP_DOORBELL_SHIFT  (0x0000000Au)
#define CSL_SRIO_DEST_OP_DOORBELL_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_ATOMIC_TEST_AND_SWAP_MASK (0x00000100u)
#define CSL_SRIO_DEST_OP_ATOMIC_TEST_AND_SWAP_SHIFT (0x00000008u)
#define CSL_SRIO_DEST_OP_ATOMIC_TEST_AND_SWAP_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_ATOMIC_INCRMNT_MASK (0x00000080u)
#define CSL_SRIO_DEST_OP_ATOMIC_INCRMNT_SHIFT (0x00000007u)
#define CSL_SRIO_DEST_OP_ATOMIC_INCRMNT_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_ATOMIC_DCRMNT_MASK (0x00000040u)
#define CSL_SRIO_DEST_OP_ATOMIC_DCRMNT_SHIFT (0x00000006u)
#define CSL_SRIO_DEST_OP_ATOMIC_DCRMNT_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_ATOMIC_SET_MASK (0x00000020u)
#define CSL_SRIO_DEST_OP_ATOMIC_SET_SHIFT (0x00000005u)
#define CSL_SRIO_DEST_OP_ATOMIC_SET_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_ATOMIC_CLEAR_MASK (0x00000010u)
#define CSL_SRIO_DEST_OP_ATOMIC_CLEAR_SHIFT (0x00000004u)
#define CSL_SRIO_DEST_OP_ATOMIC_CLEAR_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_PORT_WRITE_MASK (0x00000004u)
#define CSL_SRIO_DEST_OP_PORT_WRITE_SHIFT (0x00000002u)
#define CSL_SRIO_DEST_OP_PORT_WRITE_RESETVAL (0x00000001u)

#define CSL_SRIO_DEST_OP_IMPLMNT_DEFINED_1_MASK (0x00000003u)
#define CSL_SRIO_DEST_OP_IMPLMNT_DEFINED_1_SHIFT (0x00000000u)
#define CSL_SRIO_DEST_OP_IMPLMNT_DEFINED_1_RESETVAL (0x00000000u)

#define CSL_SRIO_DEST_OP_RESETVAL        (0x00000004u)

/* PE_LL_CTL */

#define CSL_SRIO_PE_LL_CTL_EXTENDED_ADDRESSING_CONTROL_MASK (0x00000007u)
#define CSL_SRIO_PE_LL_CTL_EXTENDED_ADDRESSING_CONTROL_SHIFT (0x00000000u)
#define CSL_SRIO_PE_LL_CTL_EXTENDED_ADDRESSING_CONTROL_RESETVAL (0x00000001u)

/*----EXTENDED_ADDRESSING_CONTROL Tokens----*/
#define CSL_SRIO_PE_LL_CTL_EXTENDED_ADDRESSING_CONTROL_66BIT (0x00000004u)
#define CSL_SRIO_PE_LL_CTL_EXTENDED_ADDRESSING_CONTROL_50BIT (0x00000002u)
#define CSL_SRIO_PE_LL_CTL_EXTENDED_ADDRESSING_CONTROL_34BIT (0x00000001u)

#define CSL_SRIO_PE_LL_CTL_RESETVAL      (0x00000001u)

/* LCL_CFG_HBAR */

#define CSL_SRIO_LCL_CFG_HBAR_LCSBA_MASK (0x7FFFFFFFu)
#define CSL_SRIO_LCL_CFG_HBAR_LCSBA_SHIFT (0x00000000u)
#define CSL_SRIO_LCL_CFG_HBAR_LCSBA_RESETVAL (0x00000000u)

#define CSL_SRIO_LCL_CFG_HBAR_RESETVAL   (0x00000000u)

/* LCL_CFG_BAR */

#define CSL_SRIO_LCL_CFG_BAR_LCSBA_MASK  (0xFFFFFFFFu)
#define CSL_SRIO_LCL_CFG_BAR_LCSBA_SHIFT (0x00000000u)
#define CSL_SRIO_LCL_CFG_BAR_LCSBA_RESETVAL (0x00000000u)

#define CSL_SRIO_LCL_CFG_BAR_RESETVAL    (0x00000000u)

/* BASE_ID */

#define CSL_SRIO_BASE_ID_BASE_DEVICEID_MASK (0x00FF0000u)
#define CSL_SRIO_BASE_ID_BASE_DEVICEID_SHIFT (0x00000010u)
#define CSL_SRIO_BASE_ID_BASE_DEVICEID_RESETVAL (0x000000FFu)

#define CSL_SRIO_BASE_ID_LARGE_BASE_DEVICEID_MASK (0x0000FFFFu)
#define CSL_SRIO_BASE_ID_LARGE_BASE_DEVICEID_SHIFT (0x00000000u)
#define CSL_SRIO_BASE_ID_LARGE_BASE_DEVICEID_RESETVAL (0x0000FFFFu)

#define CSL_SRIO_BASE_ID_RESETVAL        (0x00FFFFFFu)

/* HOST_BASE_ID_LOCK */

#define CSL_SRIO_HOST_BASE_ID_LOCK_HOST_BASE_DEVICEID_MASK (0x0000FFFFu)
#define CSL_SRIO_HOST_BASE_ID_LOCK_HOST_BASE_DEVICEID_SHIFT (0x00000000u)
#define CSL_SRIO_HOST_BASE_ID_LOCK_HOST_BASE_DEVICEID_RESETVAL (0x0000FFFFu)

#define CSL_SRIO_HOST_BASE_ID_LOCK_RESETVAL (0x0000FFFFu)

/* COMP_TAG */

#define CSL_SRIO_COMP_TAG_COMPONENT_TAG_MASK (0xFFFFFFFFu)
#define CSL_SRIO_COMP_TAG_COMPONENT_TAG_SHIFT (0x00000000u)
#define CSL_SRIO_COMP_TAG_COMPONENT_TAG_RESETVAL (0x00000000u)

#define CSL_SRIO_COMP_TAG_RESETVAL       (0x00000000u)

/* SP_MB_HEAD */

#define CSL_SRIO_SP_MB_HEAD_EF_PTR_MASK  (0xFFFF0000u)
#define CSL_SRIO_SP_MB_HEAD_EF_PTR_SHIFT (0x00000010u)
#define CSL_SRIO_SP_MB_HEAD_EF_PTR_RESETVAL (0x00001000u)

#define CSL_SRIO_SP_MB_HEAD_EF_ID_MASK   (0x0000FFFFu)
#define CSL_SRIO_SP_MB_HEAD_EF_ID_SHIFT  (0x00000000u)
#define CSL_SRIO_SP_MB_HEAD_EF_ID_RESETVAL (0x00000001u)

#define CSL_SRIO_SP_MB_HEAD_RESETVAL     (0x10000001u)

/* SP_LT_CTL */

#define CSL_SRIO_SP_LT_CTL_TIMEOUT_VALUE_MASK (0xFFFFFF00u)
#define CSL_SRIO_SP_LT_CTL_TIMEOUT_VALUE_SHIFT (0x00000008u)
#define CSL_SRIO_SP_LT_CTL_TIMEOUT_VALUE_RESETVAL (0x00FFFFFFu)

#define CSL_SRIO_SP_LT_CTL_RESETVAL      (0xFFFFFF00u)

/* SP_RT_CTL */

#define CSL_SRIO_SP_RT_CTL_TIMEOUT_VALUE_MASK (0xFFFFFF00u)
#define CSL_SRIO_SP_RT_CTL_TIMEOUT_VALUE_SHIFT (0x00000008u)
#define CSL_SRIO_SP_RT_CTL_TIMEOUT_VALUE_RESETVAL (0x00FFFFFFu)

#define CSL_SRIO_SP_RT_CTL_RESETVAL      (0xFFFFFF00u)

/* SP_GEN_CTL */

#define CSL_SRIO_SP_GEN_CTL_HOST_MASK    (0x80000000u)
#define CSL_SRIO_SP_GEN_CTL_HOST_SHIFT   (0x0000001Fu)
#define CSL_SRIO_SP_GEN_CTL_HOST_RESETVAL (0x00000000u)

/*----HOST Tokens----*/
#define CSL_SRIO_SP_GEN_CTL_HOST_DISABLE (0x00000000u)
#define CSL_SRIO_SP_GEN_CTL_HOST_ENABLE  (0x00000001u)

#define CSL_SRIO_SP_GEN_CTL_MASTER_ENABLE_MASK (0x40000000u)
#define CSL_SRIO_SP_GEN_CTL_MASTER_ENABLE_SHIFT (0x0000001Eu)
#define CSL_SRIO_SP_GEN_CTL_MASTER_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_GEN_CTL_DISCOVERED_MASK (0x20000000u)
#define CSL_SRIO_SP_GEN_CTL_DISCOVERED_SHIFT (0x0000001Du)
#define CSL_SRIO_SP_GEN_CTL_DISCOVERED_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_GEN_CTL_RESETVAL     (0x00000000u)

/* SP_LM_REQ */

#define CSL_SRIO_SP_LM_REQ_COMMAND_MASK  (0x00000007u)
#define CSL_SRIO_SP_LM_REQ_COMMAND_SHIFT (0x00000000u)
#define CSL_SRIO_SP_LM_REQ_COMMAND_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_LM_REQ_RESETVAL      (0x00000000u)

/* SP_LM_RESP */

#define CSL_SRIO_SP_LM_RESP_RESPONSE_VALID_MASK (0x80000000u)
#define CSL_SRIO_SP_LM_RESP_RESPONSE_VALID_SHIFT (0x0000001Fu)
#define CSL_SRIO_SP_LM_RESP_RESPONSE_VALID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_LM_RESP_ACKID_STATUS_MASK (0x000003E0u)
#define CSL_SRIO_SP_LM_RESP_ACKID_STATUS_SHIFT (0x00000005u)
#define CSL_SRIO_SP_LM_RESP_ACKID_STATUS_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_LM_RESP_LINK_STATUS_MASK (0x0000001Fu)
#define CSL_SRIO_SP_LM_RESP_LINK_STATUS_SHIFT (0x00000000u)
#define CSL_SRIO_SP_LM_RESP_LINK_STATUS_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_LM_RESP_RESETVAL     (0x00000000u)

/* SP_ACKID_STAT */

#define CSL_SRIO_SP_ACKID_STAT_INBOUND_ACKID_MASK (0x1F000000u)
#define CSL_SRIO_SP_ACKID_STAT_INBOUND_ACKID_SHIFT (0x00000018u)
#define CSL_SRIO_SP_ACKID_STAT_INBOUND_ACKID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ACKID_STAT_OUTSTANDING_ACKID_MASK (0x00001F00u)
#define CSL_SRIO_SP_ACKID_STAT_OUTSTANDING_ACKID_SHIFT (0x00000008u)
#define CSL_SRIO_SP_ACKID_STAT_OUTSTANDING_ACKID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ACKID_STAT_OUTBOUND_ACKID_MASK (0x0000001Fu)
#define CSL_SRIO_SP_ACKID_STAT_OUTBOUND_ACKID_SHIFT (0x00000000u)
#define CSL_SRIO_SP_ACKID_STAT_OUTBOUND_ACKID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ACKID_STAT_RESETVAL  (0x00000000u)

/* SP_ERR_STAT */

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_PKT_DROP_MASK (0x04000000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_PKT_DROP_SHIFT (0x0000001Au)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_PKT_DROP_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_FLD_ENC_MASK (0x02000000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_FLD_ENC_SHIFT (0x00000019u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_FLD_ENC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_DEGRD_ENC_MASK (0x01000000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_DEGRD_ENC_SHIFT (0x00000018u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_DEGRD_ENC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRY_ENC_MASK (0x00100000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRY_ENC_SHIFT (0x00000014u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRY_ENC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRIED_MASK (0x00080000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRIED_SHIFT (0x00000013u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRIED_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRY_STP_MASK (0x00040000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRY_STP_SHIFT (0x00000012u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_RETRY_STP_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_ERROR_ENC_MASK (0x00020000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_ERROR_ENC_SHIFT (0x00000011u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_ERROR_ENC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_OUTPUT_ERROR_STP_MASK (0x00010000u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_ERROR_STP_SHIFT (0x00000010u)
#define CSL_SRIO_SP_ERR_STAT_OUTPUT_ERROR_STP_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_INPUT_RETRY_STP_MASK (0x00000400u)
#define CSL_SRIO_SP_ERR_STAT_INPUT_RETRY_STP_SHIFT (0x0000000Au)
#define CSL_SRIO_SP_ERR_STAT_INPUT_RETRY_STP_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_INPUT_ERROR_ENC_MASK (0x00000200u)
#define CSL_SRIO_SP_ERR_STAT_INPUT_ERROR_ENC_SHIFT (0x00000009u)
#define CSL_SRIO_SP_ERR_STAT_INPUT_ERROR_ENC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_INPUT_ERROR_STP_MASK (0x00000100u)
#define CSL_SRIO_SP_ERR_STAT_INPUT_ERROR_STP_SHIFT (0x00000008u)
#define CSL_SRIO_SP_ERR_STAT_INPUT_ERROR_STP_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_PORT_WRITE_PND_MASK (0x00000010u)
#define CSL_SRIO_SP_ERR_STAT_PORT_WRITE_PND_SHIFT (0x00000004u)
#define CSL_SRIO_SP_ERR_STAT_PORT_WRITE_PND_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_PORT_ERROR_MASK (0x00000004u)
#define CSL_SRIO_SP_ERR_STAT_PORT_ERROR_SHIFT (0x00000002u)
#define CSL_SRIO_SP_ERR_STAT_PORT_ERROR_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_PORT_OK_MASK (0x00000002u)
#define CSL_SRIO_SP_ERR_STAT_PORT_OK_SHIFT (0x00000001u)
#define CSL_SRIO_SP_ERR_STAT_PORT_OK_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_STAT_PORT_UNINITIALIZED_MASK (0x00000001u)
#define CSL_SRIO_SP_ERR_STAT_PORT_UNINITIALIZED_SHIFT (0x00000000u)
#define CSL_SRIO_SP_ERR_STAT_PORT_UNINITIALIZED_RESETVAL (0x00000001u)

#define CSL_SRIO_SP_ERR_STAT_RESETVAL    (0x00000001u)

/* SP_CTL */

#define CSL_SRIO_SP_CTL_PORT_WIDTH_MASK  (0xC0000000u)
#define CSL_SRIO_SP_CTL_PORT_WIDTH_SHIFT (0x0000001Eu)
#define CSL_SRIO_SP_CTL_PORT_WIDTH_RESETVAL (0x00000001u)

#define CSL_SRIO_SP_CTL_INITIALIZED_PORT_WIDTH_MASK (0x38000000u)
#define CSL_SRIO_SP_CTL_INITIALIZED_PORT_WIDTH_SHIFT (0x0000001Bu)
#define CSL_SRIO_SP_CTL_INITIALIZED_PORT_WIDTH_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_PORT_WIDTH_OVERRIDE_MASK (0x07000000u)
#define CSL_SRIO_SP_CTL_PORT_WIDTH_OVERRIDE_SHIFT (0x00000018u)
#define CSL_SRIO_SP_CTL_PORT_WIDTH_OVERRIDE_RESETVAL (0x00000000u)

/*----PORT_WIDTH_OVERRIDE Tokens----*/
#define CSL_SRIO_SP_CTL_PORT_WIDTH_OVERRIDE_NO_OVERRIDE (0x00000000u)
#define CSL_SRIO_SP_CTL_PORT_WIDTH_OVERRIDE_SINGLE_LANE_0 (0x00000002u)
#define CSL_SRIO_SP_CTL_PORT_WIDTH_OVERRIDE_SINGLE_LANE_2 (0x00000003u)

#define CSL_SRIO_SP_CTL_PORT_DISABLE_MASK (0x00800000u)
#define CSL_SRIO_SP_CTL_PORT_DISABLE_SHIFT (0x00000017u)
#define CSL_SRIO_SP_CTL_PORT_DISABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_OUTPUT_PORT_ENABLE_MASK (0x00400000u)
#define CSL_SRIO_SP_CTL_OUTPUT_PORT_ENABLE_SHIFT (0x00000016u)
#define CSL_SRIO_SP_CTL_OUTPUT_PORT_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_INPUT_PORT_ENABLE_MASK (0x00200000u)
#define CSL_SRIO_SP_CTL_INPUT_PORT_ENABLE_SHIFT (0x00000015u)
#define CSL_SRIO_SP_CTL_INPUT_PORT_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_ERROR_CHECK_DISABLE_MASK (0x00100000u)
#define CSL_SRIO_SP_CTL_ERROR_CHECK_DISABLE_SHIFT (0x00000014u)
#define CSL_SRIO_SP_CTL_ERROR_CHECK_DISABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_MULTICAST_PARTICIPANT_MASK (0x00080000u)
#define CSL_SRIO_SP_CTL_MULTICAST_PARTICIPANT_SHIFT (0x00000013u)
#define CSL_SRIO_SP_CTL_MULTICAST_PARTICIPANT_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_STOP_PORT_FLD_ENC_ENABLE_MASK (0x00000008u)
#define CSL_SRIO_SP_CTL_STOP_PORT_FLD_ENC_ENABLE_SHIFT (0x00000003u)
#define CSL_SRIO_SP_CTL_STOP_PORT_FLD_ENC_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_DROP_PACKET_ENABLE_MASK (0x00000004u)
#define CSL_SRIO_SP_CTL_DROP_PACKET_ENABLE_SHIFT (0x00000002u)
#define CSL_SRIO_SP_CTL_DROP_PACKET_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_PORT_LOCKOUT_MASK (0x00000002u)
#define CSL_SRIO_SP_CTL_PORT_LOCKOUT_SHIFT (0x00000001u)
#define CSL_SRIO_SP_CTL_PORT_LOCKOUT_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_PORT_TYPE_MASK   (0x00000001u)
#define CSL_SRIO_SP_CTL_PORT_TYPE_SHIFT  (0x00000000u)
#define CSL_SRIO_SP_CTL_PORT_TYPE_RESETVAL (0x00000001u)

#define CSL_SRIO_SP_CTL_RESETVAL         (0x40000001u)

/* ERR_RPT_BH */

#define CSL_SRIO_ERR_RPT_BH_EF_PTR_MASK  (0xFFFF0000u)
#define CSL_SRIO_ERR_RPT_BH_EF_PTR_SHIFT (0x00000010u)
#define CSL_SRIO_ERR_RPT_BH_EF_PTR_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_RPT_BH_EF_ID_MASK   (0x0000FFFFu)
#define CSL_SRIO_ERR_RPT_BH_EF_ID_SHIFT  (0x00000000u)
#define CSL_SRIO_ERR_RPT_BH_EF_ID_RESETVAL (0x00000007u)

#define CSL_SRIO_ERR_RPT_BH_RESETVAL     (0x00000007u)

/* ERR_DET */

#define CSL_SRIO_ERR_DET_IO_ERR_RSPNS_MASK (0x80000000u)
#define CSL_SRIO_ERR_DET_IO_ERR_RSPNS_SHIFT (0x0000001Fu)
#define CSL_SRIO_ERR_DET_IO_ERR_RSPNS_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_MSG_ERR_RSPNS_MASK (0x40000000u)
#define CSL_SRIO_ERR_DET_MSG_ERR_RSPNS_SHIFT (0x0000001Eu)
#define CSL_SRIO_ERR_DET_MSG_ERR_RSPNS_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_GSM_ERR_RSPNS_MASK (0x20000000u)
#define CSL_SRIO_ERR_DET_GSM_ERR_RSPNS_SHIFT (0x0000001Du)
#define CSL_SRIO_ERR_DET_GSM_ERR_RSPNS_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_ERR_MSG_FORMAT_MASK (0x10000000u)
#define CSL_SRIO_ERR_DET_ERR_MSG_FORMAT_SHIFT (0x0000001Cu)
#define CSL_SRIO_ERR_DET_ERR_MSG_FORMAT_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_ILL_TRANS_DECODE_MASK (0x08000000u)
#define CSL_SRIO_ERR_DET_ILL_TRANS_DECODE_SHIFT (0x0000001Bu)
#define CSL_SRIO_ERR_DET_ILL_TRANS_DECODE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_ILL_TRANS_TRGT_ERR_MASK (0x04000000u)
#define CSL_SRIO_ERR_DET_ILL_TRANS_TRGT_ERR_SHIFT (0x0000001Au)
#define CSL_SRIO_ERR_DET_ILL_TRANS_TRGT_ERR_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_MSG_REQ_TIMEOUT_MASK (0x02000000u)
#define CSL_SRIO_ERR_DET_MSG_REQ_TIMEOUT_SHIFT (0x00000019u)
#define CSL_SRIO_ERR_DET_MSG_REQ_TIMEOUT_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_PKT_RSPNS_TIMEOUT_MASK (0x01000000u)
#define CSL_SRIO_ERR_DET_PKT_RSPNS_TIMEOUT_SHIFT (0x00000018u)
#define CSL_SRIO_ERR_DET_PKT_RSPNS_TIMEOUT_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_UNSOLICITED_RSPNS_MASK (0x00800000u)
#define CSL_SRIO_ERR_DET_UNSOLICITED_RSPNS_SHIFT (0x00000017u)
#define CSL_SRIO_ERR_DET_UNSOLICITED_RSPNS_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_UNSUPPORTED_TRANS_MASK (0x00400000u)
#define CSL_SRIO_ERR_DET_UNSUPPORTED_TRANS_SHIFT (0x00000016u)
#define CSL_SRIO_ERR_DET_UNSUPPORTED_TRANS_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_RX_CPPI_SECURITY_MASK (0x00000080u)
#define CSL_SRIO_ERR_DET_RX_CPPI_SECURITY_SHIFT (0x00000007u)
#define CSL_SRIO_ERR_DET_RX_CPPI_SECURITY_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_RX_IO_DMA_ACCESS_MASK (0x00000040u)
#define CSL_SRIO_ERR_DET_RX_IO_DMA_ACCESS_SHIFT (0x00000006u)
#define CSL_SRIO_ERR_DET_RX_IO_DMA_ACCESS_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_DET_RESETVAL        (0x00000000u)

/* ERR_EN */

#define CSL_SRIO_ERR_EN_IO_ERR_RESP_ENABLE_MASK (0x80000000u)
#define CSL_SRIO_ERR_EN_IO_ERR_RESP_ENABLE_SHIFT (0x0000001Fu)
#define CSL_SRIO_ERR_EN_IO_ERR_RESP_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_MSG_ERR_RESP_ENABLE_MASK (0x40000000u)
#define CSL_SRIO_ERR_EN_MSG_ERR_RESP_ENABLE_SHIFT (0x0000001Eu)
#define CSL_SRIO_ERR_EN_MSG_ERR_RESP_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_GSM_ERR_RESP_ENABLE_MASK (0x20000000u)
#define CSL_SRIO_ERR_EN_GSM_ERR_RESP_ENABLE_SHIFT (0x0000001Du)
#define CSL_SRIO_ERR_EN_GSM_ERR_RESP_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_ERR_MSG_FORMAT_ENABLE_MASK (0x10000000u)
#define CSL_SRIO_ERR_EN_ERR_MSG_FORMAT_ENABLE_SHIFT (0x0000001Cu)
#define CSL_SRIO_ERR_EN_ERR_MSG_FORMAT_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_ILL_TRANS_DECODE_ENABLE_MASK (0x08000000u)
#define CSL_SRIO_ERR_EN_ILL_TRANS_DECODE_ENABLE_SHIFT (0x0000001Bu)
#define CSL_SRIO_ERR_EN_ILL_TRANS_DECODE_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_ILL_TRANS_TARGET_ERR_ENABLE_MASK (0x04000000u)
#define CSL_SRIO_ERR_EN_ILL_TRANS_TARGET_ERR_ENABLE_SHIFT (0x0000001Au)
#define CSL_SRIO_ERR_EN_ILL_TRANS_TARGET_ERR_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_MSG_REQ_TIMEOUT_ENABLE_MASK (0x02000000u)
#define CSL_SRIO_ERR_EN_MSG_REQ_TIMEOUT_ENABLE_SHIFT (0x00000019u)
#define CSL_SRIO_ERR_EN_MSG_REQ_TIMEOUT_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_PKT_RESP_TIMEOUT_ENABLE_MASK (0x01000000u)
#define CSL_SRIO_ERR_EN_PKT_RESP_TIMEOUT_ENABLE_SHIFT (0x00000018u)
#define CSL_SRIO_ERR_EN_PKT_RESP_TIMEOUT_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_UNSOLICITED_RESP_ENABLE_MASK (0x00800000u)
#define CSL_SRIO_ERR_EN_UNSOLICITED_RESP_ENABLE_SHIFT (0x00000017u)
#define CSL_SRIO_ERR_EN_UNSOLICITED_RESP_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_UNSUPPORTED_TRANS_ENABLE_MASK (0x00400000u)
#define CSL_SRIO_ERR_EN_UNSUPPORTED_TRANS_ENABLE_SHIFT (0x00000016u)
#define CSL_SRIO_ERR_EN_UNSUPPORTED_TRANS_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_RX_CPPI_SECURITY_MASK (0x00000080u)
#define CSL_SRIO_ERR_EN_RX_CPPI_SECURITY_SHIFT (0x00000007u)
#define CSL_SRIO_ERR_EN_RX_CPPI_SECURITY_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_RX_IO_SECURITY_MASK (0x00000040u)
#define CSL_SRIO_ERR_EN_RX_IO_SECURITY_SHIFT (0x00000006u)
#define CSL_SRIO_ERR_EN_RX_IO_SECURITY_RESETVAL (0x00000000u)

#define CSL_SRIO_ERR_EN_RESETVAL         (0x00000000u)

/* H_ADDR_CAPT */

#define CSL_SRIO_H_ADDR_CAPT_ADDRESS_63_32_MASK (0xFFFFFFFFu)
#define CSL_SRIO_H_ADDR_CAPT_ADDRESS_63_32_SHIFT (0x00000000u)
#define CSL_SRIO_H_ADDR_CAPT_ADDRESS_63_32_RESETVAL (0x00000000u)

#define CSL_SRIO_H_ADDR_CAPT_RESETVAL    (0x00000000u)

/* ADDR_CAPT */

#define CSL_SRIO_ADDR_CAPT_ADDRESS_31_3_MASK (0xFFFFFFF8u)
#define CSL_SRIO_ADDR_CAPT_ADDRESS_31_3_SHIFT (0x00000003u)
#define CSL_SRIO_ADDR_CAPT_ADDRESS_31_3_RESETVAL (0x00000000u)

#define CSL_SRIO_ADDR_CAPT_XAMSBS_MASK   (0x00000003u)
#define CSL_SRIO_ADDR_CAPT_XAMSBS_SHIFT  (0x00000000u)
#define CSL_SRIO_ADDR_CAPT_XAMSBS_RESETVAL (0x00000000u)

#define CSL_SRIO_ADDR_CAPT_RESETVAL      (0x00000000u)

/* ID_CAPT */

#define CSL_SRIO_ID_CAPT_MSB_DESTID_MASK (0xFF000000u)
#define CSL_SRIO_ID_CAPT_MSB_DESTID_SHIFT (0x00000018u)
#define CSL_SRIO_ID_CAPT_MSB_DESTID_RESETVAL (0x00000000u)

#define CSL_SRIO_ID_CAPT_DESTID_MASK     (0x00FF0000u)
#define CSL_SRIO_ID_CAPT_DESTID_SHIFT    (0x00000010u)
#define CSL_SRIO_ID_CAPT_DESTID_RESETVAL (0x00000000u)

#define CSL_SRIO_ID_CAPT_MSB_SOURCEID_MASK (0x0000FF00u)
#define CSL_SRIO_ID_CAPT_MSB_SOURCEID_SHIFT (0x00000008u)
#define CSL_SRIO_ID_CAPT_MSB_SOURCEID_RESETVAL (0x00000000u)

#define CSL_SRIO_ID_CAPT_SOURCEID_MASK   (0x000000FFu)
#define CSL_SRIO_ID_CAPT_SOURCEID_SHIFT  (0x00000000u)
#define CSL_SRIO_ID_CAPT_SOURCEID_RESETVAL (0x00000000u)

#define CSL_SRIO_ID_CAPT_RESETVAL        (0x00000000u)

/* CTRL_CAPT */

#define CSL_SRIO_CTRL_CAPT_FTYPE_MASK    (0xF0000000u)
#define CSL_SRIO_CTRL_CAPT_FTYPE_SHIFT   (0x0000001Cu)
#define CSL_SRIO_CTRL_CAPT_FTYPE_RESETVAL (0x00000000u)

#define CSL_SRIO_CTRL_CAPT_TTYPE_MASK    (0x0F000000u)
#define CSL_SRIO_CTRL_CAPT_TTYPE_SHIFT   (0x00000018u)
#define CSL_SRIO_CTRL_CAPT_TTYPE_RESETVAL (0x00000000u)

#define CSL_SRIO_CTRL_CAPT_MSGINFO_MASK  (0x00FF0000u)
#define CSL_SRIO_CTRL_CAPT_MSGINFO_SHIFT (0x00000010u)
#define CSL_SRIO_CTRL_CAPT_MSGINFO_RESETVAL (0x00000000u)

#define CSL_SRIO_CTRL_CAPT_IMP_SPECIFIC_MASK (0x0000FFFFu)
#define CSL_SRIO_CTRL_CAPT_IMP_SPECIFIC_SHIFT (0x00000000u)
#define CSL_SRIO_CTRL_CAPT_IMP_SPECIFIC_RESETVAL (0x00000000u)

#define CSL_SRIO_CTRL_CAPT_RESETVAL      (0x00000000u)

/* PW_TGT_ID */

#define CSL_SRIO_PW_TGT_ID_DEVICEID_MSB_MASK (0xFF000000u)
#define CSL_SRIO_PW_TGT_ID_DEVICEID_MSB_SHIFT (0x00000018u)
#define CSL_SRIO_PW_TGT_ID_DEVICEID_MSB_RESETVAL (0x00000000u)

#define CSL_SRIO_PW_TGT_ID_DEVICEID_MASK (0x00FF0000u)
#define CSL_SRIO_PW_TGT_ID_DEVICEID_SHIFT (0x00000010u)
#define CSL_SRIO_PW_TGT_ID_DEVICEID_RESETVAL (0x00000000u)

#define CSL_SRIO_PW_TGT_ID_RESETVAL      (0x00000000u)

/* SP_ERR_DET */

#define CSL_SRIO_SP_ERR_DET_ERR_IMP_SPECIFIC_MASK (0x80000000u)
#define CSL_SRIO_SP_ERR_DET_ERR_IMP_SPECIFIC_SHIFT (0x0000001Fu)
#define CSL_SRIO_SP_ERR_DET_ERR_IMP_SPECIFIC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_CORRUPT_CNTL_SYM_MASK (0x00400000u)
#define CSL_SRIO_SP_ERR_DET_CORRUPT_CNTL_SYM_SHIFT (0x00000016u)
#define CSL_SRIO_SP_ERR_DET_CORRUPT_CNTL_SYM_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_CNTL_SYM_UNEXPECTED_ACKID_MASK (0x00200000u)
#define CSL_SRIO_SP_ERR_DET_CNTL_SYM_UNEXPECTED_ACKID_SHIFT (0x00000015u)
#define CSL_SRIO_SP_ERR_DET_CNTL_SYM_UNEXPECTED_ACKID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_NOT_ACCPT_MASK (0x00100000u)
#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_NOT_ACCPT_SHIFT (0x00000014u)
#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_NOT_ACCPT_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_PKT_UNEXPECTED_ACKID_MASK (0x00080000u)
#define CSL_SRIO_SP_ERR_DET_PKT_UNEXPECTED_ACKID_SHIFT (0x00000013u)
#define CSL_SRIO_SP_ERR_DET_PKT_UNEXPECTED_ACKID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_WITH_BAD_CRC_MASK (0x00040000u)
#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_WITH_BAD_CRC_SHIFT (0x00000012u)
#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_WITH_BAD_CRC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_OVER_276B_MASK (0x00020000u)
#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_OVER_276B_SHIFT (0x00000011u)
#define CSL_SRIO_SP_ERR_DET_RCVD_PKT_OVER_276B_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_NON_OUTSTANDING_ACKID_MASK (0x00000020u)
#define CSL_SRIO_SP_ERR_DET_NON_OUTSTANDING_ACKID_SHIFT (0x00000005u)
#define CSL_SRIO_SP_ERR_DET_NON_OUTSTANDING_ACKID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_PROTOCOL_ERROR_MASK (0x00000010u)
#define CSL_SRIO_SP_ERR_DET_PROTOCOL_ERROR_SHIFT (0x00000004u)
#define CSL_SRIO_SP_ERR_DET_PROTOCOL_ERROR_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_DELINEATION_ERROR_MASK (0x00000004u)
#define CSL_SRIO_SP_ERR_DET_DELINEATION_ERROR_SHIFT (0x00000002u)
#define CSL_SRIO_SP_ERR_DET_DELINEATION_ERROR_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_UNSOLICITED_ACK_CNTL_SYM_MASK (0x00000002u)
#define CSL_SRIO_SP_ERR_DET_UNSOLICITED_ACK_CNTL_SYM_SHIFT (0x00000001u)
#define CSL_SRIO_SP_ERR_DET_UNSOLICITED_ACK_CNTL_SYM_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_LINK_TIMEOUT_MASK (0x00000001u)
#define CSL_SRIO_SP_ERR_DET_LINK_TIMEOUT_SHIFT (0x00000000u)
#define CSL_SRIO_SP_ERR_DET_LINK_TIMEOUT_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_DET_RESETVAL     (0x00000000u)

/* SP_RATE_EN */

#define CSL_SRIO_SP_RATE_EN_EN_IMP_SPECIFIC_MASK (0x80000000u)
#define CSL_SRIO_SP_RATE_EN_EN_IMP_SPECIFIC_SHIFT (0x0000001Fu)
#define CSL_SRIO_SP_RATE_EN_EN_IMP_SPECIFIC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_CORRUPT_CNTL_SYM_ENABLE_MASK (0x00400000u)
#define CSL_SRIO_SP_RATE_EN_CORRUPT_CNTL_SYM_ENABLE_SHIFT (0x00000016u)
#define CSL_SRIO_SP_RATE_EN_CORRUPT_CNTL_SYM_ENABLE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_CNTL_SYM_UNEXPECTED_ACKID_EN_MASK (0x00200000u)
#define CSL_SRIO_SP_RATE_EN_CNTL_SYM_UNEXPECTED_ACKID_EN_SHIFT (0x00000015u)
#define CSL_SRIO_SP_RATE_EN_CNTL_SYM_UNEXPECTED_ACKID_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_NOT_ACCPT_EN_MASK (0x00100000u)
#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_NOT_ACCPT_EN_SHIFT (0x00000014u)
#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_NOT_ACCPT_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_PKT_UNEXPECTED_ACKID_EN_MASK (0x00080000u)
#define CSL_SRIO_SP_RATE_EN_PKT_UNEXPECTED_ACKID_EN_SHIFT (0x00000013u)
#define CSL_SRIO_SP_RATE_EN_PKT_UNEXPECTED_ACKID_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_WITH_BAD_CRC_EN_MASK (0x00040000u)
#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_WITH_BAD_CRC_EN_SHIFT (0x00000012u)
#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_WITH_BAD_CRC_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_OVER_276B_EN_MASK (0x00020000u)
#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_OVER_276B_EN_SHIFT (0x00000011u)
#define CSL_SRIO_SP_RATE_EN_RCVED_PKT_OVER_276B_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_NON_OUTSTANDING_ACKID_EN_MASK (0x00000020u)
#define CSL_SRIO_SP_RATE_EN_NON_OUTSTANDING_ACKID_EN_SHIFT (0x00000005u)
#define CSL_SRIO_SP_RATE_EN_NON_OUTSTANDING_ACKID_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_PROTOCOL_ERROR_EN_MASK (0x00000010u)
#define CSL_SRIO_SP_RATE_EN_PROTOCOL_ERROR_EN_SHIFT (0x00000004u)
#define CSL_SRIO_SP_RATE_EN_PROTOCOL_ERROR_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_DELINEATION_ERROR_EN_MASK (0x00000004u)
#define CSL_SRIO_SP_RATE_EN_DELINEATION_ERROR_EN_SHIFT (0x00000002u)
#define CSL_SRIO_SP_RATE_EN_DELINEATION_ERROR_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_UNSOLICITED_ACK_CNTL_SYM_EN_MASK (0x00000002u)
#define CSL_SRIO_SP_RATE_EN_UNSOLICITED_ACK_CNTL_SYM_EN_SHIFT (0x00000001u)
#define CSL_SRIO_SP_RATE_EN_UNSOLICITED_ACK_CNTL_SYM_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_LINK_TIMEOUT_EN_MASK (0x00000001u)
#define CSL_SRIO_SP_RATE_EN_LINK_TIMEOUT_EN_SHIFT (0x00000000u)
#define CSL_SRIO_SP_RATE_EN_LINK_TIMEOUT_EN_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RATE_EN_RESETVAL     (0x00000000u)

/* SP_ERR_ATTR_CAPT_DBG0 */

#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_INFO_TYPE_MASK (0xC0000000u)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_INFO_TYPE_SHIFT (0x0000001Eu)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_INFO_TYPE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_ERROR_TYPE_MASK (0x1F000000u)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_ERROR_TYPE_SHIFT (0x00000018u)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_ERROR_TYPE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_IMP_SPECIFIC_MASK (0x00FFFFF0u)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_IMP_SPECIFIC_SHIFT (0x00000004u)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_IMP_SPECIFIC_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_CAPTURE_VALID_INFO_MASK (0x00000001u)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_CAPTURE_VALID_INFO_SHIFT (0x00000000u)
#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_CAPTURE_VALID_INFO_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_ATTR_CAPT_DBG0_RESETVAL (0x00000000u)

/* SP_ERR_CAPT_DBG */

#define CSL_SRIO_SP_ERR_CAPT_DBG_CAPTURE_MASK (0xFFFFFFFFu)
#define CSL_SRIO_SP_ERR_CAPT_DBG_CAPTURE_SHIFT (0x00000000u)
#define CSL_SRIO_SP_ERR_CAPT_DBG_CAPTURE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_CAPT_DBG_RESETVAL (0x00000000u)

/* SP_ERR_RATE */

#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_BIAS_MASK (0xFF000000u)
#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_BIAS_SHIFT (0x00000018u)
#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_BIAS_RESETVAL (0x000000FFu)

#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_RECOVERY_MASK (0x00030000u)
#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_RECOVERY_SHIFT (0x00000010u)
#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_RECOVERY_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_RATE_PEAK_ERROR_RATE_MASK (0x0000FF00u)
#define CSL_SRIO_SP_ERR_RATE_PEAK_ERROR_RATE_SHIFT (0x00000008u)
#define CSL_SRIO_SP_ERR_RATE_PEAK_ERROR_RATE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_COUNTER_MASK (0x000000FFu)
#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_COUNTER_SHIFT (0x00000000u)
#define CSL_SRIO_SP_ERR_RATE_ERROR_RATE_COUNTER_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_ERR_RATE_RESETVAL    (0xFF000000u)

/* SP_ERR_THRESH */

#define CSL_SRIO_SP_ERR_THRESH_ERROR_RATE_FAILED_THRESHOLD_MASK (0xFF000000u)
#define CSL_SRIO_SP_ERR_THRESH_ERROR_RATE_FAILED_THRESHOLD_SHIFT (0x00000018u)
#define CSL_SRIO_SP_ERR_THRESH_ERROR_RATE_FAILED_THRESHOLD_RESETVAL (0x000000FFu)

#define CSL_SRIO_SP_ERR_THRESH_ERROR_RATE_DEGRADED_THRES_MASK (0x00FF0000u)
#define CSL_SRIO_SP_ERR_THRESH_ERROR_RATE_DEGRADED_THRES_SHIFT (0x00000010u)
#define CSL_SRIO_SP_ERR_THRESH_ERROR_RATE_DEGRADED_THRES_RESETVAL (0x000000FFu)

#define CSL_SRIO_SP_ERR_THRESH_RESETVAL  (0xFFFF0000u)

/* SP_IP_DISCOVERY_TIMER */

#define CSL_SRIO_SP_IP_DISCOVERY_TIMER_DISCOVERY_TIMER_MASK (0xF0000000u)
#define CSL_SRIO_SP_IP_DISCOVERY_TIMER_DISCOVERY_TIMER_SHIFT (0x0000001Cu)
#define CSL_SRIO_SP_IP_DISCOVERY_TIMER_DISCOVERY_TIMER_RESETVAL (0x00000009u)

#define CSL_SRIO_SP_IP_DISCOVERY_TIMER_PW_TIMER_MASK (0x00F00000u)
#define CSL_SRIO_SP_IP_DISCOVERY_TIMER_PW_TIMER_SHIFT (0x00000014u)
#define CSL_SRIO_SP_IP_DISCOVERY_TIMER_PW_TIMER_RESETVAL (0x00000008u)

#define CSL_SRIO_SP_IP_DISCOVERY_TIMER_RESETVAL (0x90800000u)

/* SP_IP_MODE */

#define CSL_SRIO_SP_IP_MODE_SP_MODE_MASK (0xC0000000u)
#define CSL_SRIO_SP_IP_MODE_SP_MODE_SHIFT (0x0000001Eu)
#define CSL_SRIO_SP_IP_MODE_SP_MODE_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_IP_MODE_IDLE_ERR_DIS_MASK (0x20000000u)
#define CSL_SRIO_SP_IP_MODE_IDLE_ERR_DIS_SHIFT (0x0000001Du)
#define CSL_SRIO_SP_IP_MODE_IDLE_ERR_DIS_RESETVAL (0x00000000u)

/*----IDLE_ERR_DIS Tokens----*/
#define CSL_SRIO_SP_IP_MODE_IDLE_ERR_DIS_DISABLE (0x00000001u)
#define CSL_SRIO_SP_IP_MODE_IDLE_ERR_DIS_ENABLE (0x00000000u)

#define CSL_SRIO_SP_IP_MODE_TX_FIFO_BYPASS_MASK (0x10000000u)
#define CSL_SRIO_SP_IP_MODE_TX_FIFO_BYPASS_SHIFT (0x0000001Cu)
#define CSL_SRIO_SP_IP_MODE_TX_FIFO_BYPASS_RESETVAL (0x00000000u)

/*----TX_FIFO_BYPASS Tokens----*/
#define CSL_SRIO_SP_IP_MODE_TX_FIFO_BYPASS_DISABLE (0x00000000u)
#define CSL_SRIO_SP_IP_MODE_TX_FIFO_BYPASS_ENABLE (0x00000001u)

#define CSL_SRIO_SP_IP_MODE_PW_DIS_MASK  (0x08000000u)
#define CSL_SRIO_SP_IP_MODE_PW_DIS_SHIFT (0x0000001Bu)
#define CSL_SRIO_SP_IP_MODE_PW_DIS_RESETVAL (0x00000000u)

/*----PW_DIS Tokens----*/
#define CSL_SRIO_SP_IP_MODE_PW_DIS_DISABLE (0x00000001u)
#define CSL_SRIO_SP_IP_MODE_PW_DIS_ENABLE (0x00000000u)

#define CSL_SRIO_SP_IP_MODE_TGT_ID_DIS_MASK (0x04000000u)
#define CSL_SRIO_SP_IP_MODE_TGT_ID_DIS_SHIFT (0x0000001Au)
#define CSL_SRIO_SP_IP_MODE_TGT_ID_DIS_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_IP_MODE_SELF_RST_MASK (0x02000000u)
#define CSL_SRIO_SP_IP_MODE_SELF_RST_SHIFT (0x00000019u)
#define CSL_SRIO_SP_IP_MODE_SELF_RST_RESETVAL (0x00000000u)

/*----SELF_RST Tokens----*/
#define CSL_SRIO_SP_IP_MODE_SELF_RST_DISABLE (0x00000000u)
#define CSL_SRIO_SP_IP_MODE_SELF_RST_ENABLE (0x00000001u)

#define CSL_SRIO_SP_IP_MODE_MLTC_EN_MASK (0x00000020u)
#define CSL_SRIO_SP_IP_MODE_MLTC_EN_SHIFT (0x00000005u)
#define CSL_SRIO_SP_IP_MODE_MLTC_EN_RESETVAL (0x00000000u)

/*----MLTC_EN Tokens----*/
#define CSL_SRIO_SP_IP_MODE_MLTC_EN_DISABLE (0x00000000u)
#define CSL_SRIO_SP_IP_MODE_MLTC_EN_ENABLE (0x00000001u)

#define CSL_SRIO_SP_IP_MODE_MLTC_IRQ_MASK (0x00000010u)
#define CSL_SRIO_SP_IP_MODE_MLTC_IRQ_SHIFT (0x00000004u)
#define CSL_SRIO_SP_IP_MODE_MLTC_IRQ_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_IP_MODE_RST_EN_MASK  (0x00000008u)
#define CSL_SRIO_SP_IP_MODE_RST_EN_SHIFT (0x00000003u)
#define CSL_SRIO_SP_IP_MODE_RST_EN_RESETVAL (0x00000000u)

/*----RST_EN Tokens----*/
#define CSL_SRIO_SP_IP_MODE_RST_EN_DISABLE (0x00000000u)
#define CSL_SRIO_SP_IP_MODE_RST_EN_ENABLE (0x00000001u)

#define CSL_SRIO_SP_IP_MODE_RST_CS_MASK  (0x00000004u)
#define CSL_SRIO_SP_IP_MODE_RST_CS_SHIFT (0x00000002u)
#define CSL_SRIO_SP_IP_MODE_RST_CS_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_IP_MODE_PW_EN_MASK   (0x00000002u)
#define CSL_SRIO_SP_IP_MODE_PW_EN_SHIFT  (0x00000001u)
#define CSL_SRIO_SP_IP_MODE_PW_EN_RESETVAL (0x00000000u)

/*----PW_EN Tokens----*/
#define CSL_SRIO_SP_IP_MODE_PW_EN_DISABLE (0x00000000u)
#define CSL_SRIO_SP_IP_MODE_PW_EN_ENABLE (0x00000001u)

#define CSL_SRIO_SP_IP_MODE_PW_IRQ_MASK  (0x00000001u)
#define CSL_SRIO_SP_IP_MODE_PW_IRQ_SHIFT (0x00000000u)
#define CSL_SRIO_SP_IP_MODE_PW_IRQ_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_IP_MODE_RESETVAL     (0x00000000u)

/* IP_PRESCAL */

#define CSL_SRIO_IP_PRESCAL_PRESCALE_MASK (0x000000FFu)
#define CSL_SRIO_IP_PRESCAL_PRESCALE_SHIFT (0x00000000u)
#define CSL_SRIO_IP_PRESCAL_PRESCALE_RESETVAL (0x0000000Fu)

#define CSL_SRIO_IP_PRESCAL_RESETVAL     (0x0000000Fu)

/* SP_IP_PW_IN_CAPT */

#define CSL_SRIO_SP_IP_PW_IN_CAPT_PW_CAPT_MASK (0xFFFFFFFFu)
#define CSL_SRIO_SP_IP_PW_IN_CAPT_PW_CAPT_SHIFT (0x00000000u)
#define CSL_SRIO_SP_IP_PW_IN_CAPT_PW_CAPT_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_IP_PW_IN_CAPT_RESETVAL (0x00000000u)

/* SP_RST_OPT */

#define CSL_SRIO_SP_RST_OPT_PORT_ID_MASK (0x000000FFu)
#define CSL_SRIO_SP_RST_OPT_PORT_ID_SHIFT (0x00000000u)
#define CSL_SRIO_SP_RST_OPT_PORT_ID_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_RST_OPT_RESETVAL     (0x00000000u)

/* SP_CTL_INDEP */

#define CSL_SRIO_SP_CTL_INDEP_TX_FLW_MASK (0x40000000u)
#define CSL_SRIO_SP_CTL_INDEP_TX_FLW_SHIFT (0x0000001Eu)
#define CSL_SRIO_SP_CTL_INDEP_TX_FLW_RESETVAL (0x00000000u)

/*----TX_FLW Tokens----*/
#define CSL_SRIO_SP_CTL_INDEP_TX_FLW_DISABLE (0x00000000u)
#define CSL_SRIO_SP_CTL_INDEP_TX_FLW_ENABLE (0x00000001u)

#define CSL_SRIO_SP_CTL_INDEP_SOFT_REC_MASK (0x20000000u)
#define CSL_SRIO_SP_CTL_INDEP_SOFT_REC_SHIFT (0x0000001Du)
#define CSL_SRIO_SP_CTL_INDEP_SOFT_REC_RESETVAL (0x00000000u)

/*----SOFT_REC Tokens----*/
#define CSL_SRIO_SP_CTL_INDEP_SOFT_REC_BYHARDWARE (0x00000000u)
#define CSL_SRIO_SP_CTL_INDEP_SOFT_REC_BYSOFTWARE (0x00000001u)

#define CSL_SRIO_SP_CTL_INDEP_FORCE_REINIT_MASK (0x04000000u)
#define CSL_SRIO_SP_CTL_INDEP_FORCE_REINIT_SHIFT (0x0000001Au)
#define CSL_SRIO_SP_CTL_INDEP_FORCE_REINIT_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_TRANS_MODE_MASK (0x03000000u)
#define CSL_SRIO_SP_CTL_INDEP_TRANS_MODE_SHIFT (0x00000018u)
#define CSL_SRIO_SP_CTL_INDEP_TRANS_MODE_RESETVAL (0x00000001u)

#define CSL_SRIO_SP_CTL_INDEP_DEBUG_MASK (0x00800000u)
#define CSL_SRIO_SP_CTL_INDEP_DEBUG_SHIFT (0x00000017u)
#define CSL_SRIO_SP_CTL_INDEP_DEBUG_RESETVAL (0x00000000u)

/*----DEBUG Tokens----*/
#define CSL_SRIO_SP_CTL_INDEP_DEBUG_NORMAL (0x00000000u)
#define CSL_SRIO_SP_CTL_INDEP_DEBUG_DEBUG (0x00000001u)

#define CSL_SRIO_SP_CTL_INDEP_SEND_DBG_PKT_MASK (0x00400000u)
#define CSL_SRIO_SP_CTL_INDEP_SEND_DBG_PKT_SHIFT (0x00000016u)
#define CSL_SRIO_SP_CTL_INDEP_SEND_DBG_PKT_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_EN_MASK (0x00200000u)
#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_EN_SHIFT (0x00000015u)
#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_EN_RESETVAL (0x00000000u)

/*----ILL_TRANS_EN Tokens----*/
#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_EN_DISABLE (0x00000000u)
#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_EN_ENABLE (0x00000001u)

#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_ERR_MASK (0x00100000u)
#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_ERR_SHIFT (0x00000014u)
#define CSL_SRIO_SP_CTL_INDEP_ILL_TRANS_ERR_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_EN_MASK (0x00020000u)
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_EN_SHIFT (0x00000011u)
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_EN_RESETVAL (0x00000000u)

/*----MAX_RETRY_EN Tokens----*/
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_EN_ENABLE (0x00000001u)
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_EN_DISABLE (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_ERR_MASK (0x00010000u)
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_ERR_SHIFT (0x00000010u)
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_ERR_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_THR_MASK (0x0000FF00u)
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_THR_SHIFT (0x00000008u)
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_THR_RESETVAL (0x00000000u)

/*----MAX_RETRY_THR Tokens----*/
#define CSL_SRIO_SP_CTL_INDEP_MAX_RETRY_THR_DISABLE (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_IRQ_EN_MASK (0x00000080u)
#define CSL_SRIO_SP_CTL_INDEP_IRQ_EN_SHIFT (0x00000007u)
#define CSL_SRIO_SP_CTL_INDEP_IRQ_EN_RESETVAL (0x00000000u)

/*----IRQ_EN Tokens----*/
#define CSL_SRIO_SP_CTL_INDEP_IRQ_EN_ENABLE (0x00000001u)
#define CSL_SRIO_SP_CTL_INDEP_IRQ_EN_DISABLE (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_IRQ_ERR_MASK (0x00000040u)
#define CSL_SRIO_SP_CTL_INDEP_IRQ_ERR_SHIFT (0x00000006u)
#define CSL_SRIO_SP_CTL_INDEP_IRQ_ERR_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CTL_INDEP_RESETVAL   (0x01000000u)

/* SP_SILENCE_TIMER */

#define CSL_SRIO_SP_SILENCE_TIMER_SILENCE_TIMER_MASK (0xF0000000u)
#define CSL_SRIO_SP_SILENCE_TIMER_SILENCE_TIMER_SHIFT (0x0000001Cu)
#define CSL_SRIO_SP_SILENCE_TIMER_SILENCE_TIMER_RESETVAL (0x0000000Bu)

#define CSL_SRIO_SP_SILENCE_TIMER_RESETVAL (0xB0000000u)

/* SP_MULT_EVNT_CS */

#define CSL_SRIO_SP_MULT_EVNT_CS_MULT_EVNT_CS_MASK (0xFFFFFFFFu)
#define CSL_SRIO_SP_MULT_EVNT_CS_MULT_EVNT_CS_SHIFT (0x00000000u)
#define CSL_SRIO_SP_MULT_EVNT_CS_MULT_EVNT_CS_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_MULT_EVNT_CS_RESETVAL (0x00000000u)

/* SP_CS_TX */

#define CSL_SRIO_SP_CS_TX_STYPE_0_MASK   (0xE0000000u)
#define CSL_SRIO_SP_CS_TX_STYPE_0_SHIFT  (0x0000001Du)
#define CSL_SRIO_SP_CS_TX_STYPE_0_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CS_TX_PAR_0_MASK     (0x1F000000u)
#define CSL_SRIO_SP_CS_TX_PAR_0_SHIFT    (0x00000018u)
#define CSL_SRIO_SP_CS_TX_PAR_0_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CS_TX_PAR_1_MASK     (0x00F80000u)
#define CSL_SRIO_SP_CS_TX_PAR_1_SHIFT    (0x00000013u)
#define CSL_SRIO_SP_CS_TX_PAR_1_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CS_TX_STYPE_1_MASK   (0x00070000u)
#define CSL_SRIO_SP_CS_TX_STYPE_1_SHIFT  (0x00000010u)
#define CSL_SRIO_SP_CS_TX_STYPE_1_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CS_TX_CMD_MASK       (0x0000E000u)
#define CSL_SRIO_SP_CS_TX_CMD_SHIFT      (0x0000000Du)
#define CSL_SRIO_SP_CS_TX_CMD_RESETVAL   (0x00000000u)

#define CSL_SRIO_SP_CS_TX_CS_EMB_MASK    (0x00001000u)
#define CSL_SRIO_SP_CS_TX_CS_EMB_SHIFT   (0x0000000Cu)
#define CSL_SRIO_SP_CS_TX_CS_EMB_RESETVAL (0x00000000u)

#define CSL_SRIO_SP_CS_TX_RESETVAL       (0x00000000u)


/**************************************************************************\
* Field Definition Macros for Tx Buffer Descriptor
\**************************************************************************/

/* TXBUFFDESC (for opt1) */

#define CSL_SRIO_TXBUFFDESC_DEST_ID_MASK     (0xFFFF0000u)
#define CSL_SRIO_TXBUFFDESC_DEST_ID_SHIFT    (0x00000010u)
#define CSL_SRIO_TXBUFFDESC_DEST_ID_RESETVAL (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_PRI_MASK        (0x0000C000u)
#define CSL_SRIO_TXBUFFDESC_PRI_SHIFT       (0x0000000Eu)
#define CSL_SRIO_TXBUFFDESC_PRI_RESETVAL    (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_TT_MASK         (0x00003000u)
#define CSL_SRIO_TXBUFFDESC_TT_SHIFT        (0x0000000Cu)
#define CSL_SRIO_TXBUFFDESC_TT_RESETVAL     (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_PORT_ID_MASK     (0x00000C00u)
#define CSL_SRIO_TXBUFFDESC_PORT_ID_SHIFT    (0x0000000Au)
#define CSL_SRIO_TXBUFFDESC_PORT_ID_RESETVAL (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_SSIZE_MASK      (0x000003C0u)
#define CSL_SRIO_TXBUFFDESC_SSIZE_SHIFT     (0x00000006u)
#define CSL_SRIO_TXBUFFDESC_SSIZE_RESETVAL  (0x00000000u)

/*----SSIZE Tokens----*/
#define CSL_SRIO_TXBUFFDESC_SSIZE_128B  (0x00000009u)
#define CSL_SRIO_TXBUFFDESC_SSIZE_256B  (0x0000000Au)
#define CSL_SRIO_TXBUFFDESC_SSIZE_512B  (0x0000000Bu)
#define CSL_SRIO_TXBUFFDESC_SSIZE_1024B (0x0000000Cu)
#define CSL_SRIO_TXBUFFDESC_SSIZE_2048B (0x0000000Du)
#define CSL_SRIO_TXBUFFDESC_SSIZE_4096B (0x0000000Eu)

#define CSL_SRIO_TXBUFFDESC_MAILBOX_MASK    (0x0000003Fu)
#define CSL_SRIO_TXBUFFDESC_MAILBOX_SHIFT   (0x00000000u)
#define CSL_SRIO_TXBUFFDESC_MAILBOX_RESETVAL (0x00000000u)

/* TXBUFFDESC (for opt2) */

#define CSL_SRIO_TXBUFFDESC_SOP_MASK        (0x80000000u)
#define CSL_SRIO_TXBUFFDESC_SOP_SHIFT       (0x0000001Fu)
#define CSL_SRIO_TXBUFFDESC_SOP_RESETVAL    (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_EOP_MASK        (0x40000000u)
#define CSL_SRIO_TXBUFFDESC_EOP_SHIFT       (0x0000001Eu)
#define CSL_SRIO_TXBUFFDESC_EOP_RESETVAL    (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_OWNERSHIP_MASK  (0x20000000u)
#define CSL_SRIO_TXBUFFDESC_OWNERSHIP_SHIFT (0x0000001Du)
#define CSL_SRIO_TXBUFFDESC_OWNERSHIP_RESETVAL (0x00000000u)

/*----OWNERSHIP Tokens----*/
#define CSL_SRIO_TXBUFFDESC_OWNERSHIP_HOST (0x00000000u)
#define CSL_SRIO_TXBUFFDESC_OWNERSHIP_PORT (0x00000001u)

#define CSL_SRIO_TXBUFFDESC_EOQ_MASK        (0x10000000u)
#define CSL_SRIO_TXBUFFDESC_EOQ_SHIFT       (0x0000001Cu)
#define CSL_SRIO_TXBUFFDESC_EOQ_RESETVAL    (0x00000000u)

/*----EOQ Tokens----*/
#define CSL_SRIO_TXBUFFDESC_EOQ_TRUE    (0x00000001u)
#define CSL_SRIO_TXBUFFDESC_EOQ_FALSE   (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_TEARDOWN_MASK   (0x08000000u)
#define CSL_SRIO_TXBUFFDESC_TEARDOWN_SHIFT  (0x0000001Bu)
#define CSL_SRIO_TXBUFFDESC_TEARDOWN_RESETVAL (0x00000000u)

/*----TEARDOWN Tokens----*/
#define CSL_SRIO_TXBUFFDESC_TEARDOWN_NOT_COMPLETE (0x00000000u)
#define CSL_SRIO_TXBUFFDESC_TEARDOWN_COMPLETE (0x00000001u)

#define CSL_SRIO_TXBUFFDESC_RESERVED_MASK   (0x07FC0000u)
#define CSL_SRIO_TXBUFFDESC_RESERVED_SHIFT  (0x00000012u)
#define CSL_SRIO_TXBUFFDESC_RESERVED_RESETVAL (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_RETRY_COUNT_MASK (0x0003F000u)
#define CSL_SRIO_TXBUFFDESC_RETRY_COUNT_SHIFT (0x0000000Cu)
#define CSL_SRIO_TXBUFFDESC_RETRY_COUNT_RESETVAL (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_CC_MASK         (0x00000E00u)
#define CSL_SRIO_TXBUFFDESC_CC_SHIFT        (0x00000009u)
#define CSL_SRIO_TXBUFFDESC_CC_RESETVAL     (0x00000000u)

#define CSL_SRIO_TXBUFFDESC_MESSAGE_LENGTH_MASK (0x000001FFu)
#define CSL_SRIO_TXBUFFDESC_MESSAGE_LENGTH_SHIFT (0x00000000u)
#define CSL_SRIO_TXBUFFDESC_MESSAGE_LENGTH_RESETVAL (0x00000000u)

/**************************************************************************\
* Field Definition Macros for Rx Buffer Descriptor
\**************************************************************************/

/* RXBUFFDESC (for opt1) */

#define CSL_SRIO_RXBUFFDESC_SRC_ID_MASK     (0xFFFF0000u)
#define CSL_SRIO_RXBUFFDESC_SRC_ID_SHIFT    (0x00000010u)
#define CSL_SRIO_RXBUFFDESC_SRC_ID_RESETVAL (0x00000000u)

#define CSL_SRIO_RXBUFFDESC_PRI_MASK        (0x0000C000u)
#define CSL_SRIO_RXBUFFDESC_PRI_SHIFT       (0x0000000Eu)
#define CSL_SRIO_RXBUFFDESC_PRI_RESETVAL    (0x00000000u)

#define CSL_SRIO_RXBUFFDESC_TT_MASK         (0x00003000u)
#define CSL_SRIO_RXBUFFDESC_TT_SHIFT        (0x0000000Cu)
#define CSL_SRIO_RXBUFFDESC_TT_RESETVAL     (0x00000000u)

#define CSL_SRIO_RXBUFFDESC_MAILBOX_MASK    (0x0000003Fu)
#define CSL_SRIO_RXBUFFDESC_MAILBOX_SHIFT   (0x00000000u)
#define CSL_SRIO_RXBUFFDESC_MAILBOX_RESETVAL (0x00000000u)

/* RXBUFFDESC (option 2) */

#define CSL_SRIO_RXBUFFDESC_SOP_MASK        (0x80000000u)
#define CSL_SRIO_RXBUFFDESC_SOP_SHIFT       (0x0000001Fu)
#define CSL_SRIO_RXBUFFDESC_SOP_RESETVAL    (0x00000000u)

#define CSL_SRIO_RXBUFFDESC_EOP_MASK        (0x40000000u)
#define CSL_SRIO_RXBUFFDESC_EOP_SHIFT       (0x0000001Eu)
#define CSL_SRIO_RXBUFFDESC_EOP_RESETVAL    (0x00000000u)

#define CSL_SRIO_RXBUFFDESC_OWNERSHIP_MASK  (0x20000000u)
#define CSL_SRIO_RXBUFFDESC_OWNERSHIP_SHIFT (0x0000001Du)
#define CSL_SRIO_RXBUFFDESC_OWNERSHIP_RESETVAL (0x00000000u)

/*----OWNERSHIP Tokens----*/
#define CSL_SRIO_RXBUFFDESC_OWNERSHIP_HOST (0x00000000u)
#define CSL_SRIO_RXBUFFDESC_OWNERSHIP_PORT (0x00000001u)


#define CSL_SRIO_RXBUFFDESC_EOQ_MASK        (0x10000000u)
#define CSL_SRIO_RXBUFFDESC_EOQ_SHIFT       (0x0000001Cu)
#define CSL_SRIO_RXBUFFDESC_EOQ_RESETVAL    (0x00000000u)

/*----EOQ Tokens----*/
#define CSL_SRIO_RXBUFFDESC_EOQ_TRUE    (0x00000001u)
#define CSL_SRIO_RXBUFFDESC_EOQ_FALSE   (0x00000000u)

#define CSL_SRIO_RXBUFFDESC_TEARDOWN_MASK   (0x08000000u)
#define CSL_SRIO_RXBUFFDESC_TEARDOWN_SHIFT  (0x0000001Bu)
#define CSL_SRIO_RXBUFFDESC_TEARDOWN_RESETVAL (0x00000000u)

/*----TEARDOWN Tokens----*/
#define CSL_SRIO_RXBUFFDESC_TEARDOWN_NOT_COMPLETE (0x00000000u)
#define CSL_SRIO_RXBUFFDESC_TEARDOWN_COMPLETE (0x00000001u)

#define CSL_SRIO_RXBUFFDESC_CC_MASK         (0x00000E00u)
#define CSL_SRIO_RXBUFFDESC_CC_SHIFT        (0x00000009u)
#define CSL_SRIO_RXBUFFDESC_CC_RESETVAL     (0x00000000u)

#define CSL_SRIO_RXBUFFDESC_MESSAGE_LENGTH_MASK (0x000001FFu)
#define CSL_SRIO_RXBUFFDESC_MESSAGE_LENGTH_SHIFT (0x00000000u)
#define CSL_SRIO_RXBUFFDESC_MESSAGE_LENGTH_RESETVAL (0x00000000u)


#endif
