------------------------------------------------------------------------------------
-- $Archive:: /VHDL/product/dsk6455/emu_mux/emu_mux.vhd                            $
-- $Revision:: 2                                                                   $
-- $Date:: 11/21/05 11:17a                                                         $
-- $Author:: Tonyc                                                                 $
--
--
-- Copyright (c) 2005, Spectrum Digital Incorporated
-- All rights reserved
------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
-- Start the real code                  
------------------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;

entity emu_mux is
  port
  (  

	  EMU_DETECTn				: in		std_logic;
		HURRICANE_DETECTn	: in		std_logic;
		DSPB_PRESENTn			: in		std_logic;
		HURRICANE_B_DETECT	: in		std_logic;

		
		HURRICANE_DETECT  : out   std_logic;
		
		USB_IN_USE				: out		std_logic;
	
		-- 14 Pin Header signals
		XDS_TDO						: out		std_logic;
		XDS_TDI						: in		std_logic;
		XDS_TMS						: in		std_logic;
		XDS_TRSTn					: in		std_logic;
		XDS_TCK						: in		std_logic;
		XDS_TCKRET				: out		std_logic;
		
		-- Embedded emulator signals
		T_TDO							: out		std_logic;
		T_TDI							: in		std_logic;
		T_TMS							: in		std_logic;
		T_TRSTn						: in		std_logic;
		T_TCK							: in		std_logic;
		T_TCKRET					: out		std_logic;
	
		-- DSPA JTAG Port
		DSPA_TCK					: out		std_logic;
		DSPA_TDO					: in		std_logic;
		DSPA_TDI					: out		std_logic;
		DSPA_TMS					: out		std_logic;
		DSPA_TSRTn				: out		std_logic;

		-- DSPB JTAG Port	
		DSPB_TCK					: out		std_logic;
		DSPB_TDO					: in		std_logic;
		DSPB_TDI					: out		std_logic;
		DSPB_TMS					: out		std_logic;
		DSPB_TSRTn				: out		std_logic
				
);
end emu_mux;

-----------------------------------------------------------------------------------
-- Include standard librariess
-----------------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
-- use work.std_arith.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

architecture behavior_emu_mux of emu_mux is      

-----------------------------------------------------------------------------------
-- Add local components in here  
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Add signals 
-----------------------------------------------------------------------------------
  signal  muxTDIA     : std_logic;
  signal  muxTDIB     : std_logic;
  signal  muxTDO      : std_logic;
	signal	muxTMS			: std_logic;
	signal	muxTCK			: std_logic;
	--signal	muxTCKRET		: std_logic;
  signal  muxTRSTn    : std_logic;
	signal  JtagBEnable : std_logic;

-----------------------------------------------------------------------------------
-- The implementation
-----------------------------------------------------------------------------------

begin 
-----------------------------------------------------------------------------------
-- Map the other components
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Now define the logic
-----------------------------------------------------------------------------------
    
    -- Enable JTAG to CPU_B when the board is present and neither of the Hurricane
    -- headers are in use.

    JtagBEnable <= '1' when     DSPB_PRESENTn      = '0' 
                            and HURRICANE_B_DETECT = '0'
                            and HURRICANE_DETECTn  = '1' else '0';
			
		muxTDIA   	<=	XDS_TDI   when 	EMU_DETECTn 	 = '0' else T_TDI;	
	  muxTDIB			<=  DSPA_TDO  when 	JtagBEnable    = '1' else '1';	
		muxTDO			<=	DSPB_TDO	when	JtagBEnable    = '1' else	DSPA_TDO;
	
	 	muxTMS			<= 	XDS_TMS		when 	EMU_DETECTn 	= '0' else T_TMS;	
		muxTCK			<= 	XDS_TCK		when 	EMU_DETECTn 	= '0' else T_TCK;		
  	muxTRSTn  	<= 	XDS_TRSTn	when 	EMU_DETECTn 	= '0' else T_TRSTn;  

		-- DSPA Port
 		DSPA_TCK		<= muxTCK 		when 	HURRICANE_DETECTn = '1' else 'Z';
		DSPA_TDI		<= muxTDIA 		when 	HURRICANE_DETECTn = '1' else 'Z';
		DSPA_TMS		<= muxTMS 		when 	HURRICANE_DETECTn = '1' else 'Z';
		DSPA_TSRTn	<= muxTRSTn 	when 	HURRICANE_DETECTn = '1' else 'Z';
		
		-- DSPB Port
		DSPB_TCK		<= muxTCK 		when 	JtagBEnable = '1' else 'Z';
		DSPB_TDI		<= muxTDIB 		when 	JtagBEnable = '1' else 'Z';
		DSPB_TMS		<= muxTMS 		when 	JtagBEnable = '1' else 'Z';
		DSPB_TSRTn	<= muxTRSTn 	when 	JtagBEnable = '1' else 'Z';
		
		-- XDS Port
		XDS_TCKRET	<= XDS_TCK		when	EMU_DETECTn	=	'0' else '0';
		XDS_TDO			<= muxTDO			when	EMU_DETECTn = '0' else '0';
 
		-- Embedded EMU Port
		T_TCKRET		<= T_TCK			when	EMU_DETECTn	=	'1' else '0';
		T_TDO				<= muxTDO			when	EMU_DETECTn = '1' else '0';

		USB_IN_USE	<= '0'				when	EMU_DETECTn	= '1' and HURRICANE_DETECTn = '1'
															else '1';

		HURRICANE_DETECT	<=  not HURRICANE_DETECTn;

end behavior_emu_mux;

