/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004 , 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */

/** ============================================================================
 *   @file  tcp2_extrinsics.c
 *
 *   @path  $(CSLPATH)\example\c6455\tcp2\tcp2_shared_mode\src
 *
 *   @desc  extrinsic reference data for the TCP2 shared mode
 *
 */
 
#include <tistdtypes.h>
Uint32 extrinsicData [] = {
0x6a7c110d,0x077c195a,
0x7a7e7f7b,0x79100705,
0x097e0009,0x07007d7f,
0x0601037b,0x10777407,
0x7c047b78,0x00000100,
0x7f057f09,0x72027303,
0x03077b00,0x02780877,
0x06790103,0x03077e7c,
0x09797a00,0x75070400,
0x7e04730b,0x04080177,
0x7505077e,0x7f077c7f,
0x7e010001,0x05780c04,
0x79747a0c,0x75057d05,
0x0a7a750a,0x017a0c0a,
0x11021b04,0x0c716d76,
0x18272063,0x0d1d1e73,
0x720d136d,0x73186121,
0x16116c72,0x6d6b1a69,
0x000f6d0f,0x776e0873,
0x7f7d7c7d,0x790b0c75,
0x027e0405,0x780b7c7e,
0x757c7e01,0x00047b7f,
0x75017971,0x097c7603,
0x0c070d77,0x7b087905,
0x060c0600,0x0576010e,
0x040c0506,0x04090907,
0x7f030500,0x7e027c03,
0x7412030a,0x00750104,
0x097d0601,0x797e7e02,
0x007b7f7b,0x03027b7f,
0x7d790306,0x7b7a0302,
0x06080401,0x0302077e,
0x7a0b037d,0x02040702,
0x07007c01,0x7e7f0305,
0x740f0f17,0x0c780276,
0x010f7d0f,0x7e7e087a,
0x72090000,0x07760573,
0x7e7c7d04,0x000a7b74,
0x0a770879,0x7a737778,
0x75747579,0x79687173,
0x7b0c0f0f,0x10020576,
0x07057973,0x7a7d7f70,
0x78777f14,0x7404710b,
0x7c7b7e0c,0x7f787f73,
0x7f79077f,0x027d0006,
0x7c0a7f04,0x047a7d04,
0x68776c1a,0x0e0f7271,
0x6a116b6e,0x1b16676a,
0x0a0f1010,0x720a1266,
0x72757478,0x6c7c7778,
0x7b7b787e,0x077b7777,
0x0e787e7e,0x7b06027e,
0x100d7a01,0x0a71087f,
0x1a226a6f,0x12677704,
0x580e141e,0x5e627061,
0x1c5f6660,0x5f1d1f65,
0x1c686b60,0x2a19171c,
0x0010770e,0x68121e6e,
0x7d7d047f,0x7f797e7c,
0x0a7b7b09,0x7c7a7503,
0x0a770108,0x05007601,
0x03037b74,0x7f040a08,
0x00787b0a,0x06730b03,
0x07146c0e,0x010e0874,
0x740a6d1a,0x140e7479,
0x78097e79,0x07700c08,
0x79067503,0x7a040703,
0x74017d02,0x03010407,
0x757d7d70,0x0001007e,
0x7e7a7c04,0x040a7e7f,
0x0a0d7178,0x00017006,
0x77010f11,0x13196a6e,
0x7902047b,0x78010203,
0x037e0000,0x797d017e,
0x0a7e7d7e,0x78030003,
0x7b060004,0x7f7f7800,
0x710d7479,0x07080b7f,
0x700f1011,0x78790c13,
0x74150c07,0x0612710b,
0x73146d06,0x7b0b710b,
0x0b0b087d,0x146b6f6e,
0x5d171312,0x72086970,
0x10686f5b,0x0d742021,
0x73071700,0x7903020c,
0x10781103,0x7b0a797c,
0x0a7e110d,0x0a037166,
0x060a7800,0x04060c0d,
0x117d7a09,0x067e077c,
0x7c07000a,0x7d03767a,
0x000d0604,0x7a040079,
0x00010d0e,0x0d020c7c,
0x7e777f00,0x09707402,
0x7e07007c,0x0a7f7978,
0x03090d79,0x0a030501,
0x0079047e,0x047c7903,
0x12020400,0x7e6c010a,
0x73167116,0x0f066b7d,
0x6771140c,0x13720813,
0x66685a28,0x69622014,
0x6b0e0572,0x12241e5b,
0x74777e7f,0x017f107c,
0x0007077a,0x09030b77,
0x0e077803,0x7d7e050b,
0x7a080b09,0x77117f01,
0x1d656367,0x78061702,
0x6c6a646f,0x6f69150c,
0x0e787b7f,0x7d08777d,
0x0e0a0679,0x767a6d0b,
0x7872767b,0x087a7d0a,
0x747e027f,0x7d007677,
0x0e790274,0x7c6e117b,
0x0b0c6b0b,0x07040005,
0x720c737e,0x76777206,
0x07737901,0x750e7079,
0x0f71731a,0x106f6914,
0x7b0a7e7f,0x030c1905,
0x787e7a7d,0x7d7f7b01,
0x0e797b04,0x79057a07,
0x14107110,0x7f06710e,
0x6d0c1a7c,0x6b147573,
0x6e191716,0x0d7c0d79,
0x156e7363,0x1c1e1d69,
0x14107513,0x040a0d08,
0x0d096c6e,0x746c0772,
0x027b0600,0x71071074,
0x730b0407,0x761a6f05,
0x7f010901,0x0502027d,
0x6e03000a,0x09000b08,
0x0904740e,0x03767c7c,
0x12776b0f,0x116c766d,
0x7e07037f,0x7a71740c,
0x08027c0e,0x02080706,
0x017b017c,0x6c040303,
0x030a0201,0x7a7a0309,
0x7b16100e,0x79087208,
0x18716c1e,0x12100e6d,
0x0a0d060b,0x680f7973,
0x7771770f,0x7f7d7c7f,
0x70030804,0x7b7a0609,
0x170f2064,0x08120b08,
0x11710d0c,0x70766a1b,
0x737b7c7f,0x7e060775,
0x7c7c7c0d,0x7c7d7f02,
0x7b060500,0x750b7b7e,
0x79007a04,0x7d037f7f,
0x767f0401,0x0e167a7b,
0x040a040b,0x70770706,
0x6f700e0b,0x0e6e0772,
0x77780f13,0x14116e72,
0x0f01027e,0x0802067f,
0x14100f73,0x6514740f,
0x7a027d11,0x176d6f6b,
0x0307047d,0x7e017c07,
0x057b087e,0x7c717d75,
0x017d7907,0x7c020105,
0x0d7d0703,0x7a7d787d,
0x790b7d7b,0x0106067f,
0x02047a7a,0x08007d7f,
0x7a76087b,0x02000001,
0x611e6c11,0x787c740b,
0x74750575,0x0d0e7014,
0x02017d75,0x7979096a,
0x0e6d676e,0x7c0e007d,
0x7c0d6772,0x11761c17,
0x7409090c,0x0c780267,
0x13726d10,0x0e740871,
0x70070a7b,0x0a157873,
0x6f136513,0x68697970,
0x79690377,0x03751374,
0x7d74087e,0x72080c0c,
0x7d097b12,0x0c097f02,
0x72750975,0x0e79737b,
0x66696e6b,0x1170710e,
0x09020117,0x1d67201c,
0x077a760a,0x0402780b,
0x0805757e,0x7e107e77,
0x6f777908,0x120e7e75,
0x0b00770c,0x02740671,
0x0c05797c,0x7b067d03,
0x097e057f,0x7c030707,
0x037d7f01,0x02067f01,
0x097a0278,0x087c0078,
0x097b037c,0x74017e7f,
0x060e6f05,0x7b7c7d7d,
0x6b6a7111,0x12706901,
0x79751013,0x0b6d641c,
0x7d78757e,0x050e0105,
0x7c7b0500,0x02050479,
0x767f0c7f,0x01017b01,
0x767a737c,0x74790774,
0x0b6f7207,0x7a7a0c0e,
0x1a6f6b11,0x0b026272,
0x7577096d,0x15081011,
0x1c5f6865,0x2160607f,
0x0a13720b,0x19746a76,
0x63711266,0x160f1117,
0x63621573,0x601d6c6a,
0x151f1b11,0x676a1b18,
0x76136267,0x6c101d73,
0x790d1103,0x140d6775,
0x797c770d,0x73700c08,
0x6c777270,0x72720310,
0x7a7d077d,0x79777e0e,
0x7e040176,0x7c7a777b,
0x087a0278,0x01797e7d,
0x7605087d,0x097f7a0f,
0x13740501,0x0076707a,
0x787b7579,0x10787602,
0x7506007f,0x037c0000,
0x7c027207,0x020a037f,
0x7e7e7b01,0x01030e72,
0x7d05017e,0x7e7c0302,
0x7f7b7a7c,0x0100067f,
0x01017d09,0x01777b74,
0x7779117d,0x7e037701,
0x14097273,0x06760a76,
0x71140377,0x72140e70,
0x00017809,0x007f7901,
0x017a7d7d,0x02090402,
0x01777a04,0x727f0307,
0x7b780507,0x0778017c,
0x07087600,0x0a007c75,
0x77107273,0x7b77037e,
0x05780b77,0x0c72037f,
0x057a0a7a,0x0872047f,
0x03067a0e,0x03747878,
0x09080100,0x76797673,
0x79067878,0x090c7f04,
0x7d780479,0x0b766a03,
0x74707710,0x6679760c,
0x15161d70,0x126e136e,
0x77760b0c,0x75126c6e,
0x047d7e0b,0x7a077c7a,
0x02010101,0x027e077c,
0x7f7e7e7c,0x03037d7b,
0x07750278,0x01750304,
0x0c030006,0x7c7e7f7a,
0x7e04047b,0x7c090e04,
0x740f210e,0x000d7709,
0x17182211,0x216b246e,
0x120f1868,0x18611b16,
0x05087f76,0x140f090b,
0x00767e7b,0x0a7f7376,
0x78170705,0x08030674,
0x76100071,0x01797c14,
0x7a71107d,0x07720b10,
0x027a6e00,0x02027b04,
0x017a0f03,0x7d7f7702,
0x0a090005,0x7f0b027d,
0x05750b01,0x00057b02,
0x0002067f,0x7f79017f,
0x0b657002,0x7e7a097f,
0x6d6e1917,0x67171b7e,
0x0f027574,0x10741610,
0x10740c78,0x746f766e,
0x7e007774,0x08777c73,
0x08007b02,0x06767877,
0x09007901,0x037f7d75,
0x02797c7c,0x01037f02,
0x73050912,0x0b790505,
0x59602161,0x1a0a750a,
0x695a6614,0x1e206060,
0x10121014,0x636b6e62,
0x0701057b,0x0f760f72,
0x7a060b7c,0x7605047b,
0x7d087a01,0x0e7a000d,
0x06020b05,0x0c0c790b,
0x007c7c03,0x05040a08,
0x0e6e0206,0x0e7a0301,
0x097f0007,0x6f6e7e07,
0x7b7a0502,0x6f7e0e02,
0x0208787c,0x05790878,
0x04120202,0x04037e03,
0x797f0100,0x7f077e6f,
0x02787d01,0x7a7d7c02,
0x70020972,0x0602047d,
0x780c7479,0x020c0f70,
0x7d0b0c7e,0x120d0801,
0x0c7d737e,0x08797d7f,
0x7f070878,0x0b7c760c,
0x15717412,0x70700809,
0x7f6f116b,0x71741569,
0x697a7707,0x02007407,
0x7a017200,0x74057a7f,
0x01777e01,0x7b03057d,
0x01010010,0x7d7b0201,
0x7c060a06,0x74020307,
0x717c756f,0x037b7e07,
0x1207797c,0x07087c0a,
0x7805037c,0x7c050e7d,
0x097b0072,0x7b047877,
0x73747272,0x77770109,
0x7c78097b,0x726a7a10,
0x100d7006,0x6c017609,
0x0d0f7568,0x707e0a75,
0x656f6614,0x6b0e757e,
0x6c636a12,0x1766735c,
0x746c111f,0x0f136f66,
0x0300097a,0x7d020c07,
0x71010901,0x7d010b7b,
0x76010b75,0x00050305,
0x7a72120e,0x71707475,
0x12106865,0x16661470,
0x731c7671,0x69687270,
0x67776c6d,0x1016786f,
0x7a14080f,0x0d126c08,
0x09020204,0x73010575,
0x077f7b00,0x01027b7e,
0x5f6f750b,0x0d03007e,
0x171c1513,0x6b1d736d,
0x0a730f6f,0x710f1467,
0x7904027d,0x00047b7d,
0x77080c7c,0x7f7b7808,
0x0300017e,0x0401060d,
0x7f09107c,0x0204057e,
0x78000805,0x787b0707,
0x05070309,0x7f7d7b7e,
0x730c7903,0x07780579,
0x0c797579,0x05730600,
0x16060d75,0x037c0b73,
0x6f6c666d,0x15120b72,
0x756f0c07,0x04051b17,
0x7b7a086b,0x0e050302,
0x65077b06,0x74797e7c,
0x1208740f,0x77057e79,
0x0002006f,0x0106770b,
0x78027c7e,0x08027205,
0x7b7c750a,0x75777c7f,
0x0614146d,0x70716704,
0x1072067b,0x040b6f0e,
0x7c057301,0x06737c7b,
0x00087f08,0x7d080378,
0x7d7b7e00,0x75750076,
0x7f03080b,0x7f7a7d7e,
0x7d7c037c,0x7c087e78,
0x0d040578,0x76737705,
0x7071676d,0x0a6d1a77,
0x01040a06,0x02007500,
0x0401017b,0x01040474,
0x0403017e,0x01786e02,
0x00747377,0x0b017805,
0x7a000109,0x0300787d,
0x0a7b7c04,0x027b0175,
0x0e7f7507,0x7d7b7d0c,
0x7b7d7709,0x7c07780c,
0x7a7a0202,0x067a060a,
0x7e067f7e,0x09060001,
0x7e07097b,0x0a070604,
0x050f0975,0x08070102,
0x01071709,0x7d707378,
0x7c777609,0x07077d07,
0x767d0609,0x7e0a027d,
0x05730505,0x06750402,
0x0e077510,0x6e047b0a,
0x6c147170,0x6b0e6c10,
0x0d7d0404,0x0a100272,
0x7f7c7905,0x7d077f7b,
0x6d7a0102,0x0878087d,
0x70077d79,0x02080203,
0x0f1a156f,0x7f737e0a,
0x0f0b700d,0x1971151a,
0x1572076f,0x740c1073,
0x747d756f,0x166e0b6e,
0x626f786f,0x140f7572,
0x660f1760,0x63730f14,
0x05056e14,0x037a6d1f,
0x77070e05,0x127d7776,
0x07760d77,0x7e750806,
0x0c0e7778,0x017e7c0a,
0x7e780a75,0x700c670a,
0x00037506,0x09017f05,
0x057d7f05,0x7c047a00,
0x750d7612,0x7b750b08,
0x0b08110d,0x0c777270,
0x077f7b0e,0x017f0700,
0x777c7c0e,0x7a05780b,
0x10727a7a,0x757a737a,
0x7f737b7a,0x7e110b12,
0x7d0b037f,0x79040b06,
0x0c7d0605,0x00000072,
0x04040706,0x71077b7e,
0x7c080304,0x7f057d0c,
0x77760402,0x0e7e0105,
0x76097b12,0x1176790d,
0x7873107c,0x07787e00,
0x7b7c7271,0x7c08760d,
0x177c777a,0x7c02120c,
0x7b7b7a7a,0x777a0b79,
0x777d7b08,0x787f007e,
0x04070204,0x04037e75,
0x790b0f0a,0x03070702,
0x166e1711,0x706c0506,
0x7a777c79,0x72140a73,
0x73700a7c,0x7a0e7405,
0x7b050308,0x08010800,
0x087e7474,0x047d0878,
0x090e7d72,0x7d75010a,
0x706e7578,0x0c6f110e,
0x177d6d68,0x0f740476,
0x63626359,0x5b69205a,
0x057f6d76,0x0b0b7412,
0x79721404,0x787c7c0d,
0x746d1211,0x6a6d6f05,
0x6f77750c,0x120f0c0e,
0x0000760b,0x7a6f746b,
0x14136c16,0x74757b00,
0x786c6e1b,0x186c1e18,
0x016e0c01,0x04106c0f,
0x0d040a0b,0x767e0c0a,
0x7c7f0401,0x0b077c7f,
0x07017f01,0x097d0205,
0x000e7806,0x04047e03,
0x027c0001,0x03770105,
0x0a04037e,0x057c0601,
0x7a067e02,0x7c037d7f,
0x7e040079,0x007c7f00,
0x050c7f03,0x76747e7a,
0x0f13156f,0x6d107302,
0x776f6663,0x2562616e,
0x7e77050e,0x7c7c0b05,
0x04767d09,0x027b7b78,
0x03080264,0x02090905,
0x0e720a78,0x6f0a127d,
0x70166f6d,0x0c15670a,
0x0109097d,0x05001569,
0x7b030279,0x7f050306,
0x7d00017a,0x05037b00,
0x04027975,0x7a7d0304,
0x7e037a09,0x7b760a05,
0x010b0005,0x7f027d77,
0x03760702,0x7f7b777e,
0x017a7c7f,0x017b7f79,
0x7e777c7e,0x01030402,
0x7b097a08,0x037d7c79,
0x790d7300,0x7d077b00,
0x7b027f76,0x060c7d7e,
0x796b086f,0x01767201,
0x10090604,0x79700a0c,
0x6d6e0f74,0x146d7206,
0x776f7f76,0x136e140e,
0x77067f02,0x017d0606,
0x027b0603,0x79057c0b,
0x05017e05,0x7e007d7f,
0x00027373,0x7a040079,
0x790d7f06,0x027d7f03,
0x7b7a7b7d,0x7c050407,
0x07777d02,0x7b6b7f7d,
0x116d1f11,0x050a0d00,
0x1719050e,0x1015136c,
0x037c020b,0x017a7611,
0x09027b73,0x0800047e,
0x7b760a01,0x7a7d7a05,
0x7b7c7c7b,0x7b03017d,
0x017b0a02,0x78057e00,
0x7a7a0073,0x7d7e7c7c,
0x74047b0b,0x0007037b,
0x080f7509,0x7f78780a,
0x7e747d00,0x0779027a,
0x7975797d,0x01007605,
0x0e097503,0x74100a15,
0x7b0b0801,0x050e1309,
0x7e0b027f,0x7c7f7b75,
0x7e7d0201,0x78777b05,
0x780c077b,0x0308007d,
0x090c057d,0x727d7905,
0x0c020a03,0x0d020e0d,
0x7f747d02,0x0101037b,
0x78010308,0x7f060900,
0x00777d02,0x057e1106,
0x00080504,0x7d027c00,
0x7d090505,0x05047e09,
0x777d017d,0x017e017a,
0x7c017f01,0x767a7e7d,
0x067e7a77,0x01007605,
0x7b707a70,0x0773757b,
0x7e6e6d08,0x6e70687d,
0x7f060104,0x0c0f737d,
0x08720279,0x06000876,
0x7a710d75,0x6d7b0301,
0x0c037308,0x7106066e,
0x0404790a,0x047c077f,
0x780a7f7e,0x05060902,
0x756e797c,0x0b017676,
0x71790b68,0x720b7f16,
0x0c711a13,0x0d771112,
0x0b770a77,0x7a1f6f07,
0x7f7c027b,0x7e7e7e7f,
0x0005067c,0x7c7b7873,
0x79060101,0x0b7b097c,
0x0107117d,0x7d127e04,
0x790e057d,0x77060c72,
0x7203777f,0x78030179,
0x05116d6a,0x17196a18,
0x060b0e00,0x7e72006a,
0x107c7c7e,0x727b0672,
0x08797701,0x7a70057f,
0x027c0102,0x7b000b7e,
0x7a777b02,0x047f7a06,
0x07080f01,0x08060f77,
0x01780c09,0x7d7a0907,
0x0e027704,0x7e010007,
0x7d7a7c05,0x037a7c79,
0x7e770b02,0x7d797f03,
0x7e077c01,0x0a080a0a,
0x03747a05,0x7f027d01,
0x0c017708,0x7b7e060a,
0x7d02027b,0x7c067f7e,
0x0d7b797f,0x7f7c7d05,
0x030e1103,0x0b09787e,
0x77050e72,0x7b0d0379,
0x7d060a7d,0x027c027e,
0x6b77797d,0x770d0c79,
0x7d756f0e,0x190a160c,
0x73026b72,0x1278060b,
0x76020077,0x74770700,
0x03070179,0x04040302,
0x790f0202,0x027f017d,
0x7e79087f,0x7a710506,
0x727d747c,0x757b090b,
0x01090975,0x7b797b02,
0x006d7c09,0x70070570,
0x0c7a767c,0x78750301,
0x7f007e0e,0x08080a04,
0x03047505,0x07067516,
0x7c017903,0x03057a0a,
0x01017f00,0x727c050b,
0x7b6e0703,0x787f7a01,
0x760b7003,0x747a027d,
0x097b6b15,0x08077111,
0x726f1075,0x67171777,
0x137f057a,0x0e0a7574,
0x7a100002,0x79070c02,
0x16710c10,0x13177279,
0x6b201b0b,0x66212822,
0x15146314,0x6b11705d,
0x6d160a6b,0x70176c60,
0x70737069,0x72195f62,
0x7a000876,0x71090c7e,
0x6818617a,0x0c6b0c01,
0x71196167,0x196b700c,
0x79100d12,0x71186c67,
0x0208047a,0x7f790274,
0x7e030408,0x05080306,
0x03007d0b,0x09040101,
0x7f017c79,0x02767e05,
0x76030873,0x797d7a7f,
0x0e0f7701,0x73690d7e,
0x6f65256e,0x1b1e206b,
0x09061015,0x6f6a1418,
0x73030c77,0x03747379,
0x7a6e1810,0x077b710c,
0x64602321,0x0d196d0f,
0x1d216a72,0x1a1d1868,
0x746d6d0d,0x10726d12,
0x7e787e16,0x76107707,
0x0f79027b,0x7c0a0003,
0x027e7a02,0x03770200,
0x04790a08,0x04797f09,
0x7a7e7f05,0x0b00797d,
0x7d7c040a,0x06040501,
0x7e780201,0x7b000003,
0x7f05767a,0x07000304,
0x0b770102,0x007c7800,
0x78150d79,0x080e1476,
0x0b160900,0x6072140c,
0x770b190a,0x110b7173,
0x737e760c,0x0c086609,
0x670a0911,0x05771276,
0x08020c0a,0x0470060a,
0x15730f7b,0x7a7b1478,
0x0b730f1d,0x120a1967,
0x1176736e,0x6a707f0f,
0x757f0f06,0x6f057c73,
0x7e01067b,0x047c7d11,
0x7a030411,0x0602007a,
0x717d7703,0x7c010604,
0x0d770779,0x797e0801,
0x10741b0d,0x027c0875,
0x7f777776,0x030f720b,
0x797d0801,0x07017b73,
0x70010979,0x79737a7c,
0x037f7c01,0x7c047803,
0x03747d05,0x7f08787e,
0x7e790005,0x03000079,
0x6f707a09,0x77760007,
0x75797e0c,0x79767f78,
0x130e0874,0x0b03057e,
0x6e0f7a12,0x6f08100a,
0x71736500,0x0c0a0d74,
0x1510796a,0x17760e13,
0x2322191f,0x1d206510,
0x233f3759,0x59705c5e,
0x532f582e,0x2e546151,
0x707d7177,0x07675962,
0x0c740e09,0x71100f78,
0x6d0e7313,0x0d0e0d06,
0x727c7d73,0x077b7075,
0x180d7618,0x7d747a05,
0x090e1570,0x13111c0e,
0x0c730d08,0x7a090201,
0x070e0e75,0x7c78090f,
0x7f000007,0x7e75747f,
0x047f0502,0x017e7e03,
0x77117f09,0x11027b7a,
0x6c197767,0x0f0d7876,
0x72117811,0x14161c0f,
0x117f0d0f,0x78097973,
0x6f14726c,0x6d0d0f6e,
0x7f02077a,0x096e0f6f,
0x7f7d7877,0x0103777f,
0x06786e07,0x78086d0a,
0x730b017a,0x767b070a,
0x0c0b7e74,0x08767f05,
0x6a626c68,0x1466187e,
0x12667a1b,0x6b141a1c,
0x711d691c,0x0f191a6b,
0x716b076d,0x0a6c6f13,
0x0972056d,0x0b0d0e0b,
0x0b040469,0x047a780a,
0x0003047f,0x007d7c00,
0x06070406,0x04027d78,
0x08747a07,0x060e7b06,
0x05727005,0x0a080809,
0x047b7211,0x08010908,
0x040c037f,0x7d067f07,
0x7008147c,0x1604777e,
0x7a100c0d,0x780e7f0d,
0x070b0c77,0x7676780b,
0x06747e79,0x647f7076,
0x077d037f,0x7c7d7906,
0x7f797779,0x7f0e0505,
0x017d007a,0x7c7f0902,
0x027b0205,0x017e0001,
0x04037d7c,0x007a7f7f,
0x7e07767f,0x05077600,
0x01071305,0x7a7c7c73,
0x0901770b,0x13130b78,
0x06097675,0x057b7c07,
0x7c000a7b,0x76787d0b,
0x790a1002,0x01090576,
0x750b0301,0x75071304,
0x09720b78,0x0f047975,
0x086f7f7b,0x0b127c7d,
0x0c786f0f,0x6d7a0a7f,
0x75030104,0x6c706e12,
0x75790506,0x7d76717b,
0x01090100,0x79017e73,
0x0300067d,0x0001037e,
0x0e067d7c,0x7d047d05,
0x70717c06,0x74156b0f,
0x017d7778,0x780d087d,
0x77727f02,0x7e02077d,
0x73777669,0x74117600,
0x7e7a0671,0x7e01796e,
0x010c037a,0x00770d7d,
0x0800030d,0x74090002,
0x67650904,0x70740601,
0x1b6f5c17,0x1568680c,
0x6e041579,0x6e641715,
0x68736109,0x74760d69,
0x15787371,0x0779716a,
0x087f080a,0x0a777b75,
0x047e057d,0x7f7c0504,
0x7b7d7f05,0x7a7e7c7e,
0x0502017d,0x00007b00,
0x1b690a73,0x6c6f737a,
0x137b7d0b,0x6217146e,
0x767c0b09,0x7e07056e,
0x6c071002,0x7205750a,
0x0f676c0e,0x74126a6f,
0x06780477,0x1c0e166a,
0x007d7b7b,0x7a7d0801,
0x7f010002,0x00060e7e,
0x047a787f,0x7c75017f,
0x120e7378,0x7a720e7c,
0x040e086a,0x1c1e1617,
0x11057204,0x760b120d,
0x79050405,0x7f070701,
0x037c7e7e,0x7b057f00,
0x7d08737c,0x03040308,
0x077e7505,0x7a04037c,
0x057b0805,0x0a0a0679,
0x77700777,0x75760772,
0x64655e17,0x180e746b,
0x12631f6c,0x6a165f63,
0x0b7b010e,0x7d6b0f74,
0x767f077a,0x03017c07,
0x0301740d,0x057c037e,
0x0f751700,0x0f797878,
0x0c0d1711,0x13111011,
0x79010703,0x03057b04,
0x06037c07,0x717a7707,
0x7a7e7a01,0x7e7a0e03,
0x0d0c7112,0x71080a7b,
0x13146b12,0x66790368,
0x6b5a2563,0x55231f5e,
0x090c0a7c,0x14646c0f,
0x6f640c77,0x150b1309,
0x69000d18,0x61650605,
0x760b060b,0x757a0d14,
0x060d7879,0x000c097f,
0x676a036f,0x097b020b,
0x1719121b,0x10191f10,
0x166a6d1f,0x6a196b72,
0x010a7a72,0x7077716f,
0x75037201,0x067f0101,
0x0b0d0479,0x03047e7f,
0x760a7e00,0x7e7f7e7b,
0x0a087c0f,0x7c07087e,
0x76070909,0x7b757f01,
0x7a0a0502,0x7f7d7a7f,
0x6d080703,0x080c0270,
0x7b7f7e74,0x0105006c,
0x7f027a7b,0x08787b7a,
0x00737f03,0x737e0072,
0x7f087d7b,0x01067f7f,
0x7b7f7a09,0x087e787d,
0x7f03117f,0x7f036f04,
0x7603007b,0x7700767c,
0x05787c06,0x07010006,
0x7a020c03,0x01057903,
0x7d780502,0x017f0601,
0x79787e7d,0x037f767c,
0x0675107f,0x7605040f,
0x7c007f79,0x7e797106,
0x7e0b7f06,0x0b79027c,
0x7519090d,0x7d027777,
0x0707087b,0x057b0275,
0x7a077a7e,0x7076027c,
0x0002087f,0x7507017b,
0x7a7d047b,0x05000002,
0x0a76767c,0x0d00797c,
0x6d6c100d,0x77791375,
0x0c130d06,0x69666c6f,
0x0e10080b,0x0d761705,
0x02760002,0x7408067b,
0x02090002,0x060c0877,
0x7e007707,0x02020200,
0x7d757a7d,0x7505007c,
0x0673057c,0x7e017974,
0x7d78060d,0x0b077508,
0x797e0403,0x797b7d79,
0x7678010d,0x76057973,
0x717a7c12,0x04027a7f,
0x06096c0c,0x09760a0c,
0x726e0a13,0x7a0b757a,
0x09047c7b,0x070d0e02,
0x787d060a,0x117e7703,
0x05037d02,0x7703747d,
0x01050477,0x0101727f,
0x7d7d7503,0x7e010b06,
0x0b007b05,0x7f010400,
0x7b107373,0x0e080207,
0x7403010b,0x77750912,
0x767f0005,0x137f117f,
0x000b0a72,0x79780575,
0x7b04777f,0x06020803,
0x7c09787b,0x7a767e08,
0x04037f04,0x7c7e7f01,
0x7c000007,0x0004017c,
0x057e7f00,0x7c7a7d02,
0x7f7e0775,0x7e010078,
0x6f0b017e,0x0e02067c,
0x787d7c64,0x7f0e0a79,
0x03050309,0x0f7a007b,
0x7f086e7a,0x0f07770a,
0x7d710173,0x0b0a7f7f,
0x077f017a,0x7c050606,
0x7d0b0705,0x790e7b09,
0x7b00027b,0x7e7e7d7b,
0x7f7a787d,0x7d0d7f0d,
0x077b7c03,0x00027e7b,
0x7715716b,0x00740a78,
0x077c0d76,0x6b70766b,
0x7d75040d,0x07027605,
0x00010001,0x06041100,
0x6c02047d,0x03040905,
0x71090601,0x7f087e00,
0x09767d06,0x046f017e,
0x75757478,0x77710904,
0x0300007e,0x7a037a0a,
0x6f6e7a75,0x01010b0a,
0x116b1c64,0x60171615,
0x59212020,0x1e1f2116,
0x770c6871,0x1f661c61,
0x7277081a,0x611a1816,
0x780d0674,0x08791671,
0x7a080d0b,0x7d780d70,
0x070c140f,0x196a1170,
0x7305770e,0x79000274,
0x626e1570,0x721a0b73,
0x711e6362,0x19676026,
0x09721011,0x6b14106f,
0x227c7779,0x735e0075,
0x0e6a6e0e,0x746d1470,
0x00017903,0x7b7b7470,
0x7778007e,0x7d7e7800,
0x79037704,0x7d7d067a,
0x76097b7b,0x7a037704,
0x7101037d,0x79047b03,
0x65180205,0x6b6b0773,
0x76210b1c,0x6a211418,
0x6c5a212a,0x585e2468,
0x126e6d13,0x73190f1c,
0x796e7672,0x78037806,
0x77077a75,0x05737d03,
0x787a0207,0x7f7a0704,
0x7a7c7d02,0x01010779,
0x020a7c01,0x7b017d7f,
0x7a760176,0x767d0279,
0x7f03047b,0x787e7209,
0x7a7d030a,0x08037e78,
0x0000057e,0x04717b08,
0x7c057d03,0x797d7f00,
0x037d0301,0x7f00087d,
0x6919121f,0x1a0a7570,
0x62646916,0x21575b6d,
0x7d127313,0x756d6c0f,
0x7d7c7d7c,0x017a7c01,
0x7e047e79,0x7b7b0402,
0x76797d6e,0x710b7902,
0x7e060f71,0x75766b7f,
0x06736a00,0x0a720e11,
0x0104760c,0x7a031105,
0x6e166f6b,0x07047f06,
0x0678757b,0x7c126f01,
0x6c070705,0x030d7776,
0x6e770610,0x000b1277,
0x71740e05,0x6d6f1173,
0x09796f74,0x047d7877,
0x77007e7c,0x7f097e7f,
0x03007977,0x0c017e0b,
0x78000d0b,0x73790504,
0x00007e08,0x7c710b00,
0x037c020b,0x0402057e,
0x070e7b05,0x00057476,
0x1003077e,0x007b0278,
0x060f0506,0x0e757c06,
0x0a030401,0x05100678,
0x7a760106,0x047d7b7d,
0x7d7d017e,0x767a7f01,
0x77750407,0x0104017c,
0x02147713,0x6c73027c,
0x676d196b,0x7773137c,
0x0f17056a,0x0c1a0b71,
0x120e1070,0x71701964,
0x01757904,0x7f010272,
0x22665f2b,0x18215c0d,
0x0e711a18,0x0e142324,
0x7d770775,0x780b7912,
0x07040505,0x0a040c7c,
0x700d000d,0x6f060511,
0x0d080478,0x6e6c116c,
0x72766f76,0x090e0b01,
0x0878750c,0x74777910,
0x057d7b7e,0x04770a05,
0x037e0405,0x780b0309,
0x7e007d00,0x10067d7b,
0x75010902,0x7a7c007f,
0x027b7e05,0x007e017b,
0x79010002,0x7e067703,
0x030c0101,0x047f017d,
0x720f7a09,0x76790b7f,
0x7d7b0005,0x6b7b717f,
0x097b0c09,0x6e127f79,
0x1a1c1170,0x160d1316,
0x7c101013,0x1271681b,
0x7b7d7e76,0x007f0576,
0x047d0005,0x037c0373,
0x6a630c7e,0x78070c76,
0x76131a10,0x68216669,
0x710e6f0f,0x77720d67,
0x06761171,0x76750711,
0x04057806,0x6e000814,
0x14701714,0x1116070f,
0x0a061305,0x7b776869,
0x7611776d,0x090b0a74,
0x750d0a7f,0x04777a7b,
0x0879017c,0x7103030b,
0x7e7f0479,0x7d030308,
0x0b16070b,0x0a7b027c,
0x74007609,0x79777176,
0x0b747b77,0x7e0d077c,
0x7808790b,0x11017f7e,
0x71701272,0x0c0f7f0c,
0x0b61616f,0x6d1f6a7b,
0x0c76170c,0x756c1210,
0x72140c7f,0x70156d07,
0x02720975,0x7d057f04,
0x71711117,0x6d74017b,
0x03090500,0x070f7276,
0x74077407,0x08030102,
0x0b076f0a,0x72767875,
0x170f0f76,0x710a7006,
0x01106a70,0x100d0f07,
0x78020a7f,0x09091372,
0x07787f74,0x78060e06,
0x0d787c08,0x0a7b0c79,
0x727c7969,0x0a0d0871,
0x7d037e05,0x07717778,
0x7b790707,0x797d067e,
0x7b757f06,0x76080179,
0x6a121a1e,0x136d780f,
0x146c6c6d,0x1614716e,
0x5e691811,0x0a771012,
0x7671766e,0x0c757872,
0x70206c19,0x1d23127a,
0x780a050a,0x15130c17,
0x080a0701,0x76000676,
0x7c030a0c,0x087a7708,
0x0276056a,0x04000105,
0x760e7b7a,0x03770078,
0x77060509,0x11797074,
0x026b7402,0x797e7674,
0x057b017f,0x08007a00,
0x7b0b0603,0x79777906,
0x097d0100,0x7808067b,
0x01000205,0x037b7f07,
0x7d7d0578,0x7c037c7c,
0x07760703,0x757e0606,
0x7f73007e,0x01017d04,
0x7f020f7f,0x0904740d,
0x7e7a7704,0x7f007f78,
0x00757906,0x7d0c7400,
0x0a0d7d00,0x7f0b7973,
0x037b7b79,0x01047374,
0x027e7f7d,0x08067e09,
0x08017c02,0x7f00007c,
0x727f7e79,0x09700975,
0x150d6c07,0x0b057575,
0x00781079,0x7709790b,
0x7802087b,0x7309037e,
0x78767d7a,0x7f77037b,
0x7b027f76,0x0578087c,
0x7b75757d,0x787b7f76,
0x03777078,0x747f7d06,
0x73010405,0x710d7c7a,
0x78707112,0x7e037f01,
0x18091414,0x6c697674,
0x0877137e,0x090e6b0d,
0x630e756a,0x7e130b6e,
0x02756e7a,0x066e100b,
0x7a030203,0x7901730b,
0x0a7a7d7f,0x010e7772,
0x7d0d7d7d,0x06080577,
0x017c727c,0x06057f0c,
0x0b070501,0x0406057e,
0x7277680e,0x7b7b0811,
0x6e777519,0x710f7804,
0x0d736873,0x1a13070f,
0x776e6d78,0x73097d6f,
0x007b7a75,0x73070a7e,
0x01087f74,0x077e027c,
0x01010200,0x7e067c08,
0x7f7c0200,0x040a7e03,
0x7606777d,0x017c0302,
0x6e1c0d13,0x01017a02,
0x72700e0c,0x0b0c1411,
0x7f7c7f03,0x7e027d02,
0x7c08017f,0x7d7e0077,
0x7b747a7f,0x04017b03,
0x6e7a7704,0x7c7a7a7f,
0x14681422,0x76150c0c,
0x1111120f,0x6d16106e,
0x0c6e0e7c,0x11737177,
0x05050970,0x716f0774,
0x06730177,0x7b7d7b74,
0x0103060b,0x057d7a04,
0x1a0c7f7a,0x0605010a,
0x0374080b,0x76050072,
0x6f760401,0x13097915,
0x06020804,0x037a067f,
0x0877000a,0x0a050101,
0x030b077c,0x7b7c0b7f,
0x02017801,0x7b047d06,
0x017e0e00,0x067c067f,
0x770a7608,0x75080703,
0x17766f6b,0x1274106d,
0x10097413,0x1b6c661b,
0x77770a76,0x72021077,
0x7f6e7404,0x166a7372,
0x1003787f,0x0079137b,
0x7f010203,0x00010676,
0x74080200,0x7d017c7a,
0x01726c6f,0x106f1512,
0x09070202,0x7e7b0608,
0x040f787f,0x7e7d7c7c,
0x05017d7b,0x057e7d7b,
0x0e040c07,0x7e7d7f06,
0x0b777273,0x08077107,
0x717d7b69,0x07727506,
0x7d74767a,0x017d0c77,
0x7e747906,0x00067f7b,
0x0e0f6f76,0x04797d00,
0x0b110d71,0x700f1375,
0x05020a70,0x0a090775,
0x7d7e037b,0x04030708,
0x7e01067e,0x7b7b7608
};
