/* =============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *  ============================================================================
 */

/** ============================================================================
 *   @file  cslr_vcp2.h
 *
 *   @desc  This file contains the Register Descriptions for VCP2
 */

/* =============================================================================
 *  Revision History
 *  ================
 *  23-March-2005 SPrasad   File created.
 *
 * =============================================================================
 */

#ifndef _CSLR_VCP2_H_
#define _CSLR_VCP2_H_

#include <cslr.h>
#include <tistdtypes.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Register Overlay Structure for registers accessible through Config bus
 */
typedef struct  {
    volatile Uint8 RSVD0[24];
    volatile Uint32 VCPEXE;
    volatile Uint8 RSVD1[4];
    volatile Uint32 VCPEND;
    volatile Uint8 RSVD2[28];
    volatile Uint32 VCPSTAT0;
    volatile Uint32 VCPSTAT1;
    volatile Uint8 RSVD3[8];
    volatile Uint32 VCPERR;
    volatile Uint8 RSVD4[12];
    volatile Uint32 VCPEMU;
} CSL_Vcp2ConfigRegs;

/**
 * Register Overlay Structure for registers accessible through EDMA bus
 */
typedef struct  {
    volatile Uint32 VCPIC0;
    volatile Uint32 VCPIC1;
    volatile Uint32 VCPIC2;
    volatile Uint32 VCPIC3;
    volatile Uint32 VCPIC4;
    volatile Uint32 VCPIC5;
    volatile Uint8 RSVD0[48];
    volatile Uint32 VCPOUT0;
    volatile Uint32 VCPOUT1;
    volatile Uint8 RSVD1[48];
    volatile Uint32 VCPWBM;
    volatile Uint8 RSVD2[60];
    volatile Uint32 VCPRDECS;
} CSL_Vcp2EdmaRegs;

/**************************************************************************\
* Field Definition Macros for registers accessible through config bus
\**************************************************************************/

/* VCPEXE */

#define CSL_VCP2_VCPEXE_COMMAND_MASK     (0x0000000Fu)
#define CSL_VCP2_VCPEXE_COMMAND_SHIFT    (0x00000000u)
#define CSL_VCP2_VCPEXE_COMMAND_RESETVAL (0x00000000u)

/*----COMMAND Tokens----*/
#define CSL_VCP2_VCPEXE_COMMAND_NOCMD    (0x00000000u)
#define CSL_VCP2_VCPEXE_COMMAND_START    (0x00000001u)
#define CSL_VCP2_VCPEXE_COMMAND_PAUSE    (0x00000002u)
#define CSL_VCP2_VCPEXE_COMMAND_RESTART_PAUSE (0x00000003u)
#define CSL_VCP2_VCPEXE_COMMAND_RESTART  (0x00000004u)
#define CSL_VCP2_VCPEXE_COMMAND_STOP     (0x00000005u)

#define CSL_VCP2_VCPEXE_RESETVAL         (0x00000000u)

/* VCPEND */

#define CSL_VCP2_VCPEND_SLPZVSS_EN_MASK  (0x00000200u)
#define CSL_VCP2_VCPEND_SLPZVSS_EN_SHIFT (0x00000009u)
#define CSL_VCP2_VCPEND_SLPZVSS_EN_RESETVAL (0x00000001u)

/*----SLPZVSS_EN Tokens----*/
#define CSL_VCP2_VCPEND_SLPZVSS_EN_SLEEP_DIS (0x00000000u)
#define CSL_VCP2_VCPEND_SLPZVSS_EN_SLPVSS_EN (0x00000001u)

#define CSL_VCP2_VCPEND_SLPZVDD_EN_MASK  (0x00000100u)
#define CSL_VCP2_VCPEND_SLPZVDD_EN_SHIFT (0x00000008u)
#define CSL_VCP2_VCPEND_SLPZVDD_EN_RESETVAL (0x00000001u)

/*----SLPZVDD_EN Tokens----*/
#define CSL_VCP2_VCPEND_SLPZVDD_EN_SLEEP_DIS (0x00000000u)
#define CSL_VCP2_VCPEND_SLPZVDD_EN_SLPVDD_EN (0x00000001u)

#define CSL_VCP2_VCPEND_SD_MASK          (0x00000002u)
#define CSL_VCP2_VCPEND_SD_SHIFT         (0x00000001u)
#define CSL_VCP2_VCPEND_SD_RESETVAL      (0x00000000u)

/*----SD Tokens----*/
#define CSL_VCP2_VCPEND_SD_32BIT         (0x00000000u)
#define CSL_VCP2_VCPEND_SD_NATIVE        (0x00000001u)

#define CSL_VCP2_VCPEND_BM_MASK          (0x00000001u)
#define CSL_VCP2_VCPEND_BM_SHIFT         (0x00000000u)
#define CSL_VCP2_VCPEND_BM_RESETVAL      (0x00000000u)

/*----BM Tokens----*/
#define CSL_VCP2_VCPEND_BM_32BIT         (0x00000000u)
#define CSL_VCP2_VCPEND_BM_NATIVE        (0x00000001u)

#define CSL_VCP2_VCPEND_RESETVAL         (0x00000300u)

/* VCPSTAT0 */

#define CSL_VCP2_VCPSTAT0_NSYMPROC_MASK  (0x1FFFF000u)
#define CSL_VCP2_VCPSTAT0_NSYMPROC_SHIFT (0x0000000Cu)
#define CSL_VCP2_VCPSTAT0_NSYMPROC_RESETVAL (0x00000000u)

#define CSL_VCP2_VCPSTAT0_EMUHALT_MASK   (0x00000040u)
#define CSL_VCP2_VCPSTAT0_EMUHALT_SHIFT  (0x00000006u)
#define CSL_VCP2_VCPSTAT0_EMUHALT_RESETVAL (0x00000000u)

/*----EMUHALT Tokens----*/
#define CSL_VCP2_VCPSTAT0_EMUHALT_NO     (0x00000000u)
#define CSL_VCP2_VCPSTAT0_EMUHALT_YES    (0x00000001u)

#define CSL_VCP2_VCPSTAT0_OFFUL_MASK     (0x00000020u)
#define CSL_VCP2_VCPSTAT0_OFFUL_SHIFT    (0x00000005u)
#define CSL_VCP2_VCPSTAT0_OFFUL_RESETVAL (0x00000000u)

/*----OFFUL Tokens----*/
#define CSL_VCP2_VCPSTAT0_OFFUL_NO       (0x00000000u)
#define CSL_VCP2_VCPSTAT0_OFFUL_YES      (0x00000001u)

#define CSL_VCP2_VCPSTAT0_IFEMP_MASK     (0x00000010u)
#define CSL_VCP2_VCPSTAT0_IFEMP_SHIFT    (0x00000004u)
#define CSL_VCP2_VCPSTAT0_IFEMP_RESETVAL (0x00000000u)

/*----IFEMP Tokens----*/
#define CSL_VCP2_VCPSTAT0_IFEMP_NO       (0x00000000u)
#define CSL_VCP2_VCPSTAT0_IFEMP_YES      (0x00000001u)

#define CSL_VCP2_VCPSTAT0_WIC_MASK       (0x00000008u)
#define CSL_VCP2_VCPSTAT0_WIC_SHIFT      (0x00000003u)
#define CSL_VCP2_VCPSTAT0_WIC_RESETVAL   (0x00000000u)

/*----WIC Tokens----*/
#define CSL_VCP2_VCPSTAT0_WIC_NO         (0x00000000u)
#define CSL_VCP2_VCPSTAT0_WIC_YES        (0x00000001u)

#define CSL_VCP2_VCPSTAT0_ERR_MASK       (0x00000004u)
#define CSL_VCP2_VCPSTAT0_ERR_SHIFT      (0x00000002u)
#define CSL_VCP2_VCPSTAT0_ERR_RESETVAL   (0x00000000u)

/*----ERR Tokens----*/
#define CSL_VCP2_VCPSTAT0_ERR_NO         (0x00000000u)
#define CSL_VCP2_VCPSTAT0_ERR_YES        (0x00000001u)

#define CSL_VCP2_VCPSTAT0_RUN_MASK       (0x00000002u)
#define CSL_VCP2_VCPSTAT0_RUN_SHIFT      (0x00000001u)
#define CSL_VCP2_VCPSTAT0_RUN_RESETVAL   (0x00000000u)

/*----RUN Tokens----*/
#define CSL_VCP2_VCPSTAT0_RUN_NO         (0x00000000u)
#define CSL_VCP2_VCPSTAT0_RUN_YES        (0x00000001u)

#define CSL_VCP2_VCPSTAT0_PAUSE_MASK     (0x00000001u)
#define CSL_VCP2_VCPSTAT0_PAUSE_SHIFT    (0x00000000u)
#define CSL_VCP2_VCPSTAT0_PAUSE_RESETVAL (0x00000000u)

/*----PAUSE Tokens----*/
#define CSL_VCP2_VCPSTAT0_PAUSE_NO       (0x00000000u)
#define CSL_VCP2_VCPSTAT0_PAUSE_YES      (0x00000001u)

#define CSL_VCP2_VCPSTAT0_RESETVAL       (0x00000000u)

/* VCPSTAT1 */

#define CSL_VCP2_VCPSTAT1_NSYMOF_MASK    (0xFFFF0000u)
#define CSL_VCP2_VCPSTAT1_NSYMOF_SHIFT   (0x00000010u)
#define CSL_VCP2_VCPSTAT1_NSYMOF_RESETVAL (0x00000000u)

#define CSL_VCP2_VCPSTAT1_NSYMIF_MASK    (0x0000FFFFu)
#define CSL_VCP2_VCPSTAT1_NSYMIF_SHIFT   (0x00000000u)
#define CSL_VCP2_VCPSTAT1_NSYMIF_RESETVAL (0x00000000u)

#define CSL_VCP2_VCPSTAT1_RESETVAL       (0x00000000u)

/* VCPERR */

#define CSL_VCP2_VCPERR_E_SYMR_MASK      (0x00000040u)
#define CSL_VCP2_VCPERR_E_SYMR_SHIFT     (0x00000006u)
#define CSL_VCP2_VCPERR_E_SYMR_RESETVAL  (0x00000000u)

/*----E_SYMR Tokens----*/
#define CSL_VCP2_VCPERR_E_SYMR_NO        (0x00000000u)
#define CSL_VCP2_VCPERR_E_SYMR_YES       (0x00000001u)

#define CSL_VCP2_VCPERR_E_SYMX_MASK      (0x00000020u)
#define CSL_VCP2_VCPERR_E_SYMX_SHIFT     (0x00000005u)
#define CSL_VCP2_VCPERR_E_SYMX_RESETVAL  (0x00000000u)

/*----E_SYMX Tokens----*/
#define CSL_VCP2_VCPERR_E_SYMX_NO        (0x00000000u)
#define CSL_VCP2_VCPERR_E_SYMX_YES       (0x00000001u)

#define CSL_VCP2_VCPERR_MAXMINERR_MASK   (0x00000010u)
#define CSL_VCP2_VCPERR_MAXMINERR_SHIFT  (0x00000004u)
#define CSL_VCP2_VCPERR_MAXMINERR_RESETVAL (0x00000000u)

/*----MAXMINERR Tokens----*/
#define CSL_VCP2_VCPERR_MAXMINERR_NO     (0x00000000u)
#define CSL_VCP2_VCPERR_MAXMINERR_YES    (0x00000001u)

#define CSL_VCP2_VCPERR_FCTLERR_MASK     (0x00000008u)
#define CSL_VCP2_VCPERR_FCTLERR_SHIFT    (0x00000003u)
#define CSL_VCP2_VCPERR_FCTLERR_RESETVAL (0x00000000u)

/*----FCTLERR Tokens----*/
#define CSL_VCP2_VCPERR_FCTLERR_NO       (0x00000000u)
#define CSL_VCP2_VCPERR_FCTLERR_YES      (0x00000001u)

#define CSL_VCP2_VCPERR_FTLERR_MASK      (0x00000004u)
#define CSL_VCP2_VCPERR_FTLERR_SHIFT     (0x00000002u)
#define CSL_VCP2_VCPERR_FTLERR_RESETVAL  (0x00000000u)

/*----FTLERR Tokens----*/
#define CSL_VCP2_VCPERR_FTLERR_NO        (0x00000000u)
#define CSL_VCP2_VCPERR_FTLERR_YES       (0x00000001u)

#define CSL_VCP2_VCPERR_TBNAERR_MASK     (0x00000002u)
#define CSL_VCP2_VCPERR_TBNAERR_SHIFT    (0x00000001u)
#define CSL_VCP2_VCPERR_TBNAERR_RESETVAL (0x00000000u)

/*----TBNAERR Tokens----*/
#define CSL_VCP2_VCPERR_TBNAERR_NO       (0x00000000u)
#define CSL_VCP2_VCPERR_TBNAERR_YES      (0x00000001u)

#define CSL_VCP2_VCPERR_ERROR_MASK       (0x00000001u)
#define CSL_VCP2_VCPERR_ERROR_SHIFT      (0x00000000u)
#define CSL_VCP2_VCPERR_ERROR_RESETVAL   (0x00000000u)

/*----ERROR Tokens----*/
#define CSL_VCP2_VCPERR_ERROR_NO         (0x00000000u)
#define CSL_VCP2_VCPERR_ERROR_YES        (0x00000001u)

#define CSL_VCP2_VCPERR_RESETVAL         (0x00000000u)

/* VCPEMU */

#define CSL_VCP2_VCPEMU_SOFT_MASK        (0x00000002u)
#define CSL_VCP2_VCPEMU_SOFT_SHIFT       (0x00000001u)
#define CSL_VCP2_VCPEMU_SOFT_RESETVAL    (0x00000000u)

/*----SOFT Tokens----*/
#define CSL_VCP2_VCPEMU_SOFT_HALT_DEFAULT (0x00000000u)
#define CSL_VCP2_VCPEMU_SOFT_HALT_FRAMEEND (0x00000001u)

#define CSL_VCP2_VCPEMU_FREE_MASK        (0x00000001u)
#define CSL_VCP2_VCPEMU_FREE_SHIFT       (0x00000000u)
#define CSL_VCP2_VCPEMU_FREE_RESETVAL    (0x00000000u)

/*----FREE Tokens----*/
#define CSL_VCP2_VCPEMU_FREE_SOFT_EN     (0x00000000u)
#define CSL_VCP2_VCPEMU_FREE_FREE        (0x00000001u)

#define CSL_VCP2_VCPEMU_RESETVAL         (0x00000000u)

/**************************************************************************\
* Field Definition Macros for registers accessible through EDMA bus
\**************************************************************************/

/* VCPIC0 */

#define CSL_VCP2_VCPIC0_POLY3_MASK       (0xFF000000u)
#define CSL_VCP2_VCPIC0_POLY3_SHIFT      (0x00000018u)
#define CSL_VCP2_VCPIC0_POLY3_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPIC0_POLY2_MASK       (0x00FF0000u)
#define CSL_VCP2_VCPIC0_POLY2_SHIFT      (0x00000010u)
#define CSL_VCP2_VCPIC0_POLY2_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPIC0_POLY1_MASK       (0x0000FF00u)
#define CSL_VCP2_VCPIC0_POLY1_SHIFT      (0x00000008u)
#define CSL_VCP2_VCPIC0_POLY1_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPIC0_POLY0_MASK       (0x000000FFu)
#define CSL_VCP2_VCPIC0_POLY0_SHIFT      (0x00000000u)
#define CSL_VCP2_VCPIC0_POLY0_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPIC0_RESETVAL         (0x00000000u)

/* VCPIC1 */

#define CSL_VCP2_VCPIC1_YAMEN_MASK       (0x10000000u)
#define CSL_VCP2_VCPIC1_YAMEN_SHIFT      (0x0000001Cu)
#define CSL_VCP2_VCPIC1_YAMEN_RESETVAL   (0x00000000u)

/*----YAMEN Tokens----*/
#define CSL_VCP2_VCPIC1_YAMEN_DISABLE    (0x00000000u)
#define CSL_VCP2_VCPIC1_YAMEN_ENABLE     (0x00000001u)

#define CSL_VCP2_VCPIC1_YAMT_MASK        (0x0FFF0000u)
#define CSL_VCP2_VCPIC1_YAMT_SHIFT       (0x00000010u)
#define CSL_VCP2_VCPIC1_YAMT_RESETVAL    (0x00000000u)

#define CSL_VCP2_VCPIC1_RESETVAL         (0x00000000u)

/* VCPIC2 */

#define CSL_VCP2_VCPIC2_R_MASK           (0xFFFF0000u)
#define CSL_VCP2_VCPIC2_R_SHIFT          (0x00000010u)
#define CSL_VCP2_VCPIC2_R_RESETVAL       (0x00000000u)

#define CSL_VCP2_VCPIC2_FL_MASK          (0x0000FFFFu)
#define CSL_VCP2_VCPIC2_FL_SHIFT         (0x00000000u)
#define CSL_VCP2_VCPIC2_FL_RESETVAL      (0x00000000u)

#define CSL_VCP2_VCPIC2_RESETVAL         (0x00000000u)

/* VCPIC3 */

#define CSL_VCP2_VCPIC3_OUT_ORDER_MASK   (0x10000000u)
#define CSL_VCP2_VCPIC3_OUT_ORDER_SHIFT  (0x0000001Cu)
#define CSL_VCP2_VCPIC3_OUT_ORDER_RESETVAL (0x00000000u)

/*----OUT_ORDER Tokens----*/
#define CSL_VCP2_VCPIC3_OUT_ORDER_LSB    (0x00000000u)
#define CSL_VCP2_VCPIC3_OUT_ORDER_MSB    (0x00000001u)

#define CSL_VCP2_VCPIC3_ITBEN_MASK       (0x01000000u)
#define CSL_VCP2_VCPIC3_ITBEN_SHIFT      (0x00000018u)
#define CSL_VCP2_VCPIC3_ITBEN_RESETVAL   (0x00000000u)

/*----ITBEN Tokens----*/
#define CSL_VCP2_VCPIC3_ITBEN_DISABLE    (0x00000000u)
#define CSL_VCP2_VCPIC3_ITBEN_ENABLE     (0x00000001u)

#define CSL_VCP2_VCPIC3_ITBI_MASK        (0x00FF0000u)
#define CSL_VCP2_VCPIC3_ITBI_SHIFT       (0x00000010u)
#define CSL_VCP2_VCPIC3_ITBI_RESETVAL    (0x00000000u)

#define CSL_VCP2_VCPIC3_C_MASK           (0x0000FFFFu)
#define CSL_VCP2_VCPIC3_C_SHIFT          (0x00000000u)
#define CSL_VCP2_VCPIC3_C_RESETVAL       (0x00000000u)

#define CSL_VCP2_VCPIC3_RESETVAL         (0x00000000u)

/* VCPIC4 */

#define CSL_VCP2_VCPIC4_IMINS_MASK       (0x1FFF0000u)
#define CSL_VCP2_VCPIC4_IMINS_SHIFT      (0x00000010u)
#define CSL_VCP2_VCPIC4_IMINS_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPIC4_IMAXS_MASK       (0x00001FFFu)
#define CSL_VCP2_VCPIC4_IMAXS_SHIFT      (0x00000000u)
#define CSL_VCP2_VCPIC4_IMAXS_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPIC4_RESETVAL         (0x00000000u)

/* VCPIC5 */

#define CSL_VCP2_VCPIC5_SDHD_MASK        (0x80000000u)
#define CSL_VCP2_VCPIC5_SDHD_SHIFT       (0x0000001Fu)
#define CSL_VCP2_VCPIC5_SDHD_RESETVAL    (0x00000000u)

/*----SDHD Tokens----*/
#define CSL_VCP2_VCPIC5_SDHD_HARD        (0x00000000u)
#define CSL_VCP2_VCPIC5_SDHD_SOFT        (0x00000001u)

#define CSL_VCP2_VCPIC5_OUTF_MASK        (0x40000000u)
#define CSL_VCP2_VCPIC5_OUTF_SHIFT       (0x0000001Eu)
#define CSL_VCP2_VCPIC5_OUTF_RESETVAL    (0x00000000u)

/*----OUTF Tokens----*/
#define CSL_VCP2_VCPIC5_OUTF_NO          (0x00000000u)
#define CSL_VCP2_VCPIC5_OUTF_YES         (0x00000001u)

#define CSL_VCP2_VCPIC5_TB_MASK          (0x30000000u)
#define CSL_VCP2_VCPIC5_TB_SHIFT         (0x0000001Cu)
#define CSL_VCP2_VCPIC5_TB_RESETVAL      (0x00000000u)

/*----TB Tokens----*/
#define CSL_VCP2_VCPIC5_TB_NO            (0x00000000u)
#define CSL_VCP2_VCPIC5_TB_TAIL          (0x00000001u)
#define CSL_VCP2_VCPIC5_TB_CONV          (0x00000002u)
#define CSL_VCP2_VCPIC5_TB_MIX           (0x00000003u)

#define CSL_VCP2_VCPIC5_SYMR_MASK        (0x01F00000u)
#define CSL_VCP2_VCPIC5_SYMR_SHIFT       (0x00000014u)
#define CSL_VCP2_VCPIC5_SYMR_RESETVAL    (0x00000000u)

#define CSL_VCP2_VCPIC5_SYMX_MASK        (0x000F0000u)
#define CSL_VCP2_VCPIC5_SYMX_SHIFT       (0x00000010u)
#define CSL_VCP2_VCPIC5_SYMX_RESETVAL    (0x00000000u)

#define CSL_VCP2_VCPIC5_IMAXI_MASK       (0x000000FFu)
#define CSL_VCP2_VCPIC5_IMAXI_SHIFT      (0x00000000u)
#define CSL_VCP2_VCPIC5_IMAXI_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPIC5_RESETVAL         (0x00000000u)

/* VCPOUT0 */

#define CSL_VCP2_VCPOUT0_FMINS_MASK      (0x1FFF0000u)
#define CSL_VCP2_VCPOUT0_FMINS_SHIFT     (0x00000010u)
#define CSL_VCP2_VCPOUT0_FMINS_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCPOUT0_FMAXS_MASK      (0x00001FFFu)
#define CSL_VCP2_VCPOUT0_FMAXS_SHIFT     (0x00000000u)
#define CSL_VCP2_VCPOUT0_FMAXS_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCPOUT0_RESETVAL        (0x00000000u)

/* VCPOUT1 */

#define CSL_VCP2_VCPOUT1_YAM_MASK        (0x00010000u)
#define CSL_VCP2_VCPOUT1_YAM_SHIFT       (0x00000010u)
#define CSL_VCP2_VCPOUT1_YAM_RESETVAL    (0x00000000u)

/*----YAM Tokens----*/
#define CSL_VCP2_VCPOUT1_YAM_NO          (0x00000000u)
#define CSL_VCP2_VCPOUT1_YAM_YES         (0x00000001u)

#define CSL_VCP2_VCPOUT1_FMAXI_MASK      (0x000000FFu)
#define CSL_VCP2_VCPOUT1_FMAXI_SHIFT     (0x00000000u)
#define CSL_VCP2_VCPOUT1_FMAXI_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCPOUT1_RESETVAL        (0x00000000u)

/* VCPWBM */

#define CSL_VCP2_VCPWBM_WRITE_MASK       (0xFFFFFFFFu)
#define CSL_VCP2_VCPWBM_WRITE_SHIFT      (0x00000000u)
#define CSL_VCP2_VCPWBM_WRITE_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCPWBM_RESETVAL         (0x00000000u)

/* VCPRDECS */

#define CSL_VCP2_VCPRDECS_READ_MASK      (0xFFFFFFFFu)
#define CSL_VCP2_VCPRDECS_READ_SHIFT     (0x00000000u)
#define CSL_VCP2_VCPRDECS_READ_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCPRDECS_RESETVAL       (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif
