/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v2/include/dsk6455m.h                            $
* $Revision:: 5                                                               $
* $Date:: 6/29/06 9:44a                                                       $
*
* DESCRIPTION: This file contains DSK6455 board initialization and CPLD 
*              register access functions.
*
* 
* NOTES :  BSL Version# 3.24 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef DSK6455M_
#define DSK6455M_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <std.h>
#include <sys.h>

/* Initialize all board APIs */
void DSK6455M_init();

Uint32 HimalayaM_PLL1_Init (Uint32 multi_val);

Uint32 HimalayaM_PLL2_Init ();

/* Spin in a delay loop for delay iterations */
void DSK6455M_wait(Uint32 delay);

/* Spin in a delay loop for delay microseconds */
void DSK6455M_waitusec(Uint32 delay);

#ifdef __cplusplus
}
#endif

#endif
