/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_opencodec.c      $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:   DSK6455_AIC23_openCodec() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_aic23.h"

/*
 *  ======== DSK6455_AIC23_openCodec ========
 *  Open the codec and return a codec handle
 */
DSK6455_AIC23_CodecHandle DSK6455_AIC23_openCodec(Int16 id, DSK6455_AIC23_Config *Config)
{
    /* Reset the AIC23 */ 
    DSK6455_AIC23_rset( 0, DSK6455_AIC23_RESET, 0 );

    /* Configure the rest of the AIC23 registers */ 
    DSK6455_AIC23_config( 0, Config );

    MCBSP_SPCR = 0x00000000;
    DSK6455_waitusec(100);

    /* Config MCBSP */
    MCBSP_PCR = 0x00000003;
    MCBSP_RCR = 0x00000140;
    MCBSP_XCR = 0x00000140;
    MCBSP_SRGR = 0x00000000;
    MCBSP_SPCR = 0x00010001;

    return TRUE;
}

