/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_registers.c      $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:  DSK6455_AIC23_rset() and DSK6455_AIC23_rget() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_aic23.h"

/* Internal codec state used to simulate read/write functionality */
static DSK6455_AIC23_Config codecstate = DSK6455_AIC23_DEFAULTCONFIG;

/*
 *  ======== DSK6455_AIC23_rset ========
 *  Set codec register regnum to value regval
 */
void DSK6455_AIC23_rset(DSK6455_AIC23_CodecHandle hCodec, Uint16 regnum, Uint16 regval)
{
    Uint16 buf = ( ( regval & 0x00FF ) << 8 ) | ( regnum << 1 ) | ( regval >> 8 );
    DSK6455_I2C_write( DSK6455_AIC23_I2CADDR, ( Uint8* )&buf, 2 );
    if ( regnum < DSK6455_AIC23_NUMREGS )
        codecstate.regs[regnum] = regval;
}

/*
 *  ======== DSK6455_AIC23_rget ========
 *  Return value of codec register regnum
 */
Uint16 DSK6455_AIC23_rget(DSK6455_AIC23_CodecHandle hCodec, Uint16 regnum)
{
    if (regnum < DSK6455_AIC23_NUMREGS)
        return codecstate.regs[regnum];
    else
        return 0;
}

/*
 *  ======== DSK6455_AIC23_config ========
 *  Set the default codec register config values
 */
void DSK6455_AIC23_config(DSK6455_AIC23_CodecHandle hCodec, DSK6455_AIC23_Config *Config)
{
    int i;

    /* Use default parameters if none are given */
    if (Config == NULL)
        Config = &codecstate;

    /* Reset the codec */
    DSK6455_AIC23_rset(hCodec, 15, 0);

    /* Assign each register */
    for (i = 0; i < DSK6455_AIC23_NUMREGS; i++)
    {
        if (i != 6)
            DSK6455_AIC23_rset(hCodec, i, Config -> regs[i]);
    }
    DSK6455_AIC23_rset(hCodec, 6, Config -> regs[6]);
}
