/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_setfreq.c        $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:  DSK6455_AIC23_setFreq() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include <dsk6455.h>
#include <dsk6455_aic23.h>

/* Table of supported frequencies */
static Uint16 freqtable[] =
{
    DSK6455_AIC23_FREQ_8KHZ,  0x07,  // 8000 Hz
    DSK6455_AIC23_FREQ_16KHZ, 0x2d,  // 16000 Hz
    DSK6455_AIC23_FREQ_24KHZ, 0x21,  // 24000 Hz
    DSK6455_AIC23_FREQ_32KHZ, 0x0d,  // 32000 Hz
    DSK6455_AIC23_FREQ_44KHZ, 0x11,  // 44100 Hz
    DSK6455_AIC23_FREQ_48KHZ, 0x01,  // 48000 Hz
    DSK6455_AIC23_FREQ_96KHZ, 0x0f,  // 96000 Hz
    0, 0                              // End of table
};

/*
 *  ======== DSK6455_AIC23_setFreq ========
 *  Set the codec sample rate frequency
 */
void DSK6455_AIC23_setFreq(DSK6455_AIC23_CodecHandle hCodec, Uint32 freq)
{
    Uint16 regval, curr;

    /* Calculate codec clock control setting, assume USB Mode (12MHz) */
    /* regval will contain CLKIN,SR3..SR0,BOSR */
    curr = 0;
    while(1)
    {
        /* Do nothing if frequency doesn't match */
        if (freqtable[curr] == 0)
            return;

        /* Check for match */
        if (freqtable[curr] == freq)
        {
            regval = freqtable[curr + 1];
            break;
        }

        /* Set up for next pair */
        curr += 2;
    }

    /* Write to codec register */
    DSK6455_AIC23_rset(hCodec, DSK6455_AIC23_SAMPLERATE,
        (DSK6455_AIC23_rget(hCodec, DSK6455_AIC23_SAMPLERATE) & 0xff81) |
        ((regval & 0x3f) << 1));
}
