/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_dip.c                  $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION: DIP switch module for the DSK6416.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include <dsk6455.h>
#include <dsk6455_dip.h>

void DSK6455_DIP_init()
{
}

Uint32 DSK6455_DIP_get(Uint32 dipNum)
{
    /* Check bounds for dipNum */
    if (dipNum >= 4)
        return (Uint32)-1;
        
    /* Read DIP switch */
    if ((DSK6455_rget(DSK6455_USER_REG) & (0x10 << dipNum)) == 0)
        return 0;
    else
        return 1;
}

