/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_eeprom.c               $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION: EEPROM implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_eeprom.h"

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  DSK6455_EEPROM_init( )                                               *
 *                                                                          *
 *      Initialize the I2C EEPROM                                           *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 DSK6455_EEPROM_init( )
{
    return DSK6455_I2C_init( );
}

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  DSK6455_EEPROM_read( src, dst, length )                              *
 *                                                                          *
 *      Read from the I2C EEPROM                                            *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 DSK6455_EEPROM_read( Uint32 src, Uint32 dst, Uint32 length )
{
    Int16 retcode = 0;
    Uint8 addr[2];

    addr[0] = src >> 8;         // HIGH address
    addr[1] = src & 0xFF;       // LOW address

    /* Send 16-bit address */
    retcode |= DSK6455_I2C_write( EEPROM_I2C_ADDR, addr, 2 );

    DSK6455_waitusec( 11000 );

    /* Read data */
    retcode |= DSK6455_I2C_read ( EEPROM_I2C_ADDR, ( Uint8* )dst, length );

    /* Need to wait at least 11ms */
    DSK6455_waitusec(11000);

    return retcode;
}

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  DSK6455_EEPROM_write( src, dst, length )                             *
 *                                                                          *
 *      Write to the I2C EEPROM                                             *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 DSK6455_EEPROM_write( Uint32 src, Uint32 dst, Uint32 length )
{
    Int16 retcode = 0;
    Uint16 i;
    Uint8 buffer[64 + 2];
    Uint8* psrc8 = ( Uint8* )src;
    Uint8* pdst8;

    buffer[0] = dst >> 8;       // HIGH address
    buffer[1] = dst & 0xFF;     // LOW address

    /* Fill in data */
    pdst8 = &buffer[2];
    for ( i = 0 ; i < length ; i++ )
        *pdst8++ = *psrc8++;

    /* Send 16-bit address and data */
    retcode |= DSK6455_I2C_write( EEPROM_I2C_ADDR, buffer, 2 + length );

    /* Need to wait at least 10ms */
    DSK6455_waitusec(11000);

    return retcode;
}
