/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2013-2014
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
 Example to show the initialization of Multicore Navigator for GE test 
 on KeyStone device
* =============================================================================
 *  Revision History
 *  ===============
 *  June 11, 2013 Brighton Feng   File Created
 *  October, 2014 Brighton Feng   Updated for K2E/K2L
 * ============================================================================
 */
#ifndef _GE_PKTDMA_INIT_H_
#define _GE_PKTDMA_INIT_H_

#include "K2_Navigator_init_drv.h"

//MAX accumulation page size
#define MAX_ACCU_PAGE_SIZE 	64

/*size of descriptor must be multiple of 16B*/
#define GE_DESCRIPTOR_SIZE 		(128)

/*the linking RAM entry number for each descriptor region 
must be power of 2, and no less than 32.
Actual descriptor number may less than linking entry size, this may 
leave hole in linking RAM*/
#define MSMC_RAM_HOST_DESCRIPTOR_NUM 		(128)
#define MSMC_RAM_HOST_DESC_LINK_ENTRY_NUM 	(128)
#define DDR_HOST_DESCRIPTOR_NUM 		(768)
#define DDR_HOST_DESC_LINK_ENTRY_NUM 	(1024)

#define MSMC_RAM_PACKET_BUFFER_SIZE0 	(1536)
#define MSMC_RAM_PACKET_BUFFER_SIZE1 	(10*1024)
#define MSMC_RAM_SIZE0_PKT_BUF_NUM 		(64)
#define MSMC_RAM_SIZE1_PKT_BUF_NUM 		(32+8)
#define MSMC_RAM_SIZE1_DESC_START_IDX 	(MSMC_RAM_SIZE0_PKT_BUF_NUM)

#define DDR_PACKET_BUFFER_SIZE0 	(1536)
#define DDR_PACKET_BUFFER_SIZE1 	(10*1024)
#define DDR_SIZE0_PKT_BUF_NUM 		(512)
#define DDR_SIZE1_PKT_BUF_NUM 		(256)
#define DDR_SIZE1_DESC_START_IDX 	(DDR_SIZE0_PKT_BUF_NUM)

#define TEST_QUEUE_BASE 			2048

#define MSMC_RAM_HOST_SIZE0_FDQ     (TEST_QUEUE_BASE+0)
#define MSMC_RAM_HOST_SIZE1_FDQ     (TEST_QUEUE_BASE+1)
#define DDR_HOST_SIZE0_FDQ          (TEST_QUEUE_BASE+4)
#define DDR_HOST_SIZE1_FDQ          (TEST_QUEUE_BASE+5)
#define RECLAMATION_QUEUE           (TEST_QUEUE_BASE+6)

/*pend queue 658~665 are used*/
#define GE_RX_DST_Q         (658)

/*in this example, a ethernet port corresponds to a packetDMA flow, 
and corresponds to memory buffer type*/
#define GE_RX_FLOW_PORT0_DDR 		0
#define GE_RX_FLOW_PORT1_MSMC_RAM 	1
#define GE_RX_FLOW_PORT2_DDR 		2
#define GE_RX_FLOW_PORT3_DDR 		3
#define GE_RX_FLOW_PORT4_DDR 		4
#define GE_RX_FLOW_PORT5_DDR 		5
#define GE_RX_FLOW_PORT6_DDR 		6
#define GE_RX_FLOW_PORT7_DDR 		7

/*Descriptor accumulation buffer*/
extern Uint32 uiaDescriptorAccumulationList[][(MAX_ACCU_PAGE_SIZE+1)*2];
extern Uint32 uiAccPingPong[];
extern Uint32 uiAccPageSize[];

extern Uint32 uiUsedDescRegionNum;
extern Uint32 uiInitialHostFdqNum;
extern Uint32 uiUsedRxFlowNum;

extern Uint8 packetBuffer_MSMC_RAM_Size0[MSMC_RAM_SIZE0_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE0];
extern Uint8 packetBuffer_MSMC_RAM_Size1[MSMC_RAM_SIZE1_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE1];

extern Uint8 packetBuffer_DDR_Size0[DDR_SIZE0_PKT_BUF_NUM][DDR_PACKET_BUFFER_SIZE0];
extern Uint8 packetBuffer_DDR_Size1[DDR_SIZE1_PKT_BUF_NUM][DDR_PACKET_BUFFER_SIZE1];

extern char * FDQ_str[];
extern char * flow_str[];

/*must be called after GE PSC enabled*/
extern void GE_PktDMA_init();
extern void GE_QMSS_Accumulation_config(Uint8 channel, Uint16 pageSize,
	Qmss_AccPacingMode  interruptPacingMode);

/*check the descriptors in the queue, for debug purpose*/
extern void GE_Check_Free_Queues();
extern void GE_Check_TxRx_Queues(Bool bRecycle);
extern void GE_Check_Queue(Uint32 uiQIdx, Uint32 uiExpectEntryCount);

#endif
