/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2013
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
Example to show the usage and performance of GE on KeyStone device.
VLAN, CPTS, PA, SA are not covered in this example.
This example can run on single Device with internal loopback.
With two Devices, external loopback or transfer between two Devices can be tested. 
  You should run this project on second Device firstly and then the first Device
* =============================================================================
 *  Revision History
 *  ===============
 *  June 10, 2013 Brighton Feng   File Created
 *  October 20, 2014 Brighton Feng   Updated for K2E/K2L
 *  November 23, 2014 Brighton Feng   Support each port run in different mode
 * ============================================================================
 */
#ifndef _GE_TEST_H_
#define _GE_TEST_H_

#include <tistdtypes.h>

typedef enum
{
	/*Device0 MAC TX -> Device0 MAC RX*/
	GE_TEST_EMAC_LOOPBACK= 0,

	/*Device0 SGMII TX-> Device0 SGMII RX*/
	GE_TEST_SGMII_LOOPBACK,

	/*Device0 SERDES TX -> Device0 SERDES RX*/
	GE_TEST_SERDES_LOOPBACK,

	/*Device0 TX -> Device1 RX FIFO-> Device1 TX FIFO-> Device0 RX*/
	GE_TEST_EXTERNAL_FIFO_LOOPBACK,

	/*Device0 TX -> Device0 RX (or PC)*/
	GE_TEST_DEVICE0_TO_DEVICE1
}GE_Test_Data_Path;

//The port connection state for the test
typedef enum
{
	GE_PORT_NOT_USED = 0, 	//disable the port

	/*the port is not connnected, can only run internal loopback test*/
	GE_PORT_NO_CONNECT, 	//recieve all packets to port 0

	/*the port connect through SGMII to another device*/
	GE_PORT_SGMII_CONNECT, 	//recieve all packets to port 0

	/*The port connect through PHY and ethernet cable to another device*/
	GE_PORT_CABLE_CONNECT 	
}GE_Port_Connection;

//ALE Test mode
typedef enum
{
	ALE_BYPASS = 0, 	//bypass ALE
	ALE_RECEIVE_ALL
}ALE_Test_Mode;

typedef struct
{
	Ethernet_Mode 		ethernet_mode;
	GE_Port_Connection 	port_connect;
    Ethernet_Loopback_Mode loopback_mode;
}GE_Port_Config;

extern GE_Port_Config ge_port_cfg[];
extern unsigned long long Source_MAC_address[];
extern unsigned long long Dest_MAC_address[];
extern unsigned long long Tx_FDQ[];


Bool Port_OK(Uint32 uiPortNum);

#endif
