/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2014
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
 Examples to show pacekt processing for GE
* =============================================================================
 *  Revision History
 *  ===============
 *  November 23, 2014 Brighton Feng   File Created
 * ============================================================================
 */
#ifndef _GE_LOOPBACK_TEST_H_
#define _GE_LOOPBACK_TEST_H_

#include <tistdtypes.h>

typedef struct 
{
	/*this is source queue number*/
	Uint32 sourceQueue; 	

	/*port number also determines destination flow, and destination MAC address
	different flow to different memory in this test*/
	Uint32 portNum;

	/*number of packets to be sent. Because of limited descriptors for this test,
	this number should not greater than 16 for signle port test.
	For multiport test, total packet number should not greater than 16*/
	Uint8 numPackets;

	Uint32 payloadNumBytes;

}GE_Transfer_Param;

typedef struct 
{
	GE_Transfer_Param tx_param;
	Uint32 uiTxCCNT;
	Uint32 uiNumRxPackets;
	Uint32 uiRxCCNT;
	Uint32 uiThroughput_Mbps;
}GE_port_test_stat;

//data will be filled and verfied at the header of test packet
typedef struct 
{
	Uint16 portNum;
	Uint16 payloadNumBytes;
}GE_Test_Packet_Header;

/*test GE transfer through single port*/
extern void GE_transfer_packets(Uint32 uiTX_port_mask, 
	Uint32 uiNumPackets, Uint32 uiPacketBytes);

extern void Rx_packet_process(Uint32 uiPort, Uint32 uiDescriptor);

extern void GE_Test_init();

//show the result information of the last test interation
extern int GE_Test_result();

#endif

