/*  ============================================================================
 *     Copyright (C) 2011, 2012, 2013 Texas Instruments Incorporated.       *
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
Example to show the performance of CPU access memory through HyperLink.
1. HyperLink throughput test with CPU; 
2. latency of memory access through HyperLink with CPU
* =============================================================================
 *  Revision History
 *  ===============
 *  Nov 5, 2011 Brighton Feng   File Created
 * ============================================================================
 */

#include <stdio.h>
#include "K2_common.h"
#include "common_test.h"
#include "CPU_access_test.h"
#include "HyperLink_test.h"

#define 	COPY_TEST_SIZE 				(64*1024)
#define 	Local_MSMC_RAMTEST_ADDR		(0xC080000)

#define 	LL2_LOAD_STORE_SIZE 		(256*1024)
#define 	MSMC_RAM_LOAD_STORE_SIZE 	(1024*1024)
#define 	DDR_LOAD_STORE_SIZE 		(16*1024*1024)

void MemCopyTest(Uint32 uiAddress, Uint32 uiByteCnt, char * memory_type)
{
	CP15_DCacheCleanInvalidate();

	MemCopy8Test((unsigned long long *)Local_MSMC_RAMTEST_ADDR,(unsigned long long *)uiAddress, uiByteCnt, " local MSRAM", memory_type);
	MemCopy8Test((unsigned long long *)uiAddress,(unsigned long long *)Local_MSMC_RAMTEST_ADDR, uiByteCnt, memory_type, " local MSRAM");
	MemCopy8Test((unsigned long long *)uiAddress,(unsigned long long *)(uiAddress+uiByteCnt), uiByteCnt, memory_type, memory_type);
}

void LoadStoreCycleTest(Uint32 uiAddress, Uint32 uiByteCnt, char * mem_type)
{
	CP15_DCacheCleanInvalidate();

	LDRDTest(uiAddress, uiByteCnt, mem_type);
	STRDTest(uiAddress, uiByteCnt, mem_type);
}

void HyperLink_CPU_test(HyperlinkRemoteTestAddress* remoteAddr)
{
	MemCopyTest(remoteAddr->LL2_DST_ADDR, COPY_TEST_SIZE, "  remote LL2");
	MemCopyTest(remoteAddr->MSMC_RAM_DST_ADDR, COPY_TEST_SIZE, "remote MSRAM");
	MemCopyTest(remoteAddr->DDRA_DST_ADDR, COPY_TEST_SIZE, "remote DDR3A");
	if(remoteAddr->DDRB_DST_ADDR)
		MemCopyTest(remoteAddr->DDRB_DST_ADDR, COPY_TEST_SIZE, "remote DDR3B");
#if 1
	LoadStoreCycleTest(remoteAddr->LL2_DST_ADDR, LL2_LOAD_STORE_SIZE, "  remote LL2");
	LoadStoreCycleTest(remoteAddr->MSMC_RAM_DST_ADDR, MSMC_RAM_LOAD_STORE_SIZE, "remote MSRAM");
	LoadStoreCycleTest(remoteAddr->DDRA_DST_ADDR, DDR_LOAD_STORE_SIZE, "remote DDR3A");
	if(remoteAddr->DDRB_DST_ADDR)
		LoadStoreCycleTest(remoteAddr->DDRB_DST_ADDR, DDR_LOAD_STORE_SIZE, "remote DDR3B");
#endif
}
