/****************************************************************************/
/*  K2.lds                                                         */
/*  Copyright (c) 2014  Texas Instruments Incorporated                      */
/*  Author: Brighton Feng                                                   */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the GCC compiler    */
/*                 and running the resulting .out file on an K2.            */
/****************************************************************************/

MEMORY
{
    MSMC_SRAM : 	o = 0x0C000000,  l = 0x00080000  /* use 512KB Shared Memory SRAM */
}

/* Linker script to place sections and symbol values.
 * It references following symbols, which must be defined in code:
 *   Entry : Entry of reset handler
 * 
 * It defines following symbols, which code can use without definition:
 *   __exidx_start
 *   __exidx_end
 *   __etext
 *   __data_start__
 *   __preinit_array_start
 *   __preinit_array_end
 *   __init_array_start
 *   __init_array_end
 *   __fini_array_start
 *   __fini_array_end
 *   __data_end__
 *   __bss_start__
 *   __bss_end__
 *   __end__
 *   end
 *   __HeapLimit
 *   __HeapBase		- To be compatible with Linaro's semihosting support 
 *   __StackLimit
 *   __StackTop
 *   __StackBase	- To be compatible with Linaro's semihosting support 
 *   __stack
 */

ENTRY(Entry)

SECTIONS
{
    .rsthand :
    {
        . = ALIGN(0x10000);
        KEEP(*(.isr_vector))
        *startup_A15.o (.text)
    } > MSMC_SRAM
	
	. = ALIGN(4);
	.text :
	{
		*(.text*)

		KEEP(*(.init))
		KEEP(*(.fini))

		/* .ctors */
		*crtbegin.o(.ctors)
		*crtbegin?.o(.ctors)
		*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors)
		*(SORT(.ctors.*))
		*(.ctors)

		/* .dtors */
 		*crtbegin.o(.dtors)
 		*crtbegin?.o(.dtors)
 		*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors)
 		*(SORT(.dtors.*))
 		*(.dtors)

		*(.rodata*)

		KEEP(*(.eh_frame*))
	} > MSMC_SRAM

	.ARM.extab : 
	{
		*(.ARM.extab* .gnu.linkonce.armextab.*)
	} > MSMC_SRAM

	__exidx_start = .;
	.ARM.exidx :
	{
		*(.ARM.exidx* .gnu.linkonce.armexidx.*)
	} > MSMC_SRAM
	__exidx_end = .;

		
	.data :
	{
		. = ALIGN(4);
		__data_start__ = .;
		*(vtable)
		*(.data*)

		. = ALIGN(4);
		/* preinit data */
		PROVIDE_HIDDEN (__preinit_array_start = .);
		KEEP(*(.preinit_array))
		PROVIDE_HIDDEN (__preinit_array_end = .);

		. = ALIGN(4);
		/* init data */
		PROVIDE_HIDDEN (__init_array_start = .);
		KEEP(*(SORT(.init_array.*)))
		KEEP(*(.init_array))
		PROVIDE_HIDDEN (__init_array_end = .);


		. = ALIGN(4);
		/* finit data */
		PROVIDE_HIDDEN (__fini_array_start = .);
		KEEP(*(SORT(.fini_array.*)))
		KEEP(*(.fini_array))
		PROVIDE_HIDDEN (__fini_array_end = .);

		. = ALIGN(4);
		/* All data end */
		__data_end__ = .;

	} > MSMC_SRAM

	.bss :
	{
		. = ALIGN(4);
		__bss_start__ = .;
		*(.bss*)
		*(COMMON)
		__bss_end__ = .;
	} > MSMC_SRAM
	
	.heap :
	{
		. = ALIGN(4);
		__end__ = .;
		end = __end__;
		/* The line below created to be compatible with Linaro's semihosting support */
		__HeapBase = __end__; 
		*(.heap*)
		. = . + HEAPSIZE;
		__HeapLimit = .; 
	} > MSMC_SRAM

	/* .stack section doesn't contain any symbols. It is only
	 * used for linker to calculate size of stack sections, and assign
	 * values to stack symbols later */
	.stack :
	{
		. = ALIGN(4);
		__StackLimit = . ;
		*(.stack*)
		. = . + STACKSIZE;
		__StackTop = . ;
		/* The line below created to be compatible with Linaro's semihosting support */
		__StackBase = . ;
		*(special_modes_stack*);
	} > MSMC_SRAM
	PROVIDE(__stack = __StackTop);
}
/**************************************************************************/
