/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2014
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
file name: Mem_Access_performance.h
Example to show the performance of CPU and EDMA access memory on KeyStone CPU
* =============================================================================
 *  Revision History
 *  ===============
 *  July 31, 2014 Brighton Feng   file created
 * ============================================================================
 */
#ifndef _MEMORY_PERFORMANCE_TEST_H
#define _MEMORY_PERFORMANCE_TEST_H

#include <cslr_device.h>

/*define the memory space used for test.
The size of the test space must >=256KB
The space will be split into 8 blocks, different MMU propoties will be 
assigned for each block for test.
The DDR test space must be >=16MB to avoid 3rd-level MMU table*/
#define MSMC_RAM_TEST_BASE_ADDR 	0x0C080000
#define MSMC_RAM_TEST_SPACE_SIZE 	0x00100000
#define MSMC_RAM_TEST_BLOCK_SIZE 	(MSMC_RAM_TEST_SPACE_SIZE/4)
#define DDR3A_TEST_BASE_ADDR 		0x80000000
#define DDR3A_TEST_SPACE_SIZE 		0x20000000
#define DDR3A_TEST_BLOCK_SIZE 		(DDR3A_TEST_SPACE_SIZE/4)
#define DDR3A_TEST_PHYSICAL_BASE_ADDR 	0x800000000ULL
#if (2==CSL_DDR3_PER_CNT)
#define DDR3B_TEST_BASE_ADDR 		0x60000000
#define DDR3B_TEST_SPACE_SIZE 		0x20000000
#define DDR3B_TEST_BLOCK_SIZE 		(DDR3B_TEST_SPACE_SIZE/4)
#endif
#ifdef CSL_OSR_DATA 	//for K2L only
#define OSR_TEST_BASE_ADDR 			CSL_OSR_DATA
#define OSR_TEST_SPACE_SIZE 		0x00100000
#define OSR_TEST_BLOCK_SIZE 		(OSR_TEST_SPACE_SIZE/4)
#endif

/*MSMC RAM and OSR test block is less than 2MB (2nd-level MMU entry), so 3rd-level
MMU table is required to assign different propoties to test blocks.
Here calculate the max number of 3rd-level tables may required.*/
#define NUM_MSMC_RAM_3RD_LEVEL_TABLES 	(MSMC_RAM_TEST_SPACE_SIZE/0x200000+2)
#ifdef CSL_OSR_DATA 	//for K2L only
#define NUM_OSR_3RD_LEVEL_TABLES 		(OSR_TEST_SPACE_SIZE/0x200000+2)
#else
#define NUM_OSR_3RD_LEVEL_TABLES 		0
#endif

#define DDR_PAGE_SIZE 			(8*1024)

/*a memory block for test*/
typedef struct
{
    unsigned int uiAddress;
    unsigned int uiByteCnt;
	char *       type; //a string describe the type (MMU propoties) of the memory block
}Memory_Test_Block;

/*list of all memory blocks for test.
load store latency test will be done on each blocks.
memory copy test will be done inside each block and between all blocks.*/
extern Memory_Test_Block mem_test_blocks[];
extern unsigned int num_mem_test_blocks; 

extern void	MemoryCopyTest();
extern void	LoadStoreCycleTest();
extern void	edma_test();

#endif
