
/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2013
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
Example to show the initialization of Multicore Navigator on KeyStone device
* =============================================================================
 *  Revision History
 *  ===============
 *  Feb 5, 2013 Brighton Feng   File Created
 * ============================================================================
 */

#include <stdio.h>
#include <string.h>
#include <ti/csl/cslr_device.h>
#include <ti/csl/csl_qm_queue.h>
#include "MNav_init.h"
#ifdef _BIG_ENDIAN
#ifdef ACC_48_CHANNEL
#include <ti/drv/qmss/firmware/acc48_be_bin.h>
#else
#include <ti/drv/qmss/firmware/acc32_be_bin.h>
#include <ti/drv/qmss/firmware/acc16_be_bin.h>
#endif
#else
#ifdef ACC_48_CHANNEL
#include <ti/drv/qmss/firmware/acc48_le_bin.h>
#else
#include <ti/drv/qmss/firmware/acc32_le_bin.h>
#include <ti/drv/qmss/firmware/acc16_le_bin.h>
#endif
#endif

#if (TOTAL_LINKING_ENTRY_SIZE>NUM_INTERNAL_LINKING_ENTRY)
unsigned long long linkingRAM1[LINKING_RAM1_SIZE] __attribute__ ((aligned (16), section ("QMSS_Data.linkingRAM1")));
#endif
Uint8 hostDescriptor_MSMC_RAM[MSMC_RAM_HOST_DESCRIPTOR_NUM][HOST_DESCRIPTOR_SIZE] __attribute__ ((aligned (128), section ("QMSS_Data.Descriptor_MSMC_RAM")));

Uint8 packetBuffer_MSMC_RAM_Size0[MSMC_RAM_SIZE0_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE0] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));
Uint8 packetBuffer_MSMC_RAM_Size1[MSMC_RAM_SIZE1_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE1] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));
Uint8 packetBuffer_MSMC_RAM_Size2[MSMC_RAM_SIZE2_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE2] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));
Uint8 packetBuffer_MSMC_RAM_Size3[MSMC_RAM_SIZE3_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE3] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));

Uint8 monoDescriptor_MSMC_RAM[MSMC_RAM_MONO_DESCRIPTOR_NUM][MSMC_RAM_MONO_DESCRIPTOR_SIZE] __attribute__ ((aligned (128), section ("QMSS_Data.Descriptor_MSMC_RAM")));

Uint8 hostDescriptor_DDR[DDR_HOST_DESCRIPTOR_NUM][HOST_DESCRIPTOR_SIZE] __attribute__ ((aligned (128), section ("QMSS_Data.Descriptor_DDR")));

Uint8 packetBuffer_DDR_Size0[DDR_SIZE0_PKT_BUF_NUM][DDR_PACKET_BUFFER_SIZE0] __attribute__ ((section ("PacketData.buffer_DDR")));
Uint8 packetBuffer_DDR_Size1[DDR_SIZE1_PKT_BUF_NUM][DDR_PACKET_BUFFER_SIZE1] __attribute__ ((section ("PacketData.buffer_DDR")));
Uint8 packetBuffer_DDR_Size2[DDR_SIZE2_PKT_BUF_NUM][DDR_PACKET_BUFFER_SIZE2] __attribute__ ((section ("PacketData.buffer_DDR")));
Uint8 packetBuffer_DDR_Size3[DDR_SIZE3_PKT_BUF_NUM][DDR_PACKET_BUFFER_SIZE3] __attribute__ ((section ("PacketData.buffer_DDR")));

Uint8 monoDescriptor_DDR[DDR_MONO_DESCRIPTOR_NUM][DDR_MONO_DESCRIPTOR_SIZE] __attribute__ ((aligned (128), section ("QMSS_Data.Descriptor_DDR")));

/* descriptor memory region configuration.
descriptor Base address must be specified in ascending order,
no overlap is allowed between regions*/
Qmss_DescMemRegionCfg descMemRegionsCfg[]=
{   /*The base address of descriptor region     Size of each descriptor     Number of descriptors 
                                                16*n,1<=n<=8192             2^(5+n), 0<=n<=15*/
    {(Uint32)monoDescriptor_MSMC_RAM,           MSMC_RAM_MONO_DESCRIPTOR_SIZE,MSMC_RAM_MONO_DESC_LINK_ENTRY_NUM},/*Monolithic descriptor in MSMC RAM*/
    {(Uint32)hostDescriptor_MSMC_RAM,           HOST_DESCRIPTOR_SIZE,       MSMC_RAM_HOST_DESC_LINK_ENTRY_NUM},/*host descriptor in MSMC RAM*/
    {(Uint32)hostDescriptor_DDR,                HOST_DESCRIPTOR_SIZE,       DDR_HOST_DESC_LINK_ENTRY_NUM},/*host descriptor in DDR*/
    {(Uint32)monoDescriptor_DDR,                DDR_MONO_DESCRIPTOR_SIZE,   DDR_MONO_DESC_LINK_ENTRY_NUM}/*Monolithic descriptor in DDR*/
};

FreeHostQueueCfg freeHostQueueCfgTable[]=
{
    /*free queue number*/       /*address of first descriptor*/                                         /*size of descriptor*/  /*number of descriptors*/   /*address of first buffer*/                     /*size of each buffer*/ 
    {MSMC_RAM_HOST_SIZE0_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[0][0],                                      HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE0_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size0,                 MSMC_RAM_PACKET_BUFFER_SIZE0},/*MSMC RAM Size0 host Free Descriptor Queue*/
    {MSMC_RAM_HOST_SIZE1_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_SIZE1_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE1_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size1,                 MSMC_RAM_PACKET_BUFFER_SIZE1},/*MSMC RAM Size1 host Free Descriptor Queue*/
    {MSMC_RAM_HOST_SIZE2_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_SIZE2_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE2_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size2,                 MSMC_RAM_PACKET_BUFFER_SIZE2},/*MSMC RAM Size2 host Free Descriptor Queue*/
    {MSMC_RAM_HOST_SIZE3_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_SIZE3_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE3_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size3,                 MSMC_RAM_PACKET_BUFFER_SIZE3},/*MSMC RAM Size3 host Free Descriptor Queue*/
    {MSMC_RAM_NO_BUF_HOST_FDQ,       (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_NO_BUF_DESC_START_IDX][0],              HOST_DESCRIPTOR_SIZE,   MSMC_RAM_NO_BUF_DESCRIPTOR_NUM,  0,                                              0},         /*MSMC RAM no buffer host Free Descriptor Queue*/

    {DDR_HOST_SIZE0_FDQ,        (Uint32)&hostDescriptor_DDR[0][0],                                      HOST_DESCRIPTOR_SIZE,   DDR_SIZE0_PKT_BUF_NUM,      (Uint32)packetBuffer_DDR_Size0,                 DDR_PACKET_BUFFER_SIZE0},/*DDR Size0 host Free Descriptor Queue*/
    {DDR_HOST_SIZE1_FDQ,        (Uint32)&hostDescriptor_DDR[DDR_SIZE1_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   DDR_SIZE1_PKT_BUF_NUM,      (Uint32)packetBuffer_DDR_Size1,                 DDR_PACKET_BUFFER_SIZE1},/*DDR Size1 host Free Descriptor Queue*/
    {DDR_HOST_SIZE2_FDQ,        (Uint32)&hostDescriptor_DDR[DDR_SIZE2_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   DDR_SIZE2_PKT_BUF_NUM,      (Uint32)packetBuffer_DDR_Size2,                 DDR_PACKET_BUFFER_SIZE2},/*DDR Size2 host Free Descriptor Queue*/
    {DDR_HOST_SIZE3_FDQ,        (Uint32)&hostDescriptor_DDR[DDR_SIZE3_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   DDR_SIZE3_PKT_BUF_NUM,      (Uint32)packetBuffer_DDR_Size3,                 DDR_PACKET_BUFFER_SIZE3},/*DDR Size3 host Free Descriptor Queue*/
    {DDR_NO_BUF_HOST_FDQ,       (Uint32)&hostDescriptor_DDR[DDR_NO_BUF_DESC_START_IDX][0],              HOST_DESCRIPTOR_SIZE,   DDR_NO_BUF_DESCRIPTOR_NUM,  0,                                              0}          /*DDR no buffer host Free Descriptor Queue*/
};

FreeMonoQueueCfg freeMonoQueueCfgTable[]=
{
    /*free queue number*/       /*address of first descriptor*/                                 /*size of descriptor*/      /*number of descriptors*/
    {MSMC_RAM_MONOLITHIC_FDQ,        (Uint32)monoDescriptor_MSMC_RAM,                                     MSMC_RAM_MONO_DESCRIPTOR_SIZE,    MSMC_RAM_MONO_DESCRIPTOR_NUM},/*MSMC RAM monolithic Free Descriptor Queue*/
    {DDR_MONO_LINK_RAM0_FDQ,    (Uint32)monoDescriptor_DDR,                                     DDR_MONO_DESCRIPTOR_SIZE,   DDR_MONO_LINKING_RAM0_DESC_NUM},/*DDR monolithic Free Descriptor Queue*/
    {DDR_MONO_LINK_RAM1_FDQ,    (Uint32)&monoDescriptor_DDR[DDR_MONO_LINKING_RAM0_DESC_NUM][0], DDR_MONO_DESCRIPTOR_SIZE,   DDR_MONO_LINKING_RAM1_DESC_NUM}/*DDR monolithic Free Descriptor Queue*/
};

PktDma_RxFlowCfg flowCfgTable[]=
{
    /*dest_qnum*/   /*sop_offset*/  /*ps_loc*/  /*desc_type*/   /*error retry*/ /*psinfo*/  /*einfo*/   /*size_thresh0(1,2)_en*/    /*size_thresh0*/    /*size_thresh1*/    /*size_thresh2*/    /*fdq0_sz0_qnum*/       /*fdq0_sz1_qnum*/           /*fdq0_sz2_qnum*/           /*fdq0_sz3_qnum*/           /*fdq1_qnum*/           /*fdq2_qnum*/           /*fdq3_qnum*/   /*dest_tag_lo*/ /*dest_tag_hi*/ /*src_tag_lo*/  /*src_tag_hi*/  /*dest_tag_lo_sel*/ /*dest_tag_hi_sel*/ /*src_tag_lo_sel*/  /*src_tag_hi_sel*/
    {PKT_DMA_TEST_DST_Q,    0,      0,      Cppi_DescType_HOST,     0,          0,          0,          1, 1, 1,    MSMC_RAM_PACKET_BUFFER_SIZE0, MSMC_RAM_PACKET_BUFFER_SIZE1, MSMC_RAM_PACKET_BUFFER_SIZE2, MSMC_RAM_HOST_SIZE0_FDQ,          MSMC_RAM_HOST_SIZE1_FDQ,     MSMC_RAM_HOST_SIZE2_FDQ,         MSMC_RAM_HOST_SIZE3_FDQ,         MSMC_RAM_HOST_SIZE3_FDQ,     MSMC_RAM_HOST_SIZE3_FDQ,     MSMC_RAM_HOST_SIZE3_FDQ,         0,      0,              0,              0,              0,                  0,                  0,                  0},
    {PKT_DMA_TEST_DST_Q,    0,      0,      Cppi_DescType_HOST,     0,          0,          0,          1, 1, 1,    DDR_PACKET_BUFFER_SIZE0, DDR_PACKET_BUFFER_SIZE1, DDR_PACKET_BUFFER_SIZE2, DDR_HOST_SIZE0_FDQ,          DDR_HOST_SIZE1_FDQ,     DDR_HOST_SIZE2_FDQ,         DDR_HOST_SIZE3_FDQ,         DDR_HOST_SIZE3_FDQ,     DDR_HOST_SIZE3_FDQ,     DDR_HOST_SIZE3_FDQ,         0,      0,              0,              0,              0,                  0,                  0,                  0},
    {PKT_DMA_TEST_DST_Q,    12,     0,  Cppi_DescType_MONOLITHIC,   0,          0,          0,          0, 0, 0,                    0,                  0,                  0,                  MSMC_RAM_MONOLITHIC_FDQ,     0,                          0,                          0,                          MSMC_RAM_MONOLITHIC_FDQ,     MSMC_RAM_MONOLITHIC_FDQ,     MSMC_RAM_MONOLITHIC_FDQ,         0,      0,              0,              0,              0,                  0,                  0,                  0},
    {PKT_DMA_TEST_DST_Q,    12,     0,  Cppi_DescType_MONOLITHIC,   0,          0,          0,          0, 0, 0,                    0,                  0,                  0,                  DDR_MONOLITHIC_FDQ,     0,                          0,                          0,                          DDR_MONOLITHIC_FDQ,     DDR_MONOLITHIC_FDQ,     DDR_MONOLITHIC_FDQ,         0,      0,              0,              0,              0,                  0,                  0,                  0}
};

Uint32 uiUsedDescRegionNum;
Uint32 uiInitialHostFdqNum;
Uint32 uiInitialMonoFdqNum;
Uint32 uiUsedRxFlowNum;

void QMSS_init()
{
	uiUsedDescRegionNum= sizeof(descMemRegionsCfg)/sizeof(Qmss_DescMemRegionCfg);
	uiInitialHostFdqNum= sizeof(freeHostQueueCfgTable)/sizeof(FreeHostQueueCfg);
	uiInitialMonoFdqNum= sizeof(freeMonoQueueCfgTable)/sizeof(FreeMonoQueueCfg);

	/*-----------------Queue manager configuration--------------------*/
	/*Two QM can be configured differently (split mode),
	for this test, the are configured same (shared mode)*/
#if (TOTAL_LINKING_ENTRY_SIZE>QMSS_NUM_INTERNAL_LINKING_ENTRY)
	K2_QMSS_Linking_RAM_init(QMSS_QM1, QMSS_INTERNAL_LINKING_RAM_ADDRESS, 
		QMSS_NUM_INTERNAL_LINKING_ENTRY, (Uint32)linkingRAM1, LINKING_RAM1_SIZE);
#if defined(DEVICE_K2H) || defined(DEVICE_K2K)
	K2_QMSS_Linking_RAM_init(QMSS_QM2, QMSS_INTERNAL_LINKING_RAM_ADDRESS, 
		QMSS_NUM_INTERNAL_LINKING_ENTRY, (Uint32)linkingRAM1, LINKING_RAM1_SIZE);
#endif
#else
	K2_QMSS_Linking_RAM_init(QMSS_QM1, QMSS_INTERNAL_LINKING_RAM_ADDRESS, 
		QMSS_NUM_INTERNAL_LINKING_ENTRY, 0, 0);
#if defined(DEVICE_K2H) || defined(DEVICE_K2K)
	K2_QMSS_Linking_RAM_init(QMSS_QM2, QMSS_INTERNAL_LINKING_RAM_ADDRESS, 
		QMSS_NUM_INTERNAL_LINKING_ENTRY, 0, 0);
#endif
#endif

	K2_QMSS_Descriptor_Regions_init(QMSS_QM1, 0, 0, uiUsedDescRegionNum, descMemRegionsCfg);
#if defined(DEVICE_K2H) || defined(DEVICE_K2K)
	K2_QMSS_Descriptor_Regions_init(QMSS_QM2, 0, 0, uiUsedDescRegionNum, descMemRegionsCfg);
#endif

	/*-----------------QMSS queue initialization------------------------*/
	KeyStone_Host_Descriptor_Queues_init(freeHostQueueCfgTable, uiInitialHostFdqNum);
	KeyStone_Mono_Descriptor_Queues_init(freeMonoQueueCfgTable, uiInitialMonoFdqNum);

	/*-----------------QMSS PDSP fireware configuration------------------*/
#ifdef _BIG_ENDIAN
#ifdef ACC_48_CHANNEL
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP1, &acc48_be, sizeof(acc48_be));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP3, &acc48_be, sizeof(acc48_be));
#else
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP1, &acc32_be, sizeof(acc32_be));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP2, &acc16_be, sizeof(acc16_be));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP3, &acc32_be, sizeof(acc32_be));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP4, &acc16_be, sizeof(acc16_be));
#endif
#else
#ifdef ACC_48_CHANNEL
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP1, &acc48_le, sizeof(acc48_le));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP3, &acc48_le, sizeof(acc48_le));
#else
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP1, &acc32_le, sizeof(acc32_le));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP2, &acc16_le, sizeof(acc16_le));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP3, &acc32_le, sizeof(acc32_le));
	KeyStone_Qmss_Download_Firmware(QMSS_PDSP4, &acc16_le, sizeof(acc16_le));
#endif
#endif
	gpQM_INTD_regs[0]->STATUS_CLR_REG0= 0xFFFFFFFF;
	gpQM_INTD_regs[0]->STATUS_CLR_REG1= 0xFFFF;
	gpQM_INTD_regs[1]->STATUS_CLR_REG0= 0xFFFFFFFF;
	gpQM_INTD_regs[1]->STATUS_CLR_REG1= 0xFFFF;

	KeyStone_Qmss_Config_Reclaim_Queue (QMSS_PDSP1, RECLAMATION_QUEUE);

}


void QMSS_PktDMA_init()
{
	int i;
	
	uiUsedRxFlowNum= sizeof(flowCfgTable)/sizeof(PktDma_RxFlowCfg);

	/*-----------------QMSS PktDMA configuration------------------*/
	KeyStone_pktDma_Global_Control(gpQM_DMA_CfgRegs[0], 256, 5, 5);

	for(i=0; i<8; i++)
	{
		KeyStone_pktDma_RxCh_enable(gpQM_DMA_RxChCfgRegs[0], i);
		KeyStone_pktDma_TxCh_enable(gpQM_DMA_TxChCfgRegs[0], i);
	}
	
	KeyStone_pktDma_configureRxFlow(
		gpQM_DMA_RxFlowCfgRegs[0]->RX_FLOW_CONFIG, flowCfgTable, uiUsedRxFlowNum);

#if defined(DEVICE_K2H) || defined(DEVICE_K2K)
	KeyStone_pktDma_Global_Control(gpQM_DMA_CfgRegs[1], 256, 5, 5);

	for(i=0; i<8; i++)
	{
		KeyStone_pktDma_RxCh_enable(gpQM_DMA_RxChCfgRegs[1], i);
		KeyStone_pktDma_TxCh_enable(gpQM_DMA_TxChCfgRegs[1], i);
	}
	
	KeyStone_pktDma_configureRxFlow(
		gpQM_DMA_RxFlowCfgRegs[1]->RX_FLOW_CONFIG, flowCfgTable, uiUsedRxFlowNum);
#endif
}

#ifdef CSL_SRIO_CFG_PKTDMA_GLOBAL_CFG_REGS
void SRIO_PktDMA_init()
{
	uiUsedRxFlowNum= sizeof(flowCfgTable)/sizeof(PktDma_RxFlowCfg);

	/*-----------------SRIO PktDMA configuration------------------*/
	KeyStone_pktDma_Global_Control(gpSRIO_DMA_CfgRegs, 256, 5, 5);
	//set SRIO PktDMA in loopback mode for test
	gpSRIO_DMA_CfgRegs->EMULATION_CONTROL_REG= 
		(Uint32)(1<<CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_LOOPBACK_EN_SHIFT);

	KeyStone_pktDma_RxCh_enable(gpSRIO_DMA_RxChCfgRegs, 0);
	KeyStone_pktDma_TxCh_enable(gpSRIO_DMA_TxChCfgRegs, 0);

	KeyStone_pktDma_configureRxFlow(
		gpSRIO_DMA_RxFlowCfgRegs->RX_FLOW_CONFIG, flowCfgTable, uiUsedRxFlowNum);
}
#endif

void PA_PktDMA_init()
{
	uiUsedRxFlowNum= sizeof(flowCfgTable)/sizeof(PktDma_RxFlowCfg);

	/*-----------------PA PktDMA configuration------------------*/
	KeyStone_pktDma_Global_Control(gpNetCP_DMA_CfgRegs, 256, 5, 5);
	//set PA PktDMA in loopback mode for test
	gpNetCP_DMA_CfgRegs->EMULATION_CONTROL_REG= 
		(Uint32)(1<<CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_LOOPBACK_EN_SHIFT);

	KeyStone_pktDma_RxCh_enable(gpNetCP_DMA_RxChCfgRegs, 0);
	KeyStone_pktDma_TxCh_enable(gpNetCP_DMA_TxChCfgRegs, 0);

	KeyStone_pktDma_configureRxFlow(
		gpNetCP_DMA_RxFlowCfgRegs->RX_FLOW_CONFIG, flowCfgTable, uiUsedRxFlowNum);

}

/*check the descriptors in the queue, for debug purpose*/
void checkQueues()
{
	int i, j;
	Uint32 uiQuNum, uiEntryCount, uiDescriptorNumber, uiDescriptor;
	
	for(i=0; i<uiInitialHostFdqNum; i++)
	{
		uiQuNum= freeHostQueueCfgTable[i].uiFreeQuNum;
		uiEntryCount= gpQueueStatusConfigRegs[uiQuNum].REG_A_EntryCount;
		uiDescriptorNumber= freeHostQueueCfgTable[i].uiDescriptorNumber;
		if(uiEntryCount!= uiDescriptorNumber)
		{
			printf("number of descriptors in host queue %d changed from %d to %d\n", 
				uiQuNum, uiDescriptorNumber, uiEntryCount);

			//printf some descriptors in the queue
			for(j= 0; j<uiEntryCount&&j<10; j++)
			{	
				uiDescriptor= gpQueueManageVBUSM[uiQuNum].REG_D_Descriptor;
				printf("0x%x->", uiDescriptor);
				gpQueueManageVBUSM[uiQuNum].REG_D_Descriptor= uiDescriptor;
			}
			if(j<10)
				puts("NULL");
			else
				puts("...");
		}
	}

	for(i=0; i<uiInitialMonoFdqNum; i++)
	{
		uiQuNum= freeMonoQueueCfgTable[i].uiFreeQuNum;
		uiEntryCount= gpQueueStatusConfigRegs[uiQuNum].REG_A_EntryCount;
		uiDescriptorNumber= freeMonoQueueCfgTable[i].uiDescriptorNumber;
		if(uiEntryCount!= uiDescriptorNumber)
		{	
			printf("number of descriptors in mono queue %d changed from %d to %d\n", 
				uiQuNum, uiDescriptorNumber, uiEntryCount);

			//printf some descriptors in the queue
			for(j= 0; j<uiEntryCount&&j<10; j++)
			{	
				uiDescriptor= gpQueueManageVBUSM[uiQuNum].REG_D_Descriptor;
				printf("0x%x->", uiDescriptor);
				gpQueueManageVBUSM[uiQuNum].REG_D_Descriptor= uiDescriptor;
			}
			if(j<10)
				puts("NULL");
			else
				puts("...");
		}
	}

}



