
/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2013
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
Example to show the initialization of Multicore Navigator on KeyStone device
* =============================================================================
 *  Revision History
 *  ===============
 *  Feb 5, 2013 Brighton Feng   File Created
 * ============================================================================
 */
#ifndef _MULTICORE_NAVIGATOR_INIT_H_
#define _MULTICORE_NAVIGATOR_INIT_H_

#include "K2_Navigator_init_drv.h"

#define ACC_48_CHANNEL

/*size of descriptor must be multiple of 16B*/
#define HOST_DESCRIPTOR_SIZE 		32
#define MSMC_RAM_MONO_DESCRIPTOR_SIZE 	(8192+16)
#define DDR_MONO_DESCRIPTOR_SIZE 	(8192+16)

/*the linking RAM entry size for each descriptor region 
must be power of 2, and no less than 32.
Actual descriptor number may less than linking entry size, this may 
leave hole in linking RAM*/
#define MSMC_RAM_HOST_DESCRIPTOR_NUM 		(2*1024)
#define MSMC_RAM_HOST_DESC_LINK_ENTRY_NUM 	(2*1024)
#define MSMC_RAM_MONO_DESCRIPTOR_NUM 		(32)
#define MSMC_RAM_MONO_DESC_LINK_ENTRY_NUM 	(256) 	/*only 32 of 256 is used for the 32 descriptors*/
#define DDR_HOST_DESCRIPTOR_NUM 		(QMSS_NUM_INTERNAL_LINKING_ENTRY/2)
#define DDR_HOST_DESC_LINK_ENTRY_NUM 	(QMSS_NUM_INTERNAL_LINKING_ENTRY/2)
#define DDR_MONO_DESCRIPTOR_NUM 		(QMSS_NUM_INTERNAL_LINKING_ENTRY/2)
#define DDR_MONO_DESC_LINK_ENTRY_NUM 	(QMSS_NUM_INTERNAL_LINKING_ENTRY/2)

#define TOTAL_LINKING_ENTRY_SIZE 		(MSMC_RAM_HOST_DESC_LINK_ENTRY_NUM+\
										MSMC_RAM_MONO_DESC_LINK_ENTRY_NUM+\
										DDR_HOST_DESC_LINK_ENTRY_NUM+\
										DDR_MONO_DESC_LINK_ENTRY_NUM)

/*there is only 32K or 16K entries in QMSS internal linking RAM. So, part of 
DDR mono descriptors will use external linking RAM in this test*/
#if (TOTAL_LINKING_ENTRY_SIZE>QMSS_NUM_INTERNAL_LINKING_ENTRY)
#define LINKING_RAM1_SIZE 				(TOTAL_LINKING_ENTRY_SIZE-QMSS_NUM_INTERNAL_LINKING_ENTRY)
#define DDR_MONO_LINKING_RAM1_DESC_NUM 	LINKING_RAM1_SIZE
#define DDR_MONO_LINKING_RAM0_DESC_NUM 	(DDR_MONO_DESCRIPTOR_NUM-DDR_MONO_LINKING_RAM1_DESC_NUM)
#endif

#define MSMC_RAM_PACKET_BUFFER_SIZE0 	(256)
#define MSMC_RAM_PACKET_BUFFER_SIZE1 	(1024)
#define MSMC_RAM_PACKET_BUFFER_SIZE2 	(4*1024)
#define MSMC_RAM_PACKET_BUFFER_SIZE3 	(8*1024)
#define MSMC_RAM_SIZE0_PKT_BUF_NUM 		(512)
#define MSMC_RAM_SIZE1_PKT_BUF_NUM 		(128)
#define MSMC_RAM_SIZE2_PKT_BUF_NUM 		(32)
#define MSMC_RAM_SIZE3_PKT_BUF_NUM 		(16)
#define MSMC_RAM_SIZE1_DESC_START_IDX 	(MSMC_RAM_SIZE0_PKT_BUF_NUM)
#define MSMC_RAM_SIZE2_DESC_START_IDX 	(MSMC_RAM_SIZE1_DESC_START_IDX+MSMC_RAM_SIZE1_PKT_BUF_NUM)
#define MSMC_RAM_SIZE3_DESC_START_IDX 	(MSMC_RAM_SIZE2_DESC_START_IDX+MSMC_RAM_SIZE2_PKT_BUF_NUM)
#define MSMC_RAM_NO_BUF_DESC_START_IDX 	(MSMC_RAM_SIZE3_DESC_START_IDX+MSMC_RAM_SIZE3_PKT_BUF_NUM)
#define MSMC_RAM_NO_BUF_DESCRIPTOR_NUM 	(MSMC_RAM_HOST_DESCRIPTOR_NUM-MSMC_RAM_NO_BUF_DESC_START_IDX)

#define DDR_PACKET_BUFFER_SIZE0 	(256)
#define DDR_PACKET_BUFFER_SIZE1 	(2*1024)
#define DDR_PACKET_BUFFER_SIZE2 	(16*1024)
#define DDR_PACKET_BUFFER_SIZE3 	(128*1024)
#define DDR_SIZE0_PKT_BUF_NUM 		(1024)
#define DDR_SIZE1_PKT_BUF_NUM 		(256)
#define DDR_SIZE2_PKT_BUF_NUM 		(64)
#define DDR_SIZE3_PKT_BUF_NUM 		(16)
#define DDR_SIZE1_DESC_START_IDX 	(DDR_SIZE0_PKT_BUF_NUM)
#define DDR_SIZE2_DESC_START_IDX 	(DDR_SIZE1_DESC_START_IDX+DDR_SIZE1_PKT_BUF_NUM)
#define DDR_SIZE3_DESC_START_IDX 	(DDR_SIZE2_DESC_START_IDX+DDR_SIZE2_PKT_BUF_NUM)
#define DDR_NO_BUF_DESC_START_IDX 	(DDR_SIZE3_DESC_START_IDX+DDR_SIZE3_PKT_BUF_NUM)
#define DDR_NO_BUF_DESCRIPTOR_NUM 	(DDR_HOST_DESCRIPTOR_NUM-DDR_NO_BUF_DESC_START_IDX)

#define TEST_QUEUE_BASE 			2000

#define MSMC_RAM_MONOLITHIC_FDQ 	(TEST_QUEUE_BASE+0 )
#define MSMC_RAM_HOST_SIZE0_FDQ 	(TEST_QUEUE_BASE+1 )
#define MSMC_RAM_HOST_SIZE1_FDQ 	(TEST_QUEUE_BASE+2 )
#define MSMC_RAM_HOST_SIZE2_FDQ 	(TEST_QUEUE_BASE+3 )
#define MSMC_RAM_HOST_SIZE3_FDQ 	(TEST_QUEUE_BASE+4 )
#define MSMC_RAM_NO_BUF_HOST_FDQ 	(TEST_QUEUE_BASE+5 )

#define DDR_MONOLITHIC_FDQ 			(TEST_QUEUE_BASE+6 )
#define DDR_MONO_LINK_RAM0_FDQ 		(DDR_MONOLITHIC_FDQ)
#define DDR_HOST_SIZE0_FDQ 			(TEST_QUEUE_BASE+7 )
#define DDR_HOST_SIZE1_FDQ 			(TEST_QUEUE_BASE+8 )
#define DDR_HOST_SIZE2_FDQ 			(TEST_QUEUE_BASE+9 )
#define DDR_HOST_SIZE3_FDQ 			(TEST_QUEUE_BASE+10)
#define DDR_NO_BUF_HOST_FDQ 		(TEST_QUEUE_BASE+11)

#define PKT_DMA_TEST_DST_Q 			(TEST_QUEUE_BASE+36)
#define EMPTY_FDQ 					(TEST_QUEUE_BASE+37)
#define EMPTY_DST_Q 				(TEST_QUEUE_BASE+38)

#define RECLAMATION_QUEUE 			(TEST_QUEUE_BASE+39)

#define DDR_MONO_LINK_RAM1_FDQ 		(TEST_QUEUE_BASE+40)

#define RX_FLOW_MSMC_RAM_HOST 			0
#define RX_FLOW_DDR_HOST 			1
#define RX_FLOW_MSMC_RAM_MONO 			2
#define RX_FLOW_DDR_MONO 			3

extern Uint32 uiUsedDescRegionNum;
extern Uint32 uiInitialHostFdqNum;
extern Uint32 uiInitialMonoFdqNum;
extern Uint32 uiUsedRxFlowNum;

extern void QMSS_init();
extern void QMSS_PktDMA_init();
extern void PA_PktDMA_init();
#ifdef CSL_SRIO_CFG_PKTDMA_GLOBAL_CFG_REGS
extern void SRIO_PktDMA_init();
#endif
extern void checkQueues();

#endif
