/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2013
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
Example to show the performance of Multicore Navigator on KeyStone device
* =============================================================================
 *  Revision History
 *  ===============
 *  Feb 5, 2013 Brighton Feng   File Created
 * ============================================================================
 */
#ifndef _MULTICORE_NAVIGATOR_TEST_H_
#define _MULTICORE_NAVIGATOR_TEST_H_

#include "MNav_init.h"

#define TEST_DESC_BUF_SIZE 	(1024)

/*note: proxy registers can not be used for pop*/
extern void QueuePushCycleTest(QueueManageRegs * queueRegs, Uint32 uiDescriptorNumber,
	QueueManageRegs * queuePopRegs);
	
/*note: proxy registers can not be used for pop*/
extern void QueuePopCycleTest(QueueManageRegs * queueRegs, Uint32 uiDescriptorNumber);

extern void QueuePushToPopDelayTest(QueueManageRegs * queueRegs, Uint32 uiDescriptorNumber);

extern void QueuePushToAccumulationDelayTest(Qmss_IntdId intd_id,
	Uint32 uiSrcQu);

extern void QueuePushToPendInterruptDelayTest(QueueManageRegs * queueRegs);

extern void QueueReclamationDelayTest(Uint32 uiSrcQu);

extern void PktDmaThroughput(Uint32 uiSrcQuNum, Uint32 uiTxQuNum, 
	Uint32 uiFlowID, Uint32 uiByteCount, Uint32 uiNumCh);

#endif
