/*  ============================================================================
 *     Copyright (C) 2011, 2012, 2013 Texas Instruments Incorporated.       *
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @n This is an example to benchmark the EDMA3 performance
 */
/* =============================================================================
 *  Revision History
 *  ===============
 *  June 23, 2013 Brighton Feng   File Created
 * ============================================================================
 */

#include <stdio.h>
#include <csl_edma3.h>
#include <cslr_device.h>
#include "K2_common.h"
#include "common_test.h"
#include "PCIE_test.h"

#define 	A_COUNT 	(16*1024)
#define 	B_COUNT 	(4)

#define 	Local_LL2_TEST_SRC (0x10820000)
#define 	Local_LL2_TEST_DST (0x10840000)

#define 	Local_MSMC_RAMTEST_SRC 	(0xC080000)
#define 	Local_MSMC_RAMTEST_DST 	(0xC0C0000)

#define 	Local_DDR_TEST_SRC 	(0x88000000)
#define 	Local_DDR_TEST_DST 	(0x88100000)

void edma_performance_test(Uint32 uiEDMA, Uint32 uiTC, PCIERemoteTestAddress* remoteAddr)
{   
	CSL_TpccRegs*  EDMACCRegs= gpEDMA_CC_regs[uiEDMA];
#if 1
	printf("Overhead test with EDMA CC%d TC%d\n", uiEDMA, uiTC);

	edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->LL2_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC                ,"local LL2   ", "remote LL2  ");                    
	edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->MSMC_RAM_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC           ,"local LL2   ", "remote MSRAM");                    
	edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->DDRA_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC               ,"local LL2   ", "remote DDRA ");                    

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, Local_LL2_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC                ,"remote LL2  ", "local LL2   ");                    
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, Local_LL2_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC           ,"remote MSRAM", "local LL2   ");                    
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, Local_LL2_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC               ,"remote DDRA ", "local LL2   ");                    

	edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->LL2_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC            ,"local MSRAM ", "remote LL2  ");                    
	edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->MSMC_RAM_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC       ,"local MSRAM ", "remote MSRAM");                    
	edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->DDRA_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC           ,"local MSRAM ", "remote DDRA ");                    

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, Local_MSMC_RAMTEST_DST, 8, 1, 8, EDMACCRegs, uiTC            ,"remote LL2  ", "local MSRAM ");                    
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, Local_MSMC_RAMTEST_DST, 8, 1, 8, EDMACCRegs, uiTC       ,"remote MSRAM", "local MSRAM ");                    
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, Local_MSMC_RAMTEST_DST, 8, 1, 8, EDMACCRegs, uiTC           ,"remote DDRA ", "local MSRAM ");                    

	edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->LL2_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC                ,"local DDR   ", "remote LL2  ");                    
	edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->MSMC_RAM_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC           ,"local DDR   ", "remote MSRAM");                    
	edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->DDRA_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC               ,"local DDR   ", "remote DDRA ");                    

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, Local_DDR_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC                ,"remote LL2  ", "local DDR   ");                    
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, Local_DDR_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC           ,"remote MSRAM", "local DDR   ");                    
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, Local_DDR_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC               ,"remote DDRA ", "local DDR   ");                    

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, remoteAddr->LL2_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC          ,"remote LL2  ", "remote LL2  ");                    
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, remoteAddr->MSMC_RAM_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC,"remote MSRAM", "local MSRAM ");                    
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, remoteAddr->DDRA_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC        ,"remote DDRA ", "remote DDRA ");                    
   
	if(remoteAddr->DDRB_DST_ADDR&&remoteAddr->DDRB_SRC_ADDR)
	{
		edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->DDRB_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC             ,"local LL2   ", "remote DDRB ");                    
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, Local_LL2_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC             ,"remote DDRB ", "local LL2   ");                    
		edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->DDRB_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC         ,"local MSRAM ", "remote DDRB ");                    
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, Local_MSMC_RAMTEST_DST, 8, 1, 8, EDMACCRegs, uiTC         ,"remote DDRB ", "local MSRAM ");                    
		edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->DDRB_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC             ,"local DDR   ", "remote DDRB ");                    
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, Local_DDR_TEST_DST, 8, 1, 8, EDMACCRegs, uiTC             ,"remote DDRB ", "local DDR   ");                    
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, remoteAddr->DDRB_DST_ADDR, 8, 1, 8, EDMACCRegs, uiTC      ,"remote DDRB ", "remote DDRB ");                    
	}
#endif	
	printf("Throughput test with EDMA CC%d TC%d\n", uiEDMA, uiTC);

	edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->LL2_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC                ,"local LL2   ", "remote LL2  ");  
	edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->MSMC_RAM_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC           ,"local LL2   ", "remote MSRAM");  
	edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->DDRA_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC               ,"local LL2   ", "remote DDRA ");  

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, Local_LL2_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC                ,"remote LL2  ", "local LL2   ");  
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, Local_LL2_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC           ,"remote MSRAM", "local LL2   ");  
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, Local_LL2_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC               ,"remote DDRA ", "local LL2   ");  

	edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->LL2_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC            ,"local MSRAM ", "remote LL2  ");  
	edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->MSMC_RAM_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC       ,"local MSRAM ", "remote MSRAM");  
	edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->DDRA_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC           ,"local MSRAM ", "remote DDRA ");  

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, Local_MSMC_RAMTEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC            ,"remote LL2  ", "local MSRAM ");  
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, Local_MSMC_RAMTEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC       ,"remote MSRAM", "local MSRAM ");  
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, Local_MSMC_RAMTEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC           ,"remote DDRA ", "local MSRAM ");  

	edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->LL2_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC                ,"local DDR   ", "remote LL2  ");  
	edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->MSMC_RAM_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC           ,"local DDR   ", "remote MSRAM");  
	edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->DDRA_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC               ,"local DDR   ", "remote DDRA ");  

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, Local_DDR_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC                ,"remote LL2  ", "local DDR   ");  
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, Local_DDR_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC           ,"remote MSRAM", "local DDR   ");  
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, Local_DDR_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC               ,"remote DDRA ", "local DDR   ");  

	edma_Throughput_Test(remoteAddr->LL2_SRC_ADDR, remoteAddr->LL2_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC          ,"remote LL2  ", "remote LL2  ");  
	edma_Throughput_Test(remoteAddr->MSMC_RAM_SRC_ADDR, remoteAddr->MSMC_RAM_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC,"remote MSRAM", "remote MSRAM");  
	edma_Throughput_Test(remoteAddr->DDRA_SRC_ADDR, remoteAddr->DDRA_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC        ,"remote DDRA ", "remote DDRA ");  

	if(remoteAddr->DDRB_DST_ADDR&&remoteAddr->DDRB_SRC_ADDR)
	{
		edma_Throughput_Test(Local_LL2_TEST_SRC, remoteAddr->DDRB_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC             ,"local LL2   ", "remote DDRB ");  
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, Local_LL2_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC             ,"remote DDRB ", "local LL2   ");  
		edma_Throughput_Test(Local_MSMC_RAMTEST_SRC, remoteAddr->DDRB_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC         ,"local MSRAM ", "remote DDRB ");  
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, Local_MSMC_RAMTEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC         ,"remote DDRB ", "local MSRAM ");  
		edma_Throughput_Test(Local_DDR_TEST_SRC, remoteAddr->DDRB_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC             ,"local DDR   ", "remote DDRB ");  
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, Local_DDR_TEST_DST, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC             ,"remote DDRB ", "local DDR   ");  
		edma_Throughput_Test(remoteAddr->DDRB_SRC_ADDR, remoteAddr->DDRB_DST_ADDR, A_COUNT, B_COUNT, A_COUNT, EDMACCRegs, uiTC      ,"remote DDRB ", "remote DDRB ");  
	}
   
    return;
}

/*Please note, on PCIE1 of K2E, internal loopback test may stuck on some
EDMA TCs because of data path dependency for internal loopback test.
It is not a issue in real application.*/
void PCIE_edma_test(PCIERemoteTestAddress* remoteAddr)
{  
	int i;

	EDMA_init();

	for(i=0; i<CSL_EDMACC_0_NUM_TC; i++)
		edma_performance_test(0, i, remoteAddr);
	for(i=0; i<CSL_EDMACC_1_NUM_TC; i++)
		edma_performance_test(1, i, remoteAddr);
#if 1
	for(i=0; i<CSL_EDMACC_2_NUM_TC; i++)
		edma_performance_test(2, i, remoteAddr);
#if defined(DEVICE_K2H) || defined(DEVICE_K2K) || defined(DEVICE_K2E)
	for(i=0; i<CSL_EDMACC_3_NUM_TC; i++)
		edma_performance_test(3, i, remoteAddr);
	for(i=0; i<CSL_EDMACC_4_NUM_TC; i++)
		edma_performance_test(4, i, remoteAddr);
#endif
#endif

	puts("EDMA test complete");
	return;
}

