/******************************************************************************

  Copyright (C), 2010-2013, Texas Instrument.

 ******************************************************************************
  File Name     : Robust_DDR_ECC.h
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : 2012/11/2
  Last Modified :
  Description   : Robust_DDR_ECC.c header file
  Function List :
  History       :

******************************************************************************/
#ifndef __ROBUST_DDR_ECC_H__
#define __ROBUST_DDR_ECC_H__


#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* __cplusplus */

extern void DDR_ECC_test();

/*****************************************************************************
setup timer and EDMA to scrub DDR EDC periodically.
In every "scrubbing_period_ms", timer will trigger EDMA to scrub "uiBlockByteCnt" in DDR.
"uiBlockByteCnt" should <64KB. 
Note: The priority of this EDMA TC for scrubbing should be lowest to reduce impact to normal operations.
*****************************************************************************/
extern void DDR_EDC_scrubbing_setup(unsigned int scrubbing_period_ms, 
	Uint32 uiBlockByteCnt, DDR3_ECC_Config * ecc_cfg);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */


#endif /* __ROBUST_DDR_ECC_H__ */

