/******************************************************************************

  Copyright (C), 2010-2013, Texas Instrument.

 ******************************************************************************
  File Name     : Robust_DDR_SES_MP.c
  Version       : Initial Draft
  Author        : Zhan Xiang
  Created       : 2012/3/11
  Last Modified :
  Description   : DDR SES memory protection example
  Function List :
              MSMCSesMemoryBufInit
              SES_DDR_MP_test
  History       :
  1.Date        : 2012/3/11
    Author      : Zhan Xiang
    Modification: Created file
  2.Date        : July 24, 2013
    Author      : Andy Yin
    Modification: update for K2
  3.Date         : 2014/4/21
    Author       : Brighton Feng
    Modification : Update for K2L
******************************************************************************/


#include <stdio.h>
#include "K2_common.h"

/*----------------------------------------------*
 * module-wide global variables                 *
 *----------------------------------------------*/
/*total 64K data for MSMC SES*/
//align to MPAX segment bouandary
volatile char ddrSesMPDataDst[2][8192] __attribute__ ((aligned (16*1024), section ("ddrSesMPData_w")));

/* 16K data */
//align to MPAX segment bouandary
volatile char ddrSesMPDataSrc[4][4096] __attribute__ ((aligned (16*1024), section ("ddrSesMPData_r")));

MPAX_Config SES_MPAX_cfg_table[]=
{
	    /*BADDR                  RADDR           SegementSize                  AccessPermisionMask
	    32-bit virtual           36-bit physical in byte, must         UnShare Access types allowed
	    base address             address right   be power of 2                 in this address range
	                             shift by 4                                                          */
	    {(Uint32)ddrSesMPDataDst, 0,          sizeof(ddrSesMPDataDst), TRUE, MP_SW|MP_UW},/*write only data*/
	    {(Uint32)ddrSesMPDataSrc, 0,          sizeof(ddrSesMPDataSrc), TRUE, MP_SR|MP_UR}/*read only data*/
};

/*----------------------------------------------*
 * routines' implementations                    *
 *----------------------------------------------*/

/*****************************************************************************
 Prototype    : MSMCSesMemoryBufInit
 Description  : SES test buffer initialization
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/10/20
    Author       : Zhan Xiang
    Modification : Created function
  2.Date         : 2014/10/20
    Author       : Brighton Feng
    Modification : Updated for ARM

*****************************************************************************/
void MSMCSesMemoryBufInit()
{
	int i;
	for(i=0; i<4096; i++)
	{
		ddrSesMPDataSrc[0][i] = 0xA0;
		ddrSesMPDataSrc[1][i] = 0xC0;
		ddrSesMPDataSrc[2][i] = 0xD0;
		ddrSesMPDataSrc[3][i] = 0xE0;

	}

	for(i=0; i<8192; i++)
	{
		ddrSesMPDataDst[0][i] = 0xBB;
		ddrSesMPDataDst[1][i] = 0xBB;
	}
	return;
}

/*****************************************************************************
 Prototype    : SES_DDR_MP_test
 Description  : This test shows the MSMC memory protection among different
                master
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/10/29
    Author       : Zhan Xiang
    Modification : Created function

  2.Date         : 2014/4/21
    Author       : Brighton Feng
    Modification : Update for K2L
*****************************************************************************/
void SES_DDR_MP_test()
{
	puts("===================-SES DDR memory protection test-==============");

	MSMCSesMemoryBufInit();

	SES_MPAX_cfg_table[0].RADDR= DDR_PHY_ADDR(SES_MPAX_cfg_table[0].BADDR);
	SES_MPAX_cfg_table[1].RADDR= DDR_PHY_ADDR(SES_MPAX_cfg_table[1].BADDR);
	KeyStone_SES_MPAX_setup(SES_MPAX_cfg_table, 1,
		sizeof(SES_MPAX_cfg_table)/sizeof(MPAX_Config), PRIVID_ARM_COREPAC);

	/* EDMA copy data from ddrSesMPDataSrc to ddrSesMPDataDst is allowed */
	/* The first EDMA write is allowed */
	printf("EDMA copy from 0x%x (read-only) to 0x%x (write-only)...\n",
		((Uint32)&ddrSesMPDataSrc[0][0]),
		((Uint32)&ddrSesMPDataDst[0][0]));
	EDMA_copy(((Uint32)&ddrSesMPDataSrc[0][0]),
			  ((Uint32)&ddrSesMPDataDst[0][0]),
			  64, EDMA_CC0_CH0, DMA_WAIT);

	/*EDMA copy data from ddrSesMPDataDst to ddrSesMPDataSrc is not allowed */
	printf("\n!!!EDMA copy from 0x%x (write-only) to 0x%x (read-only)...\n",
		((Uint32)&ddrSesMPDataDst[1][0]),
		((Uint32)&ddrSesMPDataSrc[1][0]));
	EDMA_copy(((Uint32)&ddrSesMPDataDst[1][0]),
			  ((Uint32)&ddrSesMPDataSrc[1][0]),
			  32, EDMA_CC0_CH0, DMA_NO_WAIT);

	/*DMA access has some latency, and normally, exception is 
	captured about 15~45 cycles after the access violation.
	Dummy operations added here to wait for DMA access and excpetion*/
	dummy_wait(1000);	
	EDMA_wait(EDMA_CC0_CH0);

	//remove the MPAX segments for this test
	KeyStone_SES_MPAX_seg_delete(1, PRIVID_ARM_COREPAC);
	KeyStone_SES_MPAX_seg_delete(2, PRIVID_ARM_COREPAC);

}

