/******************************************************************************

  Copyright (C), 2010-2013, Texas Instrument.

 ******************************************************************************
  File Name     : Robust_EDMA.c
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : 2012/11/7
  Last Modified :
  Description   : EDMA error handling example
  Function List :
  History       :

******************************************************************************/

#include <stdio.h>
#include <csl_edma3.h>
#include "K2_common.h"

/*----------------------------------------------*
 * routines' implementations                    *
 *----------------------------------------------*/

/*****************************************************************************
 Prototype    : EDMA_ERROR_test
 Description  : EDMA_ERROR_test example
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/11/7
    Author       : Brighton Feng
    Modification : Created function

*****************************************************************************/
void EDMA_ERROR_test()
{
	CSL_TpccRegs*  EDMACCRegs;
	unsigned int uiChannel;

	puts("===================-EDMA Error test-===========================");

	puts("!!!start a NULL transfer with EDMA CC0 Channel 0, to trigger event miss error...");

	EDMACCRegs= gpEDMA_CC_regs[0];
	uiChannel = 0;

	EDMACCRegs->PARAMSET[uiChannel].OPT= 
		CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS, 
			CSL_EDMA3_TCCH_DIS, 
			CSL_EDMA3_ITCINT_DIS, 
			CSL_EDMA3_TCINT_EN,
			uiChannel,
			CSL_EDMA3_TCC_NORMAL,
			CSL_EDMA3_FIFOWIDTH_NONE, 
			CSL_EDMA3_STATIC_DIS, 
			CSL_EDMA3_SYNC_A, 
			CSL_EDMA3_ADDRMODE_INCR, 
			CSL_EDMA3_ADDRMODE_INCR);
	EDMACCRegs->PARAMSET[uiChannel].SRC= (0x0C000000);
	EDMACCRegs->PARAMSET[uiChannel].A_B_CNT= 0;
	EDMACCRegs->PARAMSET[uiChannel].DST= (0x0C000000);
	EDMACCRegs->PARAMSET[uiChannel].SRC_DST_BIDX= 0;
	EDMACCRegs->PARAMSET[uiChannel].LINK_BCNTRLD= 0xFFFF;
	EDMACCRegs->PARAMSET[uiChannel].SRC_DST_CIDX= 0;
	EDMACCRegs->PARAMSET[uiChannel].CCNT= 0;
	
	/*Manually trigger the EDMA*/
	(EDMACCRegs->TPCC_ESR)= 1<<(uiChannel);
 
	/*DMA access has some latency, and normally, exception is 
	captured about 15~45 cycles after the access violation.
	Dummy operations added here to wait for DMA access and excpetion*/
	dummy_wait(1000);	

	/*wait for completion*/
	while(0==((EDMACCRegs->TPCC_IPR)&(1<<(uiChannel))));

	/*clear completion flag*/
	(EDMACCRegs->TPCC_ICR)= 1<<(uiChannel);

	puts("\n!!!start a transfer to address 0 with EDMA CC1 Channel 2, to trigger EDMA bus error...");
	EDMA_copy(0, 0, 32,EDMA_CC1_CH2, DMA_NO_WAIT);

	/*DMA access has some latency, and normally, exception is 
	captured about 15~45 cycles after the access violation.
	Dummy operations added here to wait for DMA access and excpetion*/
	dummy_wait(1000);	
	EDMA_wait(EDMA_CC1_CH2);

}

