/******************************************************************************

  Copyright (C), 2010-2013, Texas Instrument.

 ******************************************************************************
  File Name     : Robust_MNav_Init.c
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : 2012/10/28
  Last Modified :
  Description   : Initialization of Multicore Navigator on KeyStone device
                  for MPU test
  Function List :
              PktDMA_init
              QMSS_init
  History       :
  1.Date        : 2012/10/28
    Author      : Brighton Feng
    Modification: Created file

******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ti/csl/cslr_device.h>
#include <ti/csl/csl_qm_queue.h>
#include "Robust_MNav_init.h"

/*----------------------------------------------*
 * module-wide global variables                 *
 *----------------------------------------------*/
Uint8 hostDescriptor_MSMC_RAM[MSMC_RAM_HOST_DESCRIPTOR_NUM][HOST_DESCRIPTOR_SIZE] __attribute__ ((aligned (128), section ("QMSS_Data.Descriptor_MSMC_RAM")));

Uint8 packetBuffer_MSMC_RAM_Size0[MSMC_RAM_SIZE0_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE0] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));
Uint8 packetBuffer_MSMC_RAM_Size1[MSMC_RAM_SIZE1_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE1] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));
Uint8 packetBuffer_MSMC_RAM_Size2[MSMC_RAM_SIZE2_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE2] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));
Uint8 packetBuffer_MSMC_RAM_Size3[MSMC_RAM_SIZE3_PKT_BUF_NUM][MSMC_RAM_PACKET_BUFFER_SIZE3] __attribute__ ((section ("PacketData.buffer_MSMC_RAM")));

Uint8 monoDescriptor_MSMC_RAM[MSMC_RAM_MONO_DESCRIPTOR_NUM][L2_MONO_DESCRIPTOR_SIZE] __attribute__ ((aligned (128), section ("QMSS_Data.Descriptor_MSMC_RAM")));

/* descriptor memory region configuration.
descriptor Base address must be specified in ascending order,
no overlap is allowed between regions*/
Qmss_DescMemRegionCfg descMemRegionsCfg[]=
{   /*The base address of descriptor region     Size of each descriptor     Number of descriptors 
                                                16*n,1<=n<=8192             2^(5+n), 0<=n<=15*/
    {(Uint32)hostDescriptor_MSMC_RAM,                HOST_DESCRIPTOR_SIZE,       MSMC_RAM_HOST_DESC_LINK_ENTRY_NUM},/*host descriptor in MSMC_RAM*/
    {(Uint32)monoDescriptor_MSMC_RAM,                L2_MONO_DESCRIPTOR_SIZE,    MSMC_RAM_MONO_DESC_LINK_ENTRY_NUM}/*Monolithic descriptor in MSMC_RAM*/
};

FreeHostQueueCfg freeHostQueueCfgTable[]=
{
    /*free queue number*/       /*address of first descriptor*/                                         /*size of descriptor*/  /*number of descriptors*/   /*address of first buffer*/                     /*size of each buffer*/ 
    {MSMC_RAM_HOST_SIZE0_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[0][0],                                      HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE0_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size0,                 MSMC_RAM_PACKET_BUFFER_SIZE0},/*MSMC_RAM Size0 host Free Descriptor Queue*/
    {MSMC_RAM_HOST_SIZE1_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_SIZE1_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE1_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size1,                 MSMC_RAM_PACKET_BUFFER_SIZE1},/*MSMC_RAM Size1 host Free Descriptor Queue*/
    {MSMC_RAM_HOST_SIZE2_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_SIZE2_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE2_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size2,                 MSMC_RAM_PACKET_BUFFER_SIZE2},/*MSMC_RAM Size2 host Free Descriptor Queue*/
    {MSMC_RAM_HOST_SIZE3_FDQ,        (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_SIZE3_DESC_START_IDX][0],               HOST_DESCRIPTOR_SIZE,   MSMC_RAM_SIZE3_PKT_BUF_NUM,      (Uint32)packetBuffer_MSMC_RAM_Size3,                 MSMC_RAM_PACKET_BUFFER_SIZE3},/*MSMC_RAM Size3 host Free Descriptor Queue*/
    {MSMC_RAM_NO_BUF_HOST_FDQ,       (Uint32)&hostDescriptor_MSMC_RAM[MSMC_RAM_NO_BUF_DESC_START_IDX][0],              HOST_DESCRIPTOR_SIZE,   MSMC_RAM_NO_BUF_DESCRIPTOR_NUM,  0,                                              0}         /*MSMC_RAM no buffer host Free Descriptor Queue*/
};

FreeMonoQueueCfg freeMonoQueueCfgTable[]=
{
    /*free queue number*/       /*address of first descriptor*/                                 /*size of descriptor*/      /*number of descriptors*/
    {MSMC_RAM_MONOLITHIC_FDQ,        (Uint32)monoDescriptor_MSMC_RAM,                                     L2_MONO_DESCRIPTOR_SIZE,    MSMC_RAM_MONO_DESCRIPTOR_NUM}/*MSMC_RAM monolithic Free Descriptor Queue*/
};

PktDma_RxFlowCfg flowCfgTable[]=
{
    /*dest_qnum*/   /*sop_offset*/  /*ps_loc*/  /*desc_type*/   /*error retry*/ /*psinfo*/  /*einfo*/   /*size_thresh0(1,2)_en*/    /*size_thresh0*/    /*size_thresh1*/    /*size_thresh2*/    /*fdq0_sz0_qnum*/       /*fdq0_sz1_qnum*/           /*fdq0_sz2_qnum*/           /*fdq0_sz3_qnum*/           /*fdq1_qnum*/           /*fdq2_qnum*/           /*fdq3_qnum*/   /*dest_tag_lo*/ /*dest_tag_hi*/ /*src_tag_lo*/  /*src_tag_hi*/  /*dest_tag_lo_sel*/ /*dest_tag_hi_sel*/ /*src_tag_lo_sel*/  /*src_tag_hi_sel*/
    {PKT_DMA_TEST_DST_Q,    0,      0,      Cppi_DescType_HOST,     0,          0,          0,          1, 1, 1,    MSMC_RAM_PACKET_BUFFER_SIZE0, MSMC_RAM_PACKET_BUFFER_SIZE1, MSMC_RAM_PACKET_BUFFER_SIZE2, MSMC_RAM_HOST_SIZE0_FDQ,          MSMC_RAM_HOST_SIZE1_FDQ,     MSMC_RAM_HOST_SIZE2_FDQ,         MSMC_RAM_HOST_SIZE3_FDQ,         MSMC_RAM_HOST_SIZE3_FDQ,     MSMC_RAM_HOST_SIZE3_FDQ,     MSMC_RAM_HOST_SIZE3_FDQ,         0,      0,              0,              0,              0,                  0,                  0,                  0},
    {PKT_DMA_TEST_DST_Q,    12,     0,  Cppi_DescType_MONOLITHIC,   0,          0,          0,          0, 0, 0,                    0,                  0,                  0,                  MSMC_RAM_MONOLITHIC_FDQ,     0,                          0,                          0,                          MSMC_RAM_MONOLITHIC_FDQ,     MSMC_RAM_MONOLITHIC_FDQ,     MSMC_RAM_MONOLITHIC_FDQ,         0,      0,              0,              0,              0,                  0,                  0,                  0}
};

Uint32 uiUsedDescRegionNum;
Uint32 uiInitialHostFdqNum;
Uint32 uiInitialMonoFdqNum;
Uint32 uiUsedRxFlowNum;


/*****************************************************************************
 Prototype    : QMSS_init
 Description  : Initialize the QMSS for MPU test
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/10/28
    Author       : Brighton Feng
    Modification : Created function

*****************************************************************************/
void QMSS_init()
{
	uiUsedDescRegionNum= sizeof(descMemRegionsCfg)/sizeof(Qmss_DescMemRegionCfg);
	uiInitialHostFdqNum= sizeof(freeHostQueueCfgTable)/sizeof(FreeHostQueueCfg);
	uiInitialMonoFdqNum= sizeof(freeMonoQueueCfgTable)/sizeof(FreeMonoQueueCfg);

	/*-----------------Queue manager configuration--------------------*/
	/*Two QM can be configured differently (split mode),
	for this test, the are configured same (shared mode)*/
	K2_QMSS_Linking_RAM_init(QMSS_QM1, QMSS_INTERNAL_LINKING_RAM_ADDRESS,
		QMSS_NUM_INTERNAL_LINKING_ENTRY, 0, 0);
	K2_QMSS_Descriptor_Regions_init(QMSS_QM1, 0, 0, uiUsedDescRegionNum, descMemRegionsCfg);

#if defined(DEVICE_K2H) || defined(DEVICE_K2K)
	K2_QMSS_Linking_RAM_init(QMSS_QM2, QMSS_INTERNAL_LINKING_RAM_ADDRESS,
		QMSS_NUM_INTERNAL_LINKING_ENTRY, 0, 0);
	K2_QMSS_Descriptor_Regions_init(QMSS_QM2, 0, 0, uiUsedDescRegionNum, descMemRegionsCfg);
#endif

	/*-----------------QMSS queue initialization------------------------*/
	KeyStone_Host_Descriptor_Queues_init(freeHostQueueCfgTable, uiInitialHostFdqNum);
	KeyStone_Mono_Descriptor_Queues_init(freeMonoQueueCfgTable, uiInitialMonoFdqNum);

	gpQM_INTD_regs[0]->STATUS_CLR_REG0= 0xFFFFFFFF;
	gpQM_INTD_regs[0]->STATUS_CLR_REG1= 0xFFFF;
	gpQM_INTD_regs[1]->STATUS_CLR_REG0= 0xFFFFFFFF;
	gpQM_INTD_regs[1]->STATUS_CLR_REG1= 0xFFFF;
}
/*****************************************************************************
 Prototype    : PktDMA_init
 Description  : Initialize the PktDMA for MPU test
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/10/28
    Author       : Brighton Feng
    Modification : Created function

*****************************************************************************/
void PktDMA_init()
{
	int i;
	
	uiUsedRxFlowNum= sizeof(flowCfgTable)/sizeof(PktDma_RxFlowCfg);

	/*-----------------QMSS PktDMA configuration------------------*/
	KeyStone_pktDma_Global_Control(gpQM_DMA_CfgRegs[0], 256, 5, 5);

	for(i=0; i<uiUsedRxFlowNum; i++)
	{
		KeyStone_pktDma_RxCh_enable(gpQM_DMA_RxChCfgRegs[0], i);
		KeyStone_pktDma_TxCh_enable(gpQM_DMA_TxChCfgRegs[0], i);
	}

	KeyStone_pktDma_configureRxFlow(
		gpQM_DMA_RxFlowCfgRegs[0]->RX_FLOW_CONFIG, flowCfgTable, uiUsedRxFlowNum);

#if defined(DEVICE_K2H) || defined(DEVICE_K2K)
	KeyStone_pktDma_Global_Control(gpQM_DMA_CfgRegs[1], 256, 5, 5);

	for(i=0; i<uiUsedRxFlowNum; i++)
	{
		KeyStone_pktDma_RxCh_enable(gpQM_DMA_RxChCfgRegs[1], i);
		KeyStone_pktDma_TxCh_enable(gpQM_DMA_TxChCfgRegs[1], i);
	}

	KeyStone_pktDma_configureRxFlow(
		gpQM_DMA_RxFlowCfgRegs[1]->RX_FLOW_CONFIG, flowCfgTable, uiUsedRxFlowNum);

#endif
}
