/******************************************************************************

  Copyright (C), 2010-2013, Texas Instrument.

 ******************************************************************************
  File Name     : Robust_MNav_Init.h
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : 2012/10/28
  Last Modified :
  Description   : Robust_MNav_Init.c header file, Initialization of Multicore Navigator on KeyStone device for MPU test

  Function List :
  History       :
  1.Date        : 2012/10/28
    Author      : Brighton Feng
    Modification: Created file

******************************************************************************/

/*----------------------------------------------*
 * routines' implementations                    *
 *----------------------------------------------*/

#ifndef _MULTICORE_NAVIGATOR_INIT_H_
#define _MULTICORE_NAVIGATOR_INIT_H_

#include "K2_Navigator_init_drv.h"

/*size of descriptor must be multiple of 16B*/
#define HOST_DESCRIPTOR_SIZE 		32
#define L2_MONO_DESCRIPTOR_SIZE 	(1024+16)

/*the linking RAM entry size for each descriptor region 
must be power of 2, and no less than 32.
Actual descriptor number may less than linking entry size, this may 
leave hole in linking RAM*/
#define MSMC_RAM_HOST_DESCRIPTOR_NUM 		(64)
#define MSMC_RAM_HOST_DESC_LINK_ENTRY_NUM 	(64)
#define MSMC_RAM_MONO_DESCRIPTOR_NUM 		(8)
#define MSMC_RAM_MONO_DESC_LINK_ENTRY_NUM 	(32) 	/*only 8 of 32 is used for the 8 descriptors*/

#define MSMC_RAM_PACKET_BUFFER_SIZE0 	(256)
#define MSMC_RAM_PACKET_BUFFER_SIZE1 	(512)
#define MSMC_RAM_PACKET_BUFFER_SIZE2 	(1*1024)
#define MSMC_RAM_PACKET_BUFFER_SIZE3 	(2*1024)
#define MSMC_RAM_SIZE0_PKT_BUF_NUM 		(8)
#define MSMC_RAM_SIZE1_PKT_BUF_NUM 		(8)
#define MSMC_RAM_SIZE2_PKT_BUF_NUM 		(8)
#define MSMC_RAM_SIZE3_PKT_BUF_NUM 		(8)
#define MSMC_RAM_SIZE1_DESC_START_IDX 	(MSMC_RAM_SIZE0_PKT_BUF_NUM)
#define MSMC_RAM_SIZE2_DESC_START_IDX 	(MSMC_RAM_SIZE1_DESC_START_IDX+MSMC_RAM_SIZE1_PKT_BUF_NUM)
#define MSMC_RAM_SIZE3_DESC_START_IDX 	(MSMC_RAM_SIZE2_DESC_START_IDX+MSMC_RAM_SIZE2_PKT_BUF_NUM)
#define MSMC_RAM_NO_BUF_DESC_START_IDX 	(MSMC_RAM_SIZE3_DESC_START_IDX+MSMC_RAM_SIZE3_PKT_BUF_NUM)
#define MSMC_RAM_NO_BUF_DESCRIPTOR_NUM 	(MSMC_RAM_HOST_DESCRIPTOR_NUM-MSMC_RAM_NO_BUF_DESC_START_IDX)

#define TEST_QUEUE_BASE 			2048

#define MSMC_RAM_MONOLITHIC_FDQ 			(TEST_QUEUE_BASE+0 )
#define MSMC_RAM_HOST_SIZE0_FDQ 			(TEST_QUEUE_BASE+1 )
#define MSMC_RAM_HOST_SIZE1_FDQ 			(TEST_QUEUE_BASE+2 )
#define MSMC_RAM_HOST_SIZE2_FDQ 			(TEST_QUEUE_BASE+3 )
#define MSMC_RAM_HOST_SIZE3_FDQ 			(TEST_QUEUE_BASE+4 )
#define MSMC_RAM_NO_BUF_HOST_FDQ 		(TEST_QUEUE_BASE+5 )

#define PKT_DMA_TEST_DST_Q 			(TEST_QUEUE_BASE+6)

#define RX_FLOW_MSMC_RAM_HOST 			0
#define RX_FLOW_MSMC_RAM_MONO 			1

extern Uint32 uiUsedDescRegionNum;
extern Uint32 uiInitialHostFdqNum;
extern Uint32 uiInitialMonoFdqNum;
extern Uint32 uiUsedRxFlowNum;

extern void QMSS_init();
extern void PktDMA_init();

#endif
