/******************************************************************************

  Copyright (C), 2010-2013, Texas Instrument.

 ******************************************************************************
  File Name     : Robust_MSMC_RAM_SMS_MP.c
  Version       : Initial Draft
  Author        : Zhan Xiang
  Created       : 2012/3/11
  Last Modified :
  Description   : MSMC_RAM SMS memory protection example
  Function List :
              MSMCSmsMemoryBufInit
              SMS_MSMC_RAM_MP_test
  History       :
  1.Date        : 2012/3/11
    Author      : Zhan Xiang
    Modification: Created file
  2.Date        : July 24, 2013
    Author      : Andy Yin
    Modification: update for K2
  3.Date        : 2014/10/30
    Author      : Brighton Feng
    Modification: updated for ARM
******************************************************************************/
#include <stdio.h>
#include "K2_common.h"
/*----------------------------------------------*
 * external variables                           *
 *----------------------------------------------*/
extern CSL_MsmcRegs * gpMSMC_regs;

/*----------------------------------------------*
 * module-wide global variables                 *
 *----------------------------------------------*/
/*total 64K data for MSMC SMS*/
//align to MPAX segment bouandary
volatile char msmcSmsMPDataDst[2][8192] __attribute__ ((aligned (16*1024), section ("msmcSmsMPData_w")));

/* 16K data */
//align to MPAX segment bouandary
volatile char msmcSmsMPDataSrc[4][4096] __attribute__ ((aligned (16*1024), section ("msmcSmsMPData_r")));

/*memory protection and address extension configuration table*/
MPAX_Config SMS_MPAX_cfg_table[]=
{
	    /*BADDR                  RADDR           SegementSize                  AccessPermisionMask
	    32-bit virtual           36-bit physical in byte, must         UnShare Access types allowed
	    base address             address right   be power of 2                 in this address range
	                             shift by 4                                                            */
	    {(Uint32)msmcSmsMPDataDst, 0,          sizeof(msmcSmsMPDataDst), TRUE, MP_SW|MP_UW},/*write only data*/
	    {(Uint32)msmcSmsMPDataSrc, 0,          sizeof(msmcSmsMPDataSrc), TRUE, MP_SR|MP_UR}/*read only data*/
};

/*----------------------------------------------*
 * routines' implementations                    *
 *----------------------------------------------*/
/*****************************************************************************
 Prototype    : MSMCSmsMemoryBufInit
 Description  : SMS test buffer initialization
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/3/11
    Author       : Zhan Xiang
    Modification : Created function
  2.Date        : 2014/10/30
    Author      : Brighton Feng
    Modification: updated for ARM

*****************************************************************************/
void MSMCSmsMemoryBufInit()
{
	int i;
	for(i=0; i<4096; i++)
	{
		msmcSmsMPDataSrc[0][i] = 0xCC;
		msmcSmsMPDataSrc[1][i] = 0xDD;
		msmcSmsMPDataSrc[2][i] = 0xEE;
		msmcSmsMPDataSrc[3][i] = 0xFF;

	}

	for(i=0; i<8192; i++)
	{
		msmcSmsMPDataDst[0][i] = 0xAA;
		msmcSmsMPDataDst[1][i] = 0xAA;
	}
	return;
}

/*****************************************************************************
 Prototype    : SMS_MSMC_RAM_MP_test
 Description  : This test shows the MSMC memory protection among different
                master 
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/3/11
    Author       : Zhan Xiang
    Modification : Created function

  2.Date         : 2014/4/21
    Author       : Brighton Feng
    Modification : Update for K2L
*****************************************************************************/
void SMS_MSMC_RAM_MP_test()
{
	puts("===================-SMS MSMC_RAM memory protection test-==============");

	MSMCSmsMemoryBufInit();

	SMS_MPAX_cfg_table[0].RADDR= SMS_MPAX_cfg_table[0].BADDR>>4;
	SMS_MPAX_cfg_table[1].RADDR= SMS_MPAX_cfg_table[1].BADDR>>4;
	KeyStone_SMS_MPAX_setup(SMS_MPAX_cfg_table, 1,
		sizeof(SMS_MPAX_cfg_table)/sizeof(MPAX_Config), PRIVID_ARM_COREPAC);

	/* EDMA copy data from msmcMPDataSrc to msmcMPDataDst is allowed */
	/* The first EDMA write is allowed */
	printf("EDMA copy from 0x%x (read-only) to 0x%x (write-only)...\n",
		((Uint32)&msmcSmsMPDataSrc[0][0]),
		((Uint32)&msmcSmsMPDataDst[0][0]));
	EDMA_copy(((Uint32)&msmcSmsMPDataSrc[0][0]),
			  ((Uint32)&msmcSmsMPDataDst[0][0]),
			  640, EDMA_CC0_CH0, DMA_WAIT);

	/*EDMA copy data from msmcMPDataDst to msmcMPDataSrc is not allowed */
	printf("\n!!!EDMA copy from 0x%x (write-only) to 0x%x (read-only)...\n",
		((Uint32)&msmcSmsMPDataDst[1][0]),
		((Uint32)&msmcSmsMPDataSrc[1][0]));
	EDMA_copy(((Uint32)&msmcSmsMPDataDst[1][0]),
			  ((Uint32)&msmcSmsMPDataSrc[1][0]),
			  32, EDMA_CC0_CH0, DMA_NO_WAIT);

	/*DMA access has some latency, and normally, exception is 
	captured about 15~45 cycles after the access violation.
	Dummy operations added here to wait for DMA access and excpetion*/
	dummy_wait(1000);	
	EDMA_wait(EDMA_CC0_CH0);

	//remove the MPAX segments for this test
	KeyStone_SMS_MPAX_seg_delete(1, PRIVID_ARM_COREPAC);
	KeyStone_SMS_MPAX_seg_delete(2, PRIVID_ARM_COREPAC);
}


