/******************************************************************************

  Copyright (C), 2010-2013, Texas Instrument.

 ******************************************************************************
  File Name     : Robust_Reserved_space.c
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : 2012/11/7
  Last Modified :
  Description   : example to show the execptions when access reserved space.
  Function List :
  History       :

******************************************************************************/

#include <stdio.h>
#include "K2_common.h"

/*----------------------------------------------*
 * routines' implementations                    *
 *----------------------------------------------*/
/*****************************************************************************
 Prototype    : Uint32 read_reserved_space(Uint32 *)
 Description  : read reserved address
 Input        : address
 Output       : readback value
 Return Value : readback value
 
  History        :
  1.Date         : 2012/11/7
    Author       : Brighton Feng
    Modification : Created function

*****************************************************************************/
Uint32 read_reserved_space(volatile Uint32 * addr)
{
    Uint32 value;

	printf("!!!read from reserved address 0x%x...\n", (unsigned int)addr);
	value= *addr;

	/*normally, exception is captured about 10~100 cycles after the 
	access violation. Dummy operations added here to wait for it.*/
	dummy_wait(1000);	

	return value;
}
/*****************************************************************************
 Prototype    : void write_reserved_space(Uint32 *)
 Description  : write reserved address
 Input        : address
 Output       : none
 Return Value : none
 
  History        :
  1.Date         : 2012/11/7
    Author       : Brighton Feng
    Modification : Created function

*****************************************************************************/
void write_reserved_space(volatile Uint32 * addr)
{
	printf("!!!write to reserved address 0x%x...\n", (unsigned int)addr);
	*addr= 0;

	/*normally, exception is captured about 10~100 cycles after the 
	access violation. Dummy operations added here to wait for it.*/
	dummy_wait(1000);	
}
/*****************************************************************************
 Prototype    : void write_reserved_space(Uint32 *)
 Description  : execute from reserved address

 	exception will be triggered and can not return.
 Input        : address
 Output       : none
 Return Value : none
 
  History        :
  1.Date         : 2012/11/7
    Author       : Brighton Feng
    Modification : Created function

*****************************************************************************/
void execute_reserved_space(Uint32 func_addr)
{
	void (* func)();

	func= (void (*)())func_addr;
	printf("!!!execute at reserved address 0x%x...\n", func_addr);
	func();

}

/*****************************************************************************
 Prototype    : Reserved_Space_Test
 Description  : Reserved memory Space Test example
 Input        : None
 Output       : None
 Return Value : 
 
  History        :
  1.Date         : 2012/11/7
    Author       : Brighton Feng
    Modification : Created function

*****************************************************************************/
void Reserved_Space_Test()
{
	puts("==================-Reserved space access test-=================");

	puts("--------------------access zero address------------------------");
	write_reserved_space(0);

	puts("--------------------access unmapped space----------------------");
	read_reserved_space((Uint32 *)0x1C000000);
	write_reserved_space((Uint32 *)0x1C000000);
	execute_reserved_space(0x1C000000);
}

