/*  ============================================================================
 *     Copyright (C) 2013 Texas Instruments Incorporated.       *
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
Interrupts configuration for SPI
 * =============================================================================
 *  Revision History
 *  ===============
 *  23-July-2013 Brighton Feng  file created
 *  19-October-2013 Brighton  update to support multiple ports
 * =============================================================================
 */
#include <csl_device_interrupt.h>
#include "K2_common.h"
#include "K2_SPI_init_drv.h"

char * spi_int_str[]=
{
	"Error",
	"receive buffer full",
	"receive buffer overrun",
	"transmit buffer empty"
};
//all SPI interrupts are mapped to INT0 in this example
void SPI_INT0_ISR(Uint32 uiIAR_value, Uint32 uiIntAddress)
{
	Uint32 uiSpiNum=4, uiINT_ID;
	Uint32 intVector;
	CSL_SpiRegs * spiRegs;


	uiINT_ID= GIC_GET_INT_ID(uiIAR_value)-32;

	if(CSL_ARM_GIC_SPI_0_INT0==uiINT_ID)
		uiSpiNum= 0;
	else if(CSL_ARM_GIC_SPI_1_INT0==uiINT_ID)
		uiSpiNum= 1;
	else if(CSL_ARM_GIC_SPI_2_INT0==uiINT_ID)
		uiSpiNum= 2;
	else
	{
		printf("SPI INT0 ISR was triggered with invalid interrupt ID, IAR value= 0x%x\n", uiIAR_value);
		return;
	}

	spiRegs= gpSPI_regs[uiSpiNum];
	intVector=(spiRegs->INTVEC[0]&CSL_SPI_INTVEC_INTVECT_MASK)>>
		CSL_SPI_INTVEC_INTVECT_SHIFT;
	while((0x11<=intVector)&&(intVector<=0x14))
	{
	    printf("SPI%d %s interrupt happened at %d\n",
	    	uiSpiNum, spi_int_str[intVector-0x11], CP15_read_CCNT());

		intVector=(spiRegs->INTVEC[0]&CSL_SPI_INTVEC_INTVECT_MASK)>>
			CSL_SPI_INTVEC_INTVECT_SHIFT;
	}
}

void SPI_Interrupts_Init(void)
{
	GIC_INT_Config int_cfg;

	int_cfg.trigger_type= GIC_TRIGGER_TYPE_EDGE;
	int_cfg.ucGroupNum= 1; //route to group 1, IRQ
	int_cfg.ucPriority= GIC400_PRIORITY_LOWEST;

	GIC_interrupt_hook(GIC_CONVERT_SPI_ID(CSL_ARM_GIC_SPI_0_INT0), &int_cfg, SPI_INT0_ISR);
	GIC_interrupt_hook(GIC_CONVERT_SPI_ID(CSL_ARM_GIC_SPI_1_INT0), &int_cfg, SPI_INT0_ISR);
	GIC_interrupt_hook(GIC_CONVERT_SPI_ID(CSL_ARM_GIC_SPI_2_INT0), &int_cfg, SPI_INT0_ISR);
}

