/******************************************************************************
  Copyright (C), 2015, Texas Instrument.
 ******************************************************************************
  File Name     : USIM_Interrupt.c
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : 2015/3/6
  Last Modified :
  Description   :  USIM interrupt setup and handling 
******************************************************************************/

#include <stdio.h>
#include <K2_common.h>
#include <K2_USIM_Init_drv.h>
#include "USIM_interrupt.h"


void K2_USIM_ISR(Uint32 uiIAR_value, Uint32 uiIntAddress)
{
	Uint32 IQRSTATUS;

	IQRSTATUS= K2_USIM_IRQ_handler();

}

void K2_USIM_Interrupts_Init()
{
	GIC_INT_Config int_cfg;

	int_cfg.trigger_type= GIC_TRIGGER_TYPE_EDGE;
	int_cfg.ucGroupNum= 1; //route to group 1, IRQ
	int_cfg.ucPriority= GIC400_PRIORITY_LOWEST;

	gpUSIM_regs->IRQSTATUS = 0xFFFFFFFF; //clear interrupt flags
	GIC_interrupt_hook(GIC_CONVERT_SPI_ID(CSL_ARM_GIC_USIM_PONIRQ), &int_cfg, K2_USIM_ISR);
}

