/******************************************************************************
  Copyright (C), 2015, Texas Instrument.
 ******************************************************************************
  File Name     : USIM_main.c
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : 2015/3/6
  Last Modified :
  Description   :  USIM test code 
 only support mobile phone card (asynchronous, T = 0) for now
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include "K2_common.h"
#include "K2_Board_Init.h"
#include "K2_USIM_Init_drv.h"
#include "USIM_interrupt.h"

USIM_Config usim_cfg;
USIM_FIFO_Config usim_fifo_cfg;

void USIM_config()
{
	/*clear configuration structure to default values*/
	memset(&usim_cfg, 0, sizeof(usim_cfg));
	memset(&usim_fifo_cfg, 0, sizeof(usim_fifo_cfg));

	usim_fifo_cfg.rx_DMA_type= 2;
	usim_fifo_cfg.rx_FIFO_Byte_cnt= 64;
	usim_fifo_cfg.rx_FIFO_trigger_thresh= 64;
	usim_fifo_cfg.tx_FIFO_trigger_thresh= 15;
	usim_cfg.fifo_cfg= &usim_fifo_cfg;

	usim_cfg.sim_clk_div= USIM_CLK_DIV_10_MASK; /*USIM clock speed = (main core speed)/64/sim_clk_div*/
	//usim_cfg.sim_clk_div= USIM_CLK_DIV_6_LEGACY_MASK; /*USIM clock speed = (main core speed)/64/sim_clk_div*/
#if 0
	usim_cfg.Fi= USIM_FI_372;     //Tetu = (Fi/Di) x Tsclk
	usim_cfg.Di= USIM_DI_1;     //Tetu = (Fi/Di) x Tsclk
	usim_cfg.bSoftFiDi= TRUE;  //software configure Fi and Di (instead of hardware decoding)
#endif
	usim_cfg.CGT= 12; 	//in number of ETU, >=12
	usim_cfg.CWT= 8203; 	//in number of ETU, >=11
	usim_cfg.BWT= 15371; 	//in number of ETU, >=12
	usim_cfg.WAITI= 9; //WWT= (WAITI+1)*960*ETU, WI*D=CONFWAITI+1.
	usim_cfg.maxParityRetries= 3;
	usim_cfg.parErrLevel= 1;
	usim_cfg.bCheckParity= TRUE;
	usim_cfg.bPutErrInFifo= FALSE; //put/discard Rx characters with parity
	usim_cfg.bBypassSyncATR= TRUE; //Bypass ATR waiting sequence for synchronous card
	usim_cfg.protocol= 0;   //T= 0 or 1
	usim_cfg.t1Edc= USIM_T1_EDC_NONE_MASK;  
	usim_cfg.interruptEnableMask=  	//value for IRQENABLE register
		CSL_USIMOCP_IRQENABLE_TS_ERR_EN_MASK                 
		|CSL_USIMOCP_IRQENABLE_RESENT_EN_MASK                 
		|CSL_USIMOCP_IRQENABLE_TOB_EN_MASK                    
		|CSL_USIMOCP_IRQENABLE_TOC_EN_MASK                    
		|CSL_USIMOCP_IRQENABLE_EOB_EN_MASK                    
		|CSL_USIMOCP_IRQENABLE_RX_EN_MASK                     
		//|CSL_USIMOCP_IRQENABLE_TX_EN_MASK                     
		|CSL_USIMOCP_IRQENABLE_RXFULL_EN_MASK                 
		|CSL_USIMOCP_IRQENABLE_WT_EN_MASK                     
		|CSL_USIMOCP_IRQENABLE_NATR_EN_MASK                   
		|USIM_IRQ_RXDMA_RDY_MASK  
		|CSL_USIMOCP_IRQENABLE_PAR_ERR_LEVEL_REACHED_EN_MASK  
		|CSL_USIMOCP_IRQENABLE_FRAME_ERR_EN_MASK;

	K2_USIM_Init(&usim_cfg);

	K2_USIM_Interrupts_Init();
}

void USIM_test()
{
	K2_USIM_activate_card(&usim_fifo_cfg);

	//wait ATR done before othe test
	while(usim_data.stat<USIM_STATE_ATR_DONE);

	K2_USIM_read_ICCID();
}

int main(void)
{
	/*common initialization for internal modules in K2 device 
	enable GIC, memory protection interrupts, EDC for MSMC RAM */
	K2_common_device_init();
	/*initialize GIC interface for CPU, enable IRQ, FIQ, PMU*/
	K2_common_CPU_init();
	KeyStone_Exception_cfg(TRUE);

	/* Main core speed = 122.88*39/4 = 1198.08 MHz */
	KeyStone_main_PLL_init(MAIN_PLL_REF_CLK_MHZ, MAIN_PLL_MULTIPLIER, MAIN_PLL_DIVISOR);

	//ARM core speed= ARM_PLL_REF_CLK_MHZ*ARM_PLL_MULTIPLIER/ARM_PLL_DIVISOR
	K2_ARM_PLL_init(ARM_PLL_REF_CLK_MHZ, ARM_PLL_MULTIPLIER, ARM_PLL_DIVISOR);
	//K2_ARM_PLL_init(125, 8, 1);

	USIM_config();

	USIM_test();

	

	puts("USIM test complete.");
	return 0;
}

