/******************************************************************************

  Copyright (C), 2014, Texas Instrument.

 ******************************************************************************
  File Name     : CPU_access_test.h
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : June 5, 2014
  Last Modified : 
  Description   : CPU read/write test functions and definitions
  History       :
  1.Date        : June 5, 2014
    Author      : Brighton Feng
    Modification: Created file
  2.Date        : July 31, 2014
    Author      : Brighton Feng
    Modification: update for ARM Cortex A15

******************************************************************************/
#ifndef _CPU_ACCESS_TEST_H_
#define _CPU_ACCESS_TEST_H_

#include <tistdtypes.h>

/************Assembley test code implemented in "CPU_LD_ST_test.asm***************
access "buff" with LDRD, STRD, LDW or STW instruction for "uiCount" times*/
extern Asm_LDRD_Test(Uint32 buff_addr, Uint32 uiIndex, Uint32 uiCount);
extern void Asm_STRD_Test(Uint32 buff_addr, Uint32 uiIndex, Uint32 uiCount);
extern void AsmMemCopy(unsigned long long * restrict dst, unsigned long long * restrict src, Uint32 uiCount);

#define 	LD_ST_TEST_OVERHEAD 	40
#define 	LOAD_STORE_TIMES 		(512)

/*execute LDRD test in "buff" of "uiByteCnt" with different index*/
extern void LDRDTest(Uint32 buff_addr, Uint32 uiByteCnt, char * mem_type);
/*execute STRD test in "buff" of "uiByteCnt" with different index*/
extern void STRDTest(Uint32 buff_addr, Uint32 uiByteCnt, char * mem_type);
extern void AsmMemCopy8Test(unsigned long long * srcBuff, unsigned long long * dstBuff, Uint32 uiByteCnt,
 	char * srcType, char * dstType);
 	
#endif
