/******************************************************************************
  Copyright (C), 2013, Texas Instrument.
 ******************************************************************************
  File Name     : K2_Board_Init.h
  Version       : Initial Draft
  Author        : Brighton Feng
  Created       : July 8, 2013
  Last Modified :
  Description   : KeyStone 2 Board baisc configuration
  History       :
  1.Date        : July 8, 2013
    Author      : Brighton Feng
    Modification: Created file
******************************************************************************/
#ifndef _K2_BOARD_INIT_H_
#define _K2_BOARD_INIT_H_
#include "K2_DDR_Init.h"
#include "K2_common.h"

/*----------------------parameters based on board----------------------------*/
#if defined(K2L_EVM)
#if 0
/*Digital PLLs reference clock in MHz,
target speed= xxx_REF_CLK_MHZ/xxx_DIVIDER*xxx_multiplier*/
/*122.88/4*39= 1198.08MHz*/
#define MAIN_PLL_REF_CLK_MHZ    122.88  
#define MAIN_PLL_DIVISOR        4
#define MAIN_PLL_MULTIPLIER     39
/*122.88/24*205= 1049.6MHz. 
please note, there is additional 1/3 divider between PASSPLL and PASS*/
#define PASS_PLL_REF_CLK_MHZ    122.88  
#define PASS_PLL_DIVISOR        24
#define PASS_PLL_MULTIPLIER     205
/*122.88/4*39= 1198.08MHz*/
#define ARM_PLL_REF_CLK_MHZ     122.88     
#define ARM_PLL_DIVISOR         4
#define ARM_PLL_MULTIPLIER      39
#else
/*Digital PLLs reference clock in MHz,
target speed= xxx_REF_CLK_MHZ/xxx_DIVIDER*xxx_multiplier*/
/*100/1*12= 1200MHz*/
#define MAIN_PLL_REF_CLK_MHZ    100 
#define MAIN_PLL_DIVISOR        1
#define MAIN_PLL_MULTIPLIER     12
/*100/2*21= 1050MHz. 
please note, there is additional 1/3 divider between PASSPLL and PASS*/
#define PASS_PLL_REF_CLK_MHZ    100  
#define PASS_PLL_DIVISOR        2
#define PASS_PLL_MULTIPLIER     21
/*100/1*12= 1200MHz*/
#define ARM_PLL_REF_CLK_MHZ     100     
#define ARM_PLL_DIVISOR         1
#define ARM_PLL_MULTIPLIER      12
#endif

/*Serdes reference clock speeed, must be set with CSL enum value*/
#define SGMII_SERDES_REF_CLK        CSL_SERDES_REF_CLOCK_156p25M
#define PCIE_SERDES_REF_CLK         CSL_SERDES_REF_CLOCK_100M
#define AIF_SERDES_REF_CLK          CSL_SERDES_REF_CLOCK_122p88M
#define USB_SERDES_REF_CLK          CSL_SERDES_REF_CLOCK_100M

/*DDR3 memory size in bytes*/
#define DDR3A_SIZE_BYTES    (2*1024*1024*1024ULL)

/*FLASH, EEPROM size in bytes, speed in KHz*/
#define SPI_FLASH_SIZE_BYTES 	(16*1024*1024)
#define SPI_FLASH_SPEED_KHZ 	54000
#define I2C_EEPROM_SIZE_BYTES 	(64*1024)
#define I2C_EEPROM_ADDRESS 		0x51

#define EMIF_NAND_FLASH_CS 		0
#define EMIF_NOR_FLASH_CS 		0

#elif defined(K2E_EVM)
/*Digital PLLs reference clock in MHz,
target speed= xxx_REF_CLK_MHZ/xxx_DIVIDER*xxx_multiplier*/
/*100/1*12= 1200MHz*/
#define MAIN_PLL_REF_CLK_MHZ    100 
#define MAIN_PLL_DIVISOR        1
#define MAIN_PLL_MULTIPLIER     12
/*100/2*21= 1050MHz. 
please note, there is additional 1/3 divider between PASSPLL and PASS*/
#define PASS_PLL_REF_CLK_MHZ    100  
#define PASS_PLL_DIVISOR        2
#define PASS_PLL_MULTIPLIER     21

/*Serdes reference clock speeed, must be set with CSL enum value*/
#define SGMII_SERDES_REF_CLK        CSL_SERDES_REF_CLOCK_156p25M
#define PCIE_SERDES_REF_CLK         CSL_SERDES_REF_CLOCK_100M
#define USB_SERDES_REF_CLK          CSL_SERDES_REF_CLOCK_100M
#define HYPERLINK_SERDES_REF_CLK    CSL_SERDES_REF_CLOCK_312p5M

/*DDR3 memory size in bytes*/
#define DDR3A_SIZE_BYTES    (0x100000000ULL)

/*FLASH, EEPROM size in bytes, speed in KHz*/
#define SPI_FLASH_SIZE_BYTES 	(16*1024*1024)
#define SPI_FLASH_SPEED_KHZ 	54000
#define I2C_EEPROM_SIZE_BYTES 	(64*1024)
#define I2C_EEPROM_ADDRESS 		0x51

#define EMIF_NAND_FLASH_CS 		0
#define EMIF_NOR_FLASH_CS 		0

#elif defined(K2H_EVM) || defined(K2K_EVM) || defined(K2K_EVM_REV2) || defined(K2H_EVM_REV2)
/*Digital PLLs reference clock in MHz,
target speed= xxx_REF_CLK_MHZ/xxx_DIVIDER*xxx_multiplier*/
/*122.88/4*39= 1198.08MHz*/
#define MAIN_PLL_REF_CLK_MHZ    122.88  
#define MAIN_PLL_DIVISOR        4
#define MAIN_PLL_MULTIPLIER     39
/*122.88/24*205= 1049.6MHz. 
please note, there is additional 1/3 divider between PASSPLL and PASS*/
#define PASS_PLL_REF_CLK_MHZ    122.88  
#define PASS_PLL_DIVISOR        24
#define PASS_PLL_MULTIPLIER     205
/*125/5*48=1200MHz*/
#define ARM_PLL_REF_CLK_MHZ     125     
#define ARM_PLL_DIVISOR         5
#define ARM_PLL_MULTIPLIER      48

/*Serdes reference clock speeed, must be set with CSL enum value*/
#define SRIOSGMII_SERDES_REF_CLK    CSL_SERDES_REF_CLOCK_156p25M
#define SGMII_SERDES_REF_CLK    SRIOSGMII_SERDES_REF_CLK
#define PCIE_SERDES_REF_CLK         CSL_SERDES_REF_CLOCK_100M
#define HYPERLINK_SERDES_REF_CLK    CSL_SERDES_REF_CLOCK_312p5M
#define AIF_SERDES_REF_CLK          CSL_SERDES_REF_CLOCK_122p88M
#define XFI_SERDES_REF_CLK          CSL_SERDES_REF_CLOCK_156p25M
#define USB_SERDES_REF_CLK          CSL_SERDES_REF_CLOCK_100M

/*DDR3 memory size in bytes*/
#define DDR3A_SIZE_BYTES    (1*1024*1024*1024ULL)
#if defined(K2K_EVM_REV2) || defined(K2H_EVM_REV2)
	//the DDR3 memory on EVM rev 2.0 is K4B4G1646B
#define DDR3B_SIZE_BYTES    (1*1024*1024*1024)
#else
	//the DDR3 memory on EVM rev 1.0 is K4B2G1646E
#define DDR3B_SIZE_BYTES    (1*1024*1024*1024)
#endif

/*FLASH, EEPROM size in bytes, speed in KHz*/
#define SPI_FLASH_SIZE_BYTES 	(16*1024*1024)
#define SPI_FLASH_SPEED_KHZ 	54000
#define I2C_EEPROM_SIZE_BYTES 	(64*1024)
#define I2C_EEPROM_ADDRESS 		0x51

#define EMIF_NAND_FLASH_CS 		0
#define EMIF_NOR_FLASH_CS 		0

#else 
    #error Board type is NOT defined.
#endif

/*------------------------functions declaration----------------------------*/
/*configure DDR3A*/
extern void K2_DDR3A_config(DDR3_Arbitration_Config * arbitration_cfg, 
	DDR3_ECC_Config * ecc_cfg);

#if (2==CSL_DDR3_PER_CNT)
/*configure DDR3B*/
extern void K2_DDR3B_config(DDR3_Arbitration_Config * arbitration_cfg, 
	DDR3_ECC_Config * ecc_cfg);
#endif

/*Initialize SES MPAX for SOC DMA access DDR3A*/
extern void K2_SES_MPAX_init(K2_PrivID privID, K2_MSMC_Share share); 

#endif

