
#define CHIP_5509A
#include <csl.h>
#include <csl_emif.h>
#include <csl_chiphal.h>
#include <csl_gpio.h> 
#include <stdio.h>
#include <csl_mcbsp.h>
#include  "MCBSPconfig.h"

#define StaAdr  0x00800B  //ʼдַ
#define nCode 0x001B5C //flashд
#define CLKMD 0x1c00 //ʱӿƼĴ
#define Read 0x03
#define Erase 0x60
#define Program 0x02
#define AAProgram 0xAF
#define RDSR  0x05
#define WRSR 0x01
#define WREN 0x06
#define EWSR 0X50
/**/


void FlashBurn(unsigned short int * pdata,unsigned short int FlashDstAddr);
void WriteWord (unsigned long int Addr, unsigned short int Val);
void ChipErase(void);
unsigned short int ReadState(void);
void ReadAll(unsigned short int * pdata,unsigned short int FlashDstAddr,unsigned short int *stdaddr);
void SendData(unsigned short int dat);
int ReadData(int a);
void WriteEn();
void delay();
void WriteStatusRegister(int a);

unsigned short int Temp[1];
unsigned short int raddr[3];
unsigned short int cold[nCode];
unsigned short int * CodeSouce;
MCBSP_Config Configx;
MCBSP_Handle mhMcbsp;

void main()
{
unsigned short int i;
unsigned short int ErrorFlag;
unsigned short int EraseTemp;
unsigned short int test;
unsigned short int ErrorFlag3;
int k;

CodeSouce=(unsigned short int*)(StaAdr); 				//뵼ַ
for(i=0;i<nCode;i++)
cold[i]=*(CodeSouce+i);


/*ֹпεжԴ*/
IRQ_globalDisable();
CSL_init();   //ʼ

 /*ʱ1/4*/
*(volatile ioport unsigned short int *)CLKMD=0x6072;

 /*EMIFΪȫEMIFӿ*/
CHIP_RSET(XBSR,0x0a03);

/*EMIF*/
mhMcbsp = MCBSP_open(MCBSP_PORT0, MCBSP_OPEN_RESET);


 		MCBSP_getConfig(
		mhMcbsp,
		&Configx
		);


MCBSP_config(mhMcbsp, &Config_MCBSP);

 		MCBSP_getConfig(
		mhMcbsp,
		&Configx
		);
MCBSP_start(mhMcbsp, 
 				MCBSP_XMIT_START|MCBSP_SRGR_START|MCBSP_SRGR_FRAMESYNC|MCBSP_RCV_START, 
 				0x300);	
/*IO0IO1*/
GPIO_pinDirection(GPIO_PIN4,GPIO_OUTPUT);
test=0;
/*while(1)	
{ 	
	GPIO_pinWrite(GPIO_PIN4,0);
 	SendData(0x0090);
 	SendData(0x0000);
 	SendData(0x0000);
 	EraseTemp=ReadData(0x00ff);
 	ErrorFlag3=ReadData(0x00ff);
 	EraseTemp=ReadData(0x00ff);
 	ErrorFlag3=ReadData(0x00ff);
 	GPIO_pinWrite(GPIO_PIN4,1);
 	for(i=0;i<0xffff;i++);
}
	i=ReadState();*/
ChipErase();			//======джǷɹ=======
while(ReadState()&0x0001)
delay();
printf("ChipErase end! \n");
ErrorFlag=0;
for(i=0;i<0x0003;i++)
{
raddr[i]=0;
}
for(i=0;i<0x2fff;i++)
{
   ReadAll(&EraseTemp,1,raddr)	 ;
   if(EraseTemp!=0x00ff)
	   {
	   ErrorFlag++;
	   }
	raddr[0]++;
	if(raddr[0]==0x0100)
	{
		raddr[0]=0;
		raddr[1]++;
	}
	if(raddr[1]==0x0100)
	{
		raddr[1]=0;
		raddr[2]++;
	}
	if(raddr[2]==0x0100)
	{
		raddr[2]=0;
	}
}
	
if(ErrorFlag==0)
  printf("ChipErase succeful! \n");
else
{
  printf("ChipErase failed %d times!\n",ErrorFlag);
  ErrorFlag=0;
}

    EraseTemp=ReadState();
error:	for(i=0;i<0xffff;i++);
    test=0;
    WriteWord (0xffff,0x00d1);
    while(ReadState()&0x0001)
    EraseTemp=ReadState();
 // add read code here 
	 raddr[2]=0;
	 raddr[1]=0xff;
	 raddr[0]=0xff;
	ReadAll(&test,1,raddr)	 ;
	printf("test=%x\n",test); 
	if(test!=0x00d1)
	goto error;
	
	
	
	for(i=0;i<nCode-2;i++)
	{
		ErrorFlag=cold[i+2];
		
		Temp[0]=(ErrorFlag>>8)&0x00ff;
		WriteWord (i*2, Temp[0]);
		
		Temp[0]=ErrorFlag&0x00ff;
		WriteWord (i*2+1, Temp[0]);

    }
	k=0;
	for(i=0;i<0x0003;i++)
	{
		raddr[i]=0;
	}	
	ErrorFlag3=0;	
	ErrorFlag=0;
	for(i=0;i<0x00ff;i++);
	for(i=0;i<nCode-2;i++)
	{
	ReadAll(Temp,1,raddr);
	raddr[0]++;
	if(raddr[0]==0x0100)
	{
		raddr[0]=0;
		raddr[1]++;
	}
	if(raddr[1]==0x0100)
	{
		raddr[1]=0;
		raddr[2]++;
	}
	if(raddr[2]==0x0100)
	{
		raddr[2]=0;
	}
	if(Temp[0]==((cold[i+2]&0xff00)>>8));
    else if(Temp[0]!=0x00ff)
      	{
      		ErrorFlag++;
      		k=i;
      	}
    else
     	ErrorFlag3++;
     	
     	
    ReadAll(Temp,1,raddr);
	raddr[0]++;
	if(raddr[0]==0x0100)
	{
		raddr[0]=0;
		raddr[1]++;
	}
	if(raddr[1]==0x0100)
	{
		raddr[1]=0;
		raddr[2]++;
	}
	if(raddr[2]==0x0100)
	{
		raddr[2]=0;
	}
	if(Temp[0]==(cold[i+2]&0x00ff));
    else if(Temp[0]!=0x00ff)
      {
      	ErrorFlag++;
      	k=i;
      }
    else
     	ErrorFlag3++;
    }
    i=k;
	if(ErrorFlag3==0)
  printf("Flash burn  \n");
	else
  printf("Flash burn  failed %d times!\n",ErrorFlag3);
  printf("Flash burn fatal failed %d times!\n",ErrorFlag);
  //printf("%d\n",Temp[0]);}

	while(1)
	{
		;
	}


					
   
}



void FlashBurn(unsigned short int * pdata,unsigned short int FlashDstAddr)
 {
 	
 	unsigned short int i;
 	for(i=0;i<FlashDstAddr;i++)
    WriteWord (i, pdata[i]);
 }
		
void WriteWord (unsigned long int Addr, unsigned short int Val)
{
    unsigned short int a,b,i;
    i=ReadState();
    a=(Addr>>8)&0xff;
    b=Addr&0xff;
 	GPIO_pinWrite(GPIO_PIN4,1);
 	delay();
   WriteEn();
	GPIO_pinWrite(GPIO_PIN4,1);
	for(i=0;i<2048;i++);
	i=ReadState();
	GPIO_pinWrite(GPIO_PIN4,0);
	SendData(Program);
	SendData(0x00);
	SendData(a);
	SendData(b);
	SendData(Val);
	while(MCBSP_xrdy(mhMcbsp)==0);
	GPIO_pinWrite(GPIO_PIN4,1);
	delay();
	 i=ReadState();
}


void ChipErase(void)
{
   	unsigned short int i;
 	WriteStatusRegister(0x02);
   WriteEn();
   i=ReadState();
	GPIO_pinWrite(GPIO_PIN4,1);
	for(i=0;i<2048;i++);
	GPIO_pinWrite(GPIO_PIN4,0);
	SendData(Erase);
	while(MCBSP_xrdy(mhMcbsp)==0);
	GPIO_pinWrite(GPIO_PIN4,1);
	i=ReadState();
	delay();
}

unsigned short int ReadState(void)
{
	int i;
	GPIO_pinWrite(GPIO_PIN4,1);
	 	delay();
 	GPIO_pinWrite(GPIO_PIN4,0);
	SendData(RDSR);
	while(MCBSP_xrdy(mhMcbsp)==0);
	i=ReadData(0xff);
	GPIO_pinWrite(GPIO_PIN4,1);
	delay();
	return i;
}

void ReadAll(unsigned short int * pdata,unsigned short int FlashDstAddr,unsigned short int *stdaddr)
{
	int i;
	GPIO_pinWrite(GPIO_PIN4,1);
	 	delay();
 	GPIO_pinWrite(GPIO_PIN4,0);
	SendData(Read);
	SendData(stdaddr[2]);
	SendData(stdaddr[1]);
	SendData(stdaddr[0]);
	for(i=0;i<FlashDstAddr;i++)
	{
		*(pdata+i)=ReadData(0xff);
	}
	GPIO_pinWrite(GPIO_PIN4,1);
	delay();

}
void SendData(unsigned short int dat)
{	
	
	while(MCBSP_xrdy(mhMcbsp)==0)
 		MCBSP_getConfig(
 		mhMcbsp,
 		&Configx
 		);

 	MCBSP_write16(mhMcbsp,dat&0x00ff);
		 MCBSP_getConfig(
		mhMcbsp,
		&Configx
		);
		while(MCBSP_rrdy(mhMcbsp)==0)
 		MCBSP_getConfig(
 		mhMcbsp,
 		&Configx
 		);
 		MCBSP_read16(mhMcbsp)&0x00ff;
				
}
int ReadData(int a)
{
	while(MCBSP_xrdy(mhMcbsp)==0)
 		MCBSP_getConfig(
 		mhMcbsp,
 		&Configx
 		);

 	MCBSP_write16(mhMcbsp,a&0x00ff);
	while(MCBSP_rrdy(mhMcbsp)==0)
 		MCBSP_getConfig(
 		mhMcbsp,
 		&Configx
 		);
 		return MCBSP_read16(mhMcbsp)&0x00ff;
}
void WriteEn()
{
	int i;
	i=0x0000;
	 while((i&0x0002)==0)
	 {
 	GPIO_pinWrite(GPIO_PIN4,1);
 	 	delay();
 	GPIO_pinWrite(GPIO_PIN4,0);
	SendData(WREN);
	while(MCBSP_xrdy(mhMcbsp)==0);
	GPIO_pinWrite(GPIO_PIN4,1);
	delay();
	i=ReadState();
	delay();
	}
}
void delay()
{
	int i;
	for(i=0;i<10;i++);
}
void WriteStatusRegister(int a)
{
	GPIO_pinWrite(GPIO_PIN4,1);
 	delay();
 	GPIO_pinWrite(GPIO_PIN4,0);
	SendData(EWSR);
	while(MCBSP_xrdy(mhMcbsp)==0);
	GPIO_pinWrite(GPIO_PIN4,1);
	delay();
	GPIO_pinWrite(GPIO_PIN4,0);
	SendData(WRSR);
	while(MCBSP_xrdy(mhMcbsp)==0);
	SendData(a);
	GPIO_pinWrite(GPIO_PIN4,1);
	delay();
}
